/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.param;

import com.kingdee.bos.sso.client.util.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SSOParamemterReader {
    private static final Logger logger = Logger.getLogger(SSOParamemterReader.class);
    private static SSOParamemterReader reader = new SSOParamemterReader();
    private static Map<String, String[]> unfilterUrlPatternMap = new HashMap<String, String[]>();

    private SSOParamemterReader() {
    }

    public static final SSOParamemterReader getInstance() {
        return reader;
    }

    public final String[] getUnfilterUrlPattern(String webInfoPath) {
        String[] unfilterUrlArray = unfilterUrlPatternMap.get(webInfoPath);
        if (unfilterUrlArray == null) {
            String filePath = webInfoPath + "/sso/ssoParamemter.properties";
            logger.debug((Object)("SSOParamemterReader filePath:" + filePath));
            Properties prop = null;
            try {
                File file = new File(filePath);
                prop = PropertiesUtil.getProperties(file);
            }
            catch (IOException e) {
                logger.error((Object)"SSOParamemterReader file read error:", (Throwable)e);
            }
            if (prop != null) {
                String unfilterUrlStr = prop.getProperty("cas.client.UrlPattern");
                if (unfilterUrlStr != null) {
                    unfilterUrlArray = unfilterUrlStr.split(";");
                    unfilterUrlPatternMap.put(webInfoPath, unfilterUrlArray);
                } else {
                    logger.info((Object)"SSOParamemterReader unfilterUrlStr(cas.client.UrlPattern) is null.");
                }
            } else {
                logger.info((Object)"SSOParamemterReader prop(ssoParamemter.properties) is null.");
            }
        }
        return unfilterUrlArray;
    }
}

