/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.ssl.HttpsURLConnectionFactory;
import org.jasig.cas.client.util.URIBuilder;
import org.jasig.cas.client.validation.ProxyList;
import org.jasig.cas.client.validation.ProxyListEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtils.class);
    private static final String PARAM_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    private static final String PARAM_PROXY_GRANTING_TICKET = "pgtId";
    private static final HttpURLConnectionFactory DEFAULT_URL_CONNECTION_FACTORY = new HttpsURLConnectionFactory();
    private static final String SERVICE_PARAMETER_NAMES;

    private CommonUtils() {
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotEmpty(Collection<?> c, String message) {
        CommonUtils.assertNotNull(c, message);
        if (c.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertTrue(boolean cond, String message) {
        if (!cond) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertFalse(boolean cond, String message) {
        if (cond) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isNotEmpty(String string) {
        return !CommonUtils.isEmpty(string);
    }

    public static boolean isBlank(String string) {
        return CommonUtils.isEmpty(string) || string.trim().isEmpty();
    }

    public static boolean isNotBlank(String string) {
        return !CommonUtils.isBlank(string);
    }

    public static String constructRedirectUrl(String casServerLoginUrl, String serviceParameterName, String serviceUrl, boolean renew, boolean gateway, String method) {
        return casServerLoginUrl + (casServerLoginUrl.contains("?") ? "&" : "?") + serviceParameterName + "=" + CommonUtils.urlEncode(serviceUrl) + (renew ? "&renew=true" : "") + (gateway ? "&gateway=true" : "") + (method != null ? "&method=" + method : "");
    }

    public static String constructRedirectUrl(String casServerLoginUrl, String serviceParameterName, String serviceUrl, boolean renew, boolean gateway) {
        return CommonUtils.constructRedirectUrl(casServerLoginUrl, serviceParameterName, serviceUrl, renew, gateway, null);
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void readAndRespondToProxyReceptorRequest(HttpServletRequest request, HttpServletResponse response, ProxyGrantingTicketStorage proxyGrantingTicketStorage) throws IOException {
        String proxyGrantingTicketIou = request.getParameter(PARAM_PROXY_GRANTING_TICKET_IOU);
        String proxyGrantingTicket = request.getParameter(PARAM_PROXY_GRANTING_TICKET);
        if (CommonUtils.isBlank(proxyGrantingTicket) || CommonUtils.isBlank(proxyGrantingTicketIou)) {
            response.getWriter().write("");
            return;
        }
        LOGGER.debug("Received proxyGrantingTicketId [{}] for proxyGrantingTicketIou [{}]", (Object)proxyGrantingTicket, (Object)proxyGrantingTicketIou);
        proxyGrantingTicketStorage.save(proxyGrantingTicketIou, proxyGrantingTicket);
        LOGGER.debug("Successfully saved proxyGrantingTicketId [{}] for proxyGrantingTicketIou [{}]", (Object)proxyGrantingTicket, (Object)proxyGrantingTicketIou);
        response.getWriter().write("<?xml version=\"1.0\"?>");
        response.getWriter().write("<casClient:proxySuccess xmlns:casClient=\"http://www.yale.edu/tp/casClient\" />");
    }

    protected static String findMatchingServerName(HttpServletRequest request, String serverName) {
        String comparisonHost;
        String[] serverNames = serverName.split(" ");
        if (serverNames.length == 0 || serverNames.length == 1) {
            return serverName;
        }
        String host = request.getHeader("Host");
        String xHost = request.getHeader("X-Forwarded-Host");
        String string = comparisonHost = xHost != null ? xHost : host;
        if (comparisonHost == null) {
            return serverName;
        }
        for (String server : serverNames) {
            String lowerCaseServer = server.toLowerCase();
            if (!lowerCaseServer.contains(comparisonHost)) continue;
            return server;
        }
        return serverNames[0];
    }

    private static boolean requestIsOnStandardPort(HttpServletRequest request) {
        int serverPort = request.getServerPort();
        return serverPort == 80 || serverPort == 443;
    }

    @Deprecated
    public static String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, String service, String serverNames, String artifactParameterName, boolean encode) {
        return CommonUtils.constructServiceUrl(request, response, service, serverNames, SERVICE_PARAMETER_NAMES, artifactParameterName, encode);
    }

    public static String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, String service, String serverNames, String serviceParameterName, String artifactParameterName, boolean encode) {
        URIBuilder builder;
        if (CommonUtils.isNotBlank(service)) {
            return encode ? response.encodeURL(service) : service;
        }
        String serverName = CommonUtils.findMatchingServerName(request, serverNames);
        URIBuilder originalRequestUrl = new URIBuilder(request.getRequestURL().toString(), encode);
        originalRequestUrl.setParameters(request.getQueryString());
        if (!serverName.startsWith("https://") && !serverName.startsWith("http://")) {
            String scheme = request.isSecure() ? "https://" : "http://";
            builder = new URIBuilder(scheme + serverName, encode);
        } else {
            builder = new URIBuilder(serverName, encode);
        }
        if (builder.getPort() == -1 && !CommonUtils.requestIsOnStandardPort(request)) {
            builder.setPort(request.getServerPort());
        }
        builder.setEncodedPath(builder.getEncodedPath() + request.getRequestURI());
        List<String> serviceParameterNames = Arrays.asList(serviceParameterName.split(","));
        if (!serviceParameterNames.isEmpty() && !originalRequestUrl.getQueryParams().isEmpty()) {
            for (URIBuilder.BasicNameValuePair pair : originalRequestUrl.getQueryParams()) {
                String name = pair.getName();
                if (name.equals(artifactParameterName) || serviceParameterNames.contains(name)) continue;
                if (name.contains("&") || name.contains("=")) {
                    URIBuilder encodedParamBuilder = new URIBuilder();
                    encodedParamBuilder.setParameters(name);
                    for (URIBuilder.BasicNameValuePair pair2 : encodedParamBuilder.getQueryParams()) {
                        String name2 = pair2.getName();
                        if (name2.equals(artifactParameterName) || serviceParameterNames.contains(name2)) continue;
                        builder.addParameter(name2, pair2.getValue());
                    }
                    continue;
                }
                builder.addParameter(name, pair.getValue());
            }
        }
        String result = builder.toString();
        LOGGER.debug("serviceUrl generated: {}", (Object)result);
        return result;
    }

    public static String safeGetParameter(HttpServletRequest request, String parameter, List<String> parameters) {
        if ("POST".equals(request.getMethod()) && parameters.contains(parameter)) {
            LOGGER.debug("safeGetParameter called on a POST HttpServletRequest for Restricted Parameters.  Cannot complete check safely.  Reverting to standard behavior for this Parameter");
            return request.getParameter(parameter);
        }
        return request.getQueryString() == null || !request.getQueryString().contains(parameter) ? null : request.getParameter(parameter);
    }

    public static String safeGetParameter(HttpServletRequest request, String parameter) {
        return CommonUtils.safeGetParameter(request, parameter, Arrays.asList("logoutRequest"));
    }

    @Deprecated
    public static String getResponseFromServer(String constructedUrl, String encoding) {
        try {
            return CommonUtils.getResponseFromServer(new URL(constructedUrl), DEFAULT_URL_CONNECTION_FACTORY, encoding);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static String getResponseFromServer(URL constructedUrl, String encoding) {
        return CommonUtils.getResponseFromServer(constructedUrl, DEFAULT_URL_CONNECTION_FACTORY, encoding);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResponseFromServer(URL constructedUrl, HttpURLConnectionFactory factory, String encoding) {
        String string;
        HttpURLConnection conn = null;
        InputStreamReader in = null;
        try {
            int byteRead;
            conn = factory.buildHttpURLConnection(constructedUrl.openConnection());
            in = CommonUtils.isEmpty(encoding) ? new InputStreamReader(conn.getInputStream()) : new InputStreamReader(conn.getInputStream(), encoding);
            StringBuilder builder = new StringBuilder(255);
            while ((byteRead = in.read()) != -1) {
                builder.append((char)byteRead);
            }
            string = builder.toString();
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (SSLException e2) {
                    LOGGER.error("SSL error getting response from host: {} : Error Message: {}", new Object[]{constructedUrl.getHost(), e2.getMessage(), e2});
                    throw new RuntimeException(e2);
                }
                catch (IOException e3) {
                    LOGGER.error("Error getting response from host: [{}] with path: [{}] and protocol: [{}] Error Message: {}", new Object[]{constructedUrl.getHost(), constructedUrl.getPath(), constructedUrl.getProtocol(), e3.getMessage(), e3});
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                CommonUtils.closeQuietly(in);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        CommonUtils.closeQuietly(in);
        if (conn != null) {
            conn.disconnect();
        }
        return string;
    }

    public static ProxyList createProxyList(String proxies) {
        if (CommonUtils.isBlank(proxies)) {
            return new ProxyList();
        }
        ProxyListEditor editor = new ProxyListEditor();
        editor.setAsText(proxies);
        return (ProxyList)editor.getValue();
    }

    public static void sendRedirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void closeQuietly(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean toBoolean(String str) {
        return CommonUtils.toBooleanObject(str) == Boolean.TRUE;
    }

    public static Boolean toBooleanObject(String str) {
        if (str == "true") {
            return Boolean.TRUE;
        }
        if (str == null) {
            return null;
        }
        switch (str.length()) {
            case 1: {
                char ch0 = str.charAt(0);
                if (ch0 == 'y' || ch0 == 'Y' || ch0 == 't' || ch0 == 'T') {
                    return Boolean.TRUE;
                }
                if (ch0 != 'n' && ch0 != 'N' && ch0 != 'f' && ch0 != 'F') break;
                return Boolean.FALSE;
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                if (!(ch0 != 'o' && ch0 != 'O' || ch1 != 'n' && ch1 != 'N')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'n' && ch0 != 'N' || ch1 != 'o' && ch1 != 'O') break;
                return Boolean.FALSE;
            }
            case 3: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                if (!(ch0 != 'y' && ch0 != 'Y' || ch1 != 'e' && ch1 != 'E' || ch2 != 's' && ch2 != 'S')) {
                    return Boolean.TRUE;
                }
                if (ch0 != 'o' && ch0 != 'O' || ch1 != 'f' && ch1 != 'F' || ch2 != 'f' && ch2 != 'F') break;
                return Boolean.FALSE;
            }
            case 4: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                if (ch0 != 't' && ch0 != 'T' || ch1 != 'r' && ch1 != 'R' || ch2 != 'u' && ch2 != 'U' || ch3 != 'e' && ch3 != 'E') break;
                return Boolean.TRUE;
            }
            case 5: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char ch2 = str.charAt(2);
                char ch3 = str.charAt(3);
                char ch4 = str.charAt(4);
                if (ch0 != 'f' && ch0 != 'F' || ch1 != 'a' && ch1 != 'A' || ch2 != 'l' && ch2 != 'L' || ch3 != 's' && ch3 != 'S' || ch4 != 'e' && ch4 != 'E') break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static String addTrailingSlash(String uri) {
        return uri.endsWith("/") ? uri : uri + "/";
    }

    static {
        HashSet<String> serviceParameterSet = new HashSet<String>(4);
        for (Protocol protocol : Protocol.values()) {
            serviceParameterSet.add(protocol.getServiceParameterName());
        }
        SERVICE_PARAMETER_NAMES = ((Object)serviceParameterSet).toString().replaceAll("\\[|\\]", "").replaceAll("\\s", "");
    }
}

