/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sso.client.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLUtil {
    private static final Logger logger = Logger.getLogger(XMLUtil.class);

    public static boolean createXMLFile(String fileURL) {
        Document document = DocumentHelper.createDocument();
        return XMLUtil.createXMLFile(fileURL, document);
    }

    public static boolean createXMLFile(String fileURL, Document document) {
        File file = new File(fileURL);
        return XMLUtil.store(file, document);
    }

    public static Document load(String fileURL) {
        File file = new File(fileURL);
        return XMLUtil.load(file);
    }

    public static Document load(File file) {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(file);
        }
        catch (Exception e) {
            document = DocumentHelper.createDocument();
            logger.error((Object)e);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean store(File file, Document document) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndent("    ");
        format.setEncoding("UTF-8");
        XMLWriter writer = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            writer = new XMLWriter((OutputStream)fileOutputStream, format);
            writer.write(document);
            writer.flush();
            writer.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Document createDocument() {
        return DocumentHelper.createDocument();
    }

    public static Element createElement(String name) {
        return DocumentHelper.createElement((String)name);
    }

    public static Attribute createAttribute(Element owner, String name, String value) {
        return DocumentHelper.createAttribute((Element)owner, (String)name, (String)value);
    }
}

