/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cm.module.content.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.cm.CMColumnInfo;
import com.kingdee.eas.cp.eip.cm.CMContentFactory;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.ColumnTypeEnum;
import com.kingdee.eas.cp.eip.cm.ContentManageFactory;
import com.kingdee.eas.cp.eip.cm.ICMContent;
import com.kingdee.eas.cp.eip.cm.IContentManage;
import com.kingdee.eas.cp.eip.cm.web.ContentResourceHandle;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.plt.cm.common.util.LicenseTool;
import com.kingdee.portal.plt.cm.module.column.dto.ColumnDto;
import com.kingdee.portal.plt.cm.module.content.dto.ContentDto;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ContentAction
extends BaseAction {
    public String contentManager() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String licenseClassName = "com.kingdee.eas.cp.eip.cm.web.ContentAction";
        boolean hasLicense = LicenseTool.checkLicense(this.getRequest(), licenseClassName);
        if (!hasLicense) {
            return "nolicense";
        }
        boolean hasAdjustPer = false;
        boolean hasShowOrHidPer = false;
        String adjustPer = "cm_updateafterrelease";
        String showOrHidPer = "cm_updatecontentstate_showorhidden";
        try {
            IContentManage icm = ContentManageFactory.getLocalInstance((Context)ctx);
            hasAdjustPer = icm.hasBizzHandlePermission(adjustPer);
            hasShowOrHidPer = icm.hasBizzHandlePermission(showOrHidPer);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
        this.getRequest().setAttribute("hasAdjustPer", (Object)hasAdjustPer);
        this.getRequest().setAttribute("hasShowOrHidPer", (Object)hasShowOrHidPer);
        return "success";
    }

    public void editQuery() throws Exception {
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        int currentPage = 0;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String columnID = this.getRequest().getParameter("columnID");
        String classID = this.getRequest().getParameter("classID");
        String title = this.getRequest().getParameter("title");
        String author = this.getRequest().getParameter("author");
        String authorId = this.getRequest().getParameter("authorId");
        String beginDate = this.getRequest().getParameter("beginDate");
        String endDate = this.getRequest().getParameter("endDate");
        String source = this.getRequest().getParameter("source");
        String status = this.getRequest().getParameter("status");
        String orderByField = "";
        String orderType = "";
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "lastUpdateTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        orderType = orderType.toUpperCase();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        StringBuffer maskStrBf = new StringBuffer();
        String maskStr = null;
        int itemNum = 0;
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        if (null != classID && !"".equals(classID)) {
            filterItemInfo = new FilterItemInfo("classID", (Object)classID);
            filterInfo.getFilterItems().add(filterItemInfo);
            this.makeFilterMask(maskStrBf, itemNum);
            ++itemNum;
        }
        if (null != columnID && !"".equals(columnID)) {
            filterItemInfo = new FilterItemInfo("columnID", (Object)columnID);
            filterInfo.getFilterItems().add(filterItemInfo);
            this.makeFilterMask(maskStrBf, itemNum);
            ++itemNum;
        } else {
            String columnIds = this.getEditColumnIDStr(ctx);
            if (columnIds.length() > 0) {
                filterItemInfo = new FilterItemInfo("columnID", (Object)columnIds, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
                this.makeFilterMask(maskStrBf, itemNum);
                ++itemNum;
            }
        }
        if (null != title && !"".equals(title)) {
            filterItemInfo = new FilterItemInfo("title", (Object)("%" + title + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
            maskStrBf.append(" AND (#" + itemNum);
            filterItemInfo = new FilterItemInfo("keyword", (Object)("%" + title + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
            maskStrBf.append(" OR #" + ++itemNum + ")");
            ++itemNum;
        }
        if (null != author && !"".equals(author)) {
            filterItemInfo = new FilterItemInfo("creator.name", (Object)("%" + author + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
            this.makeFilterMask(maskStrBf, itemNum);
            ++itemNum;
        }
        if (null != authorId && !"".equals(authorId)) {
            filterItemInfo = new FilterItemInfo("creator.id", (Object)authorId);
            filterInfo.getFilterItems().add(filterItemInfo);
            this.makeFilterMask(maskStrBf, itemNum);
            ++itemNum;
        }
        if (null != beginDate && !"".equals(beginDate)) {
            Timestamp begin = Timestamp.valueOf(beginDate + " 00:00:00");
            filterItemInfo = new FilterItemInfo("lastUpdateTime", (Object)begin, CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            this.makeFilterMask(maskStrBf, itemNum);
            ++itemNum;
        }
        if (null != endDate && !"".equals(endDate)) {
            Timestamp end = Timestamp.valueOf(endDate + " 23:59:59");
            filterItemInfo = new FilterItemInfo("lastUpdateTime", (Object)end, CompareType.LESS_EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            this.makeFilterMask(maskStrBf, itemNum);
            ++itemNum;
        }
        if (null != source && !"".equals(source)) {
            filterItemInfo = new FilterItemInfo("source", (Object)source, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            this.makeFilterMask(maskStrBf, itemNum);
            ++itemNum;
        }
        if (null != status && !"".equals(status)) {
            filterItemInfo = new FilterItemInfo("status", (Object)status, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            this.makeFilterMask(maskStrBf, itemNum);
            ++itemNum;
        }
        if (source.equals(String.valueOf(2)) && status.equals(String.valueOf(0))) {
            filterItemInfo = new FilterItemInfo("creator.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            this.makeFilterMask(maskStrBf, itemNum);
            ++itemNum;
        } else {
            String classIds = this.getEditClassIDStr(ctx);
            if (classIds.length() > 0) {
                filterItemInfo = new FilterItemInfo("classID", (Object)classIds, CompareType.INCLUDE);
                filterInfo.getFilterItems().add(filterItemInfo);
                maskStrBf.append(" AND (#" + itemNum);
                filterItemInfo = new FilterItemInfo("creator.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                maskStrBf.append(" OR #" + ++itemNum + ")");
                ++itemNum;
            }
        }
        maskStr = maskStrBf.toString();
        if (maskStr != null && maskStr.trim().length() > 0) {
            filterInfo.setMaskString(maskStr);
        }
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
        MetaDataPK queryCountPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentCountQuery");
        IQueryExecutor exec = null;
        StringBuffer countQueryStr = new StringBuffer("");
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is\ufffd\ufffd" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            currentPage = pageNo;
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content sql is:" + exec.getSQL());
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<ContentDto> list = new ArrayList<ContentDto>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    ContentDto contentDto = new ContentDto();
                    contentDto.setColumnType(rowSet.getString("CMColumn.ColumnType"));
                    contentDto.setID(rowSet.getString("id"));
                    contentDto.setTitle(rowSet.getString("title"));
                    contentDto.setAuthor(rowSet.getString("User.name"));
                    contentDto.setColumnClass(rowSet.getString("CMColumn.name") + "/" + rowSet.getString("CMClass.name"));
                    contentDto.setSate(rowSet.getString("status"));
                    contentDto.setPublishDate(rowSet.getString("sumbitTime").substring(0, 16));
                    contentDto.setKeyword(rowSet.getString("keyword"));
                    contentDto.setCreateDate(rowSet.getString("createTime").substring(0, 16));
                    list.add(contentDto);
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getDataCount() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String columnID = this.getRequest().getParameter("columnID");
        String classID = this.getRequest().getParameter("classID");
        String title = this.getRequest().getParameter("title");
        String author = this.getRequest().getParameter("author");
        String beginDate = this.getRequest().getParameter("beginDate");
        String endDate = this.getRequest().getParameter("endDate");
        String source = this.getRequest().getParameter("source");
        String status = "";
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (int l = 0; l < 7; ++l) {
                source = "";
                status = String.valueOf(l);
                if (status.equals("5")) {
                    status = "4";
                    source = "1";
                }
                if (status.equals("0")) {
                    source = "2";
                }
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                FilterItemInfo filterItemInfo = null;
                StringBuffer maskStrBf = new StringBuffer();
                String maskStr = null;
                int itemNum = 0;
                int total = 0;
                if (null != classID && !"".equals(classID)) {
                    filterItemInfo = new FilterItemInfo("classID", (Object)classID);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    this.makeFilterMask(maskStrBf, itemNum);
                    ++itemNum;
                }
                if (null != columnID && !"".equals(columnID)) {
                    filterItemInfo = new FilterItemInfo("columnID", (Object)columnID);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    this.makeFilterMask(maskStrBf, itemNum);
                    ++itemNum;
                } else {
                    String columnIds = this.getEditColumnIDStr(ctx);
                    if (columnIds.length() > 0) {
                        filterItemInfo = new FilterItemInfo("columnID", (Object)columnIds, CompareType.INCLUDE);
                        filterInfo.getFilterItems().add(filterItemInfo);
                        this.makeFilterMask(maskStrBf, itemNum);
                        ++itemNum;
                    }
                }
                if (null != title && !"".equals(title)) {
                    filterItemInfo = new FilterItemInfo("title", (Object)("%" + title + "%"), CompareType.LIKE);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    maskStrBf.append(" AND (#" + itemNum);
                    filterItemInfo = new FilterItemInfo("keyword", (Object)("%" + title + "%"), CompareType.LIKE);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    maskStrBf.append(" OR #" + ++itemNum + ")");
                    ++itemNum;
                }
                if (null != author && !"".equals(author)) {
                    filterItemInfo = new FilterItemInfo("creator.name", (Object)("%" + author + "%"), CompareType.LIKE);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    this.makeFilterMask(maskStrBf, itemNum);
                    ++itemNum;
                }
                if (null != beginDate && !"".equals(beginDate)) {
                    Timestamp begin = Timestamp.valueOf(beginDate + " 00:00:00");
                    filterItemInfo = new FilterItemInfo("lastUpdateTime", (Object)begin, CompareType.GREATER_EQUALS);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    this.makeFilterMask(maskStrBf, itemNum);
                    ++itemNum;
                }
                if (null != endDate && !"".equals(endDate)) {
                    Timestamp end = Timestamp.valueOf(endDate + " 23:59:59");
                    filterItemInfo = new FilterItemInfo("lastUpdateTime", (Object)end, CompareType.LESS_EQUALS);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    this.makeFilterMask(maskStrBf, itemNum);
                    ++itemNum;
                }
                if (null != source && !"".equals(source)) {
                    filterItemInfo = new FilterItemInfo("source", (Object)source, CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    this.makeFilterMask(maskStrBf, itemNum);
                    ++itemNum;
                }
                if (null != status && !"".equals(status)) {
                    filterItemInfo = new FilterItemInfo("status", (Object)status, CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    this.makeFilterMask(maskStrBf, itemNum);
                    ++itemNum;
                }
                if (source.equals(String.valueOf(2)) && status.equals(String.valueOf(0))) {
                    filterItemInfo = new FilterItemInfo("creator.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS);
                    filterInfo.getFilterItems().add(filterItemInfo);
                    this.makeFilterMask(maskStrBf, itemNum);
                    ++itemNum;
                } else {
                    String classIds = this.getEditClassIDStr(ctx);
                    if (classIds.length() > 0) {
                        filterItemInfo = new FilterItemInfo("classID", (Object)classIds, CompareType.INCLUDE);
                        filterInfo.getFilterItems().add(filterItemInfo);
                        maskStrBf.append(" AND (#" + itemNum);
                        filterItemInfo = new FilterItemInfo("creator.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS);
                        filterInfo.getFilterItems().add(filterItemInfo);
                        maskStrBf.append(" OR #" + ++itemNum + ")");
                        ++itemNum;
                    }
                }
                maskStr = maskStrBf.toString();
                if (maskStr != null && maskStr.trim().length() > 0) {
                    filterInfo.setMaskString(maskStr);
                }
                entityViewInfo.setFilter(filterInfo);
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
                IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
                IRowSet countRowSet = exec.executeQuery();
                while (countRowSet.next()) {
                    this.logger.debug("record total is " + ++total);
                }
                list.add(String.valueOf(total));
            }
            this.writeAjaxData(true, null, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getColumnTypeByDocId() {
        String id = this.getRequest().getParameter("docId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICMContent iCm = CMContentFactory.getLocalInstance((Context)ctx);
            CMContentInfo concentInfo = iCm.getCMContentInfo((IObjectPK)new ObjectUuidPK(id));
            String columnID = concentInfo.getColumnID().toString();
            IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
            CMColumnInfo columnInfo = iManage.getColumnInfo(columnID.replaceAll(" ", "+"));
            ColumnDto columnDto = new ColumnDto();
            columnDto.setID(columnInfo.getId().toString());
            String type = String.valueOf(columnInfo.getColumnType().getValue());
            columnDto.setColumnType(type);
            if (type.equals(String.valueOf(ColumnTypeEnum.LINK.getValue()))) {
                // empty if block
            }
            columnDto.setColCount(concentInfo.getSummary());
            this.writeAjaxData(true, null, columnDto);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public void deleteContents() {
        String ids = this.getRequest().getParameter("ids");
        try {
            if (ids != null && !ids.equals("")) {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
                String[] id = ids.split(",");
                for (int i = 0; i < id.length; ++i) {
                    iManage.deleteContents(id[i]);
                }
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, "0");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void blankOutContents() {
        String ids = this.getRequest().getParameter("ids");
        try {
            if (ids != null && !ids.equals("")) {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
                iManage.blankOutContents(ids);
                String[] idArr = ids.split(",");
                String idStr = "";
                for (String id : idArr) {
                    idStr = idStr + "'" + id + "',";
                }
                if (!"".equals(idStr = idStr.substring(0, idStr.length() - 1))) {
                    String sql = "delete from t_cm_reader where fcontentid in (" + idStr + ")";
                    DbUtil.execute((Context)ctx, (String)sql);
                }
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, "0");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void hiddenContent() {
        String ids = this.getRequest().getParameter("ids");
        try {
            if (ids != null && !ids.equals("")) {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
                iManage.updateContentStateHidden(ids);
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, "0");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void showContent() {
        String ids = this.getRequest().getParameter("ids");
        try {
            if (ids != null && !ids.equals("")) {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
                iManage.updateContentStateShow(ids);
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, "0");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void isHasAssignID() {
        try {
            String bizID = this.getRequest().getParameter("ids");
            if (bizID != null && !bizID.equals("")) {
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                String sql = "select top 1 * from t_wfr_assign where FBizObjID='" + bizID + "'";
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql);
                String assingId = "";
                if (row.next()) {
                    assingId = row.getString("FASSIGNID");
                }
                if (assingId.equals("") && (row = DbUtil.executeQuery((Context)ctx, (String)(sql = "select top 1 * from T_WFR_AssignDetail where FBizObjID='" + bizID + "'"))).next()) {
                    assingId = row.getString("FASSIGNID");
                }
                this.writeAjaxData(true, null, assingId);
            }
        }
        catch (Exception e) {
            this.writeAjaxData(false, null, null);
            e.printStackTrace();
            this.logger.error("\u5355\u636e\u5bf9\u5e94\u7684\u4efb\u52a1\u4e0d\u5b58\u5728:" + e.getMessage());
        }
    }

    public void getPicPath() {
        String contentId = this.getRequest().getParameter("contentId");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            ICMContent iCm = CMContentFactory.getLocalInstance((Context)ctx);
            CMContentInfo concentInfo = iCm.getCMContentInfo((IObjectPK)new ObjectUuidPK(contentId));
            if (concentInfo.getFile() == null) {
                this.writeAjaxData(true, null, "0");
            } else {
                String fileId = concentInfo.getFile().toString();
                String pictureSrc = ContentResourceHandle.getContentResourceFile((String)fileId, (Context)ctx, (ServletContext)this.getServletContext());
                if (pictureSrc == null || pictureSrc.equals("")) {
                    this.writeAjaxData(true, null, "0");
                } else {
                    this.writeAjaxData(true, null, pictureSrc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    private boolean checkHasAssignID() {
        try {
            String bizID = this.getRequest().getParameter("ids");
            if (bizID != null && !bizID.equals("")) {
                String sql;
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                IRowSet row = DbUtil.executeQuery((Context)ctx, (String)(sql = "select top 1 * from t_wfr_assign where FBizObjID='" + bizID + "'"));
                if (row.next()) {
                    return true;
                }
                sql = "select top 1 * from T_WFR_AssignDetail where FBizObjID='" + bizID + "'";
                row = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (row.next()) {
                    return true;
                }
                sql = "select top 1 * from T_WFR_AssignHst where FBizObjID='" + bizID + "'";
                row = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (row.next()) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5355\u636e\u5bf9\u5e94\u7684\u4efb\u52a1\u4e0d\u5b58\u5728:" + e.getMessage());
        }
        return false;
    }

    private String getEditColumnIDStr(Context ctx) throws Exception {
        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
        IRowSet rowset = iManage.getEditColumn();
        StringBuffer columnIdBf = new StringBuffer();
        columnIdBf.append("0");
        if (rowset != null && rowset.size() > 0) {
            while (rowset.next()) {
                columnIdBf.append(",");
                columnIdBf.append(rowset.getString("FID"));
            }
        }
        return columnIdBf.toString();
    }

    private String getEditClassIDStr(Context ctx) throws Exception {
        IContentManage iManage = ContentManageFactory.getLocalInstance((Context)ctx);
        IRowSet rowset = iManage.getEditClass();
        StringBuffer bf = new StringBuffer();
        bf.append("0");
        if (rowset != null && rowset.size() > 0) {
            while (rowset.next()) {
                bf.append(",");
                bf.append(rowset.getString("FID"));
            }
        }
        return bf.toString();
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private void makeFilterMask(StringBuffer strBf, int num) {
        if (num > 0) {
            strBf.append(" AND #");
            strBf.append(num);
        } else {
            strBf.append(" #");
            strBf.append(num);
        }
    }
}

