/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.common.fme;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.portal.plt.cp.common.fme.ConvertDTO;
import com.kingdee.portal.plt.cp.common.fme.ConvertProperties;
import com.kingdee.portal.plt.cp.common.fme.HttpPostEmulator;
import com.kingdee.portal.plt.cp.common.fme.UploadFileItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertUtil {
    private static Logger log = LoggerFactory.getLogger(ConvertUtil.class);
    private static Map requestIdMap = new HashMap();

    public static ConvertDTO getConvertMessage(String requestID) {
        return (ConvertDTO)requestIdMap.get(requestID);
    }

    public static void removeConvertMessage(String requestID) {
        requestIdMap.remove(requestID);
    }

    public static boolean convert(String fileName, byte[] data, String toFile) throws Exception {
        String remoteSwfFile = "";
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ArrayList<UploadFileItem> uploadFileItemList = new ArrayList<UploadFileItem>();
        uploadFileItemList.add(new UploadFileItem(fileName, inStream));
        HttpPostEmulator httpPostEmulator = new HttpPostEmulator();
        String serverUrl = ConvertUtil.getRemoteServerUrl();
        if (null == serverUrl || "".equals(serverUrl)) {
            String err = "\u83b7\u53d6remoteFileConvertService.properties\u6587\u4ef6\u7684\u8f6c\u6362URL\u53c2\u6570\u5931\u8d25";
            log.error(err);
            throw new Exception(err);
        }
        try {
            remoteSwfFile = httpPostEmulator.sendHttpPostFileRequest(serverUrl, uploadFileItemList, "", "");
            ConvertUtil.createSwfFile(remoteSwfFile, toFile);
        }
        catch (Exception e) {
            String err = "\u8c03\u7528" + serverUrl + "\u63a5\u53e3\u8f6c\u6362\u6587\u4ef6\u5931\u8d25\uff01";
            log.error(err, (Throwable)e);
            throw new Exception(err, e);
        }
        return true;
    }

    public static boolean convert(String fileName, byte[] data, String toFile, String requestID, String callBackUrl) throws Exception {
        ConvertDTO dto = new ConvertDTO();
        dto.setFileName(fileName);
        dto.setData(data);
        dto.setToFile(toFile);
        dto.setRequestID(requestID);
        dto.setCallBackUrl(callBackUrl);
        ByteArrayInputStream inStream = new ByteArrayInputStream(data);
        ArrayList<UploadFileItem> uploadFileItemList = new ArrayList<UploadFileItem>();
        uploadFileItemList.add(new UploadFileItem(fileName, inStream));
        HttpPostEmulator httpPostEmulator = new HttpPostEmulator();
        String serverUrl = ConvertUtil.getRemoteServerUrl();
        if (null == serverUrl || "".equals(serverUrl)) {
            String err = "\u83b7\u53d6remoteFileConvertService.properties\u6587\u4ef6\u7684\u8f6c\u6362URL\u53c2\u6570\u5931\u8d25";
            log.error(err);
            throw new Exception(err);
        }
        try {
            httpPostEmulator.sendHttpPostFileRequest(serverUrl, uploadFileItemList, requestID, callBackUrl);
            requestIdMap.put(requestID, dto);
        }
        catch (Exception e) {
            String err = "\u8c03\u7528" + serverUrl + "\u63a5\u53e3\u8f6c\u6362\u6587\u4ef6\u5931\u8d25\uff01";
            log.error(err, (Throwable)e);
            throw new Exception(err, e);
        }
        return true;
    }

    public static void createSwfFile(String swfFileUrl, String toFileName) throws Exception {
        FileOutputStream outStream = null;
        try {
            byte[] urlData = ConvertUtil.getUrlFile(swfFileUrl);
            outStream = new FileOutputStream(toFileName);
            outStream.write(urlData);
        }
        catch (Exception e) {
            String err = "\u5c06\u8f6c\u6362\u540e\u7684\u6587\u4ef6\u5199\u5165\u672c\u5730\u5931\u8d25\uff01";
            log.error(err, (Throwable)e);
            throw new Exception(err, e);
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
        }
    }

    public static String getRemoteServerUrl() {
        StringBuffer url = new StringBuffer();
        String protocol = ConvertProperties.getProperty("remoteServiceProtocol");
        String ContextPath = ConvertProperties.getProperty("remoteServiceContextPath");
        String host = ConvertProperties.getProperty("remoteServiceHost");
        String port = ConvertProperties.getProperty("remoteServicePort");
        if (null == protocol || "".equals(protocol)) {
            return null;
        }
        if (null == ContextPath || "".equals(ContextPath)) {
            return null;
        }
        if (null == port || "".equals(port)) {
            return null;
        }
        if (null == host || "".equals(host)) {
            return null;
        }
        url.append(protocol + "://");
        url.append(host);
        url.append(":" + port);
        url.append("/" + ContextPath);
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getUrlFile(String fileUrl) throws Exception {
        URL url = new URL(fileUrl);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setConnectTimeout(50000);
        InputStream inputStream = null;
        byte[] data = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            data = ConvertUtil.readInputStream(inputStream);
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        return data;
    }

    public static byte[] readInputStream(InputStream inSream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inSream.read(buffer)) != -1) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        try {
            inSream.close();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readFile(String file) throws Exception {
        File inFile = new File(file);
        FileInputStream inStream = new FileInputStream(inFile);
        byte[] data = ConvertUtil.readInputStream(inStream);
        StreamUtil.closeStream((InputStream)inStream);
        return data;
    }

    public static String createPath(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sdf.format(date);
        String[] d = dateStr.split("-");
        return "/" + d[0] + "/" + d[1] + "/" + d[2] + "/";
    }

    public static String getBaseUrl(HttpServletRequest request) {
        StringBuffer baseUrl = new StringBuffer();
        baseUrl.append("http://");
        String addr = request.getServerName();
        String path = request.getContextPath();
        int port = request.getServerPort();
        baseUrl.append(addr);
        if (80 != port) {
            baseUrl.append(":" + port);
        }
        baseUrl.append(path);
        return baseUrl.toString();
    }

    public static String getBaseRootUrl(HttpServletRequest request) {
        StringBuffer baseUrl = new StringBuffer();
        baseUrl.append("http://");
        String addr = request.getServerName();
        int port = request.getServerPort();
        baseUrl.append(addr);
        if (80 != port) {
            baseUrl.append(":" + port);
        }
        baseUrl.append("/");
        return baseUrl.toString();
    }
}

