/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.StringUtil;
import com.kingdee.lightapp.util.image.ImageUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class CMContentImgHandle {
    private static Logger logger = Logger.getLogger((String)CMContentImgHandle.class.getName());

    public static String getImgFilePath(String bizID, Context ctx) {
        AttachmentInfo attInfo = null;
        try {
            attInfo = CMContentImgHandle.getAttachmentByID(bizID, ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CMContentImgHandle.getImgFilePath(attInfo, ctx);
    }

    public static String getMin_ImgFilePath(String bizID, Context ctx) {
        AttachmentInfo attInfo = null;
        try {
            attInfo = CMContentImgHandle.getAttachmentByID(bizID, ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CMContentImgHandle.getMin_ImgFilePath(attInfo, ctx);
    }

    public static String getMin_ImgFilePath(AttachmentInfo attInfo, Context ctx) {
        if (attInfo == null) {
            return "";
        }
        if (attInfo.getFile() == null || attInfo.getFile().length <= 0) {
            try {
                attInfo.setFile(AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(attInfo.getId().toString()));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (attInfo.getFile() == null || attInfo.getFile().length <= 0) {
            return "";
        }
        String path = CMContentImgHandle.getDatePath(attInfo);
        String bizID = attInfo.getId().toString();
        String lastUpdateTime = "";
        String fileName = StringUtil.encoder((String)bizID);
        Timestamp ts = attInfo.getLastUpdateTime();
        Date date = new Date();
        if (ts != null) {
            date = ts;
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            lastUpdateTime = format.format(date);
        }
        if (fileName.indexOf("%") > -1) {
            fileName = fileName.replaceAll("%", "9");
        }
        fileName = "min_" + fileName;
        String suffix = attInfo.getSimpleName();
        File image = null;
        image = CMContentImgHandle.createFileOnServer(fileName + "_" + lastUpdateTime + "." + suffix, attInfo, ctx, true);
        return "/plt_cp/resource/" + path + "/" + image.getName();
    }

    public static String getImgFilePath(AttachmentInfo attInfo, Context ctx) {
        if (attInfo == null) {
            return "";
        }
        System.out.println("attInfo.getFile(): " + attInfo.getFile());
        if (null != attInfo.getFile()) {
            System.out.println("attInfo.getFile().length: " + attInfo.getFile().length);
        }
        String path = CMContentImgHandle.getDatePath(attInfo);
        String bizID = attInfo.getId().toString();
        String lastUpdateTime = "";
        String fileName = StringUtil.encoder((String)bizID);
        Timestamp ts = attInfo.getLastUpdateTime();
        Date date = new Date();
        if (ts != null) {
            date = ts;
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            lastUpdateTime = format.format(date);
        }
        if (fileName.indexOf("%") > -1) {
            fileName = fileName.replaceAll("%", "9");
        }
        String suffix = attInfo.getSimpleName();
        File image = null;
        image = CMContentImgHandle.createFileOnServer(fileName + "_" + lastUpdateTime + "." + suffix, attInfo, ctx);
        return "/plt_cp/resource/" + path + "/" + image.getName();
    }

    private static String getDatePath(AttachmentInfo attInfo) {
        String day;
        Timestamp ts = attInfo.getLastUpdateTime();
        Date date = new Date();
        if (ts != null) {
            date = ts;
        }
        String path = "other";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String year = String.valueOf(calendar.get(1));
        String month = String.valueOf(calendar.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((day = String.valueOf(calendar.get(5))).length() == 1) {
            day = "0" + day;
        }
        path = year + "/" + month + "/" + day;
        return path;
    }

    private static AttachmentInfo getAttachmentByID(String id, Context ctx) {
        if (id != null) {
            id = id.replaceAll(" ", "+");
        }
        AttachmentInfo info = null;
        try {
            info = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return info;
    }

    private static File createFileOnServer(String fileName, AttachmentInfo info, Context ctx) {
        return CMContentImgHandle.createFileOnServer(fileName, info, ctx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createFileOnServer(String fileName, AttachmentInfo info, Context ctx, boolean isSmall) {
        String datePath = CMContentImgHandle.getDatePath(info);
        String eas_home = System.getProperty("EAS_HOME");
        String filePath = eas_home + File.separator + "server" + File.separator + "deploy" + File.separator + "portal.ear" + File.separator + "plt_cp.war" + File.separator + "resource" + File.separator + datePath + File.separator;
        File fileDir = new File(filePath);
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        File file = new File(filePath + fileName);
        try {
            if (!fileDir.exists()) {
                fileDir.mkdirs();
            }
            if (file.exists()) {
                File file2 = file;
                return file2;
            }
            file.createNewFile();
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
            byte[] data = null;
            Class<AttachmentServerManager> clazz = AttachmentServerManager.class;
            synchronized (AttachmentServerManager.class) {
                data = asm.download(info.getId().toString());
                // ** MonitorExit[var13_22] (shouldn't be in output)
                if (isSmall && data != null) {
                    data = ImageUtil.scaleByWidth((byte[])data, (int)300, (String)"jpg");
                }
                in = new BufferedInputStream(new ByteArrayInputStream(data));
                out = new BufferedOutputStream(new FileOutputStream(file));
                byte[] array = new byte[4096];
                int len = 0;
                while ((len = in.read(array)) != -1) {
                    ((BufferedOutputStream)out).write(array, 0, len);
                }
                ((BufferedOutputStream)out).flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        {
            return file;
        }
    }
}

