/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class DateTool {
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private DateTool() {
    }

    public static Date getLastDateOfCurMonth(Date date) {
        Date next = DateTool.getFirstDateOfNextMonth(date);
        return DateTool.beforeSeconds(next, 1L);
    }

    public static Date getLastDateOfPriorMonth(Date date) {
        Date start = DateTool.getFistDateOfCurrentMonth(date);
        return DateTool.beforeSeconds(start, 1L);
    }

    public static Date getLastTime(Date date) {
        try {
            return sdfTime.parse(sdfDate.format(date) + " 23:59:59");
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static Date afterSeconds(Date date, long seconds) {
        long time = date.getTime();
        return new Date(time += 1000L * seconds);
    }

    public static Date afterMinutes(Date date, long minutes) {
        return DateTool.afterSeconds(date, minutes * 60L);
    }

    public static Date afterHours(Date date, long hours) {
        return DateTool.afterMinutes(date, hours * 60L);
    }

    public static Date afterDays(Date date, long days) {
        return DateTool.afterHours(date, days * 24L);
    }

    public static Date beforeSeconds(Date date, long seconds) {
        long time = date.getTime();
        return new Date(time -= 1000L * seconds);
    }

    public static Date beforeMinutes(Date date, long minutes) {
        return DateTool.beforeSeconds(date, minutes * 60L);
    }

    public static Date beforeHours(Date date, long hours) {
        return DateTool.beforeMinutes(date, hours * 60L);
    }

    public static Date beforeDays(Date date, long days) {
        return DateTool.beforeHours(date, days * 24L);
    }

    public static Date getFirstTime(Date date) {
        try {
            return sdfTime.parse(sdfDate.format(date) + " 00:00:00");
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static Date getFirstDateOfNextMonth(Date date) {
        int month = DateTool.getMonth(date);
        int year = DateTool.getYear(date);
        if (12 == month) {
            month = 1;
            ++year;
        } else {
            ++month;
        }
        String strDate = null;
        strDate = month < 10 ? year + "-0" + month + "-01 00:00:00" : year + "-" + month + "-01 00:00:00";
        return DateTool.stringToDate(strDate, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getFistDateOfCurrentMonth(Date date) {
        String strDate = DateTool.getYear(date) + "-";
        int month = DateTool.getMonth(date);
        strDate = month < 10 ? strDate + "0" + month + "-" : strDate + month + "-";
        strDate = strDate + "01 00:00:00";
        return DateTool.stringToDate(strDate, "yyyy-MM-dd HH:mm:ss");
    }

    public static int getSecond(Date date) {
        String timeStr = DateTool.dateToString(date, "HH:mm:ss");
        int beginIndex = timeStr.lastIndexOf(":") + 1;
        int endIndex = timeStr.length();
        return new Integer(timeStr.substring(beginIndex, endIndex));
    }

    public static int getMinute(Date date) {
        String timeStr = DateTool.dateToString(date, "HH:mm:ss");
        int beginIndex = timeStr.indexOf(":") + 1;
        int endIndex = timeStr.lastIndexOf(":");
        return new Integer(timeStr.substring(beginIndex, endIndex));
    }

    public static int getHour(Date date) {
        String timeStr = DateTool.dateToString(date, "HH:mm:ss");
        int beginIndex = 0;
        int endIndex = timeStr.indexOf(":");
        return new Integer(timeStr.substring(beginIndex, endIndex));
    }

    public static int getDay(Date date) {
        String dateStr = DateTool.dateToString(date, "yyyy-MM-dd");
        int beginIndex = dateStr.lastIndexOf("-") + 1;
        int endIndex = dateStr.length();
        return new Integer(dateStr.substring(beginIndex, endIndex));
    }

    public static int getMonth(Date date) {
        String dateStr = DateTool.dateToString(date, "yyyy-MM-dd");
        int beginIndex = dateStr.indexOf("-") + 1;
        int endIndex = dateStr.lastIndexOf("-");
        return new Integer(dateStr.substring(beginIndex, endIndex));
    }

    public static int getYear(Date date) {
        String dateStr = DateTool.dateToString(date, "yyyy-MM-dd");
        int beginIndex = 0;
        int endIndex = dateStr.indexOf("-");
        return new Integer(dateStr.substring(beginIndex, endIndex));
    }

    public static Date stringToDate(String date, String formatter) {
        Date rlt = null;
        if (null == date) {
            return rlt;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(formatter);
        try {
            rlt = sdf.parse(date);
        }
        catch (Exception e) {
            rlt = null;
        }
        return rlt;
    }

    public static String dateToString(Date date, String formatter) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatter);
        return sdf.format(date);
    }

    public static Date now() {
        return new Date();
    }

    public static Date getTodayFirstTime(Date date) {
        return DateTool.getFirstTime(date);
    }

    public static Date getTodayLastTime(Date date) {
        return DateTool.getLastTime(date);
    }

    public static Date[] getMonthOfPeriod(Date fromDate, Date toDate) {
        String tempDateStr = "";
        ArrayList<Date> arrayList = new ArrayList<Date>();
        int listIndex = 0;
        while (fromDate.before(toDate) || fromDate.equals(toDate)) {
            tempDateStr = DateTool.dateToString(fromDate, "yyyy-MM");
            Date tempDate = DateTool.stringToDate(tempDateStr, "yyyy-MM");
            if (arrayList.size() > 0) {
                if (tempDate.after((Date)arrayList.get(listIndex))) {
                    arrayList.add(++listIndex, tempDate);
                }
            } else {
                arrayList.add(listIndex, tempDate);
            }
            fromDate = DateTool.afterDays(fromDate, 1L);
        }
        Date[] returnValue = new Date[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            returnValue[i++] = (Date)iterator.next();
        }
        return returnValue;
    }

    public static Date beforeMonthes(Date date, int monthes) {
        Date returnMonth = date;
        for (int i = 1; i <= monthes; ++i) {
            returnMonth = DateTool.getLastDateOfPriorMonth(returnMonth);
        }
        String dateStr = DateTool.dateToString(returnMonth, "yyyy-MM");
        returnMonth = DateTool.stringToDate(dateStr, "yyyy-MM");
        return returnMonth;
    }

    public static Date afterMonthes(Date date, int monthes) {
        Date returnMonth = date;
        for (int i = 1; i <= monthes; ++i) {
            returnMonth = DateTool.getFirstDateOfNextMonth(returnMonth);
        }
        String dateStr = DateTool.dateToString(returnMonth, "yyyy-MM");
        returnMonth = DateTool.stringToDate(dateStr, "yyyy-MM");
        return returnMonth;
    }
}

