/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.base.common.fme.ConvertUtil;
import com.kingdee.eas.cp.common.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.plt.cm.common.util.CMLicenseName;
import com.kingdee.portal.plt.cm.common.util.LicenseTool;
import com.kingdee.portal.plt.cp.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.plt.cp.common.util.PageList;
import com.kingdee.portal.plt.cp.module.cm.dto.AttachmentDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ColumnDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ContentDTO;
import com.kingdee.portal.plt.cp.module.cm.service.ClassService;
import com.kingdee.portal.plt.cp.module.cm.service.ColumnsService;
import com.kingdee.portal.plt.cp.module.cm.service.CommentService;
import com.kingdee.portal.plt.cp.module.cm.service.ContentService;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ClassServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ColumnsServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.CommentServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ContentServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentAction
extends BaseAction {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ColumnsService columnsService = ColumnsServiceImpl.getInstance();
    private ClassService classService = ClassServiceImpl.getInstance();
    private ContentService contentService = ContentServiceImpl.getInstance();
    private CommentService commentService = CommentServiceImpl.getInstance();

    public String list() throws Exception {
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String columnId = FilterSpecialCharactersTool.cleanXSS(request.getParameter("columnId"));
        String classId = request.getParameter("classId");
        String keyWords = request.getParameter("keyWords");
        String page = request.getParameter("page");
        String pageSize = request.getParameter("pageSize");
        if (null != columnId) {
            columnId = columnId.replaceAll(" ", "+");
        }
        if (null != classId) {
            classId = classId.replaceAll(" ", "+");
        }
        if (null == columnId) {
            columnId = "";
        }
        if (null == classId) {
            classId = "";
        }
        if (null == keyWords) {
            keyWords = "";
        }
        if (null == page) {
            page = "";
        }
        if (null == pageSize) {
            pageSize = "";
        }
        keyWords = new String(keyWords.getBytes("iso-8859-1"), "utf-8");
        HttpSession session = request.getSession();
        ColumnDTO columnDTO = (ColumnDTO)session.getAttribute("Attachment_ColumnDTO_" + columnId);
        if (null == columnDTO) {
            columnDTO = this.columnsService.findBean(ctx, columnId);
            List classList = this.classService.findClassList(ctx, columnId);
            columnDTO.setClassList(classList);
            session.setAttribute("Attachment_ColumnDTO_" + columnId, (Object)columnDTO);
        }
        columnDTO = this.classService.addCurrClassList(columnDTO, classId);
        request.setAttribute("columnDTO", (Object)columnDTO);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("columnId", columnId);
        params.put("page", "1");
        params.put("pageSize", "10");
        params.put("sortFieldName", "CLICKS");
        params.put("sortType", SortType.DESCEND.getName());
        PageList pointList = this.contentService.pageList(ctx, params);
        int len = pointList.size();
        for (int i = 0; i < len; ++i) {
            ContentDTO dto = (ContentDTO)pointList.get(i);
            String docId = dto.getId();
            String fileId = dto.getFileId();
            AttachmentDTO attachmentDTO = this.contentService.getAttachment(ctx, fileId, docId, false);
            dto.setAttachmentDTO(attachmentDTO);
        }
        request.setAttribute("pointList", (Object)pointList);
        params.put("page", page);
        params.put("classId", classId);
        params.put("pageSize", pageSize);
        params.put("keyWords", keyWords);
        params.put("sortFieldName", "SUMBITTIME");
        params.put("sortType", SortType.DESCEND.getName());
        PageList contentList = this.contentService.pageList(ctx, params);
        int len2 = contentList.size();
        for (int i = 0; i < len2; ++i) {
            ContentDTO dto = (ContentDTO)contentList.get(i);
            String docId = dto.getId();
            String fileId = dto.getFileId();
            AttachmentDTO attachmentDTO = this.contentService.getAttachment(ctx, fileId, docId, false);
            dto.setAttachmentDTO(attachmentDTO);
        }
        request.setAttribute("contentList", (Object)contentList);
        request.setAttribute("columnId", (Object)columnId);
        request.setAttribute("classId", (Object)classId);
        request.setAttribute("keyWords", (Object)keyWords);
        request.setAttribute("page", (Object)contentList.getCurrentPage());
        request.setAttribute("pageSize", (Object)contentList.getPageSize());
        return "success";
    }

    public String view() throws Exception {
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String docId = request.getParameter("docId");
        if (null == docId || "".equals(docId)) {
            docId = request.getParameter("contentId");
        }
        if (null != docId) {
            docId = docId.replaceAll(" ", "+");
        }
        String callBackUrl = ConvertUtil.getBaseUrl((HttpServletRequest)request) + "/common/fileToSwfPublic.action";
        ContentDTO content = this.contentService.getViewContent(ctx, docId, callBackUrl);
        String info = this.contentService.getDocInfo(ctx, docId);
        content.setDocContent(info);
        int clicks = this.contentService.updateClicks(content, ctx);
        content.setClicks(clicks);
        request.setAttribute("content", (Object)content);
        ArrayList attachmentList = this.contentService.getAttachmentList(ctx, docId);
        if (null == attachmentList) {
            attachmentList = new ArrayList();
        }
        request.setAttribute("attachmentList", attachmentList);
        request.setAttribute("attachmentListSize", (Object)attachmentList.size());
        ArrayList cmRelateList = this.contentService.getRelateList(ctx, docId);
        if (null == cmRelateList) {
            cmRelateList = new ArrayList();
        }
        request.setAttribute("cmRelateList", cmRelateList);
        request.setAttribute("cmRelateListSize", (Object)cmRelateList.size());
        ArrayList commentList = this.commentService.queryCommentList(ctx, docId);
        if (null == commentList) {
            commentList = new ArrayList();
        }
        request.setAttribute("commentList", commentList);
        request.setAttribute("commentListSize", (Object)commentList.size());
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String down() throws Exception {
        boolean hasPermission;
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String attachmentId = request.getParameter("attachmentId");
        String docId = request.getParameter("docId");
        if (null != attachmentId) {
            attachmentId = attachmentId.replaceAll(" ", "+");
        }
        if (null != docId && !"".equals(docId)) {
            docId = docId.replaceAll(" ", "+");
        }
        if (null != docId && !"".equals(docId) && !(hasPermission = this.contentService.hasPermissionToRead(ctx, docId))) {
            return "noPermission";
        }
        boolean hasLicense = LicenseTool.checkLicense((HttpServletRequest)request, (String)CMLicenseName.licenseClassName);
        if (!hasLicense) {
            return "noLicense";
        }
        if (null != docId && !"".equals(docId)) {
            AttachmentDTO attachmentDTO;
            String callBackUrl = ConvertUtil.getBaseUrl((HttpServletRequest)request) + "/common/fileToSwfPublic.action";
            ContentDTO content = this.contentService.getViewContent(ctx, docId, callBackUrl);
            String fileId = content.getFileId();
            if ((null == attachmentId || "".equals(attachmentId)) && null != (attachmentDTO = this.contentService.getAttachment(ctx, fileId, docId, false))) {
                attachmentId = attachmentDTO.getId();
            }
            this.contentService.updateClicks(content, ctx);
        }
        if (null == attachmentId || "".equals(attachmentId)) {
            return "error";
        }
        AttachmentDTO dto = this.contentService.queryAttachment(ctx, attachmentId);
        String fileName = dto.getAttachmentName() + "." + dto.getSimplename();
        fileName = StringUtil.encoder((String)fileName);
        HttpServletResponse response = this.getResponse();
        response.setContentType("application/x-download ;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        ServletOutputStream outStream = response.getOutputStream();
        byte[] data = dto.getFile();
        if (null == data || null == fileName || "".equals(fileName)) {
            return "error";
        }
        if (null != data) {
            try {
                outStream.write(dto.getFile());
                String string = "";
                return string;
            }
            catch (Exception exception) {
            }
            finally {
                if (null != outStream) {
                    outStream.close();
                }
            }
        }
        return "";
    }

    public UserInfo getUserInfo(PortalContext ctx) {
        if (null == ctx) {
            return null;
        }
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        if (null == context) {
            return null;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)context);
        return user;
    }
}

