/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.cm.CMCommentInfo;
import com.kingdee.eas.cp.eip.cm.ContentScore;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.enums.ResponseContentTypeEnum;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.plt.cp.common.util.DateTool;
import com.kingdee.portal.plt.cp.module.cm.service.ClassService;
import com.kingdee.portal.plt.cp.module.cm.service.ColumnsService;
import com.kingdee.portal.plt.cp.module.cm.service.CommentService;
import com.kingdee.portal.plt.cp.module.cm.service.ContentService;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ClassServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ColumnsServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.CommentServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ContentServiceImpl;
import java.sql.Timestamp;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CommentAction
extends BaseAction {
    private ColumnsService columnsService = ColumnsServiceImpl.getInstance();
    private ClassService classService = ClassServiceImpl.getInstance();
    private ContentService contentService = ContentServiceImpl.getInstance();
    private CommentService commentService = CommentServiceImpl.getInstance();

    public void save() throws Exception {
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return;
        }
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        HttpServletRequest request = this.getRequest();
        String content = request.getParameter("content");
        String docId = request.getParameter("docId");
        if (null == docId || "".equals(docId)) {
            return;
        }
        if (null != docId) {
            docId = docId.replaceAll(" ", "+");
        }
        CMCommentInfo info = new CMCommentInfo();
        info.setContentID(BOSUuid.read((String)docId));
        info.setCommentContent(content);
        info.setScore(ContentScore.GOOD);
        UserInfo user = UserFactory.getLocalInstance((Context)context).getUserByID(context.getCaller());
        info.setCreator(user);
        CMCommentInfo newInfo = this.commentService.saveBean(ctx, info);
        HttpServletResponse response = this.getResponse();
        response.setContentType("text/json");
        response.setHeader("cache-control", "no-cache");
        response.setHeader("charset", "UTF-8");
        Timestamp commenttime = newInfo.getCommentTime();
        String commentDate = DateTool.dateToString(commenttime, "yyyy-MM-dd HH:mm");
        String creatorName = newInfo.getCreator().getName();
        String commentcontent = newInfo.getCommentContent();
        HashMap<String, Object> ajaxData = new HashMap<String, Object>();
        ajaxData.put("success", true);
        ajaxData.put("errinfo", null);
        ajaxData.put("commenttime", commentDate);
        ajaxData.put("creatorName", creatorName);
        ajaxData.put("commentcontent", commentcontent);
        this.writeObjectData(JSONUtil.getJson4Object(ajaxData), ResponseContentTypeEnum.JSON);
    }

    public UserInfo getUserInfo(PortalContext ctx) {
        if (null == ctx) {
            return null;
        }
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        if (null == context) {
            return null;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)context);
        return user;
    }
}

