/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.base.common.fme.ConvertUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.plt.cm.common.util.CMLicenseName;
import com.kingdee.portal.plt.cm.common.util.LicenseTool;
import com.kingdee.portal.plt.cp.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.plt.cp.common.util.PageList;
import com.kingdee.portal.plt.cp.module.cm.dto.ColumnDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ContentDTO;
import com.kingdee.portal.plt.cp.module.cm.service.ClassService;
import com.kingdee.portal.plt.cp.module.cm.service.ColumnsService;
import com.kingdee.portal.plt.cp.module.cm.service.CommentService;
import com.kingdee.portal.plt.cp.module.cm.service.ContentService;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ClassServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ColumnsServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.CommentServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ContentServiceImpl;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CommonAction
extends BaseAction {
    private ColumnsService columnsService = ColumnsServiceImpl.getInstance();
    private ClassService classService = ClassServiceImpl.getInstance();
    private ContentService contentService = ContentServiceImpl.getInstance();
    private CommentService commentService = CommentServiceImpl.getInstance();

    public String list() throws Exception {
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String columnId = FilterSpecialCharactersTool.cleanXSS(request.getParameter("columnId"));
        String classId = request.getParameter("classId");
        String keyWords = request.getParameter("keyWords");
        String page = request.getParameter("page");
        String pageSize = request.getParameter("pageSize");
        if (null != columnId) {
            columnId = columnId.replaceAll(" ", "+");
        }
        if (null != classId) {
            classId = classId.replaceAll(" ", "+");
        }
        if (null == columnId) {
            columnId = "";
        }
        if (null == classId) {
            classId = "";
        }
        if (null == keyWords) {
            keyWords = "";
        }
        if (null == page) {
            page = "";
        }
        if (null == pageSize) {
            pageSize = "";
        }
        keyWords = new String(keyWords.getBytes("iso-8859-1"), "utf-8");
        HttpSession session = request.getSession();
        ColumnDTO columnDTO = (ColumnDTO)session.getAttribute("Common_ColumnDTO_" + columnId);
        if (null == columnDTO) {
            columnDTO = this.columnsService.findBean(ctx, columnId);
            List classList = this.classService.findClassList(ctx, columnId);
            columnDTO.setClassList(classList);
            session.setAttribute("Common_ColumnDTO_" + columnId, (Object)columnDTO);
        }
        columnDTO = this.classService.addCurrClassList(columnDTO, classId);
        request.setAttribute("columnDTO", (Object)columnDTO);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("columnId", columnId);
        params.put("page", page);
        params.put("classId", classId);
        params.put("pageSize", pageSize);
        params.put("keyWords", keyWords);
        params.put("sortFieldName", "SUMBITTIME");
        params.put("sortType", SortType.DESCEND.getName());
        PageList contentList = this.contentService.pageList(ctx, params);
        request.setAttribute("contentList", (Object)contentList);
        request.setAttribute("columnId", (Object)columnId);
        request.setAttribute("classId", (Object)classId);
        request.setAttribute("keyWords", (Object)keyWords);
        request.setAttribute("page", (Object)contentList.getCurrentPage());
        request.setAttribute("pageSize", (Object)contentList.getPageSize());
        return "success";
    }

    public String view() throws Exception {
        boolean hasPermission;
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String docId = request.getParameter("docId");
        if (null == docId || "".equals(docId)) {
            docId = request.getParameter("contentId");
        }
        if (docId.contains(" ")) {
            docId = docId.replace(" ", "+");
        }
        if (!(hasPermission = this.contentService.hasPermissionToRead(ctx, docId))) {
            return "noPermission";
        }
        boolean hasLicense = LicenseTool.checkLicense((HttpServletRequest)request, (String)CMLicenseName.licenseClassName);
        if (!hasLicense) {
            return "noLicense";
        }
        String loadIndex = FilterSpecialCharactersTool.cleanXSS(request.getParameter("loadIndex"));
        if (null == loadIndex || "".equals(loadIndex)) {
            loadIndex = "1";
        }
        request.setAttribute("loadIndex", (Object)loadIndex);
        request.setAttribute("actionName", (Object)"viewCommon");
        if (null != docId) {
            docId = docId.replaceAll(" ", "+");
        }
        String callBackUrl = ConvertUtil.getBaseUrl((HttpServletRequest)request) + "/common/fileToSwfPublic.action";
        ContentDTO content = this.contentService.getViewContent(ctx, docId, callBackUrl);
        int clicks = this.contentService.updateClicks(content, ctx);
        content.setClicks(clicks);
        request.setAttribute("clicks", (Object)clicks);
        request.setAttribute("content", (Object)content);
        request.setAttribute("isCanCopy", (Object)content.getCanCopy());
        ArrayList attachmentList = this.contentService.getAttachmentList(ctx, docId);
        if (null == attachmentList) {
            attachmentList = new ArrayList();
        }
        request.setAttribute("attachmentList", attachmentList);
        request.setAttribute("attachmentListSize", (Object)attachmentList.size());
        ArrayList cmRelateList = this.contentService.getRelateList(ctx, docId);
        if (null == cmRelateList) {
            cmRelateList = new ArrayList();
        }
        request.setAttribute("cmRelateList", cmRelateList);
        request.setAttribute("cmRelateListSize", (Object)cmRelateList.size());
        ArrayList commentList = this.commentService.queryCommentList(ctx, docId);
        if (null == commentList) {
            commentList = new ArrayList();
        }
        request.setAttribute("commentList", commentList);
        request.setAttribute("commentListSize", (Object)commentList.size());
        request.setAttribute("docId", (Object)docId);
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String showImg() throws Exception {
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String imgId = request.getParameter("imgId");
        if (null != imgId) {
            imgId = imgId.replaceAll(" ", "+");
        }
        AttachmentInfo info = this.contentService.getShowImg(ctx, imgId);
        HttpServletResponse response = this.getResponse();
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        String fileName = "error.jpeg";
        if (null != info) {
            fileName = info.getAttachID() + "." + info.getSimpleName();
        }
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        ServletOutputStream outStream = null;
        try {
            outStream = response.getOutputStream();
            if (null == info) {
                this.writeErrorImage();
                String string = null;
                return string;
            }
            byte[] data = info.getFile();
            if (null == data || data.length == 0) {
                this.writeErrorImage();
                String string = null;
                return string;
            }
            outStream.write(data);
        }
        catch (Exception e) {
            Log.error((Object)e);
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeErrorImage() {
        String easHome = System.getProperty("EAS_HOME");
        String defaultImg = easHome + "/server/deploy/portal.ear/plt_cp.war/res/img/defalt.png";
        File inFile = new File(defaultImg);
        FileInputStream inStream = null;
        byte[] data = null;
        try {
            inStream = new FileInputStream(inFile);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            data = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    this.logger.error("", (Throwable)e);
                }
            }
        }
        HttpServletResponse response = this.getResponse();
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        if (null == data) {
            int width = 130;
            int height = 53;
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, width, height);
            g.setFont(new Font("Times New Roman", 0, 12));
            g.drawString("image error ", 2, 2);
            try {
                ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)response.getOutputStream());
            }
            catch (IOException iOException) {}
        } else {
            response.setHeader("Content-Disposition", "attachment; filename=default.pnp");
            ServletOutputStream outStream = null;
            try {
                outStream = response.getOutputStream();
                outStream.write(data);
            }
            catch (Exception e) {
                Log.error((Object)e);
            }
            finally {
                if (null != outStream) {
                    try {
                        outStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public ColumnsService getColumnsService() {
        return this.columnsService;
    }

    public void setColumnsService(ColumnsService columnsService) {
        this.columnsService = columnsService;
    }

    public ClassService getClassService() {
        return this.classService;
    }

    public void setClassService(ClassService classService) {
        this.classService = classService;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public CommentService getCommentService() {
        return this.commentService;
    }

    public void setCommentService(CommentService commentService) {
        this.commentService = commentService;
    }

    public UserInfo getUserInfo(PortalContext ctx) {
        if (null == ctx) {
            return null;
        }
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        if (null == context) {
            return null;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)context);
        return user;
    }
}

