/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.plt.cm.common.util.CMContentImgHandle;
import com.kingdee.portal.plt.cm.common.util.CMLicenseName;
import com.kingdee.portal.plt.cm.common.util.LicenseTool;
import com.kingdee.portal.plt.cm.module.content.dto.PicAttachmentDto;
import com.kingdee.portal.plt.cp.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.plt.cp.common.util.PageList;
import com.kingdee.portal.plt.cp.module.cm.dto.ColumnDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ContentDTO;
import com.kingdee.portal.plt.cp.module.cm.service.ClassService;
import com.kingdee.portal.plt.cp.module.cm.service.ColumnsService;
import com.kingdee.portal.plt.cp.module.cm.service.CommentService;
import com.kingdee.portal.plt.cp.module.cm.service.ContentService;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ClassServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ColumnsServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.CommentServiceImpl;
import com.kingdee.portal.plt.cp.module.cm.service.impl.ContentServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PicGroupAction
extends BaseAction {
    private ColumnsService columnsService = ColumnsServiceImpl.getInstance();
    private ClassService classService = ClassServiceImpl.getInstance();
    private ContentService contentService = ContentServiceImpl.getInstance();
    private CommentService commentService = CommentServiceImpl.getInstance();

    public String list() throws Exception {
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String columnId = FilterSpecialCharactersTool.cleanXSS(request.getParameter("columnId"));
        String classId = request.getParameter("classId");
        String keyWords = request.getParameter("keyWords");
        String page = request.getParameter("page");
        String pageSize = request.getParameter("pageSize");
        if (null != columnId) {
            columnId = columnId.replaceAll(" ", "+");
        }
        if (null != classId) {
            classId = classId.replaceAll(" ", "+");
        }
        if (null == columnId) {
            columnId = "";
        }
        if (null == classId) {
            classId = "";
        }
        if (null == keyWords) {
            keyWords = "";
        }
        if (null == page) {
            page = "";
        }
        if (null == pageSize) {
            pageSize = "";
        }
        keyWords = new String(keyWords.getBytes("iso-8859-1"), "utf-8");
        HttpSession session = request.getSession();
        ColumnDTO columnDTO = (ColumnDTO)session.getAttribute("PicNews_ColumnDTO_" + columnId);
        if (null == columnDTO) {
            columnDTO = this.columnsService.findBean(ctx, columnId);
            List classList = this.classService.findClassList(ctx, columnId);
            columnDTO.setClassList(classList);
            session.setAttribute("PicNews_ColumnDTO_" + columnId, (Object)columnDTO);
        }
        columnDTO = this.classService.addCurrClassList(columnDTO, classId);
        request.setAttribute("columnDTO", (Object)columnDTO);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("columnId", columnId);
        params.put("page", page);
        params.put("classId", classId);
        params.put("pageSize", pageSize);
        params.put("keyWords", keyWords);
        params.put("sortFieldName", "SUMBITTIME");
        params.put("sortType", SortType.DESCEND.getName());
        PageList contentList = this.contentService.pageList(ctx, params);
        request.setAttribute("contentList", (Object)contentList);
        request.setAttribute("columnId", (Object)columnId);
        request.setAttribute("classId", (Object)classId);
        request.setAttribute("keyWords", (Object)keyWords);
        request.setAttribute("page", (Object)contentList.getCurrentPage());
        request.setAttribute("pageSize", (Object)contentList.getPageSize());
        return "success";
    }

    public String view() throws Exception {
        boolean hasPermission;
        PortalContext ctx = this.getPortalContext();
        if (null == this.getUserInfo(ctx)) {
            return "session_out";
        }
        HttpServletRequest request = this.getRequest();
        String docId = request.getParameter("docId");
        if (null == docId || "".equals(docId)) {
            docId = request.getParameter("contentId");
        }
        if (null != docId) {
            docId = docId.replaceAll(" ", "+");
        }
        if (!(hasPermission = this.contentService.hasPermissionToRead(ctx, docId))) {
            return "noPermission";
        }
        boolean hasLicense = LicenseTool.checkLicense((HttpServletRequest)request, (String)CMLicenseName.licenseClassName);
        if (!hasLicense) {
            return "noLicense";
        }
        request.setAttribute("actionName", (Object)"viewPicNews");
        ContentDTO content = this.contentService.getViewContent(ctx, docId);
        int clicks = this.contentService.updateClicks(content, ctx);
        content.setClicks(clicks);
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String sql = "select * from T_CM_PicGroupImg where fcontentid='" + docId + "' order by Forder";
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql);
        ArrayList<PicAttachmentDto> pics = new ArrayList<PicAttachmentDto>();
        while (rowSet.next()) {
            PicAttachmentDto picDto = new PicAttachmentDto();
            String imgId = rowSet.getString("FImgId");
            String desc = rowSet.getString("FDescription");
            String mode = rowSet.getString("FImgMode");
            int order = rowSet.getInt("FOrder");
            picDto.setImgId(imgId);
            picDto.setContentId(docId);
            picDto.setDescription(desc);
            picDto.setImgMode(mode);
            picDto.setOrder(order);
            String imgPath = CMContentImgHandle.getImgFilePath((String)imgId, (Context)context);
            picDto.setImgPath(imgPath);
            pics.add(picDto);
        }
        request.setAttribute("content", (Object)content);
        request.setAttribute("contentPics", pics);
        request.setAttribute("isCanCopy", (Object)content.getCanCopy());
        request.setAttribute("docId", (Object)docId);
        return "success";
    }

    public UserInfo getUserInfo(PortalContext ctx) {
        if (null == ctx) {
            return null;
        }
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        if (null == context) {
            return null;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)context);
        return user;
    }
}

