/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.cm.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.cp.module.cm.dto.ClassDTO;
import com.kingdee.portal.plt.cp.module.cm.dto.ColumnDTO;
import com.kingdee.portal.plt.cp.module.cm.service.ClassService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassServiceImpl
implements ClassService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private static ClassService instance = null;

    private ClassServiceImpl() {
    }

    public static synchronized ClassService getInstance() {
        if (instance == null) {
            instance = new ClassServiceImpl();
        }
        return instance;
    }

    @Override
    public ClassDTO findBean(PortalContext ctx, String classId) throws DataAccessException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String ksql = "select FID,FNAME_L2 from T_CM_Class where fid=?";
        ClassDTO se = new ClassDTO();
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)ksql, (Object[])new String[]{classId});
            if (dataSet.next()) {
                String id = dataSet.getString("FID");
                se.setId(id);
                se.setName(dataSet.getString("FNAME_L2"));
                return se;
            }
        }
        catch (Exception e) {
            this.log.error(" ClassServiceImpl findBean sql=" + ksql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return se;
    }

    @Override
    public ColumnDTO addCurrClassList(ColumnDTO columnDTO, String classId) throws BOSException {
        List classList = columnDTO.getClassList();
        int lens = classList.size();
        for (int j = 0; j < lens; ++j) {
            ClassDTO cdto = (ClassDTO)classList.get(j);
            String cid = cdto.getId();
            if (null != classId && classId.equals(cid)) {
                cdto.setIsCuur("1");
            } else {
                cdto.setIsCuur("0");
            }
            columnDTO.setCuurClassDTO(cdto);
        }
        if (StringUtil.isEmpty((String)classId)) {
            columnDTO.setCuurClassDTO(null);
        }
        return columnDTO;
    }

    @Override
    public List<ClassDTO> findClassList(PortalContext ctx, String columnId) throws DataAccessException {
        ArrayList<ClassDTO> resultList = new ArrayList<ClassDTO>();
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        if (columnId.equals("tSFimQEREADgAAD5wKgSr7n/tuc=")) {
            return resultList;
        }
        String ksql = "select FID,FNAME_L2 from T_CM_Class where fcolumnid=? order by fnumber asc";
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)ksql, (Object[])new String[]{columnId});
            while (dataSet.next()) {
                ClassDTO se = new ClassDTO();
                String id = dataSet.getString("FID");
                se.setId(id);
                se.setName(dataSet.getString("FNAME_L2"));
                resultList.add(se);
            }
        }
        catch (Exception e) {
            this.log.error(" ClassServiceImpl findClassList sql=" + ksql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return resultList;
    }
}

