/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.document.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.NLSSortType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.dm.ApproveState;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.DocAreaInfo;
import com.kingdee.eas.cp.dm.DocumentBorrowCollection;
import com.kingdee.eas.cp.dm.DocumentBorrowFactory;
import com.kingdee.eas.cp.dm.DocumentBorrowInfo;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.IPortletSet;
import com.kingdee.eas.cp.dm.PortletSetFactory;
import com.kingdee.eas.cp.dm.PortletSetInfo;
import com.kingdee.eas.cp.dm.utils.CommonUtils;
import com.kingdee.eas.cp.dm.utils.MessageCenterService;
import com.kingdee.eas.cp.dm.web.DMPortletUtils;
import com.kingdee.eas.cp.dm.web.dto.CtrlUnitInfoDTO;
import com.kingdee.eas.cp.dm.web.service.DmColumnManagerService;
import com.kingdee.eas.cp.dm.web.util.PermissionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.CommonHelperUtil;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.cp.common.util.CpServiceLocator;
import com.kingdee.portal.plt.cp.module.document.entity.Category;
import com.kingdee.portal.plt.cp.module.document.entity.DmCategoryTreeDTO;
import com.kingdee.portal.plt.cp.module.document.entity.DmPermCacheInfo;
import com.kingdee.portal.plt.cp.module.document.entity.DmReadHistory;
import com.kingdee.portal.plt.cp.module.document.entity.Document;
import com.kingdee.portal.plt.cp.module.document.entity.DocumentBorrow;
import com.kingdee.portal.plt.cp.module.document.service.DocumentService;
import com.kingdee.portal.plt.cp.module.setting.util.ExportUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentAction
extends BaseAction {
    private static final long serialVersionUID = -1596297122941590710L;
    private static final Logger logger = LoggerFactory.getLogger(DocumentAction.class);
    private DocumentService documentService = (DocumentService)CpServiceLocator.getBean("documentService");

    public void findMySpecialList() {
        logger.info("into");
        String searchText = this.getRequest().getParameter("searchText");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String pageSize = this.getRequest().getParameter("pageSize");
        String pageNo = this.getRequest().getParameter("pageNo");
        logger.info("personID:" + personId + ",pageSize:" + pageSize + ",pageNo:" + pageNo + ",searchText:" + searchText);
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult documents = null;
        try {
            documents = this.documentService.findMySpecialList(ctx, personId, searchText, pageParam);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            documents = new PagingResult();
        }
        this.writePagingResult(documents);
    }

    public void findMyReadList() {
        logger.info("into");
        String searchText = this.getRequest().getParameter("searchText");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String pageSize = this.getRequest().getParameter("pageSize");
        String pageNo = this.getRequest().getParameter("pageNo");
        logger.info("personID:" + personId + ",pageSize:" + pageSize + ",pageNo:" + pageNo + ",searchText:" + searchText);
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult documents = null;
        try {
            documents = this.documentService.findMyReadList(ctx, personId, searchText, pageParam);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            documents = new PagingResult();
        }
        this.writePagingResult(documents);
    }

    public void findMyBookMarkList() {
        logger.info("into");
        String searchText = this.getRequest().getParameter("searchText");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String pageSize = this.getRequest().getParameter("pageSize");
        String pageNo = this.getRequest().getParameter("pageNo");
        logger.info("personID:" + personId + ",pageSize:" + pageSize + ",pageNo:" + pageNo + ",searchText:" + searchText);
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult documents = null;
        try {
            documents = this.documentService.findMyBookMarkList(ctx, personId, searchText, pageParam);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            documents = new PagingResult();
        }
        this.writePagingResult(documents);
    }

    public void findMyBorrowedList() {
        logger.info("into");
        String searchText = this.getRequest().getParameter("searchText");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String pageSize = this.getRequest().getParameter("pageSize");
        String pageNo = this.getRequest().getParameter("pageNo");
        logger.info("personID:" + personId + ",pageSize:" + pageSize + ",pageNo:" + pageNo + ",searchText:" + searchText);
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult documents = null;
        try {
            documents = this.documentService.findMyBorrowedList(ctx, personId, searchText, pageParam);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            documents = new PagingResult();
        }
        this.writePagingResult(documents);
    }

    public void findMySendList() {
        logger.info("into");
        String searchText = this.getRequest().getParameter("searchText");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String pageSize = this.getRequest().getParameter("pageSize");
        String pageNo = this.getRequest().getParameter("pageNo");
        logger.info("personID:" + personId + ",pageSize:" + pageSize + ",pageNo:" + pageNo + ",searchText:" + searchText);
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult documents = null;
        try {
            documents = this.documentService.findMySendList(ctx, personId, searchText, pageParam);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            documents = new PagingResult();
        }
        this.writePagingResult(documents);
    }

    public void findMyReceiveList() {
        logger.info("into");
        String searchText = this.getRequest().getParameter("searchText");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String pageSize = this.getRequest().getParameter("pageSize");
        String pageNo = this.getRequest().getParameter("pageNo");
        logger.info("personID:" + personId + ",pageSize:" + pageSize + ",pageNo:" + pageNo + ",searchText:" + searchText);
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult documents = null;
        try {
            documents = this.documentService.findMyReceiveList(ctx, personId, searchText, pageParam);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            documents = new PagingResult();
        }
        this.writePagingResult(documents);
    }

    public String loadDocumentList() {
        String type = this.getRequest().getParameter("type");
        String focusType = this.getRequest().getParameter("focusType");
        String portletName = this.getRequest().getParameter("portletName");
        String pId = this.getRequest().getParameter("pId");
        HttpServletRequest request = this.getRequest();
        String returnResult = null;
        Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null) {
            returnResult = "notperson";
            return returnResult;
        }
        try {
            returnResult = CommonHelperUtil.checkLicense((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse(), (String)"/plt_cp/document/loadDocumentList.action");
        }
        catch (Exception e) {
            returnResult = "checkLicence";
            request.setAttribute("message", (Object)e.getMessage());
            e.printStackTrace();
        }
        if ("success".equals(returnResult)) {
            try {
                String enterpriseDocName = this.documentService.getEnterpriseDocName(ctx);
                this.getRequest().setAttribute("enterpriseDocName", (Object)enterpriseDocName);
            }
            catch (Exception e) {
                logger.error("getEnterpriseDocName err", (Throwable)e);
            }
            this.getRequest().setAttribute("type", (Object)type);
            this.getRequest().setAttribute("focusType", (Object)focusType);
            this.getRequest().setAttribute("portletName", (Object)portletName);
            this.getRequest().setAttribute("pId", (Object)pId);
            returnResult = "loadDocumentList";
        }
        return returnResult;
    }

    public String loadMyRead() {
        return "loadMyRead";
    }

    public String viewDocument() {
        HttpServletRequest request = this.getRequest();
        String docId = request.getParameter("docId");
        docId = null == (docId = docId.replaceAll(" ", "+")) ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        Document document = null;
        int isAnonymous = 0;
        String returnResult = null;
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() == null) {
            returnResult = "notperson";
            return returnResult;
        }
        try {
            returnResult = CommonHelperUtil.checkLicense((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse(), (String)"/plt_cp/document/loadDocumentList.action");
        }
        catch (Exception e) {
            returnResult = "checkLicence";
            this.getRequest().setAttribute("message", (Object)e.getMessage());
            e.printStackTrace();
        }
        if (!"success".equals(returnResult)) {
            return returnResult;
        }
        boolean hasViewPerm = false;
        try {
            boolean canView = false;
            String permissions = com.kingdee.portal.plt.cp.module.document.service.PermissionUtil.getPermissionByDocId(ctx, docId);
            if (permissions != null) {
                String[] perms = permissions.split(",");
                for (int i = 0; perms != null && i < perms.length; ++i) {
                    if ("8".equals(perms[i])) {
                        request.setAttribute("canComment", (Object)"true");
                        continue;
                    }
                    if (!"4".equals(perms[i])) continue;
                    canView = true;
                    hasViewPerm = true;
                }
            }
            Document doc = this.documentService.getDocumentById(ctx, docId);
            String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            if (personId.equals(doc.getCreatePersonId())) {
                canView = true;
            }
            if (!canView) {
                return "noViewPermission";
            }
            document = this.documentService.getDocumentById(ctx, docId);
            IPerson person = PersonFactory.getRemoteInstanceWithObjectContext((Context)ctx);
            PersonInfo creatorName = person.getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)document.getCreatePersonId())));
            PersonInfo authororName = person.getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)document.getAuthorId())));
            request.setAttribute("creatorName", (Object)creatorName);
            request.setAttribute("authororName", (Object)authororName);
            if (document != null) {
                String categoryId = document.getCategoryId();
                Category category = this.documentService.getCategoryById(ctx, categoryId);
                isAnonymous = category.getIsAnonymous();
                request.setAttribute("isShowAuthorDeptCom", (Object)category.getIsShowAuthorDeptCom());
                request.setAttribute("isShowCreatorDeptCom", (Object)category.getIsShowCreatorDeptCom());
                if (1 == category.getIsShowAuthorDeptCom()) {
                    AdminOrgUnitInfo orgAuthor = person.getPrimaryAdminOrgUnit(BOSUuid.read((String)document.getAuthorId()));
                    CompanyOrgUnitInfo authorcompanyOrgUnitInfo = this.getCompanyOrgUnitByAdminOrgUnit(orgAuthor);
                    request.setAttribute("authorOrg", (Object)orgAuthor.getName());
                    request.setAttribute("authorComp", (Object)authorcompanyOrgUnitInfo.getName());
                }
                if (1 == category.getIsShowCreatorDeptCom()) {
                    AdminOrgUnitInfo orgCreator = person.getPrimaryAdminOrgUnit(BOSUuid.read((String)document.getCreatePersonId()));
                    CompanyOrgUnitInfo creatorcompanyOrgUnitInfo = this.getCompanyOrgUnitByAdminOrgUnit(orgCreator);
                    request.setAttribute("creatorOrg", (Object)orgCreator.getName());
                    request.setAttribute("creatorComp", (Object)creatorcompanyOrgUnitInfo.getName());
                }
                DmColumnManagerService dmService = new DmColumnManagerService(null);
                CategoryInfo catInfo = dmService.findCategoryInfoById(ctx, categoryId, null, null);
                DocAreaInfo docAreaInfo = dmService.findDocAreaInfoByAreaId(ctx, catInfo.getDocArea().getId().toString());
                CtrlUnitInfoDTO cuInfo = dmService.findCuInfo(ctx, docAreaInfo);
                request.setAttribute("cuInfo", (Object)cuInfo);
            }
            boolean isCommended = this.documentService.isDocumentCommended(ctx, docId);
            int commendCount = this.documentService.commendCount(ctx, docId);
            request.setAttribute("isCommended", (Object)isCommended);
            request.setAttribute("commendCount", (Object)String.valueOf(commendCount));
            boolean isBookMarked = this.documentService.isDocumentBookMarked(ctx, docId);
            request.setAttribute("isBookMarked", (Object)isBookMarked);
            int readCount = this.documentService.addDocumentReadNote(ctx, docId);
            request.setAttribute("readCount", (Object)readCount);
        }
        catch (Exception ex) {
            this.handleErr(ex);
        }
        if ("1".equals(document.getContentType())) {
            request.setAttribute("docContent", (Object)this.getDocContent(ctx, docId));
        }
        if ("4".equals(document.getContentType())) {
            IBoAttchAsso boAtt = null;
            BoAttchAssoCollection cols = null;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("boID", (Object)docId, CompareType.EQUALS));
            filter.setMaskString(" #0 ");
            ev.setFilter(filter);
            try {
                boAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
                cols = boAtt.getBoAttchAssoCollection(ev);
                if (cols.size() == 0) {
                    request.setAttribute("isPDFExist", (Object)false);
                } else {
                    request.setAttribute("isPDFExist", (Object)true);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        String borrowInfo = this.buildDocBorrowInfo(ctx, document);
        request.setAttribute("borrowInfo", (Object)borrowInfo);
        System.out.println("borrowInfo: " + borrowInfo);
        request.setAttribute("isAnonymous", (Object)isAnonymous);
        request.setAttribute("canDownload", (Object)document.getCanDownload());
        request.setAttribute("isPrintAttach", (Object)document.getIsPrintAttach());
        request.setAttribute("canCopy", (Object)document.getCanCopy());
        if (document.getIssueTime() == null) {
            request.setAttribute("createTime", (Object)new SimpleDateFormat("yyyy-MM-dd").format(document.getCreateTime()));
        } else {
            request.setAttribute("createTime", (Object)new SimpleDateFormat("yyyy-MM-dd").format(document.getIssueTime()));
        }
        request.setAttribute("document", (Object)document);
        request.setAttribute("hasViewPerm", (Object)hasViewPerm);
        return "viewDocument";
    }

    private String buildDocBorrowInfo(Context ctx, Document document) {
        String borrowId = this.getBorrowID(ctx, document);
        System.out.println("borrowId: " + borrowId);
        String borrowInfo = "";
        if (!"".equals(borrowId)) {
            String applyDate = "";
            String borrowTime = "";
            String approveDate = "";
            String leftTime = "";
            try {
                Timestamp curdate;
                long leftHour;
                Timestamp approveDate_time = null;
                int DayNum = 0;
                int HourNum = 0;
                int renewalDay = 0;
                int renewalHour = 0;
                DocumentBorrowCollection dbCols = DocumentBorrowFactory.getLocalInstance((Context)ctx).getDocumentBorrowCollection("select id,applyDate,approveDate,borrowTime,renewalTime,renewalId,state where id = '" + borrowId + "'or renewalId = '" + borrowId + "'");
                for (int i = 0; i < dbCols.size(); ++i) {
                    DocumentBorrowInfo dbInfo = dbCols.get(i);
                    if (!ApproveState.APPROVE.equals((Object)dbInfo.getState())) continue;
                    if (borrowId.equals(dbInfo.getId().toString())) {
                        applyDate = dbInfo.getApplyDate().toString().substring(0, 16);
                        approveDate = dbInfo.getApproveDate().toString().substring(0, 16);
                        approveDate_time = dbInfo.getApproveDate();
                        String[] timeArray = dbInfo.getBorrowTime().split("#");
                        DayNum = Integer.parseInt(timeArray[0]);
                        HourNum = Integer.parseInt(timeArray[1]);
                        continue;
                    }
                    if (!borrowId.equals(dbInfo.getRenewalId().toString())) continue;
                    String[] renewalArray = dbInfo.getBorrowTime().split("#");
                    renewalDay += Integer.parseInt(renewalArray[0]);
                    renewalHour += Integer.parseInt(renewalArray[1]);
                }
                if (approveDate_time == null) {
                    return borrowInfo;
                }
                borrowTime = "";
                if (DayNum + renewalDay > 0) {
                    borrowTime = borrowTime + (DayNum + renewalDay + (HourNum + renewalHour) / 24) + "\u5929";
                }
                if ((HourNum + renewalHour) % 24 > 0) {
                    borrowTime = borrowTime + (HourNum + renewalHour) % 24 + "\u5c0f\u65f6";
                }
                if ((leftHour = (long)((DayNum + renewalDay) * 24 + (HourNum + renewalHour)) - ((curdate = new Timestamp(System.currentTimeMillis())).getTime() - approveDate_time.getTime()) / 3600000L) / 24L == 0L && leftHour % 24L == 0L) {
                    leftTime = Long.toString((long)((DayNum + renewalDay) * 24 * 60 + (HourNum + renewalHour) * 60) - (curdate.getTime() - approveDate_time.getTime()) / 60000L);
                    leftTime = leftTime + "\u5206\u949f";
                } else if (leftHour / 24L >= 0L && leftHour % 24L >= 0L) {
                    leftTime = "";
                    if (leftHour / 24L > 0L) {
                        leftTime = leftTime + leftHour / 24L + "\u5929";
                    }
                    if (leftHour % 24L > 0L) {
                        leftTime = leftTime + leftHour % 24L + "\u5c0f\u65f6";
                    }
                } else {
                    leftTime = "\u7cfb\u7edf\u51fa\u9519!\u65e0\u6cd5\u53d6\u5f97\u65f6\u95f4";
                }
            }
            catch (BOSException e) {
                logger.error(e.getMessage());
            }
            borrowInfo = "\u501f\u9605\u7533\u8bf7\u65e5\u671f\uff1a" + applyDate + "  \u501f\u9605\u65f6\u957f\uff1a" + borrowTime + "  \u5ba1\u6279\u65e5\u671f\uff1a" + approveDate + "  \u5269\u4f59\u65f6\u957f\uff1a" + leftTime;
        }
        return borrowInfo;
    }

    private String getBorrowID(Context ctx, Document document) {
        String borrowId = "";
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String bizId = document.getCategoryId();
        String bizTableName = "t_dm_category";
        String docId = document.getId();
        Map<String, Set<String>> permssionMap = com.kingdee.portal.plt.cp.module.document.service.PermissionUtil.getBizPermMap(ctx, bizId, bizTableName);
        Set<String> perssionSet = null;
        if (permssionMap != null && permssionMap.size() > 0) {
            perssionSet = permssionMap.get(perId + bizId);
        }
        System.out.println("perssionSet: " + perssionSet);
        if (!PermissionUtil.hasSpecialPermOrCategoryPerm((Context)ctx, (String)docId, (String)bizId, (String)"4", (String)"4") && PermissionUtil.hasSpecialPermOrCategoryPerm((Context)ctx, (String)docId, (String)bizId, (String)"5", (String)"5")) {
            System.out.println("sj test, hasSpecialPermOrCategoryPerm in");
            String result = "";
            result = com.kingdee.portal.plt.cp.module.document.service.PermissionUtil.checkIsInBorrow(ctx, docId, perId);
            System.out.println("sj test, result: " + result);
            String[] resultArray = result.split(",");
            if ("1".equals(resultArray[0])) {
                borrowId = resultArray[1];
            }
        }
        return borrowId;
    }

    public String loadDocumentBorrow() {
        String docId = this.getRequest().getParameter("docId");
        docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        logger.error("docId:" + docId);
        Document document = null;
        int borrowDays = 0;
        try {
            document = this.documentService.getDocumentById(ctx, docId);
            if (document != null) {
                String categoryId = document.getCategoryId();
                Category category = this.documentService.getCategoryById(ctx, categoryId);
                borrowDays = category.getBorrowDays();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.handleErr(ex);
        }
        this.getRequest().setAttribute("borrowDays", (Object)borrowDays);
        this.getRequest().setAttribute("document", (Object)document);
        return "loadDocumentBorrow";
    }

    public String loadDocumentRecommend() {
        String docId = this.getRequest().getParameter("docId");
        docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        this.getRequest().setAttribute("docId", (Object)docId);
        return "loadDocumentRecommend";
    }

    public void exportReadHistory() {
        String id = this.getRequest().getParameter("id");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentHisQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("contentID", (Object)id);
        filterInfo.getFilterItems().add(filterItemInfo);
        entityViewInfo.setFilter(filterInfo);
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            rowSet = exec.executeQuery(0, Integer.MAX_VALUE);
            String reportDesc = "\u9605\u8bfb\u5386\u53f2";
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(reportDesc);
            this.createReportHead(reportDesc, workbook, sheet);
            this.createReportBody(workbook, sheet, rowSet);
            if (workbook != null) {
                this.printExcel(workbook, reportDesc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createReportHead(String reportDesc, HSSFWorkbook workbook, HSSFSheet sheet) {
        HSSFCellStyle titleStyle = ExportUtil.createCommonTitleStyle(workbook);
        ExportUtil.createTextStyle(workbook);
        ExportUtil.createNumericStyle(workbook);
        ExportUtil.createCenterTitleStyle(workbook);
        int rowNum = 0;
        int colNum = 0;
        sheet.setColumnWidth(0, 3000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        rowNum = 0;
        HSSFRow row = sheet.createRow(rowNum++);
        ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u9605\u8bfb\u8005");
        ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u9605\u8bfb\u65f6\u95f4");
        ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u90e8\u95e8");
    }

    private void createReportBody(HSSFWorkbook workbook, HSSFSheet sheet, IRowSet rowSet) throws Exception {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        HSSFCellStyle textStyle = ExportUtil.createTextStyle(workbook);
        int colNum = 0;
        int rowNum = 0;
        rowNum = 1;
        IPerson personService = PersonFactory.getRemoteInstanceWithObjectContext((Context)ctx);
        if (rowSet != null) {
            while (rowSet.next()) {
                String readerDep = "";
                String sql = "select a.fpersonid from t_pm_user a,T_ORG_BaseUnit b where a.fname_l2='" + rowSet.getString("reader") + "'  and b.fname_l2 = '" + rowSet.getString("readerDep") + "' and a.fdeforgunitid = b.fid";
                IRowSet col = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (col.next() && !StringUtil.isEmpty((String)col.getString("fpersonid"))) {
                    PersonInfo person = personService.getPersonInfo((IObjectPK)new ObjectUuidPK(col.getString("fpersonid")));
                    logger.info("person: " + person.getId().toString());
                    readerDep = personService.getPrimaryAdminOrgUnit(person.getId()).getName();
                    logger.info("readerDep: " + readerDep);
                }
                colNum = 0;
                String reader = rowSet.getString("reader");
                String readTime = rowSet.getString("readTime").substring(0, 16);
                HSSFRow row = sheet.createRow(rowNum++);
                ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, reader);
                ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, readTime);
                ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, readerDep);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printExcel(HSSFWorkbook workbook, String fileName) {
        HttpServletResponse response = this.getResponse();
        ServletOutputStream out = null;
        try {
            fileName = fileName == null ? "sample" : new String(fileName.getBytes("GB2312"), "ISO-8859-1");
            response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
            response.setContentType("application/x-msdownload;charset=GB2312");
            out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String getDocContent(Context ctx, String docId) {
        String docContent = "";
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String tempAttacheId = null;
        try {
            String[] ids = asm.getAttachmentIDsByBoID(docId);
            if (ids != null && ids.length > 0) {
                tempAttacheId = ids[0];
            }
            if (tempAttacheId != null) {
                AttachmentInfo info = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(tempAttacheId));
                if (info != null && info.getFile() == null) {
                    byte[] files = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(tempAttacheId);
                    info.setFile(files);
                }
                if (null != info && null != info.getFile()) {
                    byte[] contentByte = info.getFile();
                    docContent = new String(contentByte);
                }
            } else {
                docContent = "\u8be5\u6587\u6863\u6ca1\u6709\u5f55\u5165\u6b63\u6587!";
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return docContent;
    }

    private String getTypeName(String type) {
        if ("2".equals(type)) {
            return "doc";
        }
        if ("3".equals(type)) {
            return "xls";
        }
        if ("4".equals(type)) {
            return "pdf";
        }
        return "";
    }

    public String getAuthorDocs() {
        String docId = this.getRequest().getParameter("docId");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        List list = null;
        try {
            list = this.documentService.getAuthorDocs(ctx, docId);
        }
        catch (Exception e) {
            logger.error("getAuthorDocs error", (Throwable)e);
        }
        JSONArray arr = new JSONArray();
        for (int i = 0; i < list.size(); ++i) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"id", ((HashMap)list.get(i)).get("id"));
            obj.put((Object)"title", ((HashMap)list.get(i)).get("title"));
            arr.add((Object)obj);
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"result", (Object)true);
        jsonObj.put((Object)"params", (Object)arr);
        this.writeData2Response(this.getResponse(), jsonObj.toString());
        return null;
    }

    private void writeData2Response(HttpServletResponse response, String data) {
        logger.info("-----------------------data:" + data);
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(data);
            response.getWriter().flush();
        }
        catch (IOException e) {
            logger.error("Response\u56de\u5199\u6570\u636e\u51fa\u9519", (Throwable)e);
        }
    }

    public void findDmLeftTree() {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String id = this.getRequest().getParameter("id");
        String type = this.getRequest().getParameter("type");
        JSONArray array = null;
        try {
            logger.info("DmLefetree ParentId ====   " + id);
            if (!StringUtil.isEmpty((String)id)) {
                id = id.replaceAll("@", "+");
                logger.info("DmLefetree ParentId replace ====   " + id);
            }
            List<DmCategoryTreeDTO> orgList = this.documentService.findDmCategoryListByParentId(ctx, id, type);
            logger.info("orgList===" + orgList);
            array = this.buildOrgTreeArr(orgList, false);
        }
        catch (Exception e) {
            logger.info("Org Parent err ====   " + id);
            this.handleErr(e);
            array = new JSONArray();
        }
        this.writeData2Response(this.getResponse(), array.toString());
    }

    public void findDocsList() {
        logger.info("into");
        String searchText = this.getRequest().getParameter("searchText");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String categoryId = this.getRequest().getParameter("categoryId");
        String type = this.getRequest().getParameter("type");
        String pageSize = this.getRequest().getParameter("pageSize");
        String pageNo = this.getRequest().getParameter("pageNo");
        logger.info("pageSize:" + pageSize + ",pageNo:" + pageNo + ",categoryId:" + categoryId + ",type:" + type + ",searchText:" + searchText);
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult<Document> documents = null;
        try {
            if (type == null || "".equals(type)) {
                type = "category";
            }
            documents = this.documentService.findDocsList(ctx, searchText, pageParam, type, categoryId);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            documents = new PagingResult<Document>();
        }
        this.writePagingResult(documents);
    }

    public void findPortletDocsList() {
        String searchText = this.getRequest().getParameter("searchText");
        String pId = this.getRequest().getParameter("pId");
        String pageSize = this.getRequest().getParameter("pageSize");
        String pageNo = this.getRequest().getParameter("pageNo");
        logger.info("pageSize:" + pageSize + ",pageNo:" + pageNo + ",pId:" + pId + ",searchText:" + searchText);
        HttpServletRequest request = this.getRequest();
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        LocalErr localErr = null;
        if (request.getQueryString() != null && (URLDecoder.decode(request.getQueryString()).indexOf("'") > -1 || URLDecoder.decode(request.getQueryString()).indexOf("%27") > -1 || URLDecoder.decode(request.getQueryString()).indexOf(")") > -1)) {
            localErr = new LocalErr();
            localErr.setMsg("Unvalid Param value!");
            localErr.setDesc("Unvalid Param value!");
            request.setAttribute("portletErrInfo", (Object)localErr);
            try {
                request.getRequestDispatcher("/cp/common/portletErr.jsp").forward((ServletRequest)request, (ServletResponse)this.getResponse());
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult<Document> documents = new PagingResult<Document>();
        try {
            Set catIdSet = DMPortletUtils.getCatIdSetByPortlet((Context)ctx, (String)pId);
            Set enableCateIdSet = this.documentService.getEnableCates(ctx, catIdSet);
            HashSet<String> hasPermCatSet = new HashSet<String>();
            HashSet<String> allPermCat = new HashSet<String>();
            List lstPerm = com.kingdee.portal.plt.cp.module.document.service.PermissionUtil.getDmPermListCache();
            for (DmPermCacheInfo info : lstPerm) {
                if (info.getDocID() != null && info.getDocID().length() != 0) continue;
                allPermCat.add(info.getCatID());
            }
            for (Object obj : enableCateIdSet) {
                String cat = (String)obj;
                if (!allPermCat.contains(cat)) continue;
                hasPermCatSet.add(cat);
            }
            if (hasPermCatSet.size() != 0) {
                documents = this.documentService.findPortletDocsList(ctx, searchText, pageParam, hasPermCatSet);
                this.writePagingResult(documents);
            } else {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put((Object)"result", (Object)true);
                jsonObj.put((Object)"data", (Object)"nodata");
                this.writeData2Response(this.getResponse(), jsonObj.toString());
            }
        }
        catch (Exception ex) {
            this.handleErr(ex);
        }
    }

    public String findPortletDocsAttr() {
        String pId = this.getRequest().getParameter("pId");
        if (!this.checkPerson()) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"result", (Object)false);
            jsonObj.put((Object)"errorInfo", (Object)"\u8be5\u7528\u6237\u6ca1\u6709\u5173\u8054\u804c\u5458\uff0c\u4e0d\u80fd\u64cd\u4f5c\u6b64\u529f\u80fd\uff01");
            this.writeData2Response(this.getResponse(), jsonObj.toString());
            return null;
        }
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String returnResult = null;
        try {
            returnResult = CommonHelperUtil.checkLicense((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse(), (String)"/plt_cp/document/findPortletDocsAttr.action");
        }
        catch (Exception e) {
            returnResult = "checkLicence";
            this.getRequest().setAttribute("message", (Object)e.getMessage());
            e.printStackTrace();
        }
        if (!"success".equals(returnResult)) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"result", (Object)false);
            jsonObj.put((Object)"errorInfo", this.getRequest().getAttribute("message"));
            this.writeData2Response(this.getResponse(), jsonObj.toString());
            return null;
        }
        try {
            IPortletSet portletSet = PortletSetFactory.getLocalInstance((Context)ctx);
            PortletSetInfo portletInfo = (PortletSetInfo)portletSet.getValue((IObjectPK)new ObjectUuidPK(pId));
            PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"result", (Object)true);
            jsonObj.put((Object)"displayRows", (Object)portletInfo.getShowRows());
            jsonObj.put((Object)"displayColumns", (Object)portletInfo.getShowColumns());
            jsonObj.put((Object)"displayCat", (Object)portletInfo.isIsShowCat());
            jsonObj.put((Object)"displayAuthor", (Object)portletInfo.isIsShowAuthor());
            jsonObj.put((Object)"displayDate", (Object)portletInfo.isIsShowDate());
            jsonObj.put((Object)"scrollType", (Object)portletInfo.getScrollType().getValue());
            jsonObj.put((Object)"portletId", (Object)portletInfo.getId().toString());
            if (portletInfo.getDisplayCount() == 0) {
                jsonObj.put((Object)"displayCount", (Object)portletInfo.getShowRows());
            } else {
                jsonObj.put((Object)"displayCount", (Object)portletInfo.getDisplayCount());
            }
            jsonObj.put((Object)"categoryId", (Object)pId);
            if (person != null) {
                jsonObj.put((Object)"isPerson", (Object)true);
            } else {
                jsonObj.put((Object)"isPerson", (Object)false);
            }
            this.writeData2Response(this.getResponse(), jsonObj.toString());
        }
        catch (Exception ex) {
            this.handleErr(ex);
        }
        return null;
    }

    public void checkIsPerson() {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String returnResult = null;
        JSONObject jsonObj = new JSONObject();
        if (!this.checkPerson()) {
            jsonObj.put((Object)"result", (Object)false);
            jsonObj.put((Object)"errorInfo", (Object)"\u8be5\u7528\u6237\u6ca1\u6709\u5173\u8054\u804c\u5458\uff0c\u4e0d\u80fd\u64cd\u4f5c\u6b64\u529f\u80fd\uff01");
            jsonObj.put((Object)"isPerson", (Object)false);
            this.writeData2Response(this.getResponse(), jsonObj.toString());
        } else {
            jsonObj.put((Object)"isPerson", (Object)true);
            try {
                returnResult = CommonHelperUtil.checkLicense((HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse(), (String)"/plt_cp/document/findPortletDocsAttr.action");
            }
            catch (Exception e) {
                returnResult = "checkLicence";
                e.printStackTrace();
            }
            if (!"success".equals(returnResult)) {
                jsonObj.put((Object)"result", (Object)false);
                jsonObj.put((Object)"errorInfo", this.getRequest().getAttribute("message"));
            } else {
                jsonObj.put((Object)"result", (Object)true);
            }
            this.writeData2Response(this.getResponse(), jsonObj.toString());
        }
    }

    private boolean checkPerson() {
        boolean isPerson = false;
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        try {
            PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            if (person != null) {
                isPerson = true;
            }
        }
        catch (Exception ex) {
            this.handleErr(ex);
        }
        return isPerson;
    }

    public void findBorrowedListByDocId() {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String docId = this.getRequest().getParameter("docId");
        docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        String pageSize = this.getRequest().getParameter("pageSize");
        String pageNo = this.getRequest().getParameter("pageNo");
        logger.info("pageSize:" + pageSize + ",pageNo:" + pageNo + ",docId:" + docId);
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult documentBorrows = null;
        try {
            documentBorrows = this.documentService.findMyBorrowedListByDocId(ctx, docId, pageParam);
        }
        catch (Exception ex) {
            this.handleErr(ex);
            documentBorrows = new PagingResult();
        }
        this.writePagingResult(documentBorrows);
    }

    public void checkLastBorrowedState() {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String docId = this.getRequest().getParameter("docId");
        docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        boolean isNotInApprove = false;
        String pageSize = "1";
        String pageNo = "1";
        PagingParam pageParam = new PagingParam(new Integer(pageNo).intValue(), new Integer(pageSize).intValue());
        PagingResult<DocumentBorrow> documentBorrows = null;
        try {
            DocumentBorrow lastDB;
            documentBorrows = this.documentService.findMyBorrowedListByDocId(ctx, docId, pageParam);
            List dbList = documentBorrows.getRecords();
            isNotInApprove = dbList.size() == 0 ? true : !(lastDB = (DocumentBorrow)((Object)dbList.get(0))).getState().equals("0");
            this.writeAjaxData(true, null, isNotInApprove);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.writeAjaxData(false, this.handleErr(ex), null);
        }
    }

    public String addDocumentBorrow() {
        String docId = this.getRequest().getParameter("docId");
        docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        String borrowDay = this.getRequest().getParameter("borrowDay");
        String borrowHour = this.getRequest().getParameter("borrowHour");
        String borrowReason = this.getRequest().getParameter("borrowReason");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        DocumentBorrow documentBorrow = new DocumentBorrow();
        documentBorrow.setDocumentId(docId);
        documentBorrow.setApplyTime(borrowDay + "#" + borrowHour);
        documentBorrow.setBorrowReason(borrowReason);
        try {
            String wfBorrowProcess = this.documentService.getFWfBorrowProcess(ctx, docId);
            if (wfBorrowProcess == null || "".equals(wfBorrowProcess)) {
                this.documentService.addDocumentBorrow(ctx, documentBorrow);
            } else {
                this.documentService.addDocumentBorrowWf(ctx, documentBorrow);
                String borrowId = this.documentService.getLatestBorrowId(ctx, docId);
                Document document = this.documentService.getDocumentById(ctx, docId);
                IEnactmentService wfService = EnactmentServiceFactory.createEnactService((Context)ctx);
                HashMap<String, String> invokeContext = new HashMap<String, String>();
                invokeContext.put("billidString", borrowId);
                invokeContext.put("billName", document.getTitle());
                invokeContext.put("billNo", document.getNumber());
                HashMap<String, String> boMap = new HashMap<String, String>();
                boMap.put(borrowId, borrowId);
                wfService.createAndCompleteFiristActivity(wfBorrowProcess, invokeContext, ctx.getCaller().toString(), boMap);
            }
        }
        catch (Exception e) {
            logger.error("addDocumentBorrow error", (Throwable)e);
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"result", (Object)true);
        this.writeData2Response(this.getResponse(), jsonObj.toString());
        return null;
    }

    public String addDocumentCommend() {
        String docId = this.getRequest().getParameter("docId");
        docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        int commendCount = 0;
        boolean isCommended = this.documentService.isDocumentCommended(ctx, docId);
        try {
            if (isCommended) {
                this.documentService.delDocumentCommend(ctx, docId);
            } else {
                this.documentService.addDocumentCommend(ctx, docId);
            }
            commendCount = this.documentService.commendCount(ctx, docId);
        }
        catch (Exception e) {
            logger.error("addDocumentCommend error", (Throwable)e);
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"isCommended", (Object)(!isCommended ? 1 : 0));
        jsonObj.put((Object)"commendCount", (Object)commendCount);
        this.writeData2Response(this.getResponse(), jsonObj.toString());
        return null;
    }

    public String addDocumentRecommend() {
        block6: {
            String docId = this.getRequest().getParameter("docId");
            docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
            String personIds = this.getRequest().getParameter("personIds");
            PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
            Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
            try {
                String[] ids;
                if (personIds == null || "".equals(personIds)) break block6;
                this.documentService.addDocumentRecommend(ctx, docId, personIds);
                ArrayList<PersonInfo> docRecommendRecieverList = new ArrayList<PersonInfo>();
                ArrayList<String> recieverList = new ArrayList<String>();
                for (String string : ids = personIds.split(",")) {
                    recieverList.add(string);
                }
                PersonCollection recommendRecieverColl = null;
                try {
                    recommendRecieverColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select id, name, number where id in" + CommonUtils.getStrFromList(recieverList));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                int size = recommendRecieverColl.size();
                for (int i = 0; i < size; ++i) {
                    docRecommendRecieverList.add(recommendRecieverColl.get(i));
                }
                this.sendRecommendSysInfo(docRecommendRecieverList, docId, ctx);
                JSONObject jsonObj = new JSONObject();
                jsonObj.put((Object)"result", (Object)true);
                this.writeData2Response(this.getResponse(), jsonObj.toString());
            }
            catch (Exception e) {
                logger.error("addDocumentRecommend error", (Throwable)e);
            }
        }
        return null;
    }

    private void sendRecommendSysInfo(List<PersonInfo> docRecommendAccepterList, String docId, Context ctx) {
        String personName = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getName();
        try {
            MessageCenterService.sendMessage((Context)ctx, docRecommendAccepterList, (String)this.getMessageTitle(ctx, docId, personName), (String)personName, (String)this.getMessageTitle(ctx, docId, personName), (String)docId);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private String getMessageTitle(Context ctx, String docId, String personName) {
        DocumentInfo docInfo = null;
        try {
            docInfo = DocumentFactory.getLocalInstance((Context)ctx).getDocumentInfo("select title where id='" + docId + "'");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(personName).append("\u7ed9\u60a8\u53d1\u9001\u4e86\u6587\u6863: ").append(docInfo.getTitle());
        return sb.toString();
    }

    public String addDocumentBookMark() {
        String docId = this.getRequest().getParameter("docId");
        docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        try {
            this.documentService.addDocumentBookMark(ctx, docId);
        }
        catch (Exception e) {
            logger.error("addDocumentBookMark error", (Throwable)e);
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"result", (Object)true);
        this.writeData2Response(this.getResponse(), jsonObj.toString());
        return null;
    }

    public void queryDocumentHistory() throws Exception {
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String page = this.getRequest().getParameter("pageNumber");
        String pageSizeStr = this.getRequest().getParameter("pageSize");
        String orderByField = "readTime";
        String orderType = SortType.DESCEND.getName();
        String nlsOrderType = "";
        String id = this.getRequest().getParameter("id");
        id = id.trim().replaceAll(" ", "+");
        orderType = orderType.toUpperCase();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("contentID", (Object)id);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "20";
        }
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        orderType = orderType.toUpperCase();
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentHisQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            if (countRowSet.next()) {
                total = countRowSet.size();
                logger.debug("record total is\ufffd\ufffd" + total);
            }
            totalPage = (total - 1) / pageSize + 1;
            logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            if (nlsOrderType != null && !"".equals(nlsOrderType)) {
                sorterItemInfo.setNLSSortType(NLSSortType.getEnum((String)nlsOrderType));
            }
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            logger.debug("executor search content sql is:" + exec.getSQL());
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<DmReadHistory> list = new ArrayList<DmReadHistory>();
            IPerson personService = PersonFactory.getRemoteInstanceWithObjectContext((Context)ctx);
            if (rowSet != null) {
                while (rowSet.next()) {
                    DmReadHistory history = new DmReadHistory();
                    history.setReaderDep("");
                    String sql = "select a.fpersonid from t_pm_user a,T_ORG_BaseUnit b where a.fname_l2='" + rowSet.getString("reader") + "'  and b.fname_l2 = '" + rowSet.getString("readerDep") + "' and a.fdeforgunitid = b.fid";
                    IRowSet col = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (col.next()) {
                        if (StringUtils.isEmpty((String)col.getString("fpersonid"))) continue;
                        PersonInfo person = personService.getPersonInfo((IObjectPK)new ObjectUuidPK(col.getString("fpersonid")));
                        logger.info("person: " + person.getId().toString());
                        history.setReaderDep(personService.getPrimaryAdminOrgUnit(person.getId()).getName());
                        logger.info("history.getReaderDep(): " + history.getReaderDep());
                    }
                    history.setReader(rowSet.getString("reader"));
                    history.setReadTime(rowSet.getString("readTime").substring(0, 16));
                    list.add(history);
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            logger.error("" + e.getMessage());
        }
    }

    public String documentReadHistoryManager() {
        this.getRequest().setAttribute("id", (Object)this.getRequest().getParameter("id"));
        this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
        return "success";
    }

    public String cancelDocumentBookMark() {
        String docId = this.getRequest().getParameter("docId");
        docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        try {
            this.documentService.cancelDocumentBookMark(ctx, docId);
        }
        catch (Exception e) {
            logger.error("cancelDocumentBookMark error", (Throwable)e);
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"result", (Object)true);
        this.writeData2Response(this.getResponse(), jsonObj.toString());
        return null;
    }

    public String getDocPermissions() {
        String docId = this.getRequest().getParameter("docId");
        docId = null == docId ? docId : StringUtils.replace((String)docId, (String)"%2B", (String)"+");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String perms = "";
        try {
            perms = com.kingdee.portal.plt.cp.module.document.service.PermissionUtil.getPermissionByDocId(ctx, docId);
            Document doc = this.documentService.getDocumentById(ctx, docId);
            String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            if (personId.equals(doc.getCreatePersonId())) {
                perms = perms != null && perms.length() > 0 ? perms + ",4" : "4";
            }
        }
        catch (Exception e) {
            logger.error("getDocPermissions error", (Throwable)e);
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"result", (Object)true);
        jsonObj.put((Object)"perms", (Object)perms);
        this.writeData2Response(this.getResponse(), jsonObj.toString());
        return null;
    }

    public void findCategoryName() {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String categoryId = this.getRequest().getParameter("categoryId");
        try {
            Category category = this.documentService.getCategoryById(ctx, categoryId);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"result", (Object)true);
            jsonObj.put((Object)"categoryName", (Object)category.getName());
            this.writeData2Response(this.getResponse(), jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getDocTagContent() {
        HttpServletRequest req = this.getRequest();
        String docId = this.getRequest().getParameter("docId");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)req);
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        List tagList = this.getTagList(req, docId);
        int len = tagList.size();
        StringBuffer mark = new StringBuffer();
        if (0 < len) {
            int i;
            mark.append(" (");
            for (i = 0; i < len; ++i) {
                filter.getFilterItems().add(new FilterItemInfo("tag", tagList.get(i), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("tag", (Object)(tagList.get(i) + ",%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("tag", (Object)("%," + tagList.get(i)), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("tag", (Object)("%," + tagList.get(i) + ",%"), CompareType.LIKE));
                if (i > 0) {
                    mark.append(" or ");
                }
                mark.append("(#").append(4 * i).append(" or #").append(4 * i + 1).append(" or #").append(4 * i + 2).append(" or #").append(4 * i + 3).append(")");
            }
            mark.append(")");
            List lstPerm = com.kingdee.portal.plt.cp.module.document.service.PermissionUtil.getDmPermListCache();
            HashSet<String> idSet = new HashSet<String>();
            HashSet<String> catIdSet = new HashSet<String>();
            for (DmPermCacheInfo info : lstPerm) {
                if (!StringUtils.isEmpty((String)info.getDocID())) {
                    idSet.add(info.getDocID());
                    continue;
                }
                if (StringUtils.isEmpty((String)info.getCatID())) continue;
                catIdSet.add(info.getCatID());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)docId, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isHistory", (Object)"0", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("wfState", (Object)3, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("category.state", (Object)1, CompareType.EQUALS));
            mark.append(" and");
            mark.append(" #" + 4 * i + " and #" + (4 * i + 1) + " and #" + (4 * i + 2) + " and #" + (4 * i + 3));
            int permCount = 0;
            if (null != idSet && idSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                ++permCount;
            }
            if (null != catIdSet && catIdSet.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("category.id", catIdSet, CompareType.INCLUDE));
                ++permCount;
            }
            if (permCount == 1) {
                mark.append(" and #" + (4 * i + 4));
            } else if (permCount == 2) {
                mark.append(" and (#" + (4 * i + 4) + " or #" + (4 * i + 5) + ")");
            }
            filter.setMaskString(mark.toString());
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata", CompareType.EQUALS));
        }
        view.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.dm.app.DocTagSearchQuery"));
        exec.setObjectView(view);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        try {
            IRowSet rowSet = exec.executeQuery(0, 10);
            ArrayList list = new ArrayList();
            if (rowSet != null) {
                while (rowSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", rowSet.getString("id"));
                    map.put("title", rowSet.getString("title"));
                    list.add(map);
                }
            }
            this.writeAjaxData(!list.isEmpty(), null, list);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void getAuthorOtherContent() {
        HttpServletRequest req = this.getRequest();
        String docId = this.getRequest().getParameter("docId");
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String userId = ContextUtil.getCurrentUserInfo((Context)WebContextUtil.getEasContext((HttpServletRequest)req)).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)WebContextUtil.getEasContext((HttpServletRequest)req)).getPerson().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("author.id", (Object)this.getAuthor(req, docId), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)docId, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isHistory", (Object)"0", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("wfState", (Object)3, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("category.state", (Object)1, CompareType.EQUALS));
        StringBuffer mark = new StringBuffer(" #0 and  #1 and #2  and #3 and #4 ");
        List lstPerm = com.kingdee.portal.plt.cp.module.document.service.PermissionUtil.getDmPermListCache();
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> catIdSet = new HashSet<String>();
        for (DmPermCacheInfo info : lstPerm) {
            if (!StringUtils.isEmpty((String)info.getDocID())) {
                idSet.add(info.getDocID());
                continue;
            }
            if (StringUtils.isEmpty((String)info.getCatID())) continue;
            catIdSet.add(info.getCatID());
        }
        int permCount = 0;
        if (null != idSet && idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            ++permCount;
        }
        if (null != catIdSet && catIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("category.id", catIdSet, CompareType.INCLUDE));
            ++permCount;
        }
        if (permCount == 1) {
            mark.append(" and #5");
        } else if (permCount == 2) {
            mark.append(" and (#5 or #6)");
        }
        filter.setMaskString(mark.toString());
        view.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.dm.app.DocTagSearchQuery"));
        exec.setObjectView(view);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        try {
            IRowSet rowSet = exec.executeQuery(0, 10);
            ArrayList list = new ArrayList();
            if (rowSet != null) {
                while (rowSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", rowSet.getString("id"));
                    map.put("title", rowSet.getString("title"));
                    list.add(map);
                }
            }
            this.writeAjaxData(!list.isEmpty(), null, list);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void isConvertFinish() {
        HttpServletRequest req = this.getRequest();
        String flashFileId = req.getParameter("flashFileId");
        String ct = req.getParameter("createTime");
        try {
            flashFileId = URLEncoder.encode(flashFileId, "UTF-8");
            flashFileId = flashFileId.replaceAll("%", "");
            flashFileId = flashFileId.replaceAll("\\+", "2B");
            flashFileId = flashFileId.replaceAll("=", "3D");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        String path_url = ct.substring(0, 4) + "/" + ct.substring(5, 7) + "/" + ct.substring(8, 10) + "/" + flashFileId + ".swf";
        String easHome = System.getProperty("EAS_HOME");
        String path = easHome + "/server/deploy/portal.ear/plt_cp.war/resource/" + path_url;
        System.out.println("path:" + path);
        File dir = new File(path);
        this.writeAjaxData(true, null, dir.exists());
    }

    private String getAuthor(HttpServletRequest req, String docId) {
        String authorId = new String();
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)req);
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        ObjectUuidPK pk = new ObjectUuidPK(docId);
        DocumentInfo model = new DocumentInfo();
        try {
            model = (DocumentInfo)DocumentFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk, this.getSelectors4Author());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
        }
        if (null != model.getAuthor()) {
            authorId = model.getAuthor().getId().toString();
        }
        return authorId;
    }

    private SelectorItemCollection getSelectors4Author() {
        SelectorItemCollection seletor = new SelectorItemCollection();
        seletor.add(new SelectorItemInfo("id"));
        seletor.add(new SelectorItemInfo("author.id"));
        return seletor;
    }

    private List getTagList(HttpServletRequest req, String docId) {
        ArrayList<String> tagList = new ArrayList<String>();
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)req);
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        ObjectUuidPK pk = new ObjectUuidPK(docId);
        DocumentInfo model = new DocumentInfo();
        try {
            model = (DocumentInfo)DocumentFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk, this.getSelectors4Tag());
        }
        catch (EASBizException e) {
            logger.error(e.getMessage());
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
        }
        if (null != model.getTag() && !"".equals(model.getTag())) {
            String[] tagArray;
            for (String str : tagArray = model.getTag().split(",")) {
                tagList.add(str);
            }
        }
        return tagList;
    }

    private SelectorItemCollection getSelectors4Tag() {
        SelectorItemCollection seletor = new SelectorItemCollection();
        seletor.add(new SelectorItemInfo("id"));
        seletor.add(new SelectorItemInfo("tag"));
        return seletor;
    }

    private JSONArray buildOrgTreeArr(List<DmCategoryTreeDTO> dmCategoryList, boolean isSearch) throws PortalBizException {
        JSONArray array = new JSONArray();
        JSONObject treeNode = null;
        for (DmCategoryTreeDTO org : dmCategoryList) {
            treeNode = new JSONObject();
            treeNode.put((Object)"id", (Object)org.getId());
            if (!isSearch) {
                treeNode.put((Object)"isParent", (Object)(!org.isLeaf() ? 1 : 0));
                treeNode.put((Object)"pId", (Object)org.getParentId());
                treeNode.put((Object)"open", (Object)false);
            }
            String name = "";
            String desc = "";
            if (org.getName() != null) {
                name = org.getName();
            }
            if (org.getDesc() != null) {
                desc = org.getDesc();
            }
            treeNode.put((Object)"name", (Object)name);
            treeNode.put((Object)"desc", (Object)desc);
            treeNode.put((Object)"type", (Object)org.getType());
            array.add((Object)treeNode);
        }
        return array;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitByAdminOrgUnit(AdminOrgUnitInfo adminOrgUnitInfo) {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        try {
            INewOrgUnitFacade iOrg = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx);
            companyOrgUnitInfo = (CompanyOrgUnitInfo)iOrg.getDelegateUnit(adminOrgUnitInfo.getId().toString(), OrgType.Company);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return companyOrgUnitInfo;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

