/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.document.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.dm.ApproveState;
import com.kingdee.eas.cp.dm.DocumentBorrowCollection;
import com.kingdee.eas.cp.dm.DocumentBorrowFactory;
import com.kingdee.eas.cp.dm.DocumentBorrowInfo;
import com.kingdee.eas.cp.dm.web.service.DefaultDmPermissionService;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.plt.cp.module.document.entity.DmPermCacheInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;

public class PermissionUtil {
    public static Logger logger = Logger.getLogger(PermissionUtil.class);
    private static List dmPermListCache;
    public static final String CATEGORY = "category";
    public static final String DOCAREA = "docarea";
    public static final String BORROW_DOC = "5";
    public static final String VIEW_DOC = "4";
    public static final String DOCUMENT_VIEW = "4";
    public static final String DOCUMENT_VIEW_HISTORY = "20";
    public static final String DOCUMENT_BORROW = "5";

    protected static HttpServletRequest getRequest() {
        return ServletActionContext.getRequest();
    }

    public static List getDmPermListCache() {
        if (null == dmPermListCache || dmPermListCache.size() < 1) {
            PermissionUtil.initPermListCache();
        }
        return dmPermListCache;
    }

    public static void setDmPermListCache(List dmPermListCache) {
        PermissionUtil.dmPermListCache = dmPermListCache;
    }

    public static void clearDmPermListCache() {
        PermissionUtil.setDmPermListCache(null);
    }

    public static void initPermListCache() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)ServletActionContext.getRequest());
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        StringBuffer getAllAdminSql = new StringBuffer();
        getAllAdminSql.append("select ADMINP.fname_l2,ADMINP.flongnumber,ADMINP.fnumber,person.fname_l2,person.fid  \n");
        getAllAdminSql.append("FROM T_BD_PERSON PERSON \n");
        getAllAdminSql.append("LEFT OUTER JOIN T_ORG_PositionMember PM ON PM.FPERSONID = PERSON.FID \n");
        getAllAdminSql.append("LEFT OUTER JOIN T_ORG_Position POSITION ON POSITION.FID = PM.FPOSITIONID \n");
        getAllAdminSql.append("LEFT OUTER JOIN T_ORG_ADMIN ADMINP ON ADMINP.FID = POSITION.FADMINORGUNITID \n");
        getAllAdminSql.append("where PERSON.fid='");
        getAllAdminSql.append(personId);
        getAllAdminSql.append("'");
        Set rtnSet = PermissionUtil.getAllAdminSqlMethd(ctx, getAllAdminSql);
        ArrayList<String> adminNumList = null;
        if (null != rtnSet && rtnSet.size() > 0) {
            adminNumList = new ArrayList<String>(rtnSet.size());
            for (String number : rtnSet) {
                adminNumList.add(number);
            }
        }
        StringBuffer sb = PermissionUtil.getAllPermByPersonSql(personId, adminNumList);
        List list = PermissionUtil.getDmPermListCacheBySql(sb);
        PermissionUtil.setDmPermListCache(list);
    }

    public static void initPermListCache(Context ctx) {
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        StringBuffer getAllAdminSql = new StringBuffer();
        getAllAdminSql.append("select ADMINP.fname_l2,ADMINP.flongnumber,ADMINP.fnumber,person.fname_l2,person.fid  \n");
        getAllAdminSql.append("FROM T_BD_PERSON PERSON \n");
        getAllAdminSql.append("LEFT OUTER JOIN T_ORG_PositionMember PM ON PM.FPERSONID = PERSON.FID \n");
        getAllAdminSql.append("LEFT OUTER JOIN T_ORG_Position POSITION ON POSITION.FID = PM.FPOSITIONID \n");
        getAllAdminSql.append("LEFT OUTER JOIN T_ORG_ADMIN ADMINP ON ADMINP.FID = POSITION.FADMINORGUNITID \n");
        getAllAdminSql.append("where PERSON.fid='");
        getAllAdminSql.append(personId);
        getAllAdminSql.append("'");
        Set rtnSet = PermissionUtil.getAllAdminSqlMethd(ctx, getAllAdminSql);
        ArrayList<String> adminNumList = null;
        if (null != rtnSet && rtnSet.size() > 0) {
            adminNumList = new ArrayList<String>(rtnSet.size());
            for (String number : rtnSet) {
                adminNumList.add(number);
            }
        }
        StringBuffer sb = PermissionUtil.getAllPermByPersonSql(personId, adminNumList);
        List list = PermissionUtil.getDmPermListCacheBySql(sb, ctx);
        PermissionUtil.setDmPermListCache(list);
    }

    public static StringBuffer getAllPermByPersonSql(String personId, List adminNumList) {
        if (null == adminNumList) {
            adminNumList = new ArrayList<String>();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select adminID,roleID,personID,permList,docID,catID,catNumber,catLongNumber,docAreaID from (").append(PermissionUtil.getPerm4CatAdminSql(personId, adminNumList)).append(" UNION ALL").append(PermissionUtil.getPerm4CatRoleSql(personId)).append(" UNION ALL").append(PermissionUtil.getPerm4CatPersonSql(personId)).append(" UNION ALL").append(PermissionUtil.getPerm4DocAdminSql(personId, adminNumList)).append(" UNION ALL").append(PermissionUtil.getPerm4DocRoleSql(personId)).append(" UNION ALL").append(PermissionUtil.getPerm4DocPersonSql(personId)).append(") t");
        return sb;
    }

    private static StringBuffer getPerm4CatAdminSql(String personId, List<String> adminNumList) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" T_DM_CategoryAdmin.FAdminID AS adminID,").append(" null as roleID,").append(" null as personID,").append(" T_DM_CategoryAdmin.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Category T_DM_Category RIGHT OUTER JOIN T_DM_CategoryAdmin T_DM_CategoryAdmin ON T_DM_Category.FID = T_DM_CategoryAdmin.FParentID").append(" WHERE").append(" EXISTS (SELECT T_ORG_Admin.FID").append("         FROM T_ORG_Position T_ORG_Position").append("         INNER JOIN T_ORG_PositionMember T_ORG_PositionMember ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID").append("         INNER JOIN T_ORG_Admin T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID = T_ORG_Admin.FID").append("         WHERE T_ORG_PositionMember.FPersonID = '").append(personId).append("'        AND T_ORG_Admin.FID = T_DM_CategoryAdmin.FAdminID )").append(" OR EXISTS (SELECT T_ORG_Admin.FID").append(" FROM T_ORG_Admin T_ORG_Admin").append("            WHERE T_ORG_Admin.FID = T_DM_CategoryAdmin.FAdminID AND T_ORG_Admin.FNumber IN ").append(PermissionUtil.getStrFromList(adminNumList)).append(" AND T_DM_CategoryAdmin.FIncludeSub = 1)").append(" AND T_DM_Category.FState <> 2");
        return sb;
    }

    private static StringBuffer getPerm4CatRoleSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" null as adminID,").append(" T_DM_CategoryRole.FRoleID AS roleID,").append(" null as personID,").append(" T_DM_CategoryRole.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_CategoryRole T_DM_CategoryRole LEFT OUTER JOIN T_PM_UserRoleOrg T_PM_UserRoleOrg ON T_DM_CategoryRole.FRoleID = T_PM_UserRoleOrg.FRoleID").append(" RIGHT OUTER JOIN T_DM_Category T_DM_Category ON T_DM_CategoryRole.FParentID = T_DM_Category.FID").append(" INNER JOIN T_PM_User T_PM_User ON T_PM_UserRoleOrg.FUserID = T_PM_User.FID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_PM_User.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private static StringBuffer getPerm4CatPersonSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT").append(" null as adminID,").append(" null as roleID,").append(" T_DM_CategoryPerson.FPersonID AS personID,").append(" T_DM_CategoryPerson.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Category T_DM_Category INNER JOIN T_DM_CategoryPerson T_DM_CategoryPerson ON T_DM_Category.FID = T_DM_CategoryPerson.FParentID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_DM_CategoryPerson.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private static StringBuffer getPerm4DocAdminSql(String personId, List<String> adminNumList) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" T_DM_DocumentAdmin.FAdminID AS adminID,").append(" null as roleID,").append(" null as personID,").append(" T_DM_DocumentAdmin.FPermList AS permList,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_DocumentAdmin T_DM_DocumentAdmin LEFT OUTER JOIN T_DM_Document T_DM_Document ON T_DM_DocumentAdmin.FParentID = T_DM_Document.FID").append(" INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" WHERE ").append(" EXISTS (SELECT T_ORG_Admin.FID").append(" \t\t  FROM T_ORG_Position T_ORG_Position").append(" \t\t  INNER JOIN T_ORG_PositionMember T_ORG_PositionMember ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID").append(" \t\t  INNER JOIN T_ORG_Admin T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID = T_ORG_Admin.FID").append(" \t\t  WHERE T_ORG_PositionMember.FPersonID = '").append(personId).append("'\t\t  AND T_ORG_Admin.FID = T_DM_DocumentAdmin.FAdminID)").append(" \t\t  OR EXISTS ( SELECT T_ORG_Admin.FID").append(" \t\t  FROM T_ORG_Admin T_ORG_Admin").append(" \t\t  WHERE T_ORG_Admin.FID = T_DM_DocumentAdmin.FAdminID AND T_ORG_Admin.FNumber IN ").append(PermissionUtil.getStrFromList(adminNumList)).append(" \t\t  AND T_DM_DocumentAdmin.FIncludeSub = 1)").append(" \t\t  AND T_DM_Category.FState <> 2 AND T_DM_Document.FState <> 2");
        return sb;
    }

    private static StringBuffer getPerm4DocRoleSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" null as adminID,").append(" T_DM_DocumentRole.FRoleID AS roleID,").append(" null as personID,").append(" T_DM_DocumentRole.FPermList AS permList,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Document T_DM_Document INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" RIGHT OUTER JOIN T_DM_DocumentRole T_DM_DocumentRole ON T_DM_Document.FID = T_DM_DocumentRole.FParentID").append(" LEFT OUTER JOIN T_PM_UserRoleOrg T_PM_UserRoleOrg ON T_DM_DocumentRole.FRoleID = T_PM_UserRoleOrg.FRoleID").append(" INNER JOIN T_PM_User T_PM_User ON T_PM_UserRoleOrg.FUserID = T_PM_User.FID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_DM_Document.FState <> 2 AND T_PM_User.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private static StringBuffer getPerm4DocPersonSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT").append(" null as adminID,").append(" null as roleID,").append(" T_DM_DocumentPerson.FPersonID AS personID,").append(" T_DM_DocumentPerson.FPermList AS permList,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Document T_DM_Document INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" INNER JOIN T_DM_DocumentPerson T_DM_DocumentPerson ON T_DM_Document.FID = T_DM_DocumentPerson.FParentID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_DM_DocumentPerson.FPersonID = '").append(personId).append("'");
        return sb;
    }

    public static String getStrFromList(List<String> list) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append(list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append(list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append(list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static List getDmPermListCacheBySql(StringBuffer sql) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)PermissionUtil.getRequest());
        ArrayList<DmPermCacheInfo> list = null;
        try {
            logger.info((Object)("DefaultDmPermissionService::getDmPermListCacheBySql--sql = " + sql.toString()));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            list = new ArrayList<DmPermCacheInfo>(rs.size());
            logger.info((Object)("getDmPermListCacheBySql: rs.size()=" + rs.size()));
            DmPermCacheInfo dp = null;
            while (rs.next()) {
                dp = new DmPermCacheInfo(rs.getString("adminID"), rs.getString("roleID"), rs.getString("personID"), rs.getString("permList"), rs.getString("docID"), rs.getString("catID"), rs.getString("docAreaID"), rs.getString("catNumber"), rs.getString("catLongNumber"));
                list.add(dp);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("getDmPermListCacheBySql error:" + e.getMessage()));
        }
        catch (SQLException e) {
            logger.error((Object)("getDmPermListCacheBySql error:" + e.getMessage()));
        }
        return list;
    }

    public static List getDmPermListCacheBySql(StringBuffer sql, Context ctx) {
        ArrayList<DmPermCacheInfo> list = null;
        try {
            logger.info((Object)("DefaultDmPermissionService::getDmPermListCacheBySql--sql = " + sql.toString()));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            list = new ArrayList<DmPermCacheInfo>(rs.size());
            logger.info((Object)("getDmPermListCacheBySql: rs.size()=" + rs.size()));
            DmPermCacheInfo dp = null;
            while (rs.next()) {
                dp = new DmPermCacheInfo(rs.getString("adminID"), rs.getString("roleID"), rs.getString("personID"), rs.getString("permList"), rs.getString("docID"), rs.getString("catID"), rs.getString("docAreaID"), rs.getString("catNumber"), rs.getString("catLongNumber"));
                list.add(dp);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("getDmPermListCacheBySql error:" + e.getMessage()));
        }
        catch (SQLException e) {
            logger.error((Object)("getDmPermListCacheBySql error:" + e.getMessage()));
        }
        return list;
    }

    public static Set getAllAdminSqlMethd(Context ctx, StringBuffer getAllAdminSql) {
        HashSet<String> rtnSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getAllAdminSql.toString());
            while (rs.next()) {
                String adminLongNum = rs.getString("flongnumber");
                if (null == adminLongNum || "".equals(adminLongNum)) continue;
                String[] as = adminLongNum.split("!");
                int len = as.length;
                for (int i = 0; i < len; ++i) {
                    rtnSet.add(as[i]);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rtnSet;
    }

    public static String getPermissionByDocId(Context ctx, String docId) {
        String permissionStr = "";
        if (null == docId || "".equals(docId)) {
            return permissionStr;
        }
        List list = PermissionUtil.getDmPermListCache();
        if (null == list || list.size() == 0) {
            return permissionStr;
        }
        String getCategoryId = "select fcategoryid from t_dm_document where fid='" + docId + "'";
        String fcategoryid = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getCategoryId);
            if (rs.next()) {
                fcategoryid = rs.getString("fcategoryid");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.error((Object)("getCategoryId error 1 :" + e.getMessage()));
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)("getCategoryId error 2 :" + e.getMessage()));
        }
        String perm = null;
        boolean docPer = false;
        boolean catePer = false;
        HashSet<String> hasPerSet = new HashSet<String>();
        for (int i = 0; i < list.size(); ++i) {
            DmPermCacheInfo doc = (DmPermCacheInfo)list.get(i);
            String string = perm = null != doc.getPermList() ? doc.getPermList() : "";
            if (null != doc.getDocID() && docId.equals(doc.getDocID())) {
                permissionStr = !"".equals(permissionStr) ? permissionStr + "," + perm : perm;
                logger.info((Object)("\u6587\u6863id=" + docId + "\u7684\u6587\u6863\u7279\u6b8a\u6743\u9650=" + perm));
                System.out.println("\u6587\u6863id=" + docId + "\u7684\u6587\u6863\u7279\u6b8a\u6743\u9650=" + perm);
                docPer = true;
            }
            if (null == doc.getDocID() && null != doc.getCatID() && fcategoryid.equals(doc.getCatID())) {
                permissionStr = !"".equals(permissionStr) ? permissionStr + "," + perm : perm;
                logger.info((Object)("\u6587\u6863id=" + docId + "\u7684\u680f\u76ee\u6743\u9650=" + perm));
                System.out.println("\u6587\u6863id=" + docId + "\u7684\u680f\u76ee\u6743\u9650=" + perm);
                catePer = true;
            }
            if (docPer && catePer) break;
        }
        if (!"".equals(permissionStr)) {
            String[] hasPerStr = permissionStr.split(",");
            for (int i = 0; i < hasPerStr.length; ++i) {
                hasPerSet.add(hasPerStr[i]);
            }
            if (hasPerSet.contains("5") && !hasPerSet.contains("4")) {
                String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
                StringBuffer queryBorrowSql = new StringBuffer("select fapplydate,fapplytime from t_dm_documentborrow where ");
                queryBorrowSql.append(" fdocumentid='").append(docId).append("'  and fborrowerId='").append(personId).append("' and fstate=1  order by fapplydate desc");
                Date applydate = null;
                String applytime = "";
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryBorrowSql.toString());
                    if (rs.next()) {
                        applydate = new Date(rs.getTimestamp("fapplydate").getTime());
                        applytime = rs.getString("fapplytime");
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)("e=" + e.getMessage()));
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    logger.error((Object)("e=" + e.getMessage()));
                    e.printStackTrace();
                }
                if (null != applytime && !"".equals(applytime)) {
                    String[] applytimes = applytime.split("#");
                    applydate.setDate(applydate.getDate() + Integer.parseInt(applytimes[0]));
                    applydate.setHours(applydate.getHours() + Integer.parseInt(applytimes[1]));
                    Date currentTime = new Date();
                    if (applydate.after(currentTime)) {
                        hasPerSet.add("4");
                    }
                }
            }
            permissionStr = "";
            for (String str : hasPerSet) {
                if (!"".equals(permissionStr)) {
                    permissionStr = permissionStr + "," + str;
                    continue;
                }
                permissionStr = str;
            }
        }
        PermissionUtil.clearDmPermListCache();
        return permissionStr;
    }

    public static Map<String, Set<String>> getBizPermMap(Context ctx, String bizId, String bizTableName) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        return DefaultDmPermissionService.getInstance().getBizPermMap(ctx, perId, userId, bizId, bizTableName);
    }

    public static String checkIsInBorrow(Context ctx, String docId, String perId) {
        int borrowState = 0;
        String borrowId = "";
        try {
            DocumentBorrowCollection dbCols = DocumentBorrowFactory.getLocalInstance((Context)ctx).getDocumentBorrowCollection("select id,applyDate,approveDate,borrowTime,state,renewalTime where borrower.id = '" + perId + "' and document.id = '" + docId + "' and renewalid is null order by applyDate desc");
            for (int i = 0; i < dbCols.size(); ++i) {
                DocumentBorrowInfo dbInfo = dbCols.get(i);
                if (dbInfo != null && ApproveState.APPROVE.equals((Object)dbInfo.getState()) && dbInfo.getApproveDate() != null && dbInfo.getBorrowTime() != null) {
                    String[] timeArray = dbInfo.getBorrowTime().split("#");
                    int DayNum = Integer.parseInt(timeArray[0]);
                    int HourNum = Integer.parseInt(timeArray[1]);
                    int renewalDay = 0;
                    int renewalHour = 0;
                    DocumentBorrowCollection dbCols2 = DocumentBorrowFactory.getLocalInstance((Context)ctx).getDocumentBorrowCollection("select id,applyDate,approveDate,borrowTime,renewalTime,renewalId,state where renewalId = '" + dbInfo.getId().toString() + "'");
                    for (int j = 0; j < dbCols2.size(); ++j) {
                        DocumentBorrowInfo docBorrowInfo = dbCols2.get(j);
                        if (docBorrowInfo == null || docBorrowInfo.getBorrowTime() == null) continue;
                        String[] renewalArray = docBorrowInfo.getBorrowTime().split("#");
                        renewalDay += Integer.parseInt(renewalArray[0]);
                        renewalHour += Integer.parseInt(renewalArray[1]);
                    }
                    Timestamp curdate = new Timestamp(System.currentTimeMillis());
                    if (curdate.getTime() - dbInfo.getApproveDate().getTime() >= (long)((DayNum + renewalDay) * 24 + (HourNum + renewalHour)) * 3600000L) continue;
                    borrowState = 1;
                    borrowId = dbInfo.getId().toString();
                    break;
                }
                if (dbInfo != null && ApproveState.INAPPROVE.equals((Object)dbInfo.getState())) {
                    borrowState = 2;
                    break;
                }
                borrowState = 0;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return borrowState + "," + borrowId;
    }
}

