/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.odm.action;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.cm.CMColorInfo;
import com.kingdee.eas.cp.odm.util.OdmUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.plt.cp.common.util.OldPortalSkinUtil;
import com.kingdee.portal.plt.cp.module.odm.dto.LatestOdmDTO;
import com.kingdee.portal.plt.cp.module.odm.dto.OdmReadHistoryDTO;
import com.kingdee.portal.plt.cp.module.odm.service.DocumentInfoService;
import com.kingdee.portal.plt.cp.module.odm.service.impl.DocumentInfoServiceImpl;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;

public class LatestOdmPortletAction
extends BaseAction {
    private DocumentInfoService infoService = DocumentInfoServiceImpl.getInstance();

    public void getLatestOdmList() {
        try {
            HttpServletRequest request = this.getRequest();
            String skin = request.getParameter("skin");
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            HashMap<String, String> resultM = new HashMap<String, String>();
            String errMsg = this.infoService.checkPermissionAndLicense(ctx, "");
            if (!"".equals(errMsg)) {
                resultM.put("errMsg", errMsg);
                this.writeAjaxData(true, null, resultM);
                return;
            }
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (userInfo.getPerson() == null || userInfo.getPerson().getId() == null) {
                HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
                resultMap.put("hideToolBar", true);
                this.writeAjaxData(true, null, resultMap);
                return;
            }
            long time1 = System.currentTimeMillis();
            IRowSet rowSet = OdmUtil.getPortletMsg2((Context)ctx);
            long time2 = System.currentTimeMillis();
            System.out.println("OdmUtil.getPortletMsg2(ctx) \u8017\u65f6\uff1a" + (time2 - time1) / 1000L + "\u79d2");
            if (rowSet != null && rowSet.size() > 0) {
                HashMap idMap = OdmUtil.getOdmReadRecord((Context)ctx, (IRowSet)rowSet);
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                ArrayList<LatestOdmDTO> odmList = new ArrayList<LatestOdmDTO>();
                while (rowSet.next()) {
                    boolean isReaded = idMap.containsKey(rowSet.getString("id"));
                    odmList.add(this.builtLatestOdmDTO(rowSet, isReaded));
                }
                CMColorInfo colorInfo = OldPortalSkinUtil.getUserColor(skin);
                resultMap.put("odmList", odmList);
                resultMap.put("unReadCss", colorInfo.getUnReadColor());
                resultMap.put("readCss", colorInfo.getReadColor());
                this.writeAjaxData(true, null, resultMap);
            } else {
                this.writeAjaxData(true, null, null);
            }
        }
        catch (Exception ex) {
            this.writeAjaxData(false, this.handleErr(ex), null);
        }
    }

    private LatestOdmDTO builtLatestOdmDTO(IRowSet rowSet, boolean isReaded) {
        LatestOdmDTO odmDto = new LatestOdmDTO();
        try {
            odmDto.setId(rowSet.getString("ID"));
            odmDto.setTitle(rowSet.getString("billName"));
            Date receivEndDate = rowSet.getDate("endDate");
            Date endDate = rowSet.getDate("createTime");
            if (endDate == null) {
                odmDto.setEndDate("");
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                odmDto.setEndDate(formatter.format(endDate));
            }
            odmDto.setShowRed(receivEndDate.after(new java.util.Date()));
            odmDto.setFormID(rowSet.getString("formId"));
            odmDto.setBillID(rowSet.getString("billId"));
            odmDto.setReaded(isReaded);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return odmDto;
    }

    public String odmReadHistoryManager() {
        this.getRequest().setAttribute("id", (Object)this.getRequest().getParameter("id"));
        this.getRequest().setAttribute("uid", (Object)UUID.randomUUID().toString());
        return "success";
    }

    public void getOdmPortletReadHistoryList() throws Exception {
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)this.getRequest());
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String page = this.getRequest().getParameter("pageNumber");
        String pageSizeStr = this.getRequest().getParameter("pageSize");
        String id = this.getRequest().getParameter("id");
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "20";
        }
        total = this.infoService.recordReadCount(ctx, id);
        totalPage = (total - 1) / pageSize + 1;
        this.logger.debug("total page is:" + totalPage);
        if (pageNo > totalPage) {
            pageNo = totalPage;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        List<OdmReadHistoryDTO> list = this.infoService.queryDocumentReadHistoryList(ctx, pageSize, pageNo, id);
        PagingResult pagingResult = new PagingResult();
        pagingResult.setPagingParam(this.pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        this.writePagingResult(pagingResult);
    }
}

