/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.odm.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.base.util.LicenseUtil;
import com.kingdee.eas.cp.odm.util.OdmUtil;
import com.kingdee.eas.framework.batchaction.BatchActionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.plt.cp.common.util.DateTool;
import com.kingdee.portal.plt.cp.common.util.PageList;
import com.kingdee.portal.plt.cp.module.cm.dto.AttachmentDTO;
import com.kingdee.portal.plt.cp.module.odm.dto.OdmInfoDTO;
import com.kingdee.portal.plt.cp.module.odm.dto.OdmReadHistoryDTO;
import com.kingdee.portal.plt.cp.module.odm.service.DocumentInfoService;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentInfoServiceImpl
implements DocumentInfoService {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String strResource = "com.kingdee.eas.framework.FrameWorkResource.";
    private static DocumentInfoService instance = null;

    private DocumentInfoServiceImpl() {
    }

    public static synchronized DocumentInfoService getInstance() {
        if (instance == null) {
            instance = new DocumentInfoServiceImpl();
        }
        return instance;
    }

    public boolean checkExistDocInType(PortalContext ctx, String templateTypeId) throws Exception {
        StringBuffer existDocSql = new StringBuffer();
        existDocSql.append("select count(1) from t_bas_documentinfo A ").append(" inner join T_BAS_TemplateType B on B.FID=A.FTemplateTypeId").append(" inner join CT_ODM_ReleasePortlet C on C.Cfbillid=A.Fsourcepk").append(" where B.FID = ?");
        return false;
    }

    @Override
    public PageList queryPageOdmList(PortalContext ctx, Map params) throws Exception {
        int total = 0;
        int pageNo = 0;
        int totalPage = 0;
        int pageSize = 0;
        int currentPage = 0;
        String page = (String)params.get("page");
        String pageSizeStr = (String)params.get("pageSize");
        String typeId = (String)params.get("typeId");
        String keyWord = (String)params.get("keyWords");
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "20";
        }
        pageNo = Integer.parseInt(page);
        pageSize = Integer.parseInt(pageSizeStr);
        PageList resultList = new PageList();
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        AdminOrgUnitInfo adminOrgUnitInfo = ContextUtil.getCurrentAdminUnit((Context)context);
        Set set = OdmUtil.getCurrentAllRoleIds((Context)context);
        String ids = OdmUtil.hashSetToStr((Set)set, (String)",");
        StringBuffer sql = new StringBuffer();
        String receiverID = "administrator";
        String roleId = "administrator";
        String adminOrgIdID = "administrator";
        if (userInfo != null && userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
            receiverID = "'" + userInfo.getPerson().getId().toString() + "' or TABLE1.FIsPushAllPerson=1";
            roleId = ids;
            adminOrgIdID = adminOrgUnitInfo.getId().toString();
        }
        sql.append("SELECT DISTINCT TABLEALL.*,D.FName_L2 AS createUser FROM (");
        sql.append("  SELECT DISTINCT TABLE1.* FROM CT_ODM_ReceivePerson F,");
        sql.append("\t( SELECT DISTINCT ");
        sql.append("\tA.fid,A.Ftitle,A.Fdocnumber,A.Fformid,A.Fsourcepk,A.FDocumentOrgName,A.Fcreatetime,A.FLastUpdateUserID");
        sql.append("\t,B.Fname_L2 AS TYPENAME,B.fid AS TYPE_ID ,B.FNAME_L2 AS TYPE_NAME");
        sql.append("\t,C.Fid AS portletId,C.FIsPushAllPerson");
        sql.append("\tFROM t_bas_documentinfo A");
        sql.append("\tLEFT JOIN T_BAS_TemplateType B ON B.FID=A.FTemplateTypeId");
        sql.append("\tLEFT JOIN CT_ODM_ReleasePortlet C ON C.Cfbillid=A.Fsourcepk) TABLE1 ");
        sql.append("\tWHERE F.CFPortletId=TABLE1.portletId AND (F.CFReceiverID = " + receiverID + ")");
        sql.append("\tUNION ALL");
        sql.append("  SELECT DISTINCT TABLE1.* FROM T_ODM_ReceiveRole G,");
        sql.append("\t( SELECT DISTINCT ");
        sql.append("\t A.fid,A.Ftitle,A.Fdocnumber,A.Fformid,A.Fsourcepk,A.FDocumentOrgName,A.Fcreatetime,A.FLastUpdateUserID");
        sql.append("\t,B.Fname_L2 AS TYPENAME,B.fid AS TYPE_ID ,B.FNAME_L2 AS TYPE_NAME");
        sql.append("\t,C.Fid AS portletId,C.FIsPushAllPerson");
        sql.append("\tFROM t_bas_documentinfo A");
        sql.append("\tLEFT JOIN T_BAS_TemplateType B ON B.FID=A.FTemplateTypeId");
        sql.append("\tLEFT JOIN CT_ODM_ReleasePortlet C ON C.Cfbillid=A.Fsourcepk) TABLE1 ");
        sql.append("\tWHERE G.FPortletId=TABLE1.portletId AND G.FRoleId in (" + roleId + ")");
        sql.append("\tUNION ALL");
        sql.append("  SELECT DISTINCT TABLE1.* FROM T_ODM_ReceiveAdmin H,");
        sql.append("\t( SELECT DISTINCT ");
        sql.append("\tA.fid,A.Ftitle,A.Fdocnumber,A.Fformid,A.Fsourcepk,A.FDocumentOrgName,A.Fcreatetime,A.FLastUpdateUserID ");
        sql.append("\t,B.Fname_L2 AS TYPENAME,B.fid AS TYPE_ID ,B.FNAME_L2 AS TYPE_NAME");
        sql.append("\t,C.Fid AS portletId,C.FIsPushAllPerson ");
        sql.append("\tFROM t_bas_documentinfo A");
        sql.append("\tLEFT JOIN T_BAS_TemplateType B ON B.FID=A.FTemplateTypeId");
        sql.append("\tLEFT JOIN CT_ODM_ReleasePortlet C ON C.Cfbillid=A.Fsourcepk) TABLE1 ");
        sql.append("\tWHERE H.FPortletId=TABLE1.portletId AND H.FAdminOrgIdID='" + adminOrgIdID + "'");
        sql.append(") TABLEALL ,T_PM_User D ");
        sql.append(" WHERE TABLEALL.FLastUpdateUserID=D.FID ");
        if (null != typeId && !"".equals(typeId)) {
            sql.append(" AND TABLEALL.TYPE_ID='" + typeId + "' ");
        }
        if (null != keyWord && !"".equals(keyWord)) {
            sql.append(" AND TABLEALL.FTitle like '%" + keyWord + "%'  ");
        }
        IRowSet countRowSet = null;
        String countSql = " select count(1) from ( " + sql.toString() + " )  AAA ";
        countRowSet = DbUtil.executeQuery((Context)context, (String)countSql);
        if (countRowSet.next()) {
            total = countRowSet.getInt(1);
            this.log.debug("record total is\uff1a" + total);
        }
        totalPage = (total - 1) / pageSize + 1;
        this.log.debug("total page is:" + totalPage);
        if (pageNo > totalPage) {
            pageNo = totalPage;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        currentPage = pageNo;
        resultList.setTotalRowCount(total);
        resultList.setCurrentPage(currentPage);
        resultList.setPageSize(pageSize);
        try {
            sql.append(" ORDER BY TABLEALL.FCreateTime DESC");
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString(), (int)((pageNo - 1) * pageSize), (int)pageSize);
            while (dataSet.next()) {
                OdmInfoDTO se = new OdmInfoDTO();
                se.setId(dataSet.getString("FID"));
                se.setTitle(dataSet.getString("Ftitle"));
                se.setNo(dataSet.getString("Fdocnumber"));
                se.setCreateUser(dataSet.getString("createUser"));
                Date createTime = dataSet.getDate("Fcreatetime");
                se.setCreateDate(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm"));
                se.setTypeName(dataSet.getString("TYPE_NAME"));
                se.setTypeId(dataSet.getString("TYPE_ID"));
                se.setPortletId(dataSet.getString("portletId"));
                resultList.add(se);
            }
        }
        catch (Exception e) {
            this.log.error(" DocumentInfoServiceImpl queryOdmList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException(e.getCause());
        }
        return resultList;
    }

    @Override
    public OdmInfoDTO getOdmInfo(PortalContext ctx, String id, String sourcePK, String callBackUrl) throws Exception {
        IRowSet dataSet;
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        StringBuffer sql = new StringBuffer();
        sql.append(" select A.fid,A.Ftitle,A.Fdocnumber,A.Fformid,  ");
        sql.append("     A.Fsourcepk,A.FDocumentOrgName,A.Fcreatetime  ");
        sql.append("       ,B.Fname_L2 as TYPENAME,B.fid as TYPE_ID ,B.FNAME_L2 as TYPE_NAME  ");
        sql.append("       ,C.Fid as portletId,C.Fcreatetime as releaseDate   ");
        sql.append("       ,D.FNAME_L2 as createUser ");
        sql.append("       ,E.Fid as personId   ");
        sql.append("    from t_bas_documentinfo A  ");
        sql.append("     left join T_BAS_TemplateType B on B.FID=A.FTemplateTypeId    ");
        sql.append("     left join CT_ODM_ReleasePortlet C on C.Cfbillid=A.Fsourcepk  ");
        sql.append("     left join T_PM_User   D on A.Flastupdateuserid =D.Fid        ");
        sql.append("     left join T_BD_Person E on E.FID=D.Fpersonid                 ");
        sql.append("     where 1=1    ");
        sql.append("       and B.FPackageName ='com.kingdee.eas.cp.odm'  ");
        sql.append("       and C.fid is not null    ");
        if (null != id && !"".equals(id)) {
            sql.append(" and A.fid='" + id + "' ");
        }
        if (null != sourcePK && !"".equals(sourcePK)) {
            sql.append(" and A.FSourcePK='" + sourcePK + "' ");
        }
        if ((dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString())).next()) {
            OdmInfoDTO se = new OdmInfoDTO();
            se.setId(dataSet.getString("FID"));
            se.setTitle(dataSet.getString("Ftitle"));
            se.setNo(dataSet.getString("Fdocnumber"));
            se.setCreateUser(dataSet.getString("createUser"));
            Date createTime = dataSet.getDate("Fcreatetime");
            Date releaseDate = dataSet.getDate("releaseDate");
            se.setCreateDate(DateTool.dateToString(createTime, "yyyy-MM-dd HH:mm"));
            se.setReleaseDate(DateTool.dateToString(releaseDate, "yyyy-MM-dd HH:mm"));
            se.setTypeName(dataSet.getString("TYPE_NAME"));
            se.setTypeId(dataSet.getString("TYPE_ID"));
            String portletId = dataSet.getString("portletId");
            String fsourcepk = dataSet.getString("Fsourcepk");
            se.setPortletId(portletId);
            int readCount = this.getreadCount(ctx, portletId);
            se.setReadCount(readCount + "");
            se.setFsourcepk(dataSet.getString("Fsourcepk"));
            return se;
        }
        return new OdmInfoDTO();
    }

    @Override
    public byte[] getOdmInfoData(PortalContext ctx, String id) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        String sql = "select FileData from t_bas_billattachment where fbillId='" + id + "'";
        IRowSet rows = DbUtil.executeQuery((Context)context, (String)sql);
        Blob blob = null;
        if (rows.next()) {
            blob = rows.getBlob(1);
        }
        byte[] b = null;
        if (null != blob) {
            b = blob.getBytes(1L, Integer.valueOf(String.valueOf(blob.length())));
        }
        return b;
    }

    public int getreadCount(PortalContext ctx, String portletId) throws Exception {
        int result = 0;
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        StringBuffer sql = new StringBuffer();
        sql.append("  select count(1) as readCount  ");
        sql.append("   from CT_ODM_ReceivePerson  a ");
        sql.append("    where 1=1                   ");
        sql.append("     and a.CFIsRead='1'         ");
        sql.append("     and a.CFPortletid='" + portletId + "'  ");
        IRowSet countRowSet = null;
        countRowSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
        if (countRowSet.next()) {
            result = countRowSet.getInt(1);
        }
        return result;
    }

    @Override
    public List queryAttachmentList(PortalContext ctx, String fboid) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        ArrayList<AttachmentDTO> list = new ArrayList<AttachmentDTO>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select B.fboid as fid, A.fid as fattachmentid  ");
        sql.append("   ,A.fsize  ,A.fname_l2 as fattachmentName,A.fsimplename,A.ftype  ");
        sql.append(" from t_bas_Attachment A  ");
        sql.append(" left join T_BAS_BoAttchAsso B on A.Fid=B.fattachmentid   ");
        sql.append(" where 1=1  ");
        sql.append(" and fsimplename !='b'");
        sql.append("    and B.fboid='" + fboid + "'");
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)context, (String)sql.toString());
            while (dataSet.next()) {
                AttachmentDTO se = new AttachmentDTO();
                se.setId(dataSet.getString("fattachmentid"));
                se.setSimplename(dataSet.getString("fsimplename"));
                se.setAttachmentName(dataSet.getString("fattachmentName"));
                se.setType(dataSet.getString("ftype"));
                se.setFileSize(dataSet.getString("fsize"));
                list.add(se);
            }
        }
        catch (Exception e) {
            this.log.error(" DocumentInfoServiceImpl queryAttachmentList sql=" + sql.toString(), (Throwable)e);
            throw new DataAccessException((Throwable)e);
        }
        return list;
    }

    @Override
    public void recordReaded(PortalContext ctx, String portletId) throws Exception {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        OdmUtil.recordRead((Context)context, (String)portletId);
    }

    @Override
    public String checkPermissionAndLicense(Context ctx, String billId) {
        if (null == ctx) {
            return "";
        }
        boolean isAdmin = false;
        String licenseUrl = "/easweb/cp/odm/odmList.jsp";
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (personInfo == null || personInfo.getId() == null) {
            isAdmin = true;
            return "\u8be5\u7528\u6237\u6ca1\u6709\u5173\u8054\u804c\u5458\uff0c\u4e0d\u80fd\u64cd\u4f5c\u6b64\u529f\u80fd\uff01";
        }
        if (!isAdmin) {
            try {
                String hasPer;
                if (!"".equals(billId) && "".equals(hasPer = this.checkPermission(ctx, billId))) {
                    return "\u8be5\u7528\u6237\u6ca1\u6709\u67e5\u770b\u6743\u9650\uff01";
                }
                int result = LicenseUtil.checkLicence((Context)ctx, (String)licenseUrl);
                if (result == 1) {
                    return "";
                }
                Locale local = null;
                if (ctx != null) {
                    local = ctx.getLocale();
                }
                if (result == 4) {
                    return ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid", (Locale)local) + "\uff0c\u5bf9\u5e94\u7684license\u6a21\u5757\u540d\u79f0\uff1aCBP_ODM";
                }
                if (result == 2) {
                    return ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS", (Locale)local) + "\uff0c\u5bf9\u5e94\u7684license\u6a21\u5757\u540d\u79f0\uff1aCBP_ODM";
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return BatchActionUtil.getExceptionMsg((Context)ctx, (Throwable)e1) + "\uff0c\u5bf9\u5e94\u7684license\u6a21\u5757\u540d\u79f0\uff1aCBP_ODM";
            }
        }
        return "";
    }

    public String checkPermission(Context ctx, String billId) {
        String objId = "";
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        String currPerId = personInfo.getId().toString();
        StringBuffer sql = new StringBuffer("");
        sql.append("select a.fid contentid from CT_ODM_ReceivePerson as a ");
        sql.append("  where a.CFPortletId in (select b.fid from CT_ODM_ReleasePortlet b left join t_bas_documentinfo c on b.Cfbillid=c.Fsourcepk where c.FID='" + billId + "')");
        sql.append("  and a.CFReceiverID='" + currPerId + "'");
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (dataSet.next()) {
                objId = dataSet.getString("contentid");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            objId = "";
        }
        return objId;
    }

    private IRowSet recordReadSet(Context ctx, int pageSize, int pageNo, String portletId) {
        IRowSet rowSet = null;
        if (portletId != null && !"".equals(portletId)) {
            StringBuffer sql_read = new StringBuffer("");
            sql_read = new StringBuffer("SELECT DISTINCT TOP " + pageSize * pageNo + " a.fid AS afid,a.CFReceiverID AS receiverID,a.CFReadTime AS readTime,b.Fname_l2 AS receiverName,c.FPersonId AS cpersonid,c.Fname_l2 AS UserName,d.FNumber AS adminNumber,d.FName_l2 AS adminName ");
            sql_read.append(" FROM CT_ODM_ReceivePerson AS a ");
            sql_read.append(" INNER JOIN T_BD_Person AS b ON a.CFReceiverID=b.fid ");
            sql_read.append(" INNER JOIN T_PM_User AS C ON C.FPersonId=b.fid ");
            sql_read.append(" INNER JOIN T_ORG_Admin AS d ON a.FReadedPersonAdminOrgId = d.FID ");
            sql_read.append(" WHERE a.CFPortletid='" + portletId + "' AND a.CFIsRead='1' ");
            sql_read.append(" ORDER BY a.CFReadTime DESC ");
            try {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_read.toString());
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return rowSet;
    }

    @Override
    public List<OdmReadHistoryDTO> queryDocumentReadHistoryList(Context ctx, int pageSize, int pageNo, String portletId) throws Exception {
        ArrayList<OdmReadHistoryDTO> listRet = new ArrayList<OdmReadHistoryDTO>();
        IRowSet rowSet = this.recordReadSet(ctx, pageSize, pageNo, portletId);
        try {
            int i = 0;
            while (rowSet.next()) {
                if (i == (pageNo - 1) * pageSize) {
                    Object strReadTime1 = rowSet.getObject("readTime");
                    String strReadTime = String.valueOf(strReadTime1);
                    strReadTime = strReadTime != null && strReadTime.length() >= 20 ? strReadTime.substring(0, 19) : "";
                    OdmReadHistoryDTO readHistoryDTO = new OdmReadHistoryDTO();
                    readHistoryDTO.setReceiverID(rowSet.getString("receiverID"));
                    readHistoryDTO.setReceiverName(rowSet.getString("receiverName"));
                    readHistoryDTO.setUserName(rowSet.getString("userName"));
                    readHistoryDTO.setReadTime(strReadTime);
                    readHistoryDTO.setAdminName(rowSet.getString("adminName"));
                    readHistoryDTO.setAdminNumber(rowSet.getString("adminNumber"));
                    listRet.add(readHistoryDTO);
                    continue;
                }
                ++i;
            }
        }
        catch (SQLException e) {
            this.log.info("queryDocumentReadHistoryList exec===" + e.getMessage());
            throw new Exception(e);
        }
        return listRet;
    }

    @Override
    public int recordReadCount(Context ctx, String portletId) {
        if (portletId != null && !"".equals(portletId)) {
            StringBuffer sql_read = new StringBuffer("");
            sql_read = new StringBuffer("select count(a.fid) as readCount from CT_ODM_ReceivePerson AS a,T_ORG_Admin AS d ");
            sql_read.append(" where a.CFPortletid='" + portletId + "' and a.CFIsRead='1' ");
            sql_read.append(" AND a.FReadedPersonAdminOrgId = d.FID ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql_read.toString());
                if (null != rowSet && rowSet.next()) {
                    return rowSet.getInt("readCount");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }
}

