/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.plt.cp.module.setting.dto.CodingHistoryDTO;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public class CodingHistoryAction
extends BaseAction {
    private static final long serialVersionUID = 1L;

    public void codingHistoryList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String odmTemplateName = this.getRequest().getParameter("odmTemplateName");
        String odmNumber = this.getRequest().getParameter("odmNumber");
        String odmSubject = this.getRequest().getParameter("odmSubject");
        String startCodingDate = this.getRequest().getParameter("startCodingDate");
        String endCodingDate = this.getRequest().getParameter("endCodingDate");
        String orderByField = "";
        String orderType = "";
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "lastUpdateTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        int conditionCount = 0;
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        filterItemInfo = new FilterItemInfo("cu.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (null != odmTemplateName && !"".equals(odmTemplateName)) {
            filterItemInfo = new FilterItemInfo("formName", (Object)("%" + odmTemplateName + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        if (null != odmNumber && !"".equals(odmNumber)) {
            filterItemInfo = new FilterItemInfo("odmNumber", (Object)("%" + odmNumber + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        if (null != odmSubject && !"".equals(odmSubject)) {
            filterItemInfo = new FilterItemInfo("odmSubject", (Object)("%" + odmSubject + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        if (null != startCodingDate && !"".equals(startCodingDate)) {
            startCodingDate = startCodingDate + " 00:00:00.0";
            filterItemInfo = new FilterItemInfo("codingDate", (Object)Timestamp.valueOf(startCodingDate), CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        if (null != endCodingDate && !"".equals(endCodingDate)) {
            endCodingDate = endCodingDate + " 23:59:59.9";
            filterItemInfo = new FilterItemInfo("codingDate", (Object)Timestamp.valueOf(endCodingDate), CompareType.LESS_EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        filterInfo.setMaskString(this.setMaskString(conditionCount));
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.odm.app", "CodingHistoryQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content sql is:" + exec.getSQL());
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<CodingHistoryDTO> list = new ArrayList<CodingHistoryDTO>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    CodingHistoryDTO codingHistoryDTO = new CodingHistoryDTO();
                    codingHistoryDTO.setId(rowSet.getString("id"));
                    codingHistoryDTO.setCodingDate(rowSet.getString("codingDate"));
                    codingHistoryDTO.setOdmTemplateName(rowSet.getString("formName"));
                    codingHistoryDTO.setOdmNumber(rowSet.getString("odmNumber"));
                    codingHistoryDTO.setOdmSubject(rowSet.getString("odmSubject"));
                    list.add(codingHistoryDTO);
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private String setMaskString(int count) {
        StringBuffer buf = new StringBuffer(" #0");
        for (int i = 0; i < count; ++i) {
            buf.append(" AND #" + (i + 1));
        }
        return buf.toString();
    }
}

