/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.arcm.ArcmUnitTypeEnum;
import com.kingdee.eas.cp.arcm.ConfidentialCollection;
import com.kingdee.eas.cp.arcm.ConfidentialEntryInfo;
import com.kingdee.eas.cp.arcm.ConfidentialFactory;
import com.kingdee.eas.cp.arcm.ConfidentialInfo;
import com.kingdee.eas.cp.arcm.IConfidential;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.cp.module.setting.dto.ConfidentialDto;
import com.kingdee.portal.plt.cp.module.setting.util.BaseSettingUtil;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ConfidentialAction
extends BaseAction {
    private static final long serialVersionUID = 1L;

    public void confidentialList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String name = this.getRequest().getParameter("name");
        String unitType = this.getRequest().getParameter("unitType");
        String orderByField = "";
        String orderType = "";
        if (orderByField == null || orderByField.trim().length() == 0) {
            orderByField = "lastUpdateTime";
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        int conditionCount = 0;
        pageNo = this.pagingParam.getPageNo();
        pageSize = this.pagingParam.getPageSize();
        filterItemInfo = new FilterItemInfo("cu.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.LIKE);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (null != name && !"".equals(name)) {
            filterItemInfo = new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        if (null != unitType && !"".equals(unitType)) {
            filterItemInfo = new FilterItemInfo("unitType", (Object)unitType, CompareType.EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++conditionCount;
        }
        if (conditionCount == 0) {
            filterInfo.setMaskString(" #0 ");
        } else if (conditionCount == 1) {
            filterInfo.setMaskString(" #0 AND #1");
        } else if (conditionCount == 2) {
            filterInfo.setMaskString(" #0 AND #1 AND #2");
        }
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.arcm.app", "ConfidentialQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content sql is:" + exec.getSQL());
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<ConfidentialDto> list = new ArrayList<ConfidentialDto>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    ConfidentialDto confidentialDto = new ConfidentialDto();
                    confidentialDto.setId(rowSet.getString("id"));
                    confidentialDto.setName(rowSet.getString("name"));
                    confidentialDto.setOrgUnitName(rowSet.getString("orgUnit.name"));
                    confidentialDto.setUnitType(rowSet.getString("unitType"));
                    confidentialDto.setConNames(rowSet.getString("conNames"));
                    list.add(confidentialDto);
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void confidentialSave() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        String id = this.getRequest().getParameter("id");
        String name = this.getRequest().getParameter("unitName");
        String orgUnitNum = this.getRequest().getParameter("orgUnitNum");
        String orgUnitName = this.getRequest().getParameter("orgUnitName");
        String orgUnitId = this.getRequest().getParameter("orgUnitId");
        String conNames = this.getRequest().getParameter("conNames");
        String conIds = this.getRequest().getParameter("conIds");
        String unitType = this.getRequest().getParameter("unitType");
        ConfidentialInfo info = new ConfidentialInfo();
        AdminOrgUnitInfo orgUnitInfo = new AdminOrgUnitInfo();
        boolean succ = false;
        String result = "";
        try {
            info.setName(name);
            if ("0".equals(unitType)) {
                orgUnitInfo.setName(orgUnitName);
                orgUnitInfo.setId(BOSUuid.read((String)orgUnitId));
                info.setOrgUnit(orgUnitInfo);
                info.setConNames(conNames);
                info.setOrgUnitNum("");
                info.setUnitType(ArcmUnitTypeEnum.Inside);
                if (!"".equals(conIds)) {
                    PersonInfo pi = null;
                    ConfidentialEntryInfo cei = null;
                    for (String conId : conIds.split(";")) {
                        pi = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)conId)));
                        cei = new ConfidentialEntryInfo();
                        cei.setPerson(pi);
                        info.getEntry().appendObject((IObjectValue)cei);
                    }
                }
            } else {
                info.setOrgUnitNum(orgUnitNum);
                info.setUnitType(ArcmUnitTypeEnum.Outside);
                info.setConNames("");
                info.setOrgUnit(null);
            }
            IConfidential confidential = ConfidentialFactory.getLocalInstance((Context)ctx);
            if (null == id || "".equals(id)) {
                String newId = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                info.setNumber(newId);
                if (!this.isExist(info)) {
                    confidential.addnew((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newId)), (CoreBaseInfo)info);
                    succ = true;
                    result = newId;
                } else {
                    localErr = new LocalErr();
                    localErr.setDesc("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                    succ = false;
                }
            } else {
                info.setId(BOSUuid.read((String)id));
                if (!this.isExist(info)) {
                    confidential.save((CoreBaseInfo)info);
                    succ = true;
                    result = id;
                } else {
                    localErr = new LocalErr();
                    localErr.setDesc("\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
                    succ = false;
                }
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void confidentialLoad() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        boolean succ = false;
        HashMap<String, String> result = new HashMap<String, String>();
        String id = this.getRequest().getParameter("id");
        try {
            IConfidential confidential = ConfidentialFactory.getLocalInstance((Context)ctx);
            ConfidentialInfo info = confidential.getConfidentialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            result.put("id", info.getId().toString());
            result.put("unitName", info.getName());
            result.put("unitType", info.getUnitType().toString());
            if ("\u5185\u90e8\u5355\u4f4d".equals(info.getUnitType().toString())) {
                IAdminOrgUnit unit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                AdminOrgUnitInfo unitInfo = unit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getOrgUnit().getId()));
                result.put("orgUnitName", unitInfo.getName());
                result.put("orgUnitId", unitInfo.getId().toString());
                StringBuffer conIds = new StringBuffer();
                for (int i = 0; i < info.getEntry().size(); ++i) {
                    conIds.append(info.getEntry().get(i).getPerson().getId().toString()).append(";");
                }
                result.put("conIds", conIds.substring(0, conIds.length() - 1));
            }
            result.put("orgUnitNum", info.getOrgUnitNum());
            result.put("connames", info.getConNames());
            succ = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void confidentialDelete() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        LocalErr localErr = null;
        boolean succ = false;
        String id = this.getRequest().getParameter("id");
        String[] idArr = id.split(",");
        ObjectUuidPK[] pkArr = new ObjectUuidPK[idArr.length];
        try {
            IConfidential confidential = ConfidentialFactory.getLocalInstance((Context)ctx);
            int j = idArr.length;
            for (int i = 0; i < j; ++i) {
                pkArr[i] = new ObjectUuidPK(BOSUuid.read((String)idArr[i]));
            }
            confidential.delete((IObjectPK[])pkArr);
            succ = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        catch (UuidException e) {
            localErr = this.handleErr((Exception)((Object)e));
            succ = false;
            e.printStackTrace();
        }
        this.writeAjaxData(succ, localErr, null);
    }

    public void confidentialPermisson() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String[] perList = new String[]{"cp_arcm_Confidential_View", "cp_arcm_Confidential_Delete", "cp_arcm_Confidential_Update"};
        Map<String, Boolean> result = BaseSettingUtil.perListCheck(perList, ctx, this.getRequest());
        this.writeAjaxData(true, null, result);
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private boolean isExist(ConfidentialInfo curModel) {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            IConfidential confidential = ConfidentialFactory.getLocalInstance((Context)ctx);
            ConfidentialCollection col = confidential.getConfidentialCollection("select * where name = '" + curModel.getName() + "'");
            if (col.size() > 0 && !col.get(0).getId().equals((Object)curModel.getId())) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }
}

