/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.action;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.plt.cp.common.util.CpServiceLocator;
import com.kingdee.portal.plt.cp.module.setting.dto.LogDTO;
import com.kingdee.portal.plt.cp.module.setting.service.CommonSealPremService;
import com.kingdee.portal.plt.cp.module.setting.service.PersonalSealPremService;
import com.kingdee.portal.plt.cp.module.setting.service.StampLogService;
import com.kingdee.portal.plt.cp.module.setting.util.ExportUtil;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;

public class LogManageAction
extends BaseAction {
    private StampLogService stampLogServiceImpl = (StampLogService)CpServiceLocator.getBean("stampLogService");
    private CommonSealPremService commonSealPremServiceImpl = (CommonSealPremService)CpServiceLocator.getBean("commonSealPremService");
    private PersonalSealPremService personalSealPremServiceImpl = (PersonalSealPremService)CpServiceLocator.getBean("personalSealPremService");

    public void loadManagerLog() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            Map<String, String> paramMap = this.buildManageLogParam();
            PagingResult<LogDTO> pagingResult = this.stampLogServiceImpl.getMamageLogPageList(ctx, paramMap, this.pagingParam);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> buildManageLogParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("operation", this.getRequest().getParameter("operation"));
        param.put("permissionPersonId", this.getRequest().getParameter("permissionPersonId"));
        param.put("operationPersonId", this.getRequest().getParameter("operationPersonId"));
        param.put("beginDate", this.getRequest().getParameter("beginDate"));
        param.put("endDate", this.getRequest().getParameter("endDate"));
        param.put("sealId", this.getRequest().getParameter("sealId"));
        return param;
    }

    public void loadStampLog() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            Map<String, String> paramMap = this.buildStampLogParam();
            PagingResult<LogDTO> pagingResult = this.stampLogServiceImpl.getStampLogPageList(ctx, paramMap, this.pagingParam);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> buildStampLogParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("operationPersonId", this.getRequest().getParameter("operationPersonId"));
        param.put("beginDate", this.getRequest().getParameter("beginDate"));
        param.put("endDate", this.getRequest().getParameter("endDate"));
        param.put("sealId", this.getRequest().getParameter("sealId"));
        param.put("title", this.getRequest().getParameter("title"));
        return param;
    }

    private Map<String, String> buildPersonalParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("comSealId", this.getRequest().getParameter("comSealId"));
        param.put("ownerId", this.getRequest().getParameter("ownerId"));
        param.put("permissionPersonId", this.getRequest().getParameter("permissionPersonId"));
        param.put("operationPersonId", this.getRequest().getParameter("operationPersonId"));
        param.put("beginDate", this.getRequest().getParameter("beginDate"));
        param.put("endDate", this.getRequest().getParameter("endDate"));
        return param;
    }

    private Map<String, String> buildCommonParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("comSealId", this.getRequest().getParameter("comSealId"));
        param.put("orgId", this.getRequest().getParameter("orgId"));
        param.put("permissionPersonId", this.getRequest().getParameter("permissionPersonId"));
        param.put("operationPersonId", this.getRequest().getParameter("operationPersonId"));
        param.put("beginDate", this.getRequest().getParameter("beginDate"));
        param.put("endDate", this.getRequest().getParameter("endDate"));
        return param;
    }

    public void exportLog() {
        try {
            String reportDesc = null;
            HSSFWorkbook workbook = new HSSFWorkbook();
            String type = this.getRequest().getParameter("type");
            String isShowDate = this.getRequest().getParameter("isShowDate");
            HashMap<String, String> paramMap = new HashMap();
            if (type != null) {
                if ("commonSealPermission".equals(type)) {
                    paramMap = this.buildCommonParam();
                    reportDesc = "\u516c\u7ae0\u6388\u6743";
                } else if ("personalSealPermission".equals(type)) {
                    paramMap = this.buildPersonalParam();
                    reportDesc = "\u79c1\u7ae0\u6388\u6743";
                } else if ("managelog".equals(type)) {
                    paramMap = this.buildManageLogParam();
                    reportDesc = "\u5370\u7ae0\u7ba1\u7406\u65e5\u5fd7";
                } else if ("stamplog".equals(type)) {
                    paramMap = this.buildStampLogParam();
                    reportDesc = "\u76d6\u7ae0\u65e5\u5fd7";
                }
                HSSFSheet sheet = workbook.createSheet(reportDesc);
                this.createReportHead(reportDesc, workbook, sheet, type);
                this.createReportBody(workbook, sheet, type, paramMap);
                if (workbook != null) {
                    if (isShowDate.equals("true")) {
                        Date date = new Date();
                        SimpleDateFormat adf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                        reportDesc = reportDesc + "-" + adf.format(date);
                    }
                    this.printExcel(workbook, reportDesc);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printExcel(HSSFWorkbook workbook, String fileName) {
        HttpServletResponse response = this.getResponse();
        ServletOutputStream out = null;
        System.out.println("***** wrs \u65e5\u5fd7\u5bfc\u51fa\uff0c\u6587\u4ef6\u540d\u4e3a:" + fileName);
        try {
            fileName = fileName == null ? "sample" : new String(fileName.getBytes("GB2312"), "ISO-8859-1");
            response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
            response.setContentType("application/x-msdownload;charset=GB2312");
            out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void createReportHead(String reportDesc, HSSFWorkbook workbook, HSSFSheet sheet, String type) {
        HSSFCellStyle titleStyle = ExportUtil.createCommonTitleStyle(workbook);
        HSSFCellStyle textStyle = ExportUtil.createTextStyle(workbook);
        HSSFCellStyle numericStyle = ExportUtil.createNumericStyle(workbook);
        HSSFCellStyle centerStyle = ExportUtil.createCenterTitleStyle(workbook);
        int rowNum = 0;
        int colNum = 0;
        if ("commonSealPermission".equals(type)) {
            sheet.setColumnWidth(0, 6000);
            sheet.setColumnWidth(1, 5000);
            sheet.setColumnWidth(2, 3000);
            sheet.setColumnWidth(3, 5000);
            sheet.setColumnWidth(4, 5000);
            sheet.setColumnWidth(5, 5000);
            sheet.setColumnWidth(6, 5000);
            sheet.setColumnWidth(7, 5000);
            rowNum = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u516c\u7ae0\u540d\u79f0");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6240\u5c5e\u7ec4\u7ec7");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u5b58\u50a8\u65b9\u5f0f");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u88ab\u6388\u6743\u4f7f\u7528\u8005");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6388\u6743\u5f00\u59cb\u65e5\u671f");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6388\u6743\u622a\u6b62\u65e5\u671f");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6388\u6743\u4eba");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6388\u6743\u65e5\u671f");
        } else if ("personalSealPermission".equals(type)) {
            sheet.setColumnWidth(0, 6000);
            sheet.setColumnWidth(1, 5000);
            sheet.setColumnWidth(2, 3000);
            sheet.setColumnWidth(3, 5000);
            sheet.setColumnWidth(4, 5000);
            sheet.setColumnWidth(5, 5000);
            sheet.setColumnWidth(6, 5000);
            sheet.setColumnWidth(7, 5000);
            rowNum = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u79c1\u7ae0\u540d\u79f0");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6240\u6709\u8005");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u5b58\u50a8\u65b9\u5f0f");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u88ab\u6388\u6743\u4f7f\u7528\u8005");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6388\u6743\u5f00\u59cb\u65e5\u671f");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6388\u6743\u622a\u6b62\u65e5\u671f");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6388\u6743\u4eba");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6388\u6743\u65e5\u671f");
        } else if ("managelog".equals(type)) {
            sheet.setColumnWidth(0, 5000);
            sheet.setColumnWidth(1, 4000);
            sheet.setColumnWidth(2, 3000);
            sheet.setColumnWidth(3, 6000);
            sheet.setColumnWidth(4, 5000);
            sheet.setColumnWidth(5, 8000);
            rowNum = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u65e5\u671f\u65f6\u95f4");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u64cd\u4f5c");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u64cd\u4f5c\u4eba");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u5370\u7ae0\u540d\u79f0");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u88ab\u6388\u6743\u4f7f\u7528\u8005");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u64cd\u4f5c\u8bf4\u660e");
        } else if ("stamplog".equals(type)) {
            sheet.setColumnWidth(0, 5000);
            sheet.setColumnWidth(1, 5000);
            sheet.setColumnWidth(2, 3000);
            sheet.setColumnWidth(3, 4000);
            sheet.setColumnWidth(4, 4000);
            sheet.setColumnWidth(5, 5000);
            sheet.setColumnWidth(6, 5000);
            sheet.setColumnWidth(7, 5000);
            sheet.setColumnWidth(8, 6000);
            rowNum = 0;
            HSSFRow row = sheet.createRow(rowNum++);
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u65e5\u671f");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u5370\u7ae0\u540d\u79f0");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u65e5\u5fd7\u7c7b\u578b");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u7b7e\u7ae0\u7528\u6237");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6388\u6743\u4f7f\u7528\u8005");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u5b50\u7cfb\u7edf");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6a21\u5757");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u5355\u636e\u540d\u79f0");
            ExportUtil.createCell(row, colNum++, titleStyle, CellType.STRING, "\u6807\u9898");
        }
    }

    private void createReportBody(HSSFWorkbook workbook, HSSFSheet sheet, String type, Map<String, String> paramMap) throws Exception {
        block7: {
            int rowNum;
            int colNum;
            HSSFCellStyle textStyle;
            Context ctx;
            block9: {
                block8: {
                    block6: {
                        ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                        textStyle = ExportUtil.createTextStyle(workbook);
                        colNum = 0;
                        rowNum = 0;
                        if (!"commonSealPermission".equals(type)) break block6;
                        IRowSet rowSet = this.commonSealPremServiceImpl.getComSealPremList(ctx, paramMap);
                        rowNum = 1;
                        if (rowSet == null) break block7;
                        while (rowSet.next()) {
                            colNum = 0;
                            String sealName = rowSet.getString("sealName.name");
                            String belongOrg = rowSet.getString("sealName.belogOrg.name");
                            String user = rowSet.getString("user.name");
                            String startDate = rowSet.getString("startDate");
                            String endDate = rowSet.getString("endDate");
                            String settingPerson = rowSet.getString("settingPerson.name");
                            String createTime = rowSet.getString("createTime");
                            String storeType = rowSet.getString("sealName.storeType");
                            HSSFRow row = sheet.createRow(rowNum++);
                            ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, sealName);
                            ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, belongOrg);
                            ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, storeType);
                            ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, user);
                            ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, startDate);
                            ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, endDate);
                            ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, settingPerson);
                            ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, createTime);
                        }
                        break block7;
                    }
                    if (!"personalSealPermission".equals(type)) break block8;
                    IRowSet rowSet = this.personalSealPremServiceImpl.getPersonalSealPremList(ctx, paramMap);
                    rowNum = 1;
                    if (rowSet == null) break block7;
                    while (rowSet.next()) {
                        colNum = 0;
                        String personalSealName = rowSet.getString("sealName.name");
                        String owner = rowSet.getString("owner.name");
                        String user = rowSet.getString("user.name");
                        String startDate = rowSet.getString("startDate");
                        String endDate = rowSet.getString("endDate");
                        String settingPerson = rowSet.getString("settingPerson.name");
                        String createTime = rowSet.getString("createTime");
                        String storeType = rowSet.getString("sealName.storeType");
                        HSSFRow row = sheet.createRow(rowNum++);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, personalSealName);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, owner);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, storeType);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, user);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, startDate);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, endDate);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, settingPerson);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, createTime);
                    }
                    break block7;
                }
                if (!"managelog".equals(type)) break block9;
                IRowSet rowSet = this.stampLogServiceImpl.getMamageLogList(ctx, paramMap);
                rowNum = 1;
                if (rowSet == null) break block7;
                while (rowSet.next()) {
                    colNum = 0;
                    String occurTime = rowSet.getString("occurTime").substring(0, 16);
                    String operation = rowSet.getString("operation");
                    String operationPerson = rowSet.getString("operationPerson.name");
                    String seal = rowSet.getString("seal.name");
                    String permissionPerson = rowSet.getString("permissionPerson.name");
                    String operationDetail = rowSet.getString("operationDetail");
                    HSSFRow row = sheet.createRow(rowNum++);
                    ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, occurTime);
                    ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, operation);
                    ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, operationPerson);
                    ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, seal);
                    ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, permissionPerson);
                    ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, operationDetail);
                }
                break block7;
            }
            if ("stamplog".equals(type)) {
                IRowSet rowSet = this.stampLogServiceImpl.getStampLogList(ctx, paramMap);
                rowNum = 1;
                if (rowSet != null) {
                    while (rowSet.next()) {
                        colNum = 0;
                        String occurTime = rowSet.getString("occurTime").substring(0, 16);
                        String operation = rowSet.getString("operationType");
                        String operationPerson = rowSet.getString("operationPerson.name");
                        String seal = rowSet.getString("seal.name");
                        String permissionPerson = rowSet.getString("permissionPerson.name");
                        String subsystem = rowSet.getString("subsystem");
                        String submodel = rowSet.getString("submodel");
                        String entityName = rowSet.getString("entityName");
                        String billTitle = rowSet.getString("billTitle");
                        HSSFRow row = sheet.createRow(rowNum++);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, occurTime);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, seal);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, operation);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, operationPerson);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, permissionPerson);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, subsystem);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, submodel);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, entityName);
                        ExportUtil.createCell(row, colNum++, textStyle, CellType.STRING, billTitle);
                    }
                }
            }
        }
    }
}

