/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.stamp.IPersonalSeal;
import com.kingdee.eas.cp.stamp.IPersonalSealPermission;
import com.kingdee.eas.cp.stamp.ManageLogUtil;
import com.kingdee.eas.cp.stamp.PersonalSealFactory;
import com.kingdee.eas.cp.stamp.PersonalSealInfo;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionCollection;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionFactory;
import com.kingdee.eas.cp.stamp.PersonalSealPermissionInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.cp.common.util.CpServiceLocator;
import com.kingdee.portal.plt.cp.module.setting.dto.SealPermissionDTO;
import com.kingdee.portal.plt.cp.module.setting.dto.SealPermissionListDTO;
import com.kingdee.portal.plt.cp.module.setting.service.PersonalSealPremService;
import com.kingdee.util.UuidException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class PersonalSealPermAction
extends BaseAction {
    private PersonalSealPremService personalSealPremServiceImpl = (PersonalSealPremService)CpServiceLocator.getBean("personalSealPremService");

    public void loadPersonalSealPremList() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            Map<String, String> paramMap = this.buildParam();
            PagingResult<SealPermissionDTO> pagingResult = this.personalSealPremServiceImpl.getPersonalSealPremPageList(ctx, paramMap, this.pagingParam);
            this.writePagingResult(pagingResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> buildParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("comSealId", this.getRequest().getParameter("comSealId"));
        param.put("ownerId", this.getRequest().getParameter("ownerId"));
        param.put("permissionPersonId", this.getRequest().getParameter("permissionPersonId"));
        param.put("operationPersonId", this.getRequest().getParameter("operationPersonId"));
        param.put("beginDate", this.getRequest().getParameter("beginDate"));
        param.put("endDate", this.getRequest().getParameter("endDate"));
        return param;
    }

    public void savePersonalSealPrem() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String sealId = this.getRequest().getParameter("sealId");
        String userId = this.getRequest().getParameter("userId");
        String beginDateStr = this.getRequest().getParameter("beginDate");
        String endDateStr = this.getRequest().getParameter("endDate");
        String DateStr = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        try {
            if (StringUtil.isEmpty((String)sealId) || StringUtil.isEmpty((String)userId)) {
                this.writeAjaxData(false, null, "0");
                return;
            }
            IPersonalSealPermission icsp = PersonalSealPermissionFactory.getLocalInstance((Context)ctx);
            IPersonalSeal ics = PersonalSealFactory.getLocalInstance((Context)ctx);
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            String sql = "select id,startDate,endDate where personalSealName='" + sealId + "' order by startDate asc";
            PersonalSealPermissionCollection commPerCol = icsp.getPersonalSealPermissionCollection(sql);
            Date currentDatea = new SimpleDateFormat("yyyy-MM-dd").parse(DateStr);
            Date startDate = new SimpleDateFormat("yyyy-MM-dd").parse(beginDateStr);
            Date endDate = new SimpleDateFormat("yyyy-MM-dd").parse(endDateStr);
            Date historyStartDate = null;
            Date historyEndDate = null;
            if (startDate.compareTo(currentDatea) < 0) {
                this.writeAjaxData(false, null, "1");
                return;
            }
            if (startDate.compareTo(endDate) > 0) {
                this.writeAjaxData(false, null, "2");
                return;
            }
            if (commPerCol != null && commPerCol.size() != 0) {
                for (int i = 0; i < commPerCol.size(); ++i) {
                    boolean validInner;
                    historyStartDate = commPerCol.get(i).getStartDate();
                    historyEndDate = commPerCol.get(i).getEndDate();
                    boolean validStartDate = startDate.compareTo(historyStartDate) <= 0 && endDate.compareTo(historyStartDate) >= 0;
                    boolean validEndDate = startDate.compareTo(historyEndDate) <= 0 && endDate.compareTo(historyEndDate) >= 0;
                    boolean bl = validInner = startDate.compareTo(historyStartDate) >= 0 && endDate.compareTo(historyEndDate) <= 0;
                    if (!validStartDate && !validEndDate && !validInner) continue;
                    this.writeAjaxData(false, null, "3");
                    return;
                }
            }
            PersonalSealPermissionInfo csp = new PersonalSealPermissionInfo();
            PersonalSealInfo csInfo = ics.getPersonalSealInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)sealId)));
            PersonInfo person = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId)));
            PersonInfo settingPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            csp.setPersonalSealName(csInfo);
            csp.setStartDate(startDate);
            csp.setEndDate(endDate);
            csp.setUser(person);
            csp.setSettingPerson(settingPerson);
            IObjectPK logpk = ManageLogUtil.beginLog((Context)ctx, (int)2, (CoreBaseInfo)csp);
            icsp.save((CoreBaseInfo)csp);
            ManageLogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), "-1");
            e.printStackTrace();
        }
    }

    public void getPersonalSealPremBySealId() {
        try {
            String sealId = this.getRequest().getParameter("sealId");
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            SealPermissionListDTO spDto = this.personalSealPremServiceImpl.getPersonalSealPremBySealId(ctx, sealId);
            this.writeAjaxData(true, null, spDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void getPersonalSealPremById() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String id = this.getRequest().getParameter("sealpremId");
        try {
            IPersonalSealPermission icsp = PersonalSealPermissionFactory.getLocalInstance((Context)ctx);
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            IPersonalSeal iPersonalSeal = PersonalSealFactory.getLocalInstance((Context)ctx);
            PersonalSealPermissionInfo csp = icsp.getPersonalSealPermissionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            PersonalSealInfo comSealInfo = csp.getPersonalSealName();
            comSealInfo = iPersonalSeal.getPersonalSealInfo((IObjectPK)new ObjectUuidPK(comSealInfo.getId()));
            String comSealName = comSealInfo.getName();
            String fileName = comSealInfo.getFileName();
            String storeType = comSealInfo.getStoreType().getAlias();
            PersonInfo owner = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(comSealInfo.getOwner().getId()));
            PersonInfo user = csp.getUser();
            user = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(user.getId()));
            String userName = user.getName();
            PersonInfo settingperson = csp.getSettingPerson();
            settingperson = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(settingperson.getId()));
            String settingName = settingperson.getName();
            SealPermissionDTO spsDto = new SealPermissionDTO();
            spsDto.setOwnerId(owner.getId().toString());
            spsDto.setOwnerName(owner.getName());
            spsDto.setEndDate(new SimpleDateFormat("yyyy-MM-dd").format(csp.getEndDate()));
            spsDto.setStartDate(new SimpleDateFormat("yyyy-MM-dd").format(csp.getStartDate()));
            spsDto.setFileName(fileName);
            spsDto.setSealName(comSealName);
            spsDto.setSettingPerson(settingName);
            spsDto.setUserName(userName);
            spsDto.setStoreType(storeType);
            this.writeAjaxData(true, null, spsDto);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
        catch (UuidException e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr((Exception)((Object)e)), null);
        }
    }

    public void deletePersonalSealPrem() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        try {
            IPersonalSealPermission icsp = PersonalSealPermissionFactory.getLocalInstance((Context)ctx);
            String ids = this.getRequest().getParameter("ids");
            String[] id = ids.split(",");
            for (int i = 0; i < id.length; ++i) {
                String comSealId = id[i];
                PersonalSealPermissionInfo csp = icsp.getPersonalSealPermissionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)comSealId)));
                IObjectPK logPK = ManageLogUtil.beginLog((Context)ctx, (int)6, (CoreBaseInfo)csp);
                icsp.delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)comSealId)));
                ManageLogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
            }
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, this.handleErr(e), null);
        }
    }

    public void editPersonalSealPrem() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        String premId = this.getRequest().getParameter("sealPremId");
        String beginDateStr = this.getRequest().getParameter("beginDate");
        String endDateStr = this.getRequest().getParameter("endDate");
        String DateStr = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        try {
            if (StringUtil.isEmpty((String)premId)) {
                this.writeAjaxData(false, null, "0");
                return;
            }
            IPersonalSealPermission icsp = PersonalSealPermissionFactory.getLocalInstance((Context)ctx);
            PersonalSealPermissionInfo csp = icsp.getPersonalSealPermissionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)premId)));
            String sealId = csp.getPersonalSealName().getId().toString();
            String sql = "select id,startDate,endDate where personalSealName='" + sealId + "' order by startDate asc";
            PersonalSealPermissionCollection commPerCol = icsp.getPersonalSealPermissionCollection(sql);
            Date currentDatea = new SimpleDateFormat("yyyy-MM-dd").parse(DateStr);
            Date startDate = new SimpleDateFormat("yyyy-MM-dd").parse(beginDateStr);
            Date endDate = new SimpleDateFormat("yyyy-MM-dd").parse(endDateStr);
            Date historyStartDate = null;
            Date historyEndDate = null;
            if (startDate.compareTo(currentDatea) < 0) {
                this.writeAjaxData(false, null, "1");
                return;
            }
            if (startDate.compareTo(endDate) > 0) {
                this.writeAjaxData(false, null, "2");
                return;
            }
            if (commPerCol != null && commPerCol.size() != 0) {
                for (int i = 0; i < commPerCol.size(); ++i) {
                    boolean validInner;
                    historyStartDate = commPerCol.get(i).getStartDate();
                    historyEndDate = commPerCol.get(i).getEndDate();
                    boolean validStartDate = startDate.compareTo(historyStartDate) <= 0 && endDate.compareTo(historyStartDate) >= 0;
                    boolean validEndDate = startDate.compareTo(historyEndDate) <= 0 && endDate.compareTo(historyEndDate) >= 0;
                    boolean bl = validInner = startDate.compareTo(historyStartDate) >= 0 && endDate.compareTo(historyEndDate) <= 0;
                    if (!validStartDate && !validEndDate && !validInner || commPerCol.get(i).getId().equals((Object)premId)) continue;
                    this.writeAjaxData(false, null, "3");
                    return;
                }
            }
            PersonInfo settingPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            csp.setSettingPerson(settingPerson);
            csp.setStartDate(startDate);
            csp.setEndDate(endDate);
            IObjectPK logpk = ManageLogUtil.beginLog((Context)ctx, (int)4, (CoreBaseInfo)csp);
            icsp.save((CoreBaseInfo)csp);
            ManageLogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            this.writeAjaxData(false, this.handleErr(e), "-1");
            e.printStackTrace();
        }
    }
}

