/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.stamp.CommonSealFactory;
import com.kingdee.eas.cp.stamp.CommonSealInfo;
import com.kingdee.eas.cp.stamp.ICommonSeal;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.cp.module.setting.dto.SealPermissionDTO;
import com.kingdee.portal.plt.cp.module.setting.dto.SealPermissionListDTO;
import com.kingdee.portal.plt.cp.module.setting.service.CommonSealPremService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class CommonSealPremServiceImpl
implements CommonSealPremService {
    @Override
    public IRowSet getComSealPremList(Context ctx, Map<String, String> param) throws Exception {
        EntityViewInfo entityViewInfo = this.buileComSealPremViewInfo(ctx, param);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.CommonSealPermissionQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        IRowSet countRowSet = null;
        countRowSet = exec.executeQuery();
        return countRowSet;
    }

    @Override
    public PagingResult<SealPermissionDTO> getComSealPremPageList(Context ctx, Map<String, String> param, PagingParam pagingParam) throws Exception {
        EntityViewInfo entityViewInfo = this.buileComSealPremViewInfo(ctx, param);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.CommonSealPermissionQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        countRowSet = exec.executeQuery();
        int total = 0;
        int totalPage = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        while (countRowSet.next()) {
            ++total;
        }
        totalPage = (total - 1) / pageSize + 1;
        if (pageNo > totalPage) {
            pageNo = totalPage;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.getEnum((String)SortType.DESCEND.getName()));
        entityViewInfo.getSorter().add(sorterItemInfo);
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        ArrayList<SealPermissionDTO> list = new ArrayList<SealPermissionDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                SealPermissionDTO sealPermissionDTO = new SealPermissionDTO();
                sealPermissionDTO.setId(rowSet.getString("id"));
                sealPermissionDTO.setBelogOrgId(rowSet.getString("sealName.belogOrg.id"));
                sealPermissionDTO.setBelogOrgName(rowSet.getString("sealName.belogOrg.name"));
                sealPermissionDTO.setCreateTime(rowSet.getString("createTime"));
                sealPermissionDTO.setEndDate(rowSet.getString("endDate"));
                sealPermissionDTO.setFileName(rowSet.getString("sealName.fileName"));
                sealPermissionDTO.setIsEnableCA(rowSet.getString("sealName.isEnableCA"));
                sealPermissionDTO.setSealId(rowSet.getString("sealName.id"));
                sealPermissionDTO.setSealName(rowSet.getString("sealName.name"));
                sealPermissionDTO.setSettingPerson(rowSet.getString("settingPerson.name"));
                sealPermissionDTO.setStartDate(rowSet.getString("startDate"));
                sealPermissionDTO.setStatus(rowSet.getString("sealName.status"));
                sealPermissionDTO.setStoreType(rowSet.getString("sealName.storeType"));
                sealPermissionDTO.setUserId(rowSet.getString("user.id"));
                sealPermissionDTO.setUserName(rowSet.getString("user.name"));
                list.add(sealPermissionDTO);
            }
        }
        PagingResult pagingResult = new PagingResult();
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    private EntityViewInfo buileComSealPremViewInfo(Context ctx, Map<String, String> param) throws Exception {
        FilterItemInfo item;
        FilterItemCollection itemCollection;
        FilterInfo filterInfo;
        String comSealId = param.get("comSealId");
        String orgId = param.get("orgId");
        String permissionPersonId = param.get("permissionPersonId");
        String operationPersonId = param.get("operationPersonId");
        String beginDate = param.get("beginDate");
        String endDate = param.get("endDate");
        EntityViewInfo commonEntityViewInfo = new EntityViewInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (this.isCurrPersonSealAdmin(ctx)) {
            filterInfo = new FilterInfo();
            itemCollection = filterInfo.getFilterItems();
            item = new FilterItemInfo("CU.id", (Object)this.getCurrCUID(ctx));
            itemCollection.add(item);
            entityViewInfo.setFilter(filterInfo);
        } else {
            filterInfo = new FilterInfo();
            itemCollection = filterInfo.getFilterItems();
            item = new FilterItemInfo("creator.id", (Object)this.getCurUserID(ctx));
            itemCollection.add(item);
            item = new FilterItemInfo("user.id", (Object)this.getCurPersonID(ctx));
            filterInfo.getFilterItems().add(item);
            item = new FilterItemInfo("startDate", (Object)this.getBeginDate(new Date()), CompareType.LESS_EQUALS);
            filterInfo.getFilterItems().add(item);
            item = new FilterItemInfo("endDate", (Object)this.getBeginDate(new Date()), CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(item);
            filterInfo.setMaskString("(#0 or (#1 and #2 and #3))");
            entityViewInfo.setFilter(filterInfo);
        }
        this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        entityViewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        itemCollection = filterInfo.getFilterItems();
        item = null;
        if (!StringUtil.isEmpty((String)comSealId)) {
            item = new FilterItemInfo("sealName.id", (Object)comSealId);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)orgId)) {
            item = new FilterItemInfo("belongOrg.id", (Object)orgId);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)operationPersonId)) {
            item = new FilterItemInfo("settingPerson.id", (Object)operationPersonId);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)permissionPersonId)) {
            item = new FilterItemInfo("user.id", (Object)permissionPersonId);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)beginDate) && !StringUtil.isEmpty((String)endDate)) {
            FilterInfo filterInfoStart = new FilterInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterItemInfo filterItemStar1 = new FilterItemInfo("startDate", (Object)beginDate, CompareType.GREATER_EQUALS);
            FilterItemInfo filterItemStar2 = new FilterItemInfo("startDate", (Object)endDate, CompareType.LESS_EQUALS);
            filterInfoStart.getFilterItems().add(filterItemStar1);
            filterInfoStart.getFilterItems().add(filterItemStar2);
            FilterItemInfo filterItemEnd1 = new FilterItemInfo("endDate", (Object)beginDate, CompareType.GREATER_EQUALS);
            FilterItemInfo filterItemEnd2 = new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS);
            filterInfoStart.getFilterItems().add(filterItemEnd1);
            filterInfoStart.getFilterItems().add(filterItemEnd2);
            FilterItemInfo filterItemEndEqual1 = new FilterItemInfo("startDate", (Object)beginDate, CompareType.LESS_EQUALS);
            FilterItemInfo filterItemEndEqual2 = new FilterItemInfo("endDate", (Object)endDate, CompareType.GREATER_EQUALS);
            filterInfoStart.getFilterItems().add(filterItemEndEqual1);
            filterInfoStart.getFilterItems().add(filterItemEndEqual2);
            filterInfoStart.setMaskString("(#0 and #1) or (#2 and #3) or (#4 and #5)");
            viewInfo.setFilter(filterInfoStart);
            this.mergeEntityViewInfo(commonEntityViewInfo, viewInfo);
        } else {
            if (!StringUtil.isEmpty((String)beginDate)) {
                item = new FilterItemInfo("startDate", (Object)beginDate, CompareType.GREATER_EQUALS);
                itemCollection.add(item);
            }
            if (!StringUtil.isEmpty((String)endDate)) {
                item = new FilterItemInfo("endDate", (Object)endDate, CompareType.LESS_EQUALS);
                itemCollection.add(item);
            }
        }
        entityViewInfo.setFilter(filterInfo);
        this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        return commonEntityViewInfo;
    }

    @Override
    public SealPermissionListDTO getComSealPremBySealId(Context ctx, String sealId) throws Exception {
        ICommonSeal iCommonSeal = CommonSealFactory.getLocalInstance((Context)ctx);
        CommonSealInfo comSealInfo = iCommonSeal.getCommonSealInfo((IObjectPK)new ObjectUuidPK(sealId));
        SealPermissionListDTO sealPermissionList = new SealPermissionListDTO();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo item = new FilterItemInfo("sealName.id", (Object)comSealInfo.getId().toString());
        itemCollection.add(item);
        item = new FilterItemInfo("endDate", (Object)this.getBeginDate(new Date()), CompareType.GREATER_EQUALS);
        itemCollection.add(item);
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.CommonSealPermissionQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        IRowSet rowSet = null;
        rowSet = exec.executeQuery();
        ICtrlUnit ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo cuInfo = ctrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(comSealInfo.getBelongOrg().getId()));
        sealPermissionList.setBelogOrgId(comSealInfo.getBelongOrg().getId().toString());
        sealPermissionList.setBelogOrgName(cuInfo.getName());
        sealPermissionList.setFileName(comSealInfo.getFileName());
        sealPermissionList.setIsEnableCA(comSealInfo.getIsEnableCA().getAlias());
        sealPermissionList.setSealId(comSealInfo.getId().toString());
        sealPermissionList.setSealName(comSealInfo.getName());
        sealPermissionList.setStatus(comSealInfo.getStatus().getAlias());
        sealPermissionList.setStoreType(comSealInfo.getStoreType().getAlias());
        ArrayList<SealPermissionDTO> list = new ArrayList<SealPermissionDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                SealPermissionDTO sealPermissionDTO = new SealPermissionDTO();
                sealPermissionDTO.setId(rowSet.getString("id"));
                sealPermissionDTO.setCreateTime(rowSet.getString("createTime"));
                sealPermissionDTO.setEndDate(rowSet.getString("endDate"));
                sealPermissionDTO.setSettingPerson(rowSet.getString("settingPerson.name"));
                sealPermissionDTO.setStartDate(rowSet.getString("startDate"));
                sealPermissionDTO.setUserId(rowSet.getString("user.id"));
                sealPermissionDTO.setUserName(rowSet.getString("user.name"));
                list.add(sealPermissionDTO);
            }
        }
        sealPermissionList.setSealPermissionList(list);
        return sealPermissionList;
    }

    public boolean isCurrPersonSealAdmin(Context ctx) {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgCUIDPK = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getCU().getId());
        boolean isAdmin = false;
        try {
            isAdmin = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgCUIDPK, "cp_stamp_Seal_Admin");
        }
        catch (Exception e) {
            e.printStackTrace();
            isAdmin = false;
        }
        return isAdmin;
    }

    private String getCurPersonID(Context ctx) {
        PersonInfo curPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (curPerson != null) {
            return curPerson.getId().toString();
        }
        return "";
    }

    private String getCurUserID(Context ctx) {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (curUser != null) {
            return curUser.getId().toString();
        }
        return "";
    }

    private String getCurrCUID(Context ctx) {
        CtrlUnitInfo curUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return curUnit.getId().toString();
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private void mergeEntityViewInfo(EntityViewInfo commonEntityViewInfo, EntityViewInfo commonFilter) throws Exception {
        if (FilterUtility.hasFilterItem((FilterInfo)commonEntityViewInfo.getFilter())) {
            commonEntityViewInfo.getFilter().mergeFilter(commonFilter.getFilter(), "AND");
        } else {
            FilterInfo filterInfo = commonFilter.getFilter();
            if (filterInfo != null) {
                commonEntityViewInfo.setFilter((FilterInfo)filterInfo.clone());
            }
        }
        if (commonFilter.getSorter().size() > 0) {
            commonEntityViewInfo.getSorter().clear();
            for (int i = 0; i < commonFilter.getSorter().size(); ++i) {
                commonEntityViewInfo.getSorter().add(commonFilter.getSorter().get(i));
            }
        }
    }

    private Date getBeginDate(Date beginDate) {
        Date begin = beginDate;
        Calendar cal = Calendar.getInstance();
        cal.setTime(begin);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        cal.set(14, 0);
        begin = cal.getTime();
        return begin;
    }
}

