/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.cp.module.setting.dto.LogDTO;
import com.kingdee.portal.plt.cp.module.setting.service.StampLogService;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StampLogServiceImpl
implements StampLogService {
    @Override
    public IRowSet getMamageLogList(Context ctx, Map<String, String> param) throws Exception {
        EntityViewInfo entityViewInfo = this.buileManagerEntityViewInfo(ctx, param);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.ManageLogQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        IRowSet countRowSet = null;
        countRowSet = exec.executeQuery();
        return countRowSet;
    }

    @Override
    public PagingResult<LogDTO> getMamageLogPageList(Context ctx, Map<String, String> param, PagingParam pagingParam) throws Exception {
        EntityViewInfo entityViewInfo = this.buileManagerEntityViewInfo(ctx, param);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.ManageLogQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        countRowSet = exec.executeQuery();
        int total = 0;
        int totalPage = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        while (countRowSet.next()) {
            ++total;
        }
        totalPage = (total - 1) / pageSize + 1;
        if (pageNo > totalPage) {
            pageNo = totalPage;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo("occurTime");
        sorterItemInfo.setSortType(SortType.getEnum((String)SortType.DESCEND.getName()));
        entityViewInfo.getSorter().add(sorterItemInfo);
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        ArrayList<LogDTO> list = new ArrayList<LogDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                LogDTO logDto = new LogDTO();
                logDto.setId(rowSet.getString("id"));
                logDto.setOccurTime(rowSet.getString("occurTime").substring(0, 16));
                logDto.setOperation(rowSet.getString("operation"));
                logDto.setOperationDetail(rowSet.getString("operationDetail"));
                logDto.setOperationPersonId(rowSet.getString("operationPerson.id"));
                logDto.setOperationPersonName(rowSet.getString("operationPerson.name"));
                logDto.setPermissionPersonId(rowSet.getString("permissionPerson.id"));
                logDto.setPermissionPersonName(rowSet.getString("permissionPerson.name"));
                logDto.setSealId(rowSet.getString("seal.id"));
                logDto.setSealName(rowSet.getString("seal.name"));
                list.add(logDto);
            }
        }
        PagingResult pagingResult = new PagingResult();
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    @Override
    public IRowSet getStampLogList(Context ctx, Map<String, String> param) throws Exception {
        EntityViewInfo entityViewInfo = this.buileStampEntityViewInfo(ctx, param);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.StampLogQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        IRowSet countRowSet = null;
        countRowSet = exec.executeQuery();
        return countRowSet;
    }

    @Override
    public PagingResult<LogDTO> getStampLogPageList(Context ctx, Map<String, String> param, PagingParam pagingParam) throws Exception {
        EntityViewInfo entityViewInfo = this.buileStampEntityViewInfo(ctx, param);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.StampLogQuery");
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        String sql = exec.getSQL();
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        countRowSet = exec.executeQuery();
        int total = 0;
        int totalPage = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        while (countRowSet.next()) {
            ++total;
        }
        totalPage = (total - 1) / pageSize + 1;
        if (pageNo > totalPage) {
            pageNo = totalPage;
        }
        if (pageNo <= 0) {
            pageNo = 1;
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo("occurTime");
        sorterItemInfo.setSortType(SortType.getEnum((String)SortType.DESCEND.getName()));
        entityViewInfo.getSorter().add(sorterItemInfo);
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        ArrayList<LogDTO> list = new ArrayList<LogDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                LogDTO logDto = new LogDTO();
                logDto.setId(rowSet.getString("id"));
                logDto.setOccurTime(rowSet.getString("occurTime").substring(0, 16));
                logDto.setOperationPersonId(rowSet.getString("operationPerson.id"));
                logDto.setOperationPersonName(rowSet.getString("operationPerson.name"));
                logDto.setPermissionPersonId(rowSet.getString("permissionPerson.id"));
                logDto.setPermissionPersonName(rowSet.getString("permissionPerson.name"));
                logDto.setSealId(rowSet.getString("seal.id"));
                logDto.setSealName(rowSet.getString("seal.name"));
                logDto.setBillTitle(rowSet.getString("billTitle"));
                logDto.setEntityName(rowSet.getString("entityName"));
                logDto.setSealType(rowSet.getString("sealType"));
                logDto.setSubmodel(rowSet.getString("submodel"));
                logDto.setSubsystem(rowSet.getString("subsystem"));
                logDto.setOperation(rowSet.getString("operationType"));
                list.add(logDto);
            }
        }
        PagingResult pagingResult = new PagingResult();
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    private EntityViewInfo buileManagerEntityViewInfo(Context ctx, Map<String, String> param) throws Exception {
        FilterItemInfo item;
        String operation = param.get("operation");
        String permissionPersonId = param.get("permissionPersonId");
        String operationPersonId = param.get("operationPersonId");
        String beginDate = param.get("beginDate");
        String endDate = param.get("endDate");
        String sealId = param.get("sealId");
        EntityViewInfo commonEntityViewInfo = new EntityViewInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        filterInfo = this.getLogSealIDFilter(ctx, sealId);
        entityViewInfo.setFilter(filterInfo);
        this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        entityViewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        itemCollection = filterInfo.getFilterItems();
        if (!StringUtil.isEmpty((String)operation)) {
            item = new FilterItemInfo("operation", (Object)Integer.valueOf(operation));
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)permissionPersonId)) {
            item = new FilterItemInfo("permissionPerson.id", (Object)permissionPersonId);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)operationPersonId)) {
            item = new FilterItemInfo("operationPerson.id", (Object)operationPersonId);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)beginDate)) {
            beginDate = beginDate + " 00:00:00.0";
            item = new FilterItemInfo("occurTime", (Object)Timestamp.valueOf(beginDate), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)endDate)) {
            endDate = endDate + " 23:59:59.0";
            item = new FilterItemInfo("occurTime", (Object)Timestamp.valueOf(endDate), CompareType.LESS_EQUALS);
            itemCollection.add(item);
        }
        entityViewInfo.setFilter(filterInfo);
        this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        if (this.isCurrPersonSealAdmin(ctx)) {
            entityViewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            itemCollection = filterInfo.getFilterItems();
            item = new FilterItemInfo("cu.id", (Object)this.getCurrCUID(ctx));
            itemCollection.add(item);
            entityViewInfo.setFilter(filterInfo);
            this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        }
        return commonEntityViewInfo;
    }

    private FilterInfo getLogSealIDFilter(Context ctx, String sealID) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        if (this.isCurrPersonSealAdmin(ctx)) {
            if (!StringUtil.isEmpty((String)sealID)) {
                FilterItemInfo item = new FilterItemInfo("seal.id", (Object)sealID);
                itemCollection.add(item);
            }
        } else {
            Set<String> myPermissionCommonSealIDSet = this.getMyPermissionCommonSealIDSet(ctx);
            Set<String> myPersonalSealIDSet = this.getMyPersonalSealIDSet(ctx);
            Set<String> myPermissionPersonalSealIDSet = this.getMyPermissionPersonalSealIDSet(ctx);
            if (!StringUtil.isEmpty((String)sealID)) {
                if (myPermissionCommonSealIDSet.contains(sealID) || myPermissionPersonalSealIDSet.contains(sealID)) {
                    FilterItemInfo item = new FilterItemInfo("seal.id", (Object)sealID);
                    itemCollection.add(item);
                    item = new FilterItemInfo("operationPerson.id", (Object)this.getCurPersonID(ctx));
                    itemCollection.add(item);
                    item = new FilterItemInfo("permissionPerson.id", (Object)this.getCurPersonID(ctx));
                    itemCollection.add(item);
                    filterInfo.setMaskString("#0 and (#1 or #2)");
                } else if (myPersonalSealIDSet.contains(sealID)) {
                    FilterItemInfo item = new FilterItemInfo("seal.id", (Object)sealID);
                    itemCollection.add(item);
                } else {
                    FilterItemInfo item = new FilterItemInfo("seal.id", (Object)"nodata");
                    itemCollection.add(item);
                }
            } else {
                itemCollection.add(new FilterItemInfo("permissionPerson.id", (Object)this.getCurPersonID(ctx)));
                itemCollection.add(new FilterItemInfo("operation", (Object)6));
                if (myPermissionCommonSealIDSet.size() > 0 || myPersonalSealIDSet.size() > 0 || myPermissionPersonalSealIDSet.size() > 0) {
                    FilterItemInfo item;
                    myPermissionCommonSealIDSet.addAll(myPermissionPersonalSealIDSet);
                    String maskStr = "";
                    if (myPermissionCommonSealIDSet.size() > 0) {
                        item = new FilterItemInfo("seal.id", myPermissionCommonSealIDSet, CompareType.INCLUDE);
                        itemCollection.add(item);
                        item = new FilterItemInfo("operationPerson.id", (Object)this.getCurPersonID(ctx));
                        itemCollection.add(item);
                        item = new FilterItemInfo("permissionPerson.id", (Object)this.getCurPersonID(ctx));
                        itemCollection.add(item);
                        maskStr = "(#0 and #1) or (#2 and (#3 or #4))";
                    }
                    if (myPersonalSealIDSet.size() > 0) {
                        item = new FilterItemInfo("seal.id", myPersonalSealIDSet, CompareType.INCLUDE);
                        itemCollection.add(item);
                        String string = maskStr = "".equals(maskStr) ? "(#0 and #1) or #2" : "(#0 and #1) or (#2 and (#3 or #4)) or (#5)";
                    }
                    if (!"".equals(maskStr)) {
                        filterInfo.setMaskString(maskStr);
                    }
                }
            }
        }
        return filterInfo;
    }

    private EntityViewInfo buileStampEntityViewInfo(Context ctx, Map<String, String> param) throws Exception {
        FilterItemInfo item;
        String operationPersonId = param.get("operationPersonId");
        String beginDate = param.get("beginDate");
        String endDate = param.get("endDate");
        String sealId = param.get("sealId");
        String title = param.get("title");
        EntityViewInfo commonEntityViewInfo = new EntityViewInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        filterInfo = this.getLogStampSealIDFilter(ctx, sealId);
        entityViewInfo.setFilter(filterInfo);
        this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        entityViewInfo = new EntityViewInfo();
        filterInfo = new FilterInfo();
        itemCollection = filterInfo.getFilterItems();
        if (!StringUtil.isEmpty((String)operationPersonId)) {
            item = new FilterItemInfo("operationPerson.id", (Object)operationPersonId);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)beginDate)) {
            beginDate = beginDate + " 00:00:00.0";
            item = new FilterItemInfo("occurTime", (Object)Timestamp.valueOf(beginDate), CompareType.GREATER_EQUALS);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)endDate)) {
            endDate = endDate + " 23:59:59.0";
            item = new FilterItemInfo("occurTime", (Object)Timestamp.valueOf(endDate), CompareType.LESS_EQUALS);
            itemCollection.add(item);
        }
        if (!StringUtil.isEmpty((String)title)) {
            item = new FilterItemInfo("billTitle", (Object)("%" + title + "%"), CompareType.LIKE);
            itemCollection.add(item);
        }
        entityViewInfo.setFilter(filterInfo);
        this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        if (this.isCurrPersonSealAdmin(ctx)) {
            entityViewInfo = new EntityViewInfo();
            filterInfo = new FilterInfo();
            itemCollection = filterInfo.getFilterItems();
            item = new FilterItemInfo("cu.id", (Object)this.getCurrCUID(ctx));
            itemCollection.add(item);
            entityViewInfo.setFilter(filterInfo);
            this.mergeEntityViewInfo(commonEntityViewInfo, entityViewInfo);
        }
        return commonEntityViewInfo;
    }

    private FilterInfo getLogStampSealIDFilter(Context ctx, String sealID) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        if (this.isCurrPersonSealAdmin(ctx)) {
            if (!StringUtil.isEmpty((String)sealID)) {
                FilterItemInfo item = new FilterItemInfo("seal.id", (Object)sealID);
                itemCollection.add(item);
            }
        } else {
            Set<String> myPermissionCommonSealIDSet = this.getMyPermissionCommonSealIDSet(ctx);
            Set<String> myPersonalSealIDSet = this.getMyPersonalSealIDSet(ctx);
            Set<String> myPermissionPersonalSealIDSet = this.getMyPermissionPersonalSealIDSet(ctx);
            if (!StringUtil.isEmpty((String)sealID)) {
                if (myPermissionCommonSealIDSet.contains(sealID) || myPermissionPersonalSealIDSet.contains(sealID)) {
                    FilterItemInfo item = new FilterItemInfo("seal.id", (Object)sealID);
                    itemCollection.add(item);
                    item = new FilterItemInfo("operationPerson.id", (Object)this.getCurPersonID(ctx));
                    itemCollection.add(item);
                    item = new FilterItemInfo("permissionPerson.id", (Object)this.getCurPersonID(ctx));
                    itemCollection.add(item);
                    filterInfo.setMaskString("#0 and (#1 or #2)");
                } else if (myPersonalSealIDSet.contains(sealID)) {
                    FilterItemInfo item = new FilterItemInfo("seal.id", (Object)sealID);
                    itemCollection.add(item);
                } else {
                    FilterItemInfo item = new FilterItemInfo("seal.id", (Object)"nodata");
                    itemCollection.add(item);
                }
            } else {
                itemCollection.add(new FilterItemInfo("operationPerson.id", (Object)this.getCurPersonID(ctx)));
                itemCollection.add(new FilterItemInfo("operationType", (Object)1));
                itemCollection.add(new FilterItemInfo("operationType", (Object)2));
                if (myPermissionCommonSealIDSet.size() > 0 || myPersonalSealIDSet.size() > 0 || myPermissionPersonalSealIDSet.size() > 0) {
                    FilterItemInfo item;
                    myPermissionCommonSealIDSet.addAll(myPermissionPersonalSealIDSet);
                    String maskStr = "";
                    if (myPermissionCommonSealIDSet.size() > 0) {
                        item = new FilterItemInfo("seal.id", myPermissionCommonSealIDSet, CompareType.INCLUDE);
                        itemCollection.add(item);
                        item = new FilterItemInfo("operationPerson.id", (Object)this.getCurPersonID(ctx));
                        itemCollection.add(item);
                        item = new FilterItemInfo("permissionPerson.id", (Object)this.getCurPersonID(ctx));
                        itemCollection.add(item);
                        maskStr = "(#0 and (#1 or #2)) or (#3 and (#4 or #5))";
                    }
                    if (myPersonalSealIDSet.size() > 0) {
                        item = new FilterItemInfo("seal.id", myPersonalSealIDSet, CompareType.INCLUDE);
                        itemCollection.add(item);
                        String string = maskStr = "".equals(maskStr) ? "(#0 and (#1 or #2)) or #3" : "(#0 and (#1 or #2)) or (#3 and (#4 or #5)) or (#6)";
                    }
                    if (!"".equals(maskStr)) {
                        filterInfo.setMaskString(maskStr);
                    }
                }
            }
        }
        return filterInfo;
    }

    private Set<String> getMyPersonalSealIDSet(Context ctx) {
        HashSet<String> idSet = new HashSet<String>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo item = new FilterItemInfo("owner.id", (Object)this.getCurPersonID(ctx));
        itemCollection.add(item);
        item = new FilterItemInfo("creator.id", (Object)this.getCurUserID(ctx));
        itemCollection.add(item);
        filterInfo.setMaskString("#0 or #1");
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.PersonalSealAdvanceQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            rowSet = exec.executeQuery();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idSet;
    }

    private Set<String> getMyPermissionPersonalSealIDSet(Context ctx) {
        HashSet<String> idSet = new HashSet<String>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo item = null;
        item = new FilterItemInfo("sealPermission.user.id", (Object)this.getCurPersonID(ctx));
        filterInfo.getFilterItems().add(item);
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.PersonalSealAdvanceQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            rowSet = exec.executeQuery();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idSet;
    }

    private Set<String> getMyPermissionCommonSealIDSet(Context ctx) {
        HashSet<String> idSet = new HashSet<String>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo item = null;
        item = new FilterItemInfo("sealPermission.user.id", (Object)this.getCurPersonID(ctx));
        filterInfo.getFilterItems().add(item);
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.cp.stamp.app.CommonSealAdvanceQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)queryPK, entityViewInfo, ctx);
            rowSet = exec.executeQuery();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idSet;
    }

    private boolean isCurrPersonSealAdmin(Context ctx) {
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgCUIDPK = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getCU().getId());
        boolean isAdmin = false;
        try {
            isAdmin = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgCUIDPK, "cp_stamp_Seal_Admin");
        }
        catch (Exception e) {
            e.printStackTrace();
            isAdmin = false;
        }
        return isAdmin;
    }

    private String getCurPersonID(Context ctx) {
        PersonInfo curPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (curPerson != null) {
            return curPerson.getId().toString();
        }
        return "";
    }

    private String getCurUserID(Context ctx) {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (curUser != null) {
            return curUser.getId().toString();
        }
        return "";
    }

    private String getCurrCUID(Context ctx) {
        CtrlUnitInfo curUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return curUnit.getId().toString();
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private void mergeEntityViewInfo(EntityViewInfo commonEntityViewInfo, EntityViewInfo commonFilter) throws Exception {
        if (FilterUtility.hasFilterItem((FilterInfo)commonEntityViewInfo.getFilter())) {
            commonEntityViewInfo.getFilter().mergeFilter(commonFilter.getFilter(), "AND");
        } else {
            FilterInfo filterInfo = commonFilter.getFilter();
            if (filterInfo != null) {
                commonEntityViewInfo.setFilter((FilterInfo)filterInfo.clone());
            }
        }
        if (commonFilter.getSorter().size() > 0) {
            commonEntityViewInfo.getSorter().clear();
            for (int i = 0; i < commonFilter.getSorter().size(); ++i) {
                commonEntityViewInfo.getSorter().add(commonFilter.getSorter().get(i));
            }
        }
    }
}

