/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.setting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class BaseSettingUtil {
    public static boolean isHasPermission(Context ctx, String permissionItem) {
        try {
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            if (cuId == null || StringUtils.isEmpty((String)permissionItem)) {
                return false;
            }
            IObjectPK userPK = ctx.getCaller();
            ObjectUuidPK orgPK = new ObjectUuidPK(cuId);
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            iPermission.checkFunctionPermission(userPK, (IObjectPK)orgPK, permissionItem);
            return true;
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            e2.printStackTrace();
        }
        return false;
    }

    public static Map<String, Boolean> perListCheck(String[] perList, Context ctx, HttpServletRequest request) {
        HashMap<String, Boolean> permission = new HashMap<String, Boolean>();
        for (String str : perList) {
            try {
                BaseSettingUtil.checkFunctionPermission(str, (OrgUnitInfo)ContextUtil.getCurrentCtrlUnit((Context)ctx), request);
                permission.put(str, true);
            }
            catch (Exception e) {
                permission.put(str, false);
            }
        }
        return permission;
    }

    private static void checkFunctionPermission(String permItemName, OrgUnitInfo mainOrg, HttpServletRequest request) throws BOSException, EASBizException {
        IPermission perm = PermissionFactory.getRemoteInstance();
        Context uiContext = WebContextUtil.getEasContext((HttpServletRequest)request);
        ObjectUuidPK orgPK = null;
        OrgUnitInfo org = mainOrg;
        if (org != null) {
            orgPK = new ObjectUuidPK(org.getId());
        }
        ObjectUuidPK userPK = null;
        CoreBaseInfo user = (CoreBaseInfo)uiContext.get((Object)"UserInfo");
        if (user != null) {
            userPK = new ObjectUuidPK(user.getId());
        }
        if (orgPK == null) {
            throw new EASBizException(new NumericExceptionSubItem("007", "\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6821\u9a8c\u6743\u9650\u3002"));
        }
        perm.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permItemName);
    }
}

