/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.cp.module.sm.action;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.simple.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.sm.InviteBillStateEnum;
import com.kingdee.eas.cp.sm.Schedule4PersonVisableConfigInfo;
import com.kingdee.eas.cp.sm.web.ScheduleDataDao;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.plt.cp.module.sm.util.CommonDataUtil;
import com.kingdee.portal.plt.cp.module.sm.util.DateUtil;
import com.kingdee.portal.plt.cp.module.sm.util.ScheduleDataBiz;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class MySMCalendarAction
extends BaseAction {
    private static final String resource = "com.kingdee.eas.portal.portalPublic";
    private static Locale locale = ContextUtils.getLocaleFromEnv();

    public void getcalendarXml() throws Exception {
        HttpServletRequest request = this.getRequest();
        String yMonth = request.getParameter("yMonth");
        if (yMonth != null && yMonth.trim().length() > 0) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String beginStr = yMonth + "-01 00:00";
            String endStr = yMonth + "-31 23:59";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtil.getDateFormat(beginStr, "yyyy-MM-dd H:mm"));
            paramMap.put("userCal", cal);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            paramMap.put("userId", userInfo.getPerson().getId().toString());
            List myCreateList = new ScheduleDataDao().getUserCreateScheduleData(ctx, paramMap);
            List invitedMyList = new ScheduleDataDao().getInvitedUserScheduleData(ctx, paramMap);
            Schedule4PersonVisableConfigInfo configInfo = CommonDataUtil.getPersonVisableConfig(ctx, userInfo.getPerson().getId().toString());
            List<HashMap<String, Object>> MyScheduleList = ScheduleDataBiz.clearMyScheduleDirtyData(configInfo, myCreateList, invitedMyList);
            HashMap dateMap = new HashMap();
            String dateStr = null;
            ArrayList<Msg> list = null;
            if (MyScheduleList.size() > 0) {
                for (int i = 0; i < MyScheduleList.size(); ++i) {
                    BizEnumValueDTO inviteBillState;
                    HashMap<String, Object> info = MyScheduleList.get(i);
                    Date eventDate = null;
                    Date eventEndDate = null;
                    String id = null;
                    String title = null;
                    if (info.get("eventdate") == null || info.get("eventenddate") == null || (inviteBillState = (BizEnumValueDTO)info.get("invitedperson.invitebillstate")) != null && inviteBillState.getValue().equals(String.valueOf(InviteBillStateEnum.REFUSE.getValue()))) continue;
                    id = (String)info.get("id");
                    eventDate = (Date)info.get("eventdate");
                    eventEndDate = (Date)info.get("eventenddate");
                    title = (String)info.get("title");
                    Calendar calStart = Calendar.getInstance();
                    calStart.setTime(eventDate);
                    Calendar calEnd = Calendar.getInstance();
                    calEnd.setTime(eventEndDate);
                    dateStr = DateUtil.toString(calStart.getTime(), "yyyy-MM-dd");
                    if (dateStr.indexOf(yMonth) == -1) continue;
                    list = (ArrayList<Msg>)dateMap.get(dateStr);
                    if (list == null) {
                        list = new ArrayList<Msg>();
                        dateMap.put(dateStr, list);
                    }
                    Msg msg = new Msg();
                    msg.id = id;
                    msg.title = this.convertLenth(title, 40);
                    msg.time = DateUtil.toString(eventDate, "yyyy-MM-dd H:mm");
                    msg.body = this.convertLenth((String)info.get("content"), 40);
                    msg.resourceId = id;
                    list.add(msg);
                    if (calEnd.get(5) == calStart.get(5)) continue;
                    dateStr = DateUtil.toString(calEnd.getTime(), "yyyy-MM-dd");
                    list = (ArrayList<Msg>)dateMap.get(dateStr);
                    if (list == null) {
                        list = new ArrayList<Msg>();
                        dateMap.put(dateStr, list);
                    }
                    msg.time = DateUtil.toString(eventEndDate, "yyyy-MM-dd H:mm");
                    list.add(msg);
                }
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("dataMap", dateMap);
            resultMap.put("yam", yMonth);
            this.writeAjaxData(true, null, resultMap);
        }
    }

    private Locale getLocale(Context ctx) {
        if (ctx == null) {
            return locale;
        }
        if (ctx.getLocale() == null) {
            return locale;
        }
        return ctx.getLocale();
    }

    private JSONObject makeJson(String yMonth, HashMap map, Locale mLocale) {
        JSONObject reply = new JSONObject();
        reply.put((Object)"yam", (Object)yMonth);
        String date = yMonth.replaceAll("-", "");
        String tDate = "";
        ArrayList list = null;
        Msg msg = null;
        JSONObject monthInfo = new JSONObject();
        int index = 0;
        for (int i = 0; i < 31; ++i) {
            tDate = date + this.convertInt(i + 1);
            list = (ArrayList)map.get(tDate);
            if (list == null || list.size() <= 0) continue;
            JSONArray dayInfo = new JSONArray();
            for (int j = 0; j < list.size(); ++j) {
                msg = (Msg)list.get(j);
                JSONObject msgInfo = new JSONObject();
                if (msg != null) {
                    msgInfo.put((Object)"subject", (Object)(EASCommonResource.getString((String)resource, (String)"subject", (Locale)mLocale) + this.convertLenth(msg.title, 40)));
                    msgInfo.put((Object)"time", (Object)msg.time);
                    msgInfo.put((Object)"address", (Object)(EASCommonResource.getString((String)resource, (String)"event", (Locale)mLocale) + this.convertLenth(msg.body, 40)));
                    msgInfo.put((Object)"msgtype", (Object)new Integer(msg.type));
                    msgInfo.put((Object)"url", (Object)("1," + msg.id + "," + msg.resourceId + "," + msg.type + "," + msg.webSupport + "," + msg.sourceIDs + "," + msg.bizType));
                }
                dayInfo.put(j, (Object)msgInfo);
            }
            monthInfo.put((Object)("day" + (i + 1)), (Object)dayInfo);
            ++index;
        }
        reply.put((Object)"monthInfo", (Object)monthInfo);
        return reply;
    }

    private String convertInt(int i) {
        String temp = String.valueOf(i);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        return temp;
    }

    private String convertLenth(String str, int length) {
        if (str == null) {
            return "";
        }
        if (str.length() < length) {
            return str;
        }
        return str.substring(0, length);
    }

    public class Msg {
        public int type;
        public int bizType;
        public String id;
        public String resourceId;
        public String title;
        public String body;
        public String time;
        public boolean webSupport = false;
        public String sourceIDs = "";

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getBizType() {
            return this.bizType;
        }

        public void setBizType(int bizType) {
            this.bizType = bizType;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public boolean isWebSupport() {
            return this.webSupport;
        }

        public void setWebSupport(boolean webSupport) {
            this.webSupport = webSupport;
        }

        public String getSourceIDs() {
            return this.sourceIDs;
        }

        public void setSourceIDs(String sourceIDs) {
            this.sourceIDs = sourceIDs;
        }
    }
}

