/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.action;

import com.kingdee.portal.biz.common.action.BaseFileUploadAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.iservice.common.enums.DocTypeEnum;
import com.kingdee.portal.plt.iservice.common.enums.NodeTypeEnum;
import com.kingdee.portal.plt.iservice.common.exception.ServiceBizException;
import com.kingdee.portal.plt.iservice.common.exception.conf.ServiceErrConfig;
import com.kingdee.portal.plt.iservice.common.util.ServiceLocator;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDefinition;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDocument;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDefinitionService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDocumentService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;

public class DocumentManageAction
extends BaseFileUploadAction {
    private ServiceDefinitionService serviceDefinitionService = (ServiceDefinitionService)ServiceLocator.getBean("serviceDefinitionService");
    private ServiceDocumentService serviceDocumentService = (ServiceDocumentService)ServiceLocator.getBean("serviceDocumentService");
    private ServiceDocument serviceDocument = null;

    public String findServiceNav() {
        String pltInsId = StringUtil.convNull((String)this.getRequest().getParameter("pltInsId"));
        this.getRequest().setAttribute("pltInsId", (Object)pltInsId);
        try {
            List<ServiceDefinition> result = this.serviceDefinitionService.findServiceList4Enable(this.getPortalContext());
            this.buildNavTreeData(result);
        }
        catch (Exception ex) {
            this.getRequest().setAttribute("error", (Object)this.handleErr(ex));
            return "error";
        }
        return "success";
    }

    public String findDocListPage() {
        try {
            String pltInsId = StringUtil.convNull((String)this.getRequest().getParameter("pltInsId"));
            this.getRequest().setAttribute("pltInsId", (Object)pltInsId);
            String serviceDefId = StringUtil.convNull((String)this.getRequest().getParameter("serviceDefId"));
            this.getRequest().setAttribute("serviceDefId", (Object)serviceDefId);
            boolean isManager = this.serviceDocumentService.isManagerForCurrentUser(this.getPortalContext(), serviceDefId);
            this.getRequest().setAttribute("isManager", (Object)isManager);
        }
        catch (ServiceBizException ex) {
            this.getRequest().setAttribute("error", (Object)ex);
            return "error";
        }
        return "success";
    }

    public String findDocList() {
        boolean success = true;
        LocalErr localErr = null;
        PagingResult<ServiceDocument> docList = null;
        try {
            docList = this.serviceDocumentService.findDocListByServDefId(this.getPortalContext(), this.serviceDocument.getServiceDefId(), this.pagingParam);
            if (docList != null && docList.getRecords() != null) {
                for (ServiceDocument serviceDocument : docList.getRecords()) {
                    serviceDocument.setContent(null);
                }
            }
        }
        catch (Exception ex) {
            localErr = this.handleErr(ex);
            success = false;
        }
        this.writePagingResult(docList);
        return null;
    }

    public String showUploadDocWin() {
        String pltInsId = StringUtil.convNull((String)this.getRequest().getParameter("pltInsId"));
        this.getRequest().setAttribute("pltInsId", (Object)pltInsId);
        try {
            if (this.serviceDocument != null && !StringUtil.isEmpty((String)this.serviceDocument.getId())) {
                this.serviceDocument = this.serviceDocumentService.findDocById(this.getPortalContext(), this.serviceDocument.getId());
            }
            this.getRequest().setAttribute("serviceDocument", (Object)this.serviceDocument);
        }
        catch (ServiceBizException ex) {
            this.getRequest().setAttribute("error", (Object)ex);
        }
        return "success";
    }

    public String uploadTempDoc() {
        boolean success = true;
        LocalErr localErr = null;
        FileModel fileModel = null;
        try {
            this.copyFile2UploadFolder();
            fileModel = new FileModel();
            fileModel.setUploadFilePath(this.getUpload().getAbsolutePath());
            fileModel.setUploadFileName(this.getUploadFileName());
            fileModel.setUploadContentType(this.getUploadContentType());
            fileModel.setLength(Long.valueOf(this.getUpload().length()));
        }
        catch (Exception ex) {
            localErr = this.handleErr(ex);
            success = false;
        }
        this.getRequest().setAttribute("success", (Object)success);
        this.getRequest().setAttribute("oper", (Object)"uploadTempDoc");
        this.getRequest().getSession().setAttribute("iservice_last_upload_doc", (Object)fileModel);
        this.getRequest().setAttribute("localErr", (Object)localErr);
        return "success";
    }

    public String showTempDoc() {
        FileModel fileModel = (FileModel)this.getRequest().getSession().getAttribute("iservice_last_upload_doc");
        File tempTempImg = new File(fileModel.getUploadFilePath());
        byte[] fileContent = this.getFileContent(tempTempImg);
        this.writeResponse4Down(fileModel.getUploadFileName(), null, fileContent);
        return null;
    }

    public String saveDocument() {
        String pltInsId = StringUtil.convNull((String)this.getRequest().getParameter("pltInsId"));
        this.getRequest().setAttribute("pltInsId", (Object)pltInsId);
        boolean success = true;
        try {
            String updateDocStr = StringUtil.convNull((String)this.getRequest().getParameter("updateFlag"));
            boolean updateDoc = Boolean.parseBoolean(updateDocStr);
            FileModel fileModel = (FileModel)this.getRequest().getSession().getAttribute("iservice_last_upload_doc");
            this.serviceDocument = this.serviceDocumentService.saveDocument(this.getPortalContext(), this.serviceDocument, fileModel, updateDoc);
        }
        catch (ServiceBizException ex) {
            success = false;
            LocalErr localErr = this.handleErr((Exception)((Object)ex));
            this.getRequest().setAttribute("error", (Object)localErr);
        }
        this.getRequest().setAttribute("success", (Object)success);
        this.getRequest().setAttribute("oper", (Object)"saveDoc");
        return "success";
    }

    public String downloadDoc() {
        try {
            String docId = StringUtil.convNull((String)this.getRequest().getParameter("docId"));
            this.serviceDocument = this.serviceDocumentService.findDocById(this.getPortalContext(), docId);
            if (this.serviceDocument == null) {
                throw new ServiceBizException(ServiceErrConfig.ISERVICE_DOC_NO_EXISTED_ERR);
            }
            DisplayName displayName = new DisplayName(this.serviceDocument.getDisplayName(), this.getPortalContext().getLocale().toString());
            String fileName = displayName.getLocaleText() + this.serviceDocument.getDocSuffix();
            byte[] fileContent = this.serviceDocument.getContent();
            String contentType = null;
            if (DocTypeEnum.FLOWCHART.equals((Object)this.serviceDocument.getDocType())) {
                contentType = this.serviceDocument.getContentType();
            }
            this.writeResponse4Down(fileName, contentType, fileContent);
            if (DocTypeEnum.DOC.equals((Object)this.serviceDocument.getDocType())) {
                this.serviceDocumentService.updateDocDownloadCount(this.getPortalContext(), docId);
            }
        }
        catch (ServiceBizException ex) {
            LocalErr localErr = this.handleErr((Exception)((Object)ex));
            this.getRequest().setAttribute("error", (Object)localErr);
            return "error";
        }
        return null;
    }

    public String deleteDoc() {
        boolean success = true;
        LocalErr localErr = null;
        try {
            this.serviceDocumentService.deleteDoc(this.getPortalContext(), this.serviceDocument.getId(), this.serviceDocument.getServiceDefId());
        }
        catch (ServiceBizException ex) {
            success = false;
            localErr = this.handleErr((Exception)((Object)ex));
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    public String importContent4File() {
        boolean success = true;
        LocalErr localErr = null;
        try {
            String iserviceRootPath = this.getIServiceRootPath();
            this.serviceDocumentService.importContent4InitData(this.getPortalContext(), iserviceRootPath);
        }
        catch (ServiceBizException ex) {
            success = false;
            localErr = this.handleErr((Exception)((Object)ex));
        }
        this.writeAjaxData(success, localErr, null);
        return null;
    }

    private String getIServiceRootPath() {
        String iServiceRootPath = Constant.SYSTEM_ROOT_PATH + ".." + Constant.SYSTEM_PATH_SEPARATOR + "plt_iservice.war";
        return iServiceRootPath;
    }

    private void buildNavTreeData(List<ServiceDefinition> list) {
        ArrayList<Object> categoryList = new ArrayList<Object>();
        for (Object serviceDefinition : list) {
            if (!serviceDefinition.getNodeType().equals((Object)NodeTypeEnum.CATEGORY)) continue;
            categoryList.add(serviceDefinition);
        }
        HashMap subServiceMap = new HashMap();
        for (ServiceDefinition serviceDefinition : categoryList) {
            ArrayList<ServiceDefinition> subList = new ArrayList<ServiceDefinition>();
            int docCount = 0;
            for (ServiceDefinition serviceDefinition2 : list) {
                if (!serviceDefinition.getId().equals(serviceDefinition2.getParentNodeId())) continue;
                subList.add(serviceDefinition2);
                int currentCount = serviceDefinition2.getDocCount() == null ? 0 : serviceDefinition2.getDocCount();
                docCount += currentCount;
            }
            subServiceMap.put(serviceDefinition.getId(), subList);
            serviceDefinition.setDocCount(docCount);
        }
        Set categoryIdList = subServiceMap.keySet();
        if (categoryIdList != null) {
            for (String categoryId : categoryIdList) {
                List servList = (List)subServiceMap.get(categoryId);
                if (!servList.isEmpty()) continue;
                for (ServiceDefinition serviceDefinition2 : list) {
                    if (!serviceDefinition2.getId().equals(categoryId)) continue;
                    categoryList.remove((Object)serviceDefinition2);
                }
            }
        }
        this.getRequest().setAttribute("categoryList", categoryList);
        this.getRequest().setAttribute("subServiceMap", subServiceMap);
    }

    public void findServiceDocList() {
        boolean success = true;
        LocalErr localErr = null;
        try {
            String idList = this.getRequest().getParameter("idList");
            Map<String, Object> map = this.serviceDocumentService.findDocListByIdList(this.getPortalContext(), idList);
            for (String key : map.keySet()) {
                if (key.equals("defIdList")) continue;
                ArrayList<ServiceDocument> scList = new ArrayList<ServiceDocument>();
                for (ServiceDocument sd : (List)map.get(key)) {
                    ServiceDocument newSd = new ServiceDocument();
                    BeanUtils.copyProperties((Object)((Object)newSd), (Object)((Object)sd));
                    newSd.setContent(null);
                    scList.add(newSd);
                }
                map.put(key, scList);
            }
            this.writeAjaxData(success, null, map);
        }
        catch (Exception ex) {
            localErr = this.handleErr(ex);
            success = false;
            this.writeAjaxData(success, localErr, null);
        }
    }

    public ServiceDocument getServiceDocument() {
        return this.serviceDocument;
    }

    public void setServiceDocument(ServiceDocument serviceDocument) {
        this.serviceDocument = serviceDocument;
    }
}

