/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.iservice.module.service.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.module.perm.entity.PermRefRes;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.portal.plt.iservice.common.enums.InsStateEnum;
import com.kingdee.portal.plt.iservice.common.enums.NodeTypeEnum;
import com.kingdee.portal.plt.iservice.common.enums.ServiceStateEnum;
import com.kingdee.portal.plt.iservice.common.enums.TreeSortTypeEnum;
import com.kingdee.portal.plt.iservice.common.exception.ServiceBizException;
import com.kingdee.portal.plt.iservice.common.exception.conf.ServiceErrConfig;
import com.kingdee.portal.plt.iservice.module.service.dao.ServiceDefinitionDAO;
import com.kingdee.portal.plt.iservice.module.service.dto.PersonalFavoriteDTO;
import com.kingdee.portal.plt.iservice.module.service.dto.ServiceTreeSortDTO;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDefinition;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceDocument;
import com.kingdee.portal.plt.iservice.module.service.entity.ServiceFavorite;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDefinitionService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceDocumentService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceFavoriteService;
import com.kingdee.portal.plt.iservice.module.service.service.ServiceInstanceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ServiceDefinitionServiceImpl
implements ServiceDefinitionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServiceDefinitionDAO serviceDefinitionDAO;
    private ServiceDocumentService serviceDocumentService;
    private ServiceInstanceService serviceInstanceService;
    private ServiceFavoriteService serviceFavoriteService;

    @Override
    public ServiceDefinition saveServiceDefinition(PortalContext portalContext, ServiceDefinition serviceDefinition, FileModel fileModel, boolean updateImg) throws ServiceBizException {
        try {
            if (StringUtil.isEmpty((String)serviceDefinition.getId())) {
                serviceDefinition.setId(UUID.randomUUID().toString());
                if (updateImg) {
                    ServiceDocument serviceDocument = this.serviceDocumentService.saveFlowchart(portalContext, serviceDefinition.getId(), fileModel);
                    serviceDefinition.setWorkflowImg(serviceDocument.getId());
                }
                ServiceDefinition parentServiceDef = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(serviceDefinition.getParentNodeId()));
                serviceDefinition.setParentNode(parentServiceDef);
                serviceDefinition.setPortalContext(portalContext);
                serviceDefinition.setDocCount(0);
                this.serviceDefinitionDAO.create((Object)serviceDefinition);
            } else {
                if (updateImg) {
                    ServiceDocument serviceDocument = this.serviceDocumentService.saveFlowchart(portalContext, serviceDefinition.getId(), fileModel);
                    serviceDefinition.setWorkflowImg(serviceDocument.getId());
                }
                serviceDefinition = this.updateServiceDefinition(portalContext, serviceDefinition);
            }
        }
        catch (Exception e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_SAVE_ERR, e);
        }
        return serviceDefinition;
    }

    @Override
    public void sortServiceNodeOrder(PortalContext portalContext, ServiceTreeSortDTO serviceTreeSortDTO) throws ServiceBizException {
        try {
            if (TreeSortTypeEnum.category2Category.equals((Object)serviceTreeSortDTO.getTreeSortType())) {
                this.updateChildsOrderNum(portalContext, serviceTreeSortDTO);
            } else if (TreeSortTypeEnum.leaf2Category.equals((Object)serviceTreeSortDTO.getTreeSortType())) {
                this.updateParentNode(portalContext, serviceTreeSortDTO);
                this.updateChildsOrderNum(portalContext, serviceTreeSortDTO);
            } else if (TreeSortTypeEnum.leaf2Leaf.equals((Object)serviceTreeSortDTO.getTreeSortType())) {
                this.updateParentNode(portalContext, serviceTreeSortDTO);
                this.updateChildsOrderNum(portalContext, serviceTreeSortDTO);
            }
        }
        catch (DataAccessException ex) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_SORT_NODE_ORDER, ex);
        }
    }

    @Override
    public void deleteServiceDefinitionById(PortalContext portalContext, String serviceDefId) throws ServiceBizException {
        try {
            ServiceDefinition serviceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(serviceDefId));
            if (serviceDefinition == null) {
                return;
            }
            int count = this.serviceInstanceService.getServRecTotalCountBySerDefId(portalContext, serviceDefId, InsStateEnum.RUNNING);
            if (count > 0) {
                throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_HAS_RUN_INS);
            }
            if (NodeTypeEnum.CATEGORY.equals((Object)serviceDefinition.getNodeType()) && this.serviceDefinitionDAO.hasExistedService(serviceDefId)) {
                DisplayName displayName = new DisplayName(serviceDefinition.getDisplayName(), portalContext.getLocale().toString());
                String _displayName = displayName.getLocaleText();
                HashMap<String, Object> errContext = new HashMap<String, Object>();
                errContext.put("serviceName", _displayName);
                throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_HAS_CHILD_SERVICE, errContext);
            }
            serviceDefinition.setState(ServiceStateEnum.DELETED);
            serviceDefinition.setPortalContext(portalContext);
            this.serviceDefinitionDAO.update((Object)serviceDefinition);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_DELETE_ERR, e);
        }
    }

    @Override
    public List<ServiceDefinition> findAllServiceCategory(PortalContext portalContext) throws ServiceBizException {
        List servDefList = null;
        try {
            ServiceDefinition serviceDefinition = new ServiceDefinition();
            serviceDefinition.setNodeType(NodeTypeEnum.CATEGORY);
            servDefList = this.serviceDefinitionDAO.findList((Object)serviceDefinition, new Filter[]{new FieldFilter("state", "=", (Object)ServiceStateEnum.ENABLE), new OrderFilter("nodeOrder", OrderEnum.ASC)});
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
        return servDefList;
    }

    @Override
    public List<ServiceDefinition> findServiceDefListByCategoryId(PortalContext portalContext, String categoryId) throws ServiceBizException {
        List servDefList = null;
        try {
            ServiceDefinition serviceDefinition = new ServiceDefinition();
            serviceDefinition.setParentNodeId(categoryId);
            servDefList = this.serviceDefinitionDAO.findList((Object)serviceDefinition, new Filter[]{new FieldFilter("state", "=", (Object)ServiceStateEnum.ENABLE), new OrderFilter("nodeOrder", OrderEnum.ASC)});
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
        return servDefList;
    }

    @Override
    public List<ServiceDefinition> findServiceList4Enable(PortalContext portalContext) throws ServiceBizException {
        List servDefList = null;
        try {
            servDefList = this.serviceDefinitionDAO.findList(new Filter[]{new FieldFilter("state", "=", (Object)ServiceStateEnum.ENABLE), new OrderFilter("nodeOrder", OrderEnum.ASC)});
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
        return servDefList;
    }

    @Override
    public List<ServiceDefinition> findServiceList4EnableAndDisable(PortalContext portalContext) throws ServiceBizException {
        List servDefList = null;
        try {
            servDefList = this.serviceDefinitionDAO.findList(new Filter[]{new FieldFilter("state", "!=", (Object)ServiceStateEnum.DELETED), new OrderFilter("nodeOrder", OrderEnum.ASC)});
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
        return servDefList;
    }

    @Override
    public ServiceDefinition findServiceDefinitionById(PortalContext portalContext, String defId) throws ServiceBizException {
        ServiceDefinition serviceDefinition = null;
        try {
            if (StringUtil.isEmpty((String)defId)) {
                this.logger.error("findServiceDefinitionById defId is null!!!");
                return null;
            }
            serviceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(defId));
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
        return serviceDefinition;
    }

    @Override
    public List<ServiceDefinition> findServiceList4Tree(PortalContext portalContext, String id) throws ServiceBizException {
        ArrayList<ServiceDefinition> servDefList = new ArrayList<ServiceDefinition>();
        try {
            ServiceDefinition serviceDefinition = null;
            if (StringUtil.isEmpty((String)id)) {
                serviceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findObject(new Filter[]{new FieldFilter("nodeType", "=", (Object)NodeTypeEnum.ROOT)}));
                servDefList.add(serviceDefinition);
                List childServDefList = this.serviceDefinitionDAO.findList(new Filter[]{new FieldFilter("parentNodeId", "=", (Object)serviceDefinition.getId()), new FieldFilter("state", "!=", (Object)ServiceStateEnum.DELETED), new OrderFilter("nodeOrder", OrderEnum.ASC)});
                servDefList.addAll(childServDefList);
                return servDefList;
            }
            serviceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(id));
            if (serviceDefinition.getNodeType().equals((Object)NodeTypeEnum.ROOT) || serviceDefinition.getNodeType().equals((Object)NodeTypeEnum.CATEGORY)) {
                List childServDefList = this.serviceDefinitionDAO.findList(new Filter[]{new FieldFilter("parentNodeId", "=", (Object)id), new FieldFilter("state", "!=", (Object)ServiceStateEnum.DELETED), new OrderFilter("nodeOrder", OrderEnum.ASC)});
                servDefList.addAll(childServDefList);
            } else {
                servDefList.add(serviceDefinition);
            }
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
        return servDefList;
    }

    @Override
    public void increaseServiceDocCount(PortalContext portalContext, String id) throws ServiceBizException {
        try {
            ServiceDefinition serviceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(id));
            if (serviceDefinition == null) {
                throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_NO_FIND_ERR);
            }
            if (serviceDefinition.getDocCount() <= 0) {
                serviceDefinition.setDocCount(1);
            } else {
                serviceDefinition.setDocCount(serviceDefinition.getDocCount() + 1);
            }
            this.serviceDefinitionDAO.update((Object)serviceDefinition);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_SAVE_ERR, e);
        }
    }

    @Override
    public void decreaseServiceDocCount(PortalContext portalContext, String id) throws ServiceBizException {
        try {
            ServiceDefinition serviceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(id));
            if (serviceDefinition == null) {
                throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_NO_FIND_ERR);
            }
            if (serviceDefinition.getDocCount() <= 0) {
                serviceDefinition.setDocCount(0);
            } else {
                serviceDefinition.setDocCount(serviceDefinition.getDocCount() - 1);
            }
            this.serviceDefinitionDAO.update((Object)serviceDefinition);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_SAVE_ERR, e);
        }
    }

    private void updateParentNode(PortalContext portalContext, ServiceTreeSortDTO serviceTreeSortDTO) throws DataAccessException {
        String targetNodePid = serviceTreeSortDTO.getTargetNodePid();
        ServiceDefinition parentServiceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(targetNodePid));
        String currentNodeId = serviceTreeSortDTO.getNodeId();
        ServiceDefinition currentServiceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(currentNodeId));
        currentServiceDefinition.setParentNode(parentServiceDefinition);
        currentServiceDefinition.setPortalContext(portalContext);
        this.serviceDefinitionDAO.update((Object)currentServiceDefinition);
    }

    private void updateChildsOrderNum(PortalContext portalContext, ServiceTreeSortDTO serviceTreeSortDTO) throws DataAccessException {
        String[] nodeIds = serviceTreeSortDTO.getNodeIds().split(",");
        if (nodeIds != null) {
            for (int i = 0; i < nodeIds.length; ++i) {
                String nodeId = nodeIds[i];
                if (StringUtil.isEmpty((String)nodeId)) continue;
                ServiceDefinition serviceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(nodeId));
                serviceDefinition.setNodeOrder(i + 1);
                this.serviceDefinitionDAO.update((Object)serviceDefinition);
            }
        }
    }

    private ServiceDefinition updateServiceDefinition(PortalContext portalContext, ServiceDefinition serviceDefinition) throws Exception {
        ServiceDefinition serviceDefinition4DB = (ServiceDefinition)((Object)this.serviceDefinitionDAO.findById(serviceDefinition.getId()));
        if (serviceDefinition4DB == null) {
            HashMap<String, Object> contextParams = new HashMap<String, Object>();
            contextParams.put("defId", serviceDefinition.getId());
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, contextParams);
        }
        if (!NodeTypeEnum.ROOT.equals((Object)serviceDefinition4DB.getNodeType())) {
            if (NodeTypeEnum.CATEGORY.equals((Object)serviceDefinition4DB.getNodeType())) {
                serviceDefinition4DB.setDisplayName(serviceDefinition.getDisplayName());
                serviceDefinition4DB.setDescription(serviceDefinition.getDescription());
                serviceDefinition4DB.setState(serviceDefinition.getState());
                this.updateChildNodeState(portalContext, serviceDefinition.getId(), serviceDefinition.getState());
            } else {
                serviceDefinition4DB.setDisplayName(serviceDefinition.getDisplayName());
                serviceDefinition4DB.setDescription(serviceDefinition.getDescription());
                serviceDefinition4DB.setState(serviceDefinition.getState());
                serviceDefinition4DB.setServiceType(serviceDefinition.getServiceType());
                serviceDefinition4DB.setDefParam(serviceDefinition.getDefParam());
                serviceDefinition4DB.setServiceStandard(serviceDefinition.getServiceStandard());
                serviceDefinition4DB.setDeptId(serviceDefinition.getDeptId());
                serviceDefinition4DB.setDeptDisplayName(serviceDefinition.getDeptDisplayName());
                serviceDefinition4DB.setServiceObject(serviceDefinition.getServiceObject());
                serviceDefinition4DB.setServiceLocation(serviceDefinition.getServiceLocation());
                serviceDefinition4DB.setIcon(serviceDefinition.getIcon());
                serviceDefinition4DB.setManagerId(serviceDefinition.getManagerId());
                serviceDefinition4DB.setManagerDisplayName(serviceDefinition.getManagerDisplayName());
                serviceDefinition4DB.setTel(serviceDefinition.getTel());
                serviceDefinition4DB.setEmail(serviceDefinition.getEmail());
                serviceDefinition4DB.setIntro(serviceDefinition.getIntro());
                serviceDefinition4DB.setOpenType(serviceDefinition.getOpenType());
                serviceDefinition4DB.setWorkflowImg(serviceDefinition.getWorkflowImg());
                serviceDefinition4DB.setPermViewCtrl(serviceDefinition.getPermViewCtrl());
                serviceDefinition4DB.setExternalId(serviceDefinition.getExternalId());
                serviceDefinition4DB.setNodeType(serviceDefinition.getNodeType());
            }
        }
        serviceDefinition4DB.setPortalContext(portalContext);
        serviceDefinition = (ServiceDefinition)((Object)this.serviceDefinitionDAO.update((Object)serviceDefinition4DB));
        return serviceDefinition;
    }

    private void updateChildNodeState(PortalContext portalContext, String pNodeId, ServiceStateEnum serviceState) throws DataAccessException {
        this.serviceDefinitionDAO.updateChildState(pNodeId, serviceState);
    }

    @Override
    public Map<String, Object> findAllEnableMyService(PortalContext portalContext, Map<String, Object> permMap) throws ServiceBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<PersonalFavoriteDTO> dtoList = new ArrayList<PersonalFavoriteDTO>();
        try {
            List serList = this.serviceDefinitionDAO.findList(new Filter[]{new FieldFilter("state", "=", (Object)ServiceStateEnum.ENABLE), new OrderFilter("nodeOrder", OrderEnum.ASC)});
            List<ServiceDefinition> servDefList = this.selectPermServiceList(portalContext, serList, permMap);
            List<ServiceFavorite> favList = this.serviceFavoriteService.findFavList(portalContext);
            HashMap<String, ServiceFavorite> favMap = new HashMap<String, ServiceFavorite>();
            for (ServiceFavorite fav : favList) {
                favMap.put(fav.getServiceDefId(), fav);
            }
            if (servDefList != null) {
                ArrayList<ServiceDefinition> firstLevelPages = new ArrayList<ServiceDefinition>();
                HashMap multiTreeNodes = new HashMap();
                for (ServiceDefinition sd : servDefList) {
                    if (!NodeTypeEnum.CATEGORY.equals((Object)sd.getNodeType())) continue;
                    ArrayList<ServiceDefinition> tempList = new ArrayList<ServiceDefinition>();
                    for (ServiceDefinition temp : servDefList) {
                        if (!sd.getId().equals(temp.getParentNodeId())) continue;
                        if (favMap.containsKey(temp.getId())) {
                            PersonalFavoriteDTO dto = new PersonalFavoriteDTO((ServiceFavorite)((Object)favMap.get(temp.getId())), temp.getDisplayName());
                            dto.setDefinition(temp);
                            dtoList.add(dto);
                            temp.setFavFlag(true);
                        } else {
                            temp.setFavFlag(false);
                        }
                        tempList.add(temp);
                    }
                    if (tempList.size() <= 0) continue;
                    firstLevelPages.add(sd);
                    multiTreeNodes.put(sd.getId(), tempList);
                }
                resultMap.put("firstLevelPages", firstLevelPages);
                resultMap.put("multiTreeNodes", multiTreeNodes);
                resultMap.put("favList", dtoList);
            }
        }
        catch (Exception e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
        return resultMap;
    }

    @Override
    public List<ServiceDefinition> selectPermServiceList(PortalContext ctx, List<ServiceDefinition> serList, Map<String, Object> permMap) throws ServiceBizException {
        ArrayList<ServiceDefinition> newList = new ArrayList<ServiceDefinition>();
        List permList = PortalCache.getPortalPagePerm((PortalContext)ctx);
        Map easLinkList = PortalCache.getEasWebListPerm((PortalContext)ctx);
        Map oaLinkList = PortalCache.getOADynamicListPerm((PortalContext)ctx);
        Map guiList = PortalCache.getGUIListPerm((PortalContext)ctx);
        for (ServiceDefinition sd : serList) {
            Object newSd;
            if (sd.getNodeType().equals((Object)NodeTypeEnum.CATEGORY)) {
                newList.add(sd);
                continue;
            }
            if (!sd.getNodeType().equals((Object)NodeTypeEnum.URL) && StringUtil.isEmpty((String)sd.getExternalId())) {
                ServiceDefinition newSd2 = this.copyServiceDefinition(sd, true);
                newList.add(newSd2);
            }
            boolean result = false;
            if (sd.getNodeType().equals((Object)NodeTypeEnum.EAS_WEB_BILL)) {
                if (easLinkList.get(sd.getExternalId()) == null) continue;
                newSd = this.copyServiceDefinition(sd, true);
                newList.add((ServiceDefinition)((Object)newSd));
                continue;
            }
            if (sd.getNodeType().equals((Object)NodeTypeEnum.EAS_GUI_BILL)) {
                if (guiList.get(sd.getExternalId()) == null) continue;
                newSd = this.copyServiceDefinition(sd, true);
                newList.add((ServiceDefinition)((Object)newSd));
                continue;
            }
            if (sd.getNodeType().equals((Object)NodeTypeEnum.OA_WEB_BILL)) {
                if (oaLinkList.get(sd.getExternalId()) == null) continue;
                newSd = this.copyServiceDefinition(sd, true);
                newList.add((ServiceDefinition)((Object)newSd));
                continue;
            }
            for (PermRefRes ref : permList) {
                if (!sd.getId().equals(ref.getResId())) continue;
                ServiceDefinition newSd3 = this.copyServiceDefinition(sd, true);
                newList.add(newSd3);
                result = true;
                break;
            }
            if (result || sd.getPermViewCtrl() == null || sd.getPermViewCtrl().booleanValue()) continue;
            newSd = this.copyServiceDefinition(sd, true);
            newList.add((ServiceDefinition)((Object)newSd));
        }
        return newList;
    }

    private ServiceDefinition copyServiceDefinition(ServiceDefinition oldSd, boolean viewCtrl) {
        ServiceDefinition sd = new ServiceDefinition();
        sd.setDefParam(oldSd.getDefParam());
        sd.setDeptDisplayName(oldSd.getDeptDisplayName());
        sd.setDeptId(oldSd.getDeptId());
        sd.setDescription(oldSd.getDescription());
        sd.setDisplayName(oldSd.getDisplayName());
        sd.setDocCount(oldSd.getDocCount());
        sd.setEmail(oldSd.getEmail());
        sd.setExternalId(oldSd.getExternalId());
        sd.setFavFlag(oldSd.getFavFlag());
        sd.setHidden(oldSd.getHidden());
        sd.setIcon(oldSd.getIcon());
        sd.setId(oldSd.getId());
        sd.setIntro(oldSd.getIntro());
        sd.setManagerDisplayName(oldSd.getManagerDisplayName());
        sd.setManagerId(oldSd.getManagerId());
        sd.setNodeLevel(oldSd.getNodeLevel());
        sd.setNodePath(oldSd.getNodePath());
        sd.setNodeOrder(oldSd.getNodeOrder());
        sd.setNodeType(oldSd.getNodeType());
        sd.setOpenType(oldSd.getOpenType());
        sd.setParentNodeId(oldSd.getParentNodeId());
        sd.setPermViewCtrl(viewCtrl);
        sd.setServiceLocation(oldSd.getServiceLocation());
        sd.setServiceObject(oldSd.getServiceObject());
        sd.setServiceScore(oldSd.getServiceScore());
        sd.setServiceStandard(oldSd.getServiceStandard());
        sd.setServiceType(oldSd.getServiceType());
        sd.setState(oldSd.getState());
        sd.setTel(oldSd.getTel());
        sd.setWorkflowImg(oldSd.getWorkflowImg());
        return sd;
    }

    @Override
    public float findServiceTotalScore(PortalContext ctx) throws ServiceBizException {
        try {
            float totalScore = 0.0f;
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            String sql = "SELECT avg(fserviceScore) fserviceScore FROM T_JP_ServiceDefinition";
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)sql);
            if (rs != null) {
                while (rs.next()) {
                    String score = rs.getString("fserviceScore");
                    if (score == null) continue;
                    totalScore = rs.getFloat("fserviceScore");
                }
            }
            return totalScore;
        }
        catch (Exception e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
    }

    @Override
    public void updateServiceScore(PortalContext ctx, String defId) throws ServiceBizException {
        try {
            this.serviceDefinitionDAO.updateServiceScore(ctx, defId);
        }
        catch (DataAccessException e) {
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
    }

    @Override
    public IRowSet findPresetFavPageList(PortalContext ctx, String presetId) throws ServiceBizException {
        try {
            return this.serviceDefinitionDAO.findPresetFavPageList(ctx, presetId);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new ServiceBizException(ServiceErrConfig.ISERVICE_DEF_FIND_ERR, e);
        }
    }

    public ServiceDefinitionDAO getServiceDefinitionDAO() {
        return this.serviceDefinitionDAO;
    }

    public void setServiceDefinitionDAO(ServiceDefinitionDAO serviceDefinitionDAO) {
        this.serviceDefinitionDAO = serviceDefinitionDAO;
    }

    public ServiceDocumentService getServiceDocumentService() {
        return this.serviceDocumentService;
    }

    public void setServiceDocumentService(ServiceDocumentService serviceDocumentService) {
        this.serviceDocumentService = serviceDocumentService;
    }

    public ServiceInstanceService getServiceInstanceService() {
        return this.serviceInstanceService;
    }

    public void setServiceInstanceService(ServiceInstanceService serviceInstanceService) {
        this.serviceInstanceService = serviceInstanceService;
    }

    public void setServiceFavoriteService(ServiceFavoriteService serviceFavoriteService) {
        this.serviceFavoriteService = serviceFavoriteService;
    }
}

