/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.mrm.module.query.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.waf.ctx.WafContext;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.config.BOTProcessSubItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BOTPHelper {
    private Context ctx;
    private String dstBosType;
    private String srcBosType;
    private boolean isShowList = false;
    private boolean isWebForm = false;
    private String ruleId;

    public void setWebForm(boolean isWebForm) {
        this.isWebForm = isWebForm;
    }

    public String getSrcBosType() {
        return this.srcBosType;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public BOTPHelper(Context ctx, String srcBosType, String dstBosType, String ruleId) {
        this.ctx = ctx;
        this.srcBosType = srcBosType;
        this.dstBosType = dstBosType;
        if (ruleId != null) {
            ruleId = ruleId.replaceAll(" ", "+");
        }
        this.ruleId = ruleId;
    }

    public BOTPHelper(Context ctx, String bosType) {
        this.ctx = ctx;
        this.dstBosType = bosType;
    }

    public BOTPHelper(String bosType) {
        this.dstBosType = bosType;
    }

    public String[][] getSourceBosTypes() throws BOTPException, BOSException, BTPException {
        IBOTMapping iBOTMapping = (IBOTMapping)BusinessProcessUtil.getBizInterface((Context)this.ctx, BOTMappingFactory.class);
        String srcBillBosTypeAndAlias = iBOTMapping.getSourceBillTypeListAndAlias(this.dstBosType);
        String[] srcBillBosTypeAndAliasArray = StringUtil.split((String)srcBillBosTypeAndAlias, (String)"|");
        if (srcBillBosTypeAndAliasArray.length != 2) {
            throw new BTPException(BTPException.MAPPINGINFONULLERROR);
        }
        String[] srcBillBosTypeArray = StringUtil.split((String)srcBillBosTypeAndAliasArray[0], (String)",");
        String[] srcBillAliasArray = StringUtil.split((String)srcBillBosTypeAndAliasArray[1], (String)",");
        int length = srcBillBosTypeArray.length;
        String[][] sourceBosTypes = new String[2][length];
        System.arraycopy(srcBillBosTypeArray, 0, sourceBosTypes[0], 0, length);
        System.arraycopy(srcBillAliasArray, 0, sourceBosTypes[1], 0, length);
        return sourceBosTypes;
    }

    public String[][] getDestinationBosTypes() throws BOSException, BOTPException, BTPException {
        IBOTMapping iBOTMapping = (IBOTMapping)BusinessProcessUtil.getBizInterface((Context)this.ctx, BOTMappingFactory.class);
        String targetTypeAndAliasString = iBOTMapping.getTargetBillTypeList(this.srcBosType);
        String[] targetTypeAndAlias = StringUtil.split((String)targetTypeAndAliasString, (String)"|");
        if (targetTypeAndAlias.length != 2) {
            throw new BTPException(BTPException.MAPPINGINFONULLERROR);
        }
        String targetBillTypeString = targetTypeAndAlias[0];
        String targetAliasString = targetTypeAndAlias[1];
        String[] targetAlias = StringUtil.split((String)targetAliasString, (String)",");
        String[] targetBillType = StringUtil.split((String)targetBillTypeString, (String)",");
        int length = targetAlias.length;
        String[][] dstBosTypes = new String[2][length];
        System.arraycopy(targetBillType, 0, dstBosTypes[0], 0, length);
        System.arraycopy(targetAlias, 0, dstBosTypes[1], 0, length);
        return dstBosTypes;
    }

    public BOTMappingCollection getMappingCollectionForSelectWithoutData(String srcBosType, Map transmitCtx) throws BOSException, BOTPException {
        IBOTMapping iBOTMapping = (IBOTMapping)BusinessProcessUtil.getBizInterface((Context)this.ctx, BOTMappingFactory.class);
        return iBOTMapping.getMappingCollectionForSelectWithoutData(srcBosType, this.dstBosType, transmitCtx);
    }

    public BOTMappingCollection getMappingCollectionForSelect(String dstBosType) throws BOTPException, BOSException {
        IBOTMapping iBOTMapping = (IBOTMapping)BusinessProcessUtil.getBizInterface((Context)this.ctx, BOTMappingFactory.class);
        return iBOTMapping.getMappingCollectionForSelect(this.srcBosType, dstBosType, DefineSysEnum.BTP);
    }

    public BTPTransformResult transformTo(String[] selectedBillIds) throws EASBizException, BOSException {
        if (selectedBillIds == null || selectedBillIds.length == 0) {
            return null;
        }
        if (this.ruleId != null) {
            this.ruleId = this.ruleId.replaceAll(" ", "+");
        }
        ObjectStringPK botMappingId = new ObjectStringPK(this.ruleId);
        IBOTMapping iBOTMapping = (IBOTMapping)BusinessProcessUtil.getBizInterface((Context)this.ctx, BOTMappingFactory.class);
        BOTMappingInfo mappingInfo = iBOTMapping.getMappingInfoByPK((IObjectPK)botMappingId);
        BOTProcessSubItem subItem = BOTProcessSubItem.defineBOTSubItem((String)this.srcBosType, (String)this.dstBosType, (String)"1", (String)this.ruleId);
        BatchActionResults batchResults = DynamicBusinessProcessHelper.batchHandle((Context)this.ctx, (String)this.srcBosType, (IBusinessBatchHandle)subItem, (Object[])selectedBillIds);
        BTPTransformResult btpResult = batchResults.getTransformResult("1");
        IObjectCollection destBillCols = null;
        if (btpResult != null) {
            destBillCols = btpResult.getBills();
        }
        if (destBillCols == null || destBillCols.size() == 0) {
            return null;
        }
        if (this.isWebForm || this.isShowList || destBillCols.size() > 1) {
            IBTPManager iBTPManager = (IBTPManager)BusinessProcessUtil.getBizInterface((Context)this.ctx, BTPManagerFactory.class);
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
                if (mappingInfo.getIsTempSave() == 1) {
                    iBTPManager.saveRelations(destBillInfo, botRelationCols);
                    continue;
                }
                if (mappingInfo.getIsTempSave() != 0) continue;
                iBTPManager.submitRelations(destBillInfo, botRelationCols);
            }
        }
        return btpResult;
    }

    public static void acceptMapping(String[] selectedBillIds, BOTMappingInfo mappingInfo, String bosType) throws BOSException, BOTPException {
        boolean hasEntryFilter = false;
        EntityViewInfo evi = BOTPHelper.getBOTMappingFilter(mappingInfo);
        evi.getSelector().add("id");
        FilterInfo filterInfo = evi.getFilter();
        if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
            int count = evi.getEntryFilters().size();
            for (int i = 0; i < count; ++i) {
                FilterInfo entryFilter = evi.getEntryFilters().get(i);
                String entryName = entryFilter.getEntryName();
                evi.getSelector().add(entryName + ".id");
            }
        }
        if (!(filterInfo != null && filterInfo.getFilterItems().size() != 0 || evi.getEntryFilters() != null && evi.getEntryFilters().size() != 0)) {
            return;
        }
        ArrayList<String> billIdList = new ArrayList<String>();
        int count = selectedBillIds.length;
        for (int i = 0; i < count; ++i) {
            billIdList.add(selectedBillIds[i]);
        }
        FilterInfo newHeadFilterInfo = BOTPHelper.mergeFilterWithIdList(billIdList, filterInfo);
        if (filterInfo == null) {
            filterInfo = newHeadFilterInfo;
            evi.setFilter(newHeadFilterInfo);
        }
        ArrayList errorBillCollection = new ArrayList();
        IDynamicObject iDynObj2 = DynamicObjectFactory.getLocalInstance((Context)WafContext.getInstance().getContext());
        IObjectCollection filteredCols = iDynObj2.getCollection(BOSObjectType.create((String)bosType), evi);
        ArrayList<String> filteredIdList = new ArrayList<String>();
        int count2 = filteredCols.size();
        for (int i = 0; i < count2; ++i) {
            IObjectValue filteredInfo = filteredCols.getObject(i);
            boolean flag = true;
            if (hasEntryFilter) {
                int es = evi.getEntryFilters().size();
                for (int e = 0; e < es; ++e) {
                    FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                    String entryName = entryFilterInfo.getEntryName();
                    if (filteredInfo.get(entryName) != null && filteredInfo.get(entryName) instanceof IObjectCollection && ((IObjectCollection)filteredInfo.get(entryName)).size() > 0) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                filteredIdList.add(filteredInfo.get("id").toString());
                continue;
            }
            filteredIdList.add(filteredInfo.get("id").toString());
        }
        HashMap pkListMap = new HashMap();
        for (int i = 0; i < filteredIdList.size(); ++i) {
            pkListMap.put(filteredIdList.get(i), null);
        }
    }

    public static EntityViewInfo getBOTMappingFilter(BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo entityViewInfo;
        if (StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter())) {
            entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            entityViewInfo.setFilter(filterInfo);
        } else {
            try {
                entityViewInfo = new EntityViewInfo(mappingInfo.getExtRule().getFilter());
            }
            catch (Exception exc) {
                throw new BOSException(exc.getMessage(), (Throwable)exc);
            }
        }
        return entityViewInfo;
    }

    private static FilterInfo mergeFilterWithIdList(List idList, FilterInfo filterInfo) {
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            Iterator iterFilter = filterInfo.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            filterInfo.setMaskString(sbMaskString.toString());
        }
        StringBuffer sbNewMaskString = new StringBuffer();
        index = 0;
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        sbNewMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            filterInfo.setMaskString(sbNewMaskString.toString());
        } else {
            filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") and (" + sbNewMaskString.toString() + ")");
        }
        return filterInfo;
    }

    public void setShowList(boolean isShowList) {
        this.isShowList = isShowList;
    }

    public BOTMappingInfo getMappingInfoByPK(String botMappingId) throws BOSException {
        IBOTMapping iBOTMapping = (IBOTMapping)BusinessProcessUtil.getBizInterface((Context)this.ctx, BOTMappingFactory.class);
        return iBOTMapping.getMappingInfoByPK((IObjectPK)new ObjectStringPK(botMappingId));
    }
}

