/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.mrm.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.mrm.IMRAdmin;
import com.kingdee.eas.cp.mrm.MRAdminCollection;
import com.kingdee.eas.cp.mrm.MRAdminFactory;
import com.kingdee.eas.cp.mrm.MRAdminInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.mrm.module.setting.dto.MeetingAdminDTO;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class MeetingAdminAction
extends BaseAction {
    private static final long serialVersionUID = 923182381085413782L;

    public void loadMeetingAdminList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MRAdminQuery");
        try {
            String meetingadminName = this.getRequest().getParameter("adminName");
            String nameSql = "";
            if (meetingadminName != null && !meetingadminName.equals("")) {
                nameSql = "mrApplyAdmin.name like '%" + meetingadminName + "%' and ";
            }
            entityViewInfo.setFilter(nameSql + "cu.id='" + cuId + "'");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("cu.id"));
            sic.add(new SelectorItemInfo("mrApplyAdmin.name"));
            entityViewInfo.setSelector(sic);
            IQueryExecutor exec = null;
            IRowSet rowSet = null;
            IRowSet countRowSet = null;
            int total = 0;
            int totalPage = 0;
            int pageNo = 0;
            int pageSize = 10;
            pageNo = this.pagingParam.getPageNo();
            pageSize = this.pagingParam.getPageSize();
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            ArrayList<MeetingAdminDTO> list = new ArrayList<MeetingAdminDTO>();
            if (total > 0) {
                this.logger.debug("executor search content sql is:" + exec.getSQL());
                rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
                if (rowSet != null) {
                    while (rowSet.next()) {
                        MeetingAdminDTO meetingAdminDTO = new MeetingAdminDTO();
                        meetingAdminDTO.setId(rowSet.getString("id"));
                        meetingAdminDTO.setName(rowSet.getString("mrApplyAdmin.name"));
                        meetingAdminDTO.setCUId(rowSet.getString("cu.id"));
                        list.add(meetingAdminDTO);
                    }
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveMeetingAdmin() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        String result = "";
        String id = request.getParameter("id");
        String adminId = request.getParameter("adminId");
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        MRAdminInfo info = new MRAdminInfo();
        try {
            IMRAdmin mrAdmin = MRAdminFactory.getLocalInstance((Context)ctx);
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
            filterInfo.getFilterItems().add(new FilterItemInfo("mrApplyAdmin.id", (Object)adminId));
            entityViewInfo.setFilter(filterInfo);
            MRAdminCollection collection = mrAdmin.getMRAdminCollection(entityViewInfo);
            if (collection.size() > 0 && !collection.get(0).getId().equals((Object)info.getId())) {
                result = "\u8be5\u4eba\u5458\u5df2\u662f\u4f1a\u8bae\u5ba4\u7ba1\u7406\u5458\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0";
            } else {
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)adminId));
                info.setMrApplyAdmin(personInfo);
                if (StringUtils.isEmpty((String)id)) {
                    String newId = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                    info.setNumber(newId);
                    mrAdmin.addnew((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newId)), (CoreBaseInfo)info);
                    success = true;
                    result = newId;
                } else {
                    info.setId(BOSUuid.read((String)id));
                    mrAdmin.save((CoreBaseInfo)info);
                    success = true;
                    result = id;
                }
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void deleteMeetingAdmin() {
        HttpServletRequest request = this.getRequest();
        String ids = request.getParameter("ids");
        LocalErr localErr = null;
        boolean succ = false;
        String result = "";
        if (StringUtils.isNotBlank((String)ids)) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String[] idArr = ids.split(",");
            ObjectUuidPK[] pkArr = new ObjectUuidPK[idArr.length];
            int j = idArr.length;
            for (int i = 0; i < j; ++i) {
                pkArr[i] = new ObjectUuidPK(BOSUuid.read((String)idArr[i]));
            }
            try {
                IMRAdmin mrAdmin = MRAdminFactory.getLocalInstance((Context)ctx);
                mrAdmin.delete((IObjectPK[])pkArr);
                succ = true;
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                result = "-1";
                e.printStackTrace();
            }
            catch (EASBizException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                result = "-1";
                e.printStackTrace();
            }
        }
        this.writeAjaxData(succ, localErr, result);
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

