/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.mrm.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.mrm.EnableStateEnum;
import com.kingdee.eas.cp.mrm.IMeetingType;
import com.kingdee.eas.cp.mrm.MeetingTypeCollection;
import com.kingdee.eas.cp.mrm.MeetingTypeFactory;
import com.kingdee.eas.cp.mrm.MeetingTypeInfo;
import com.kingdee.eas.cp.mrm.app.MRProcessService;
import com.kingdee.eas.cp.mrm.app.ProcessInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.plt.mrm.module.setting.dto.MeetingTypeDTO;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class MeetingTypeAction
extends BaseAction {
    private static final long serialVersionUID = -12939016387390971L;

    public void loadMeetingTypeList() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.mrm.app.MeetingTypeQuery");
        try {
            String meetingtypeName = this.getRequest().getParameter("meetingtypeName");
            String nameSql = "";
            if (meetingtypeName != null && !meetingtypeName.equals("")) {
                nameSql = "name like '%" + meetingtypeName + "%' and ";
            }
            entityViewInfo.setFilter(nameSql + "cu.id='" + cuId + "'");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("enableState"));
            sic.add(new SelectorItemInfo("summaryProcess"));
            sic.add(new SelectorItemInfo("cu.id"));
            entityViewInfo.setSelector(sic);
            IQueryExecutor exec = null;
            IRowSet rowSet = null;
            IRowSet countRowSet = null;
            int total = 0;
            int totalPage = 0;
            int pageNo = 0;
            int pageSize = 10;
            pageNo = this.pagingParam.getPageNo();
            pageSize = this.pagingParam.getPageSize();
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            this.logger.debug("executor search content count sql is:" + exec.getSQL());
            countRowSet = exec.executeQuery();
            while (countRowSet.next()) {
                this.logger.debug("record total is" + ++total);
            }
            totalPage = (total - 1) / pageSize + 1;
            this.logger.debug("total page is:" + totalPage);
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            ArrayList<MeetingTypeDTO> list = new ArrayList<MeetingTypeDTO>();
            if (total > 0) {
                this.logger.debug("executor search content sql is:" + exec.getSQL());
                rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
                if (rowSet != null) {
                    while (rowSet.next()) {
                        MeetingTypeDTO meetingTypeDTO = new MeetingTypeDTO();
                        meetingTypeDTO.setId(rowSet.getString("id"));
                        meetingTypeDTO.setName(rowSet.getString("Name"));
                        meetingTypeDTO.setEnableState(rowSet.getString("enableState"));
                        meetingTypeDTO.setControlUnitId(rowSet.getString("cu.id"));
                        String summaryProcessId = rowSet.getString("summaryProcess");
                        meetingTypeDTO.setSummaryProcessId(summaryProcessId);
                        ProcessInfo[] processes = this.getSummaryProcess(ctx);
                        if (processes != null && processes.length > 0) {
                            for (ProcessInfo processInfo : processes) {
                                if (!processInfo.getId().equals(summaryProcessId)) continue;
                                meetingTypeDTO.setSummaryProcessName(processInfo.getName());
                                break;
                            }
                        }
                        list.add(meetingTypeDTO);
                    }
                }
            }
            PagingResult pagingResult = new PagingResult();
            pagingResult.setPagingParam(this.pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
            this.writePagingResult(pagingResult);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initMeetingTypeData() {
        HttpServletRequest request = this.getRequest();
        String id = request.getParameter("id");
        LocalErr localErr = null;
        boolean success = true;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            IMeetingType meetingType;
            MeetingTypeInfo info;
            if (StringUtils.isNotBlank((String)id) && (info = (meetingType = MeetingTypeFactory.getLocalInstance((Context)ctx)).getMeetingTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)))) != null) {
                result.put("id", info.getId());
                result.put("name", info.getName());
                result.put("summaryProcessId", info.getSummaryProcess());
            }
            ProcessInfo[] processes = this.getSummaryProcess(ctx);
            result.put("processes", processes);
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void saveMeetingType() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean success = false;
        String result = "";
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        String summaryProcess = request.getParameter("summaryprocess");
        MeetingTypeInfo info = new MeetingTypeInfo();
        try {
            IMeetingType meetingType = MeetingTypeFactory.getLocalInstance((Context)ctx);
            info.setName(name);
            info.setSummaryProcess(summaryProcess);
            info.setEnableState(EnableStateEnum.ENABLE_STATE);
            if (StringUtils.isEmpty((String)id)) {
                String newId = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                info.setNumber(newId);
                meetingType.addnew((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)newId)), (CoreBaseInfo)info);
                success = true;
                result = newId;
            } else {
                info.setId(BOSUuid.read((String)id));
                meetingType.save((CoreBaseInfo)info);
                success = true;
                result = id;
            }
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        catch (EASBizException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    public void deleteMeetingType() {
        HttpServletRequest request = this.getRequest();
        String ids = request.getParameter("ids");
        LocalErr localErr = null;
        boolean succ = false;
        String result = "";
        if (StringUtils.isNotBlank((String)ids)) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String[] idArr = ids.split(",");
            ObjectUuidPK[] pkArr = new ObjectUuidPK[idArr.length];
            StringBuffer sbIds = new StringBuffer(200);
            int j = idArr.length;
            for (int i = 0; i < j; ++i) {
                sbIds.append("'").append(idArr[i]).append("'");
                if (i < j - 1) {
                    sbIds.append(",");
                }
                pkArr[i] = new ObjectUuidPK(BOSUuid.read((String)idArr[i]));
            }
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select * from T_MRM_MRApply where FMrTypeID in (" + sbIds.toString() + ")"));
                if (rs != null && rs.next()) {
                    localErr = new LocalErr();
                    localErr.setDesc("\u5df2\u5173\u8054\u4f1a\u8bae\u7684\u4f1a\u8bae\u7c7b\u578b\u4e0d\u5f97\u5220\u9664\uff01");
                    succ = false;
                    result = "\u5df2\u5173\u8054\u4f1a\u8bae\u7684\u4f1a\u8bae\u7c7b\u578b\u4e0d\u5f97\u5220\u9664\uff01";
                } else {
                    IMeetingType meetingType = MeetingTypeFactory.getLocalInstance((Context)ctx);
                    meetingType.delete((IObjectPK[])pkArr);
                    succ = true;
                }
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                result = "-1";
                e.printStackTrace();
            }
            catch (EASBizException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                result = "-1";
                e.printStackTrace();
            }
            catch (SQLException e) {
                localErr = this.handleErr(e);
                succ = false;
                result = "-1";
                e.printStackTrace();
            }
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void setMeetingTypeState() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        LocalErr localErr = null;
        boolean succ = false;
        String result = "";
        String ids = request.getParameter("ids");
        String status = request.getParameter("status");
        if (StringUtils.isNotBlank((String)ids) && (status.equals(String.valueOf(0)) || status.equals(String.valueOf(1)))) {
            try {
                String[] idArr = ids.split(",");
                StringBuffer sbIds = new StringBuffer(100);
                for (String id : idArr) {
                    sbIds.append("'").append(id).append("'").append(",");
                }
                DbUtil.execute((Context)ctx, (String)("UPDATE T_MRM_MeetingType SET FEnableState = '" + status + "'" + " WHERE FID IN (" + sbIds.substring(0, sbIds.length() - 1).toString() + ")"));
                succ = true;
                result = "1";
            }
            catch (BOSException e) {
                localErr = this.handleErr((Exception)((Object)e));
                succ = false;
                e.printStackTrace();
            }
        }
        this.writeAjaxData(succ, localErr, result);
    }

    public void checkMeetingTypeName() {
        HttpServletRequest request = this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        boolean success = false;
        LocalErr localErr = null;
        int result = 0;
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)name));
        if (StringUtils.isNotBlank((String)id)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        try {
            IMeetingType meetingType = MeetingTypeFactory.getLocalInstance((Context)ctx);
            MeetingTypeCollection collection = meetingType.getMeetingTypeCollection(entityViewInfo);
            if (collection.size() > 0 && !collection.get(0).getId().equals((Object)id)) {
                localErr = new LocalErr();
                localErr.setDesc("\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u4f1a\u8bae\u7c7b\u578b");
                result = 1;
            }
            success = true;
        }
        catch (BOSException e) {
            localErr = this.handleErr((Exception)((Object)e));
            success = false;
            e.printStackTrace();
        }
        this.writeAjaxData(success, localErr, result);
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private ProcessInfo[] getSummaryProcess(Context ctx) throws WfException, BOSException {
        ProcessInfo[] processes = MRProcessService.getSummaryProcessInfo((Context)ctx);
        return processes;
    }
}

