/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.plt.mrm.module.setting.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.app.service.FunctionPermissionService;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.plt.mrm.module.query.util.MeetingUtil;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;

public class SettingAction
extends BaseAction {
    private static final long serialVersionUID = 8425993093292651660L;

    public String cpMeetingManager() {
        HttpServletRequest request = this.getRequest();
        request.setAttribute("uid", (Object)UUID.randomUUID().toString());
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        try {
            if (person != null) {
                boolean isAdmin = MeetingUtil.isMRAdmin(ctx, person);
                request.setAttribute("isAdmin", (Object)isAdmin);
            }
            boolean meetingTypeDelete = this.hasFunctionPermission(null, "cp_mrm_MeetingType_Delete");
            boolean meetingTypeUpdate = this.hasFunctionPermission(null, "cp_mrm_MeetingType_Update");
            request.setAttribute("meetingTypeDelete", (Object)meetingTypeDelete);
            request.setAttribute("meetingTypeUpdate", (Object)meetingTypeUpdate);
            boolean meetingRoomDelete = this.hasFunctionPermission(null, "cp_mrm_MeetingRoom_Delete");
            boolean meetingRoomUpdate = this.hasFunctionPermission(null, "cp_mrm_MeetingRoom_Update");
            boolean meetingRoomShare = this.hasFunctionPermission(null, "cp_mrm_MeetingRoom_Share");
            request.setAttribute("meetingRoomDelete", (Object)meetingRoomDelete);
            request.setAttribute("meetingRoomUpdate", (Object)meetingRoomUpdate);
            request.setAttribute("meetingRoomShare", (Object)meetingRoomShare);
            boolean meetingSettingUpdate = this.hasFunctionPermission(null, "cp_mrm_MeetingSetting_Update");
            request.setAttribute("meetingSettingUpdate", (Object)meetingSettingUpdate);
            boolean meetingArchiveView = this.hasFunctionPermission(null, "cp_mrm_MrmArchive_View");
            boolean meetingArchiveDelete = this.hasFunctionPermission(null, "cp_mrm_MrmArchive_Delete");
            boolean meetingArchiveUpdate = this.hasFunctionPermission(null, "cp_mrm_MrmArchive_Update");
            request.setAttribute("meetingArchiveView", (Object)meetingArchiveView);
            request.setAttribute("meetingArchiveDelete", (Object)meetingArchiveDelete);
            request.setAttribute("meetingArchiveUpdate", (Object)meetingArchiveUpdate);
            boolean meetingAdminUpdate = this.hasFunctionPermission(null, "cp_mrm_MRAdmin_Update");
            boolean meetingAdminDelete = this.hasFunctionPermission(null, "cp_mrm_MRAdmin_Delete");
            request.setAttribute("meetingAdminUpdate", (Object)meetingAdminUpdate);
            request.setAttribute("meetingAdminDelete", (Object)meetingAdminDelete);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "success";
    }

    private boolean hasFunctionPermission(String cuId, String permissionKey) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        String orgID = null;
        ObjectUuidPK orgPK = null;
        if (null == cuId) {
            orgID = ((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString();
            orgPK = new ObjectUuidPK(orgID);
        } else {
            orgPK = new ObjectUuidPK(cuId);
        }
        boolean permissionFlag = false;
        try {
            FunctionPermissionService service = new FunctionPermissionService(ctx);
            permissionFlag = service.hasPermission((IObjectPK)userPK, (IObjectPK)orgPK, permissionKey, true);
        }
        catch (Exception e) {
            permissionFlag = false;
        }
        return permissionFlag;
    }
}

