/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.dep;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CustomizedSchemeCollection;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.EPException;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.ep.depend.VersionManager;
import com.kingdee.eas.ep.util.EPUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.shr.dydeploy.DydeployBizException;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class DepRunner {
    public static String fileSeperate = "/";

    public static void install(String appBase, String appId, String componentId) throws BOSException, Exception {
        String depBasePath = appBase + "/bak/" + appId + ".zip/" + componentId + ".zip/dep";
        File dir = new File(depBasePath);
        if (!dir.exists()) {
            return;
        }
        File update = new File(depBasePath + fileSeperate + "update.xml");
        if (!update.exists()) {
            return;
        }
        ArrayList<File> depSchemeList = DepRunner.getDepInfoFromFile(depBasePath, update);
        for (File dep : depSchemeList) {
            DepRunner.checkDepScheme(dep);
        }
        for (File dep : depSchemeList) {
            DepRunner.installDepScheme(depBasePath, dep);
        }
    }

    public static void uninstall(String appBase, String appId, String componentId) throws EASBizException, BOSException, IOException {
        String depBasePath = appBase + "/bak/" + appId + ".zip/" + componentId + ".zip/dep";
        File dir = new File(depBasePath);
        if (!dir.exists()) {
            return;
        }
        File update = new File(depBasePath + fileSeperate + "update.xml");
        if (!update.exists()) {
            return;
        }
        ArrayList<File> depSchemeList = DepRunner.getDepInfoFromFile(depBasePath, update);
        for (File dep : depSchemeList) {
            DepRunner.unInstallDepScheme(depBasePath, dep);
        }
        if (depSchemeList.size() > 0) {
            DepRunner.updateProject();
        }
    }

    private static void unInstallDepScheme(String depBasePath, File dep) throws IOException, BOSException, EASBizException {
        try (JarFile jarFile = null;){
            File bakFile;
            jarFile = new JarFile(dep);
            Manifest manifest = jarFile.getManifest();
            if (null == manifest || manifest.getMainAttributes() == null) {
                throw new DydeployBizException(DydeployBizException.E500);
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String schemeId = mainAttributes.getValue("ID");
            if (StringUtils.isEmpty((String)schemeId)) {
                throw new DydeployBizException(DydeployBizException.E501);
            }
            ICustomizedScheme iCS = CustomizedSchemeFactory.getRemoteInstance();
            if (iCS.exists((IObjectPK)new ObjectUuidPK(schemeId))) {
                iCS.update4Used(new String[]{schemeId}, false);
                iCS.delete((IObjectPK)new ObjectUuidPK(schemeId));
            }
            if ((bakFile = new File(depBasePath + fileSeperate + "bak" + fileSeperate + "bak" + dep.getName())).exists()) {
                DepRunner.importOneScheme(bakFile);
            }
        }
    }

    private static void checkDepScheme(File dep) throws BOSException, Exception {
        if (!EPUtils.isJarFile((File)dep)) {
            throw new DydeployBizException(DydeployBizException.E500);
        }
        try (JarFile jarFile = null;){
            StringBuffer nsql;
            jarFile = new JarFile(dep);
            Manifest manifest = jarFile.getManifest();
            if (null == manifest || manifest.getMainAttributes() == null) {
                throw new DydeployBizException(DydeployBizException.E500);
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String schemeId = mainAttributes.getValue("ID");
            if (StringUtils.isEmpty((String)schemeId)) {
                throw new DydeployBizException(DydeployBizException.E501);
            }
            String exportType = mainAttributes.getValue("export_type");
            if (exportType != null && !exportType.trim().equals("1")) {
                throw new DydeployBizException(DydeployBizException.E502);
            }
            DepRunner.checkVersion(mainAttributes);
            String schemeAlias = mainAttributes.getValue("alias");
            String schemeName = mainAttributes.getValue("name");
            ICustomizedScheme iCS = CustomizedSchemeFactory.getRemoteInstance();
            if (!StringUtils.isEmpty((String)schemeName) && !schemeName.equals("null")) {
                String[] name = StringUtils.split((String)schemeName, (String)";");
                nsql = new StringBuffer("where name in(");
                for (int i = 0; i < name.length; ++i) {
                    if (i != name.length - 1) {
                        nsql.append("'" + name[i] + "',");
                        continue;
                    }
                    nsql.append("'" + name[i] + "')");
                }
                nsql.append(" and  id not in('").append(schemeId).append("')");
                CoreBaseCollection collection = iCS.getCollection(nsql.toString());
                if (collection.size() != 0) {
                    throw new DydeployBizException(DydeployBizException.E503, new Object[]{schemeAlias});
                }
            }
            if (!StringUtils.isEmpty((String)schemeAlias) && !schemeAlias.equals("null")) {
                String[] alias = StringUtils.split((String)schemeAlias, (String)";");
                nsql = new StringBuffer("where alias in(");
                for (int i = 0; i < alias.length; ++i) {
                    if (i != alias.length - 1) {
                        nsql.append("'" + alias[i] + "',");
                        continue;
                    }
                    nsql.append("'" + alias[i] + "')");
                }
                nsql.append(" and  id not in('").append(schemeId).append("')");
                CoreBaseCollection collection = iCS.getCollection(nsql.toString());
                if (collection.size() != 0) {
                    throw new DydeployBizException(DydeployBizException.E504, new Object[]{schemeAlias});
                }
            }
        }
    }

    private static void updateProject() throws BOSException {
        ICustomizedScheme ics = CustomizedSchemeFactory.getRemoteInstance();
        CustomizedSchemeCollection col = ics.getCustomizedSchemeCollection();
        IMetadataStore mds = MetadataStoreFactory.getMetadataStore(null);
        ArrayList<Project> ps = new ArrayList<Project>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            CustomizedSchemeInfo csInfo = col.get(i);
            if (!csInfo.isStart()) continue;
            ps.add(new Project(csInfo.getId().toString()));
        }
        Project[] p = new Project[ps.size()];
        p = ps.toArray(p);
        mds.setProjects(p);
    }

    private static boolean checkVersion(Attributes mainAttributes) throws BOSException, Exception {
        double platformVersion;
        String value = mainAttributes.getValue("version");
        double version = VersionManager.getVersion((String)value);
        if (version > (platformVersion = VersionManager.getPlatformVersion())) {
            throw new DydeployBizException(DydeployBizException.E505);
        }
        return true;
    }

    private static void exportScheme(String schemeId, File file) throws Exception {
        BOSUuid id = BOSUuid.read((String)schemeId);
        CustomizedSchemeInfo schemeInfo = CustomizedSchemeFactory.getRemoteInstance().getCustomizedSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
        if (schemeInfo == null) {
            return;
        }
        BufferedOutputStream outStream = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(file));
            ICustomizedScheme iCS = CustomizedSchemeFactory.getRemoteInstance();
            byte[] bb = iCS.exportScheme(schemeId);
            outStream.write(bb);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (null != outStream) {
                outStream.flush();
            }
            if (null != outStream) {
                outStream.close();
            }
        }
    }

    private static File getBakDepFile(String depBasePath, File dep) {
        File dir = new File(depBasePath + fileSeperate + "bak");
        if (!dir.exists()) {
            dir.mkdir();
        }
        File bakfile = new File(dir.getAbsolutePath() + fileSeperate + "bak" + dep.getName());
        return bakfile;
    }

    private static void installDepScheme(String depBasePath, File dep) throws BOSException, Exception {
        try (JarFile jarFile = null;){
            String schemeId;
            ICustomizedScheme iCS;
            jarFile = new JarFile(dep);
            Manifest manifest = jarFile.getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            String schemeAlias = mainAttributes.getValue("alias");
            String schemeName = mainAttributes.getValue("name");
            if (StringUtils.isEmpty((String)schemeAlias)) {
                schemeAlias = "";
            }
            if ((iCS = CustomizedSchemeFactory.getRemoteInstance()).exists((IObjectPK)new ObjectUuidPK(schemeId = mainAttributes.getValue("ID")))) {
                DepRunner.exportScheme(schemeId, DepRunner.getBakDepFile(depBasePath, dep));
            }
            BOSUuid id = DepRunner.importOneScheme(dep);
            DepRunner.updateProject();
        }
    }

    private static BOSUuid importOneScheme(File dep) throws FileNotFoundException, IOException, BOSException, EASBizException {
        try (JarFile jarFile = null;){
            String depend;
            CoreBaseCollection collection;
            StringBuffer nsql;
            jarFile = new JarFile(dep);
            Manifest manifest = jarFile.getManifest();
            ICustomizedScheme iCS = CustomizedSchemeFactory.getRemoteInstance();
            Attributes mainAttributes = manifest.getMainAttributes();
            String schemeAlias = mainAttributes.getValue("alias");
            String schemeName = mainAttributes.getValue("name");
            String schemeId = mainAttributes.getValue("ID");
            if (StringUtils.isEmpty((String)schemeAlias)) {
                schemeAlias = "";
            }
            if (!StringUtils.isEmpty((String)schemeName) && !schemeName.equals("null")) {
                String[] name = StringUtils.split((String)schemeName, (String)";");
                nsql = new StringBuffer("where name in(");
                for (int i = 0; i < name.length; ++i) {
                    if (i != name.length - 1) {
                        nsql.append("'" + name[i] + "',");
                        continue;
                    }
                    nsql.append("'" + name[i] + "')");
                }
                nsql.append(" and  id not in('").append(schemeId).append("')");
                collection = iCS.getCollection(nsql.toString());
                if (collection.size() != 0) {
                    throw new DydeployBizException(DydeployBizException.E503, new Object[]{schemeAlias});
                }
            }
            if (!StringUtils.isEmpty((String)schemeAlias) && !schemeAlias.equals("null")) {
                String[] alias = StringUtils.split((String)schemeAlias, (String)";");
                nsql = new StringBuffer("where alias in(");
                for (int i = 0; i < alias.length; ++i) {
                    if (i != alias.length - 1) {
                        nsql.append("'" + alias[i] + "',");
                        continue;
                    }
                    nsql.append("'" + alias[i] + "')");
                }
                nsql.append(" and  id not in('").append(schemeId).append("')");
                collection = iCS.getCollection(nsql.toString());
                if (collection.size() != 0) {
                    throw new DydeployBizException(DydeployBizException.E504, new Object[]{schemeAlias});
                }
            }
            if (!StringUtils.isEmpty((String)(depend = mainAttributes.getValue("depend"))) && !depend.equals("null")) {
                String[] ids = StringUtils.split((String)depend, (String)";");
                StringBuffer nsql2 = new StringBuffer("where id in(");
                for (int i = 0; i < ids.length; ++i) {
                    if (i != ids.length - 1) {
                        nsql2.append("'" + ids[i] + "',");
                    } else {
                        nsql2.append("'" + ids[i] + "')");
                    }
                    nsql2.append(" and  id not in('").append(schemeId).append("')");
                }
                CoreBaseCollection collection2 = iCS.getCollection(nsql2.toString());
                if (collection2.size() != ids.length) {
                    throw new EPException(EPException.DEPEND_SCHEME_NOT_INSTALL);
                }
            }
            byte[] buffer = new byte[1024];
            BufferedInputStream bufferedInput = new BufferedInputStream(new FileInputStream(dep));
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            int bytesRead = bufferedInput.read(buffer);
            while (0 < bytesRead) {
                byteOut.write(buffer, 0, bytesRead);
                bytesRead = bufferedInput.read(buffer);
            }
            bufferedInput.close();
            BOSUuid id = BOSUuid.read((String)schemeId);
            IObjectPK logPK = LogUtil.beginLog(null, (String)"importScheme", (BOSObjectType)id.getType(), (IObjectPK)new ObjectUuidPK(id), (String)("Import dynamic expansion scheme:[" + schemeAlias + "](" + schemeId + ")"));
            try {
                CustomizedSchemeFactory.getRemoteInstance().importScheme(byteOut.toByteArray());
            }
            catch (Exception ex) {
                throw new DydeployBizException(DydeployBizException.E506);
            }
            finally {
                byteOut.close();
            }
            if (logPK != null) {
                LogUtil.afterLog(null, (IObjectPK)logPK);
            }
            CustomizedSchemeFactory.getRemoteInstance().update4Used(new String[]{id.toString()}, true);
            BOSUuid bOSUuid = id;
            return bOSUuid;
        }
    }

    public static ArrayList<File> getDepInfoFromFile(String fileBasePath, File update) throws BOSException {
        ArrayList<File> depSchemeList = new ArrayList<File>();
        FileInputStream inStream = null;
        try {
            List childList;
            File cXMLFile = update;
            inStream = new FileInputStream(cXMLFile);
            SAXBuilder builder = new SAXBuilder();
            Document depDoc = builder.build((InputStream)inStream);
            Element ele = depDoc.getRootElement();
            if (ele != null && (childList = ele.getChildren()) != null && childList.size() > 0) {
                for (int i = 0; i < childList.size(); ++i) {
                    File depFile;
                    Element e_child = (Element)childList.get(i);
                    String path = e_child.getText();
                    if (StringUtils.isEmpty((String)path) || !(depFile = new File(fileBasePath + fileSeperate + path)).exists()) continue;
                    depSchemeList.add(depFile);
                }
            }
        }
        catch (Exception ex) {
            throw new BOSException("Get dep information from file error" + ex);
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return depSchemeList;
    }
}

