/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.dydeploy.web.executeSql.AdditionalLog;
import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.BatchPreparedSQLExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.BatchSqlParamterProvider;
import com.kingdee.shr.dydeploy.web.executeSql.CompositeSqlProvider;
import com.kingdee.shr.dydeploy.web.executeSql.ConnectionHolder;
import com.kingdee.shr.dydeploy.web.executeSql.DB2UDB;
import com.kingdee.shr.dydeploy.web.executeSql.DB400;
import com.kingdee.shr.dydeploy.web.executeSql.DBDCTableNotExistException;
import com.kingdee.shr.dydeploy.web.executeSql.DBException;
import com.kingdee.shr.dydeploy.web.executeSql.DBNetworkException;
import com.kingdee.shr.dydeploy.web.executeSql.DBSQLException;
import com.kingdee.shr.dydeploy.web.executeSql.DBSQLProviderException;
import com.kingdee.shr.dydeploy.web.executeSql.DBType2KSqlTypeUtil;
import com.kingdee.shr.dydeploy.web.executeSql.DBUuidClassFileNotExistException;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLQueryProviderExecutor2;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSqlInputStreamExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.ExceptionUtils;
import com.kingdee.shr.dydeploy.web.executeSql.IDB2UDB;
import com.kingdee.shr.dydeploy.web.executeSql.IDB400;
import com.kingdee.shr.dydeploy.web.executeSql.IDBConnectionCallback;
import com.kingdee.shr.dydeploy.web.executeSql.IDatabase;
import com.kingdee.shr.dydeploy.web.executeSql.IOracle;
import com.kingdee.shr.dydeploy.web.executeSql.ISqlServer;
import com.kingdee.shr.dydeploy.web.executeSql.ISyBase;
import com.kingdee.shr.dydeploy.web.executeSql.InAndOutBean;
import com.kingdee.shr.dydeploy.web.executeSql.InetUtil;
import com.kingdee.shr.dydeploy.web.executeSql.JDBCUtils;
import com.kingdee.shr.dydeploy.web.executeSql.MultiSqlProvider;
import com.kingdee.shr.dydeploy.web.executeSql.Oracle;
import com.kingdee.shr.dydeploy.web.executeSql.PreparedQuerySQLExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.PreparedSQLExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.ResultSetTypeProvider;
import com.kingdee.shr.dydeploy.web.executeSql.RowCallbackHandler;
import com.kingdee.shr.dydeploy.web.executeSql.RowLengthExceedBPPageSizeException;
import com.kingdee.shr.dydeploy.web.executeSql.SqlColumn;
import com.kingdee.shr.dydeploy.web.executeSql.SqlExeResultCallbackHandler;
import com.kingdee.shr.dydeploy.web.executeSql.SqlParamterProvider;
import com.kingdee.shr.dydeploy.web.executeSql.SqlProvider;
import com.kingdee.shr.dydeploy.web.executeSql.SqlServer;
import com.kingdee.shr.dydeploy.web.executeSql.SqlTable;
import com.kingdee.shr.dydeploy.web.executeSql.SyBase;
import com.kingdee.shr.dydeploy.web.executeSql.TableDataTransferResult;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbstractDB
implements IDatabase {
    private static final Logger logger = Logger.getLogger(AbstractDB.class);
    protected ConnectionHolder connectionHolder = new ConnectionHolder(this);
    protected InAndOutBean inAndOutBean;

    @Override
    public InAndOutBean getInAndOutBean() {
        return this.inAndOutBean;
    }

    @Override
    public void setInAndOutBean(InAndOutBean inAndOutBean) {
        this.inAndOutBean = inAndOutBean;
    }

    public AbstractDB() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AbstractDB.this.connectionHolder.doConnectionClean();
            }
        });
    }

    protected void testDBPort(DatabaseVO vo) throws DBNetworkException {
        boolean isOK = InetUtil.testConnection(vo.getDbAddress(), vo.getDbPort());
        if (!isOK) {
            throw new DBNetworkException("Database's port is not open", vo.getDBType(), vo.getDbAddress(), vo.getDbPort());
        }
    }

    protected abstract Connection getPhysicalDBConnection() throws SQLException;

    protected synchronized Connection getDBConnection() throws SQLException {
        return this.connectionHolder.getConnection();
    }

    @Override
    public void doInConnectionCallback(IDBConnectionCallback action) {
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            action.doInDBConnection(conn);
        }
        catch (SQLException sqle) {
            logger.error((Object)("Process sql operation in doInConnectionCallback failed, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!"), (Throwable)sqle);
            throw new DBException("Process sql operation in doInConnectionCallback failed, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!", sqle);
        }
        finally {
            this.connectionHolder.release();
        }
    }

    @Override
    public SqlTable getTableDetailFromSql(String queryName, String sql) {
        final SqlTable sqlTable = new SqlTable(queryName, false);
        this.execute(new DefaultSQLQueryProviderExecutor2(sql){

            @Override
            public void sqlExecuteResult(ResultSet rs) throws SQLException {
                if (rs != null) {
                    ResultSetMetaData metaData = rs.getMetaData();
                    for (int i = 0; i < metaData.getColumnCount(); ++i) {
                        SqlColumn col = new SqlColumn(metaData.getColumnName(i + 1));
                        col.setScale(metaData.getScale(i + 1));
                        col.setNullable(metaData.isNullable(i + 1) == 1);
                        col.setLength(metaData.getColumnDisplaySize(i + 1));
                        col.setPrecision(metaData.getPrecision(i + 1));
                        col.setDataType(metaData.getColumnTypeName(i + 1));
                        if (col.getDataType().endsWith("BLOB")) {
                            col.setLength(524288000);
                        } else if (col.getDataType().endsWith("CLOB")) {
                            col.setLength(0xA00000);
                        }
                        sqlTable.addColumn(col);
                    }
                }
            }

            @Override
            public void sqlUpdateCount(int updateCount) throws SQLException {
            }
        });
        return sqlTable;
    }

    @Override
    public HashMap getSqlTableDetail(ArrayList tableNameList, final boolean isView, boolean isChangeColType) {
        if (!isChangeColType) {
            return this.getSqlTableDetail(tableNameList, isView);
        }
        final HashMap tableDetailMap = new HashMap();
        ArrayList<4> providerList = new ArrayList<4>();
        if (tableNameList != null && tableNameList.size() > 0) {
            logger.info((Object)"It's DB2 database, use ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_READ_ONLY");
            for (int i = 0; i < tableNameList.size(); ++i) {
                final String tableName = (String)tableNameList.get(i);
                String sql = "select * from " + tableName + " where 1=0";
                if (IDB2UDB.class.isInstance(this) || IDB400.class.isInstance(this)) {
                    this.execute(new DefaultSQLQueryProviderExecutor2(sql, true, true, 1003, 1007){

                        @Override
                        public void sqlExecuteResult(ResultSet rs) throws SQLException {
                            if (rs != null) {
                                SqlTable table = new SqlTable(tableName, isView);
                                ResultSetMetaData metaData = rs.getMetaData();
                                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                                    SqlColumn col = new SqlColumn(metaData.getColumnName(i + 1));
                                    col.setScale(metaData.getScale(i + 1));
                                    col.setNullable(metaData.isNullable(i + 1) == 1);
                                    col.setLength(metaData.getColumnDisplaySize(i + 1));
                                    col.setPrecision(metaData.getPrecision(i + 1));
                                    col.setDataType(metaData.getColumnTypeName(i + 1));
                                    if (IOracle.class.isInstance(AbstractDB.this) && ((IOracle)((Object)AbstractDB.this)).isNCHAR(metaData, i + 1) && "VARCHAR2".equalsIgnoreCase(col.getDataType())) {
                                        col.setDataType("NVARCHAR2");
                                    }
                                    col.setDataType(DBType2KSqlTypeUtil.mapDBType2KSQLType(col.getDataType(), col.getScale()));
                                    if (col.getDataType().endsWith("BLOB")) {
                                        col.setLength(524288000);
                                    } else if (col.getDataType().endsWith("CLOB")) {
                                        col.setLength(0xA00000);
                                    }
                                    table.addColumn(col);
                                    tableDetailMap.put(tableName, table);
                                }
                            }
                        }

                        @Override
                        public void sqlUpdateCount(int updateCount) throws SQLException {
                        }
                    });
                    continue;
                }
                providerList.add(new DefaultSQLQueryProviderExecutor2(sql, true){

                    @Override
                    public void sqlExecuteResult(ResultSet rs) throws SQLException {
                        if (rs != null) {
                            SqlTable table = new SqlTable(tableName, isView);
                            ResultSetMetaData metaData = rs.getMetaData();
                            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                                SqlColumn col = new SqlColumn(metaData.getColumnName(i + 1));
                                col.setScale(metaData.getScale(i + 1));
                                col.setNullable(metaData.isNullable(i + 1) == 1);
                                col.setLength(metaData.getColumnDisplaySize(i + 1));
                                col.setPrecision(metaData.getPrecision(i + 1));
                                col.setDataType(metaData.getColumnTypeName(i + 1));
                                if (IOracle.class.isInstance(AbstractDB.this) && ((IOracle)((Object)AbstractDB.this)).isNCHAR(metaData, i + 1) && "VARCHAR2".equalsIgnoreCase(col.getDataType())) {
                                    col.setDataType("NVARCHAR2");
                                }
                                col.setDataType(DBType2KSqlTypeUtil.mapDBType2KSQLType(col.getDataType(), col.getScale()));
                                if (col.getDataType().endsWith("BLOB")) {
                                    col.setLength(524288000);
                                } else if (col.getDataType().endsWith("CLOB")) {
                                    col.setLength(0xA00000);
                                }
                                table.addColumn(col);
                                tableDetailMap.put(tableName, table);
                            }
                        }
                    }

                    @Override
                    public void sqlUpdateCount(int updateCount) throws SQLException {
                    }
                });
            }
            this.execute(new TT(providerList));
        }
        return tableDetailMap;
    }

    @Override
    public HashMap getSqlTableDetail(ArrayList tableNameList, final boolean isView) {
        final HashMap tableDetailMap = new HashMap();
        ArrayList<6> providerList = new ArrayList<6>();
        if (tableNameList != null && tableNameList.size() > 0) {
            logger.info((Object)"It's DB2 database, use ResultSet.TYPE_SCROLL_SENSITIVE, ResultSet.CONCUR_READ_ONLY");
            for (int i = 0; i < tableNameList.size(); ++i) {
                final String tableName = (String)tableNameList.get(i);
                String sql = "select * from " + tableName + " where 1=0";
                if (IDB2UDB.class.isInstance(this) || IDB400.class.isInstance(this)) {
                    this.execute(new DefaultSQLQueryProviderExecutor2(sql, true, true, 1003, 1007){

                        @Override
                        public void sqlExecuteResult(ResultSet rs) throws SQLException {
                            if (rs != null) {
                                SqlTable table = new SqlTable(tableName, isView);
                                ResultSetMetaData metaData = rs.getMetaData();
                                for (int i = 0; i < metaData.getColumnCount(); ++i) {
                                    SqlColumn col = new SqlColumn(metaData.getColumnName(i + 1));
                                    col.setScale(metaData.getScale(i + 1));
                                    col.setNullable(metaData.isNullable(i + 1) == 1);
                                    col.setLength(metaData.getColumnDisplaySize(i + 1));
                                    col.setPrecision(metaData.getPrecision(i + 1));
                                    col.setDataType(metaData.getColumnTypeName(i + 1));
                                    if (col.getDataType().endsWith("BLOB")) {
                                        col.setLength(524288000);
                                    } else if (col.getDataType().endsWith("CLOB")) {
                                        col.setLength(0xA00000);
                                    }
                                    table.addColumn(col);
                                    tableDetailMap.put(tableName, table);
                                }
                            }
                        }

                        @Override
                        public void sqlUpdateCount(int updateCount) throws SQLException {
                        }
                    });
                    continue;
                }
                providerList.add(new DefaultSQLQueryProviderExecutor2(sql, true){

                    @Override
                    public void sqlExecuteResult(ResultSet rs) throws SQLException {
                        if (rs != null) {
                            SqlTable table = new SqlTable(tableName, isView);
                            ResultSetMetaData metaData = rs.getMetaData();
                            for (int i = 0; i < metaData.getColumnCount(); ++i) {
                                SqlColumn col = new SqlColumn(metaData.getColumnName(i + 1));
                                col.setScale(metaData.getScale(i + 1));
                                col.setNullable(metaData.isNullable(i + 1) == 1);
                                col.setLength(metaData.getColumnDisplaySize(i + 1));
                                col.setPrecision(metaData.getPrecision(i + 1));
                                col.setDataType(metaData.getColumnTypeName(i + 1));
                                if (col.getDataType().endsWith("BLOB")) {
                                    col.setLength(524288000);
                                } else if (col.getDataType().endsWith("CLOB")) {
                                    col.setLength(0xA00000);
                                }
                                table.addColumn(col);
                                tableDetailMap.put(tableName, table);
                            }
                        }
                    }

                    @Override
                    public void sqlUpdateCount(int updateCount) throws SQLException {
                    }
                });
            }
            this.execute(new TT(providerList));
        }
        return tableDetailMap;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        try {
            this.getDBConnection().setAutoCommit(autoCommit);
            this.connectionHolder.release();
        }
        catch (SQLException sqle) {
            logger.error((Object)("Session setAutoCommit falied, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!"), (Throwable)sqle);
            throw new DBException("Session setAutoCommit falied, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!", sqle);
        }
    }

    @Override
    public boolean getAutoCommit() {
        try {
            boolean isAutoCommit = this.getDBConnection().getAutoCommit();
            this.connectionHolder.release();
            return isAutoCommit;
        }
        catch (SQLException sqle) {
            logger.error((Object)("Session getAutoCommit falied, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!"), (Throwable)sqle);
            throw new DBException("Session getAutoCommit falied, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!", sqle);
        }
    }

    @Override
    public void commitTransaction() {
        try {
            this.getDBConnection().commit();
            this.connectionHolder.release();
        }
        catch (SQLException sqle) {
            logger.error((Object)("Session commit a transaction falied, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!"), (Throwable)sqle);
            throw new DBException("Session commit a transaction falied, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!", sqle);
        }
    }

    @Override
    public void rollbackTransaction() {
        try {
            this.getDBConnection().rollback();
            this.connectionHolder.release();
        }
        catch (SQLException sqle) {
            logger.error((Object)("Session rollback a transaction falied, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!"), (Throwable)sqle);
            throw new DBException("Session rollback a transaction falied, sqlcode[" + sqle.getErrorCode() + "] sqlstate[" + sqle.getSQLState() + "]!", sqle);
        }
    }

    @Override
    public SqlTable getSqlTableDetail(String tablename, boolean isView) {
        return this.getSqlTableDetail(tablename, isView, false);
    }

    @Override
    public SqlTable getSqlTableDetail(String tablename, boolean isView, boolean ignoreException) {
        final SqlTable table = new SqlTable(tablename, isView);
        try {
            String sql = "select * from " + tablename.toLowerCase() + " where 1=0";
            this.execute(new DefaultSQLQueryProviderExecutor2(sql, ignoreException, true, 1003, 1007){

                @Override
                public void sqlExecuteResult(ResultSet rs) throws SQLException {
                    if (rs != null) {
                        ResultSetMetaData metaData = rs.getMetaData();
                        for (int i = 0; i < metaData.getColumnCount(); ++i) {
                            SqlColumn col = new SqlColumn(metaData.getColumnName(i + 1));
                            col.setScale(metaData.getScale(i + 1));
                            col.setNullable(metaData.isNullable(i + 1) == 1);
                            col.setLength(metaData.getColumnDisplaySize(i + 1));
                            col.setPrecision(metaData.getPrecision(i + 1));
                            col.setDataType(metaData.getColumnTypeName(i + 1));
                            if (IOracle.class.isInstance(AbstractDB.this) && ((IOracle)((Object)AbstractDB.this)).isNCHAR(metaData, i + 1) && "VARCHAR2".equalsIgnoreCase(col.getDataType())) {
                                col.setDataType("NVARCHAR2");
                            }
                            col.setDataType(DBType2KSqlTypeUtil.mapDBType2KSQLType(col.getDataType(), col.getScale()));
                            if (col.getDataType().endsWith("BLOB")) {
                                col.setLength(524288000);
                            } else if (col.getDataType().endsWith("CLOB")) {
                                col.setLength(0xA00000);
                            }
                            table.addColumn(col);
                        }
                    }
                }

                @Override
                public void sqlUpdateCount(int updateCount) throws SQLException {
                }
            });
            return table;
        }
        catch (Exception err) {
            logger.error((Object)"", (Throwable)err);
            throw new DBException("Get table detail info error", err);
        }
    }

    @Override
    public void testJDBCConnection() {
        block3: {
            try {
                this.connectionHolder.doConnectionClean();
                Connection conn = this.getDBConnection();
                this.connectionHolder.release();
            }
            catch (Exception sqle) {
                if (sqle instanceof AdminException) {
                    throw (AdminException)sqle;
                }
                if (!(sqle instanceof SQLException)) break block3;
                logger.error((Object)("Get database connection failed, sqlcode[" + ((SQLException)sqle).getErrorCode() + "] sqlstate[" + ((SQLException)sqle).getSQLState() + "]!"), (Throwable)sqle);
                throw new DBException("Get database connection failed, sqlcode[" + ((SQLException)sqle).getErrorCode() + "] sqlstate[" + ((SQLException)sqle).getSQLState() + "]!");
            }
        }
    }

    @Override
    public void executeMultiSql(List sqllist) throws DBSQLException {
        this.execute(new DefaultSQLProviderExecutor(sqllist, false));
    }

    @Override
    public void executeMultiSql(List sqllist, boolean autoCommit) throws DBSQLException {
        this.execute(new DefaultSQLProviderExecutor(sqllist, false), autoCommit);
    }

    @Override
    public void executeMultiSqlWithSameParameter(List sqllist, Object value) throws DBSQLException {
        if (value != null && value.getClass().isArray()) {
            throw new RuntimeException("Object value is array, Plz use executeSqlWithParams, not executeSqlWithSingleParam!");
        }
        for (int i = 0; i < sqllist.size(); ++i) {
            String sql = (String)sqllist.get(i);
            PreparedSQLExecutor executor = new PreparedSQLExecutor(sql, new Object[]{value});
            this.execute(executor);
        }
    }

    @Override
    public void executeSql(final String sql) throws DBSQLException {
        this.execute(new SqlProvider(){

            @Override
            public String getProviderName() {
                return "SingleSQLExecutor";
            }

            @Override
            public String getSql() throws DBSQLException {
                return sql;
            }

            @Override
            public boolean handleException(DBSQLException sqle) {
                return false;
            }

            @Override
            public ArrayList getExceptions() {
                return null;
            }
        });
    }

    @Override
    public void executeSqlWithSingleParam(String sql, Object value) {
        if (value != null && value.getClass().isArray()) {
            throw new RuntimeException("Object value is array, Plz use executeSqlWithParams, not executeSqlWithSingleParam!");
        }
        this.executeSqlWithParams(sql, new Object[]{value});
    }

    @Override
    public void executeSqlWithParams(String sql, Object[] values) {
        if (values != null && values.length > 0 && values[0].getClass().isArray()) {
            throw new RuntimeException("Object value is two dimension array, Plz use executeBatchSqlWithParams, not executeSqlWithParams!");
        }
        PreparedSQLExecutor executor = new PreparedSQLExecutor(sql, values);
        this.execute(executor);
    }

    @Override
    public void executeBatchSqlWithParams(String sql, Object[][] values) {
        BatchPreparedSQLExecutor batchExecutor = new BatchPreparedSQLExecutor(sql, values);
        this.execute(batchExecutor);
    }

    @Override
    public void executeQuery(String sql, RowCallbackHandler rowHandler) {
        PreparedQuerySQLExecutor executor = new PreparedQuerySQLExecutor(sql, null, rowHandler);
        this.execute(executor);
    }

    @Override
    public void executeQueryWithSingleParam(String sql, Object value, RowCallbackHandler rowHandler) {
        this.executeQueryWithParams(sql, new Object[]{value}, rowHandler);
    }

    @Override
    public void executeQueryWithParams(String sql, Object[] values, RowCallbackHandler rowHandler) {
        PreparedQuerySQLExecutor executor = new PreparedQuerySQLExecutor(sql, values, rowHandler);
        this.execute(executor);
    }

    public void execute(SqlProvider sqlProvider, boolean autoCommit) {
        if (autoCommit) {
            this.execute(sqlProvider);
        } else {
            Connection conn = null;
            try {
                conn = this.getDBConnection();
                boolean isAutoCommit = conn.getAutoCommit();
                conn.setAutoCommit(false);
                this.executeSqlProvider(conn, sqlProvider);
                conn.commit();
                conn.setAutoCommit(isAutoCommit);
            }
            catch (SQLException sqle) {
                try {
                    if (null != conn) {
                        conn.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                logger.error((Object)"Get database connection failed!", (Throwable)sqle);
                throw new DBException("Get database connection failed!", sqle);
            }
            finally {
                this.connectionHolder.release();
            }
        }
    }

    @Override
    public void execute(SqlProvider sqlProvider) {
        Connection conn = null;
        try {
            Context ctx = SHRContext.getInstance().getContext();
            conn = EJBFactory.getConnection((Context)ctx);
            this.executeSqlProvider(conn, sqlProvider);
        }
        catch (SQLException sqle) {
            logger.error((Object)"Get database connection failed!", (Throwable)sqle);
            throw new DBException("Get database connection failed!", sqle);
        }
        finally {
            this.connectionHolder.release();
        }
    }

    @Override
    public void executeAsync(final SqlProvider sqlProvider) {
        Thread executorThread = new Thread(){

            @Override
            public void run() {
                Connection conn = null;
                try {
                    conn = AbstractDB.this.getDBConnection();
                    AbstractDB.this.executeSqlProvider(conn, sqlProvider);
                }
                catch (Throwable e) {
                    logger.error((Object)"SqlProvider executeAsync failed! ", e);
                }
                finally {
                    AbstractDB.this.connectionHolder.release();
                }
            }
        };
        executorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CompositeSqlProvider compositeSqlProvider) {
        Connection conn = null;
        try {
            Context ctx = SHRContext.getInstance().getContext();
            conn = EJBFactory.getConnection((Context)ctx);
            SqlProvider sqlProvider = null;
            ArrayList<DBSQLProviderException> errlist = new ArrayList<DBSQLProviderException>();
            ArrayList<String> valueList = new ArrayList<String>();
            if (null != this.inAndOutBean) {
                this.inAndOutBean.setRegSQLValues(valueList);
            }
            while ((sqlProvider = compositeSqlProvider.getNextSqlProvider()) != null) {
                valueList.addAll(this.executeSqlProvider(conn, sqlProvider));
                if (DefaultSqlInputStreamExecutor.class.isInstance(sqlProvider)) {
                    try {
                        ((DefaultSqlInputStreamExecutor)sqlProvider).release();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (sqlProvider.getExceptions() != null && sqlProvider.getExceptions().size() > 0) {
                    DBSQLProviderException dbsqlproe;
                    Throwable dbsqleFirst = null;
                    DBSQLException dbsqlePrev = null;
                    for (int i = 0; i < sqlProvider.getExceptions().size(); ++i) {
                        DBSQLException dbSQLe = null;
                        if (DBSQLException.class.isInstance(sqlProvider.getExceptions().get(i))) {
                            dbSQLe = (DBSQLException)sqlProvider.getExceptions().get(i);
                        } else {
                            Exception dbe = (Exception)sqlProvider.getExceptions().get(i);
                            logger.error((Object)("Not expected Exception, ProviderName=[" + sqlProvider.getProviderName() + "].ErrorInfo:" + ExceptionUtils.getStackTrace(dbe)), (Throwable)dbe);
                            dbSQLe = new DBSQLException(dbe.getMessage() + ";SQL File is not UTF8 encoding, ProviderName=[" + sqlProvider.getProviderName() + "]", dbe, this.getDBType());
                        }
                        if (dbsqlePrev != null) {
                            dbsqlePrev.setNexException(dbSQLe);
                        }
                        dbsqlePrev = dbSQLe;
                        if (i != 0) continue;
                        dbsqleFirst = dbSQLe;
                    }
                    if (null == dbsqleFirst || compositeSqlProvider.handleException(dbsqlproe = new DBSQLProviderException(dbsqleFirst.getMessage(), ((DBException)dbsqleFirst).getDBType(), ((DBSQLException)dbsqleFirst).getSourceSQL(), ((DBSQLException)dbsqleFirst).getTranslateSQL(), ((DBSQLException)dbsqleFirst).getSqlCode(), ((DBSQLException)dbsqleFirst).getSqlState(), ((DBSQLException)dbsqleFirst).getSqlMessage(), sqlProvider.getProviderName()))) continue;
                    errlist.add(dbsqlproe);
                    continue;
                }
                logger.info((Object)("Execute provider[" + sqlProvider.getProviderName() + "] successful!"));
            }
            if (errlist.size() > 0) {
                throw (DBSQLProviderException)errlist.get(0);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"Get database connection failed!", (Throwable)sqle);
            String dbType = this.getDBType();
            DBSQLProviderException providerEx = new DBSQLProviderException("Get database connection failed, sqlcode[" + sqle.getErrorCode() + "] sqlstat[" + sqle.getSQLState() + "]!", dbType, "", "", sqle.getErrorCode(), sqle.getSQLState(), sqle.getMessage(), "compositeSqlProvider");
            if (!compositeSqlProvider.handleException(providerEx)) {
                throw providerEx;
            }
        }
        finally {
            this.connectionHolder.release();
        }
    }

    private String getDBType() {
        if (IDB2UDB.class.isInstance(this)) {
            return "DB2";
        }
        if (ISqlServer.class.isInstance(this)) {
            return "MS SqlServer";
        }
        if (IOracle.class.isInstance(this)) {
            return "Oracle";
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<String> executeSqlProvider(Connection conn, SqlProvider sqlProvider) {
        boolean hasPrintedProviderName = false;
        boolean isHasRowLengthExceedBPPageSize = false;
        ArrayList tooLongSql = new ArrayList();
        ArrayList<String> result = new ArrayList<String>();
        if (MultiSqlProvider.class.isInstance(sqlProvider)) {
            MultiSqlProvider multiSQL = (MultiSqlProvider)sqlProvider;
            if (DefaultSqlInputStreamExecutor.class.isInstance(sqlProvider)) {
                ((DefaultSqlInputStreamExecutor)multiSQL).setIstransTostoreProc(false);
            }
            while (multiSQL.nextSQL()) {
                try {
                    if (!hasPrintedProviderName) {
                        this.processSQL(conn, sqlProvider, true);
                        hasPrintedProviderName = true;
                    } else if ("true".equalsIgnoreCase(System.getProperty("printProviderNameOnce", "false"))) {
                        this.processSQL(conn, sqlProvider, false);
                    } else {
                        this.processSQL(conn, sqlProvider, true);
                    }
                    this.addValues(sqlProvider, result);
                }
                catch (RowLengthExceedBPPageSizeException e) {
                    logger.info((Object)"is RowLengthExceedBPPageSizeException");
                    isHasRowLengthExceedBPPageSize = true;
                    String tmpsql = ((DefaultSqlInputStreamExecutor)multiSQL).getCurOrgSql();
                    this.executeByStoreProcedure(conn, tmpsql, sqlProvider);
                }
                catch (DBSQLException e) {
                    if (sqlProvider.handleException(e)) continue;
                    DBSQLException dbsqle = e;
                    throw new DBSQLProviderException(dbsqle.getMessage(), dbsqle.getDBType(), dbsqle.getSourceSQL(), dbsqle.getTranslateSQL(), dbsqle.getSqlCode(), dbsqle.getSqlState(), dbsqle.getSqlMessage(), sqlProvider.getProviderName());
                }
            }
            return result;
        } else {
            try {
                this.processSQL(conn, sqlProvider, true);
                this.addValues(sqlProvider, result);
                return result;
            }
            catch (DBSQLException e) {
                if (sqlProvider.handleException(e)) return result;
                DBSQLException dbsqle = e;
                throw new DBSQLProviderException(dbsqle.getMessage(), dbsqle.getDBType(), dbsqle.getSourceSQL(), dbsqle.getTranslateSQL(), dbsqle.getSqlCode(), dbsqle.getSqlState(), dbsqle.getSqlMessage(), sqlProvider.getProviderName());
            }
        }
    }

    private void addValues(SqlProvider sqlProvider, List<String> result) {
        if (null == this.inAndOutBean) {
            return;
        }
        String sql = sqlProvider.getSql();
        String regSQL = this.generatePreRegSQL();
        int index = sql.toUpperCase().indexOf(regSQL);
        if (index == -1) {
            return;
        }
        String tempValue = sql.substring(index + regSQL.length());
        if ("IN".equals(this.inAndOutBean.getRegSQLCompare())) {
            String[] temps;
            String tempValues = tempValue.trim().replace("(", "").replace(")", "");
            for (String s : temps = tempValues.split(",")) {
                if (StringUtils.isEmpty((String)s)) continue;
                result.add(s.trim().replace("'", ""));
            }
        } else if ("=".equals(this.inAndOutBean.getRegSQLCompare())) {
            result.add(tempValue.trim().replace("'", ""));
        }
    }

    private String generatePreRegSQL() {
        StringBuilder sb = new StringBuilder();
        if ("DELETE".equals(this.inAndOutBean.getRegSQLOperate())) {
            sb.append("DELETE FROM ").append(this.inAndOutBean.getRegSQLTable()).append(" WHERE ").append(this.inAndOutBean.getRegSQLPK());
        }
        if ("IN".equals(this.inAndOutBean.getRegSQLCompare())) {
            sb.append(" IN");
        } else if ("=".equals(this.inAndOutBean.getRegSQLCompare())) {
            sb.append(" =");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeByStoreProcedure(Connection conn, String sql, SqlProvider sqlProvider) {
        logger.info((Object)"start to  deploy by store procdure");
        MultiSqlProvider multiSQL = (MultiSqlProvider)sqlProvider;
        if (DefaultSqlInputStreamExecutor.class.isInstance(sqlProvider)) {
            ((DefaultSqlInputStreamExecutor)multiSQL).setIstransTostoreProc(true);
            String[] procsqls = ((DefaultSqlInputStreamExecutor)multiSQL).preprocessSQL(sql);
            for (int i = 0; i < procsqls.length; ++i) {
                PreparedStatement st = null;
                try {
                    logger.debug((Object)("store procedure sql:" + procsqls[i]));
                    st = conn.prepareStatement(procsqls[i]);
                    st.execute();
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)("in edit too long sql error,sql is:" + procsqls[i] + " error msg:" + e.getMessage()), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        JDBCUtils.closeStatement(st);
                        throw throwable;
                    }
                    JDBCUtils.closeStatement(st);
                    continue;
                }
                JDBCUtils.closeStatement(st);
                continue;
            }
        }
        logger.info((Object)"end to  deploy by store procdure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSQL(Connection conn, SqlProvider sqlProvider, boolean printProviderName) throws DBSQLException {
        String sql = "";
        try {
            sql = sqlProvider.getSql();
        }
        catch (DBSQLException sqle) {
            String dbType = "";
            if (IDB2UDB.class.isInstance(this)) {
                dbType = "DB2";
            } else if (ISqlServer.class.isInstance(this)) {
                dbType = "MS SqlServer";
            } else if (IOracle.class.isInstance(this)) {
                dbType = "Oracle";
            }
            DBSQLException providerEx = new DBSQLException("Execute provider[" + sqlProvider.getProviderName() + "], sqlcode[" + sqle.getSqlCode() + "] sqlstat[" + sqle.getSqlState() + "]!", dbType, "", "", sqle.getSqlCode(), sqle.getSqlState(), sqle.getMessage());
            throw providerEx;
        }
        if (sql == null || sql.trim().length() == 0) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Execute provider[" + sqlProvider.getProviderName() + "] \nsql[" + sql + "]...."));
        }
        Statement st = null;
        try {
            ResultSet rs;
            ResultSetTypeProvider resultSetType;
            boolean hasResultSet = false;
            if (SqlParamterProvider.class.isInstance(sqlProvider)) {
                PreparedStatement ps;
                if (ResultSetTypeProvider.class.isInstance(sqlProvider)) {
                    resultSetType = (ResultSetTypeProvider)((Object)sqlProvider);
                    st = conn.prepareStatement(sql, resultSetType.getResultSetType(), resultSetType.getResultSetConcurrencyType());
                } else {
                    st = conn.prepareStatement(sql);
                }
                SqlParamterProvider paramProvider = (SqlParamterProvider)((Object)sqlProvider);
                if (paramProvider.useParameters()) {
                    if (BatchSqlParamterProvider.class.isInstance(sqlProvider)) {
                        while (((BatchSqlParamterProvider)paramProvider).hasMoreValues()) {
                            paramProvider.setValues((PreparedStatement)st);
                            ((PreparedStatement)st).addBatch();
                        }
                        ((PreparedStatement)st).executeBatch();
                    } else {
                        paramProvider.setValues((PreparedStatement)st);
                        ps = (PreparedStatement)st;
                        hasResultSet = ps.execute();
                    }
                } else {
                    ps = (PreparedStatement)st;
                    hasResultSet = ps.execute();
                }
            } else if (ResultSetTypeProvider.class.isInstance(sqlProvider)) {
                resultSetType = (ResultSetTypeProvider)((Object)sqlProvider);
                st = conn.createStatement(resultSetType.getResultSetType(), resultSetType.getResultSetConcurrencyType());
                hasResultSet = st.execute(sql);
            } else {
                st = conn.createStatement();
                hasResultSet = st.execute(sql);
            }
            if (SqlExeResultCallbackHandler.class.isInstance(sqlProvider)) {
                SqlExeResultCallbackHandler sqlCallbackhandler = (SqlExeResultCallbackHandler)((Object)sqlProvider);
                sqlCallbackhandler.sqlUpdateCount(st.getUpdateCount());
                if (hasResultSet) {
                    rs = st.getResultSet();
                    sqlCallbackhandler.sqlExecuteResult(rs);
                    if (!DefaultSQLQueryProviderExecutor2.class.isInstance(sqlProvider) || ((DefaultSQLQueryProviderExecutor2)sqlProvider).closeResultSet) {
                        JDBCUtils.closeResultSet(rs);
                    }
                }
            } else if (hasResultSet && RowCallbackHandler.class.isInstance(sqlProvider)) {
                RowCallbackHandler rowCallbackhandler = (RowCallbackHandler)((Object)sqlProvider);
                rs = st.getResultSet();
                while (rs.next()) {
                    rowCallbackhandler.processRow(rs);
                }
                JDBCUtils.closeResultSet(rs);
            }
            if (DefaultSQLQueryProviderExecutor2.class.isInstance(sqlProvider) && !((DefaultSQLQueryProviderExecutor2)sqlProvider).closeResultSet) return;
        }
        catch (SQLException sqle) {
            block51: {
                DBSQLException providerEx;
                String err;
                block52: {
                    String dbType;
                    block50: {
                        block49: {
                            try {
                                logger.error((Object)("Execute SQL[" + sql + "] failed, cause by " + sqle.getMessage()), (Throwable)sqle);
                                dbType = "";
                                if (IDB2UDB.class.isInstance(this)) {
                                    dbType = "DB2";
                                } else if (ISqlServer.class.isInstance(this)) {
                                    dbType = "MS SqlServer";
                                } else if (IOracle.class.isInstance(this)) {
                                    dbType = "Oracle";
                                }
                                err = "Source SQL:[" + sql + "] failed! \nException:sqlcode[" + sqle.getErrorCode() + "] sqlstat[" + sqle.getSQLState() + "]!";
                                if (printProviderName) {
                                    err = "Execute provider[" + sqlProvider.getProviderName() + "] failed!\n" + err;
                                }
                                if (!ISyBase.class.isInstance(this) || sqle.getErrorCode() != 13905 || !"S1000".equals(sqle.getSQLState())) break block49;
                                logger.warn((Object)err, (Throwable)sqle);
                                if (DefaultSQLQueryProviderExecutor2.class.isInstance(sqlProvider) && !((DefaultSQLQueryProviderExecutor2)sqlProvider).closeResultSet) return;
                            }
                            catch (Throwable throwable) {
                                if (DefaultSQLQueryProviderExecutor2.class.isInstance(sqlProvider) && !((DefaultSQLQueryProviderExecutor2)sqlProvider).closeResultSet) throw throwable;
                                JDBCUtils.closeStatement(st);
                                throw throwable;
                            }
                            JDBCUtils.closeStatement(st);
                            return;
                        }
                        if (!IOracle.class.isInstance(this) || sqle.getErrorCode() != 1408 && sqle.getErrorCode() != 2264) break block50;
                        logger.warn((Object)err, (Throwable)sqle);
                        if (DefaultSQLQueryProviderExecutor2.class.isInstance(sqlProvider) && !((DefaultSQLQueryProviderExecutor2)sqlProvider).closeResultSet) return;
                        JDBCUtils.closeStatement(st);
                        return;
                    }
                    if (IDB2UDB.class.isInstance(this) && this.isRowLengthTooLongException(sqle)) {
                        logger.info((Object)"the exception is RowLengthExceedBPPageSize");
                        throw new RowLengthExceedBPPageSizeException("execute sql exception ,change to store procedure." + sqle.getMessage(), sqle, dbType);
                    }
                    if (sql.toUpperCase(Locale.ENGLISH).startsWith("SELECT NEWBOSID") && -4304 == sqle.getErrorCode()) {
                        if (IDB2UDB.class.isInstance(this)) {
                            throw new DBUuidClassFileNotExistException("Execute SQL[SELECT NEWBOSID('12345678')] error!" + sqle.getMessage(), dbType);
                        }
                        if (IDB400.class.isInstance(this)) {
                            // empty if block
                        }
                    }
                    if (sql.toUpperCase(Locale.ENGLISH).endsWith("T_SYS_DATACENTER")) {
                        if (IDB2UDB.class.isInstance(this) && -204 == sqle.getErrorCode()) {
                            throw new DBDCTableNotExistException("Datacenter table [T_SYS_DATACENTER] not exist," + sqle.getMessage(), dbType);
                        }
                        if (ISqlServer.class.isInstance(this) && 208 == sqle.getErrorCode()) {
                            throw new DBDCTableNotExistException("Datacenter table [T_SYS_DATACENTER] not exist," + sqle.getMessage(), dbType);
                        }
                        if (IOracle.class.isInstance(this) && 942 == sqle.getErrorCode()) {
                            throw new DBDCTableNotExistException("Datacenter table [T_SYS_DATACENTER] not exist," + sqle.getMessage(), dbType);
                        }
                    }
                    providerEx = new DBSQLException("Execute provider[" + sqlProvider.getProviderName() + "], sql[" + sql + "] failed, sqlcode[" + sqle.getErrorCode() + "] sqlstat[" + sqle.getSQLState() + "],Causedby[" + sqle.getMessage() + "]", dbType, sql, sql, sqle.getErrorCode(), sqle.getSQLState(), sqle.getMessage());
                    if (-204 != sqle.getErrorCode() && -84 != sqle.getErrorCode() && (!IDB2UDB.class.isInstance(this) || sqle.getErrorCode() != -612 && sqle.getErrorCode() != -803 && sqle.getErrorCode() != -601)) {
                        logger.error((Object)err, (Throwable)sqle);
                        AdditionalLog.getErrLogger().error((Object)err, (Throwable)sqle);
                        if (!sqlProvider.handleException(providerEx)) {
                            throw providerEx;
                        }
                        break block51;
                    }
                    if (!sql.toUpperCase(Locale.ENGLISH).startsWith("DROP PROCEDURE ") && !sql.toUpperCase(Locale.ENGLISH).endsWith("KSQL_TEMP_PROCEDURE")) break block52;
                    if (DefaultSQLQueryProviderExecutor2.class.isInstance(sqlProvider) && !((DefaultSQLQueryProviderExecutor2)sqlProvider).closeResultSet) return;
                    JDBCUtils.closeStatement(st);
                    return;
                }
                logger.error((Object)err, (Throwable)sqle);
                AdditionalLog.getErrLogger().error((Object)err, (Throwable)sqle);
                if (sqlProvider.handleException(providerEx)) break block51;
                throw providerEx;
            }
            if (DefaultSQLQueryProviderExecutor2.class.isInstance(sqlProvider) && !((DefaultSQLQueryProviderExecutor2)sqlProvider).closeResultSet) return;
            JDBCUtils.closeStatement(st);
            return;
        }
        JDBCUtils.closeStatement(st);
        return;
    }

    private boolean isRowLengthTooLongException(SQLException sqle) {
        if (sqle != null && sqle.getMessage() != null && sqle.getSQLState() != null && sqle.getSQLState().toUpperCase().contains("54010")) {
            logger.info((Object)("sql state:" + sqle.getSQLState()));
            return true;
        }
        if (sqle != null && sqle.getMessage() != null && sqle.getSQLState() != null && sqle.getSQLState().toUpperCase().contains("42837")) {
            logger.info((Object)("sql state:" + sqle.getSQLState()));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection detectConnection(Connection dbConnection) throws SQLException {
        Statement st = null;
        try {
            st = dbConnection.createStatement();
            st.execute(this.getDetectSql());
            Connection connection = dbConnection;
            return connection;
        }
        catch (SQLException e) {
            logger.warn((Object)("Detect db connection use[" + this.getDetectSql() + "] failed, create new physical db connection....."), (Throwable)e);
            Connection connection = dbConnection = this.getPhysicalDBConnection();
            return connection;
        }
        finally {
            if (null != st) {
                st.close();
            }
        }
    }

    @Override
    public void forceReleaseConnection() {
        this.connectionHolder.doConnectionClean();
    }

    public abstract String getDetectSql();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getTabPKeys(String catalog, String schema, String table) {
        HashMap<String, String> pkMap = new HashMap<String, String>();
        Connection con = null;
        ResultSet rs = null;
        try {
            con = this.getDBConnection();
            DatabaseMetaData md = con.getMetaData();
            rs = md.getPrimaryKeys(catalog, schema, table);
            while (rs.next()) {
                String tableName = rs.getObject(3).toString();
                String pkName = rs.getObject(4).toString();
                pkMap.put(pkName, tableName);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    Statement st = rs.getStatement();
                    JDBCUtils.closeResultSet(rs);
                    JDBCUtils.closeStatement(st);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return pkMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap compareTabRecCount(ResultSet[] srcResultset, ResultSet[] destResultset, TableDataTransferResult result) {
        try {
            HashMap<String, Integer> mapCompareReult = new HashMap<String, Integer>();
            int srcTabRecCnt = 0;
            int destTabRecCnt = 0;
            int diffRecCnt = 0;
            while (srcResultset[0].next()) {
                srcTabRecCnt = srcResultset[0].getInt(1);
            }
            while (destResultset[0].next()) {
                destTabRecCnt = destResultset[0].getInt(1);
            }
            diffRecCnt = Math.abs(srcTabRecCnt - destTabRecCnt);
            mapCompareReult.put(new String("SrcTabRecCount"), new Integer(srcTabRecCnt));
            mapCompareReult.put(new String("DestTabRecCount"), new Integer(destTabRecCnt));
            mapCompareReult.put(new String("DiffRecCount"), new Integer(diffRecCnt));
            HashMap<String, Integer> hashMap = mapCompareReult;
            return hashMap;
        }
        catch (Exception e) {
            result.transferException = e;
            e.printStackTrace();
            HashMap hashMap = null;
            return hashMap;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap compareTabRecDetail(ResultSet[] srcResultset, ResultSet[] destResultset, int srcTabRecCnt, int destTabRecCnt, SqlTable destTable, TableDataTransferResult result) {
        try {
            HashMap<String, Integer> mapCompareReult = new HashMap<String, Integer>();
            if (srcTabRecCnt != destTabRecCnt) {
                HashMap hashMap = null;
                return hashMap;
            }
            int curRowIndex = 0;
            int differRowCount = 0;
            while (srcResultset[0].next() && destResultset[0].next()) {
                ++curRowIndex;
                Iterator destColIterator = destTable.columns.iterator();
                int colIndex = 0;
                int differColCount = 0;
                while (destColIterator.hasNext()) {
                    Object destColumnValue;
                    Object srcColumnValue;
                    ++colIndex;
                    SqlColumn destCol = (SqlColumn)destColIterator.next();
                    if (destCol.dataType.indexOf("BLOB") != -1 || destCol.dataType.indexOf("CLOB") != -1 || destCol.dataType.indexOf("LONG") != -1) continue;
                    if (destCol.dataType.equals("INT")) {
                        srcColumnValue = String.valueOf(srcResultset[0].getInt(colIndex));
                        destColumnValue = String.valueOf(destResultset[0].getInt(colIndex));
                        if (srcColumnValue != null && srcColumnValue != null) {
                            if (((String)srcColumnValue).equals(destColumnValue)) continue;
                            ++differColCount;
                            if (differRowCount != 0) continue;
                            logger.warn((Object)("Row [" + curRowIndex + "][" + colIndex + "],Column [" + destCol.getName() + "] is not equals. Src values [" + ((String)srcColumnValue).toString() + "] Dest values [" + ((String)destColumnValue).toString() + "]"));
                            continue;
                        }
                        if (srcColumnValue != null && destColumnValue == null) {
                            ++differColCount;
                            if (differRowCount != 0) continue;
                            logger.warn((Object)("Row [" + curRowIndex + "],Column [" + destCol.getName() + "] is not equals,src not null but dest is null."));
                            continue;
                        }
                        if (srcColumnValue != null || destColumnValue == null) continue;
                        ++differColCount;
                        if (differRowCount != 0) continue;
                        logger.warn((Object)("Row [" + curRowIndex + "],Column [" + destCol.getName() + "] is not equals,src is null but dest not null."));
                        continue;
                    }
                    if (destCol.dataType.equals("DECIMAL")) {
                        srcColumnValue = String.valueOf(srcResultset[0].getDouble(colIndex));
                        destColumnValue = String.valueOf(destResultset[0].getDouble(colIndex));
                        if (srcColumnValue != null && srcColumnValue != null) {
                            if (((String)srcColumnValue).equals(destColumnValue)) continue;
                            ++differColCount;
                            logger.warn((Object)("Row [" + curRowIndex + "][" + colIndex + "],Column [" + destCol.getName() + "] is not equals. Src values [" + ((String)srcColumnValue).toString() + "] Dest values [" + ((String)destColumnValue).toString() + "]"));
                            continue;
                        }
                        if (srcColumnValue != null && destColumnValue == null) {
                            ++differColCount;
                            if (differRowCount != 0) continue;
                            logger.warn((Object)("Row [" + curRowIndex + "],Column [" + destCol.getName() + "] is not equals,src not null but dest is null."));
                            continue;
                        }
                        if (srcColumnValue != null || destColumnValue == null) continue;
                        ++differColCount;
                        if (differRowCount != 0) continue;
                        logger.warn((Object)("Row [" + curRowIndex + "],Column [" + destCol.getName() + "] is not equals,src is null but dest not null."));
                        continue;
                    }
                    if (destCol.dataType.equals("DATETIME")) {
                        srcColumnValue = String.valueOf(srcResultset[0].getTimestamp(colIndex));
                        destColumnValue = String.valueOf(destResultset[0].getTimestamp(colIndex));
                        if (srcColumnValue != null && srcColumnValue != null) {
                            if (((String)srcColumnValue).equals(destColumnValue)) continue;
                            ++differColCount;
                            logger.warn((Object)("Row [" + curRowIndex + "][" + colIndex + "],Column [" + destCol.getName() + "] is not equals. Src values [" + ((String)srcColumnValue).toString() + "] Dest values [" + ((String)destColumnValue).toString() + "]"));
                            continue;
                        }
                        if (srcColumnValue != null && destColumnValue == null) {
                            ++differColCount;
                            if (differRowCount != 0) continue;
                            logger.warn((Object)("Row [" + curRowIndex + "],Column [" + destCol.getName() + "] is not equals,src not null but dest is null."));
                            continue;
                        }
                        if (srcColumnValue != null || destColumnValue == null) continue;
                        ++differColCount;
                        if (differRowCount != 0) continue;
                        logger.warn((Object)("Row [" + curRowIndex + "],Column [" + destCol.getName() + "] is not equals,src is null but dest not null."));
                        continue;
                    }
                    srcColumnValue = srcResultset[0].getObject(colIndex);
                    destColumnValue = destResultset[0].getObject(colIndex);
                    if (srcColumnValue != null && String.valueOf(srcColumnValue).length() > 0 && destColumnValue != null && String.valueOf(destColumnValue).length() > 0) {
                        if (srcColumnValue.equals(destColumnValue)) continue;
                        ++differColCount;
                        if (differRowCount != 0) continue;
                        logger.warn((Object)("Row [" + curRowIndex + "][" + colIndex + "],Column [" + destCol.getName() + "] is not equals. Src values [" + srcColumnValue.toString() + "] Dest values [" + destColumnValue.toString() + "]"));
                        continue;
                    }
                    if (srcColumnValue != null && String.valueOf(srcColumnValue).length() > 0 && (destColumnValue == null || String.valueOf(destColumnValue).length() == 0)) {
                        ++differColCount;
                        if (differRowCount != 0) continue;
                        logger.warn((Object)("Row [" + curRowIndex + "],Column [" + destCol.getName() + "] is not equals,src not null but dest is null."));
                        continue;
                    }
                    if (srcColumnValue != null && String.valueOf(srcColumnValue).length() != 0 || destColumnValue == null || String.valueOf(destColumnValue).length() <= 0) continue;
                    ++differColCount;
                    if (differRowCount != 0) continue;
                    logger.warn((Object)("Row [" + curRowIndex + "],Column [" + destCol.getName() + "] is not equals,src is null but dest not null."));
                }
                if (differColCount <= 0) continue;
                ++differRowCount;
            }
            mapCompareReult.put(new String("SrcTabRecCount"), new Integer(srcTabRecCnt));
            mapCompareReult.put(new String("DestTabRecCount"), new Integer(destTabRecCnt));
            mapCompareReult.put(new String("DiffRecCount"), new Integer(differRowCount));
            HashMap<String, Integer> hashMap = mapCompareReult;
            return hashMap;
        }
        catch (Exception e) {
            result.transferException = e;
            e.printStackTrace();
            HashMap hashMap = null;
            return hashMap;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferResultsetToTable(ResultSet srcResultset, SqlTable destTable, boolean ignorePrimaryKeyConfilc, boolean deleteOldData, TableDataTransferResult result) {
        try {
            StringBuffer sql = new StringBuffer();
            Iterator destColumnIterator = destTable.columns.iterator();
            boolean hasContainsLOB = false;
            Connection destConnection = this.getDBConnection();
            if (deleteOldData) {
                this.executeSql("delete from " + destTable.getName());
            }
            while (destColumnIterator.hasNext()) {
                SqlColumn tmpCol = (SqlColumn)destColumnIterator.next();
                if (tmpCol.dataType.indexOf("LOB") >= 0) {
                    hasContainsLOB = true;
                }
                sql.append(tmpCol.getName()).append(",");
            }
            sql.deleteCharAt(sql.length() - 1);
            if (hasContainsLOB) {
                if (SqlServer.class.isInstance(this)) {
                    this.doResultsetInsert(srcResultset, destTable, destConnection, sql, hasContainsLOB, ignorePrimaryKeyConfilc, result);
                } else {
                    this.doObjectInsert(srcResultset, destTable, destConnection, sql, hasContainsLOB, ignorePrimaryKeyConfilc, result);
                }
            } else if (DB2UDB.class.isInstance(this) && !DB400.class.isInstance(this)) {
                this.doObjectInsert(srcResultset, destTable, destConnection, sql, hasContainsLOB, ignorePrimaryKeyConfilc, result);
            } else {
                this.doResultsetInsert(srcResultset, destTable, destConnection, sql, hasContainsLOB, ignorePrimaryKeyConfilc, result);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error", (Throwable)ex);
            result.transferException = ex;
            return;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doObjectInsert(ResultSet srcResultset, SqlTable destTable, Connection destConnection, StringBuffer sql, boolean hasContainsLOB, boolean ignorePrimaryKeyConfilc, TableDataTransferResult result) {
        sql.insert(0, "INSERT INTO " + destTable.getName() + " (").append(") VALUES (");
        for (i = 0; i < destTable.columns.size(); ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        stmt = null;
        destSQL = sql.toString();
        if (SyBase.class.isInstance(this)) {
            destSQL = destSQL.toLowerCase();
        }
        AbstractDB.logger.debug((Object)("TransferData to destination use sql [" + destSQL + "] ..."));
        stmt = destConnection.prepareStatement(destSQL);
        curRowIndex = 0;
        batchRowSize = 0;
lbl18:
        // 6 sources

        while (srcResultset.next()) {
            ++curRowIndex;
            destColIterator = destTable.columns.iterator();
            colIndex = 0;
            ** GOTO lbl34
        }
        ** GOTO lbl-1000
        {
            block35: {
                catch (Throwable e) {
                    try {
                        result.transferException = e;
                        JDBCUtils.closeStatement(stmt);
                        return;
                    }
                    catch (Throwable var16_22) {
                        throw var16_22;
                    }
                    finally {
                        JDBCUtils.closeStatement(stmt);
                    }
                }
lbl34:
                // 15 sources

                while (destColIterator.hasNext()) {
                    ++colIndex;
                    destCol = (SqlColumn)destColIterator.next();
                    if (destCol.dataType.equals("INT")) {
                        value = srcResultset.getObject(colIndex);
                        if (value != null) {
                            stmt.setObject(colIndex, value);
                            continue;
                        }
                        stmt.setNull(colIndex, 4);
                        continue;
                    }
                    if (destCol.dataType.equals("DECIMAL")) {
                        value = srcResultset.getObject(colIndex);
                        if (value != null) {
                            stmt.setObject(colIndex, value);
                            continue;
                        }
                        stmt.setNull(colIndex, 3);
                        continue;
                    }
                    if (destCol.dataType.indexOf("CHAR") >= 0) {
                        value = srcResultset.getString(colIndex);
                        if (value != null) {
                            stmt.setString(colIndex, (String)value);
                            continue;
                        }
                        stmt.setNull(colIndex, 12);
                        continue;
                    }
                    if (destCol.dataType.indexOf("CLOB") >= 0) {
                        value = srcResultset.getString(colIndex);
                        if (value != null) {
                            stmt.setString(colIndex, (String)value);
                            continue;
                        }
                        stmt.setString(colIndex, "");
                        continue;
                    }
                    if (destCol.dataType.indexOf("BLOB") >= 0) {
                        value = srcResultset.getBytes(colIndex);
                        if (value != null) {
                            stmt.setBytes(colIndex, (byte[])value);
                            continue;
                        }
                        if (SqlServer.class.isInstance(this)) {
                            stmt.setBytes(colIndex, null);
                            continue;
                        }
                        stmt.setNull(colIndex, 2004);
                        continue;
                    }
                    if (destCol.dataType.indexOf("TIME") >= 0) {
                        value = srcResultset.getTimestamp(colIndex);
                        if (value != null) {
                            stmt.setTimestamp(colIndex, (Timestamp)value);
                            continue;
                        }
                        stmt.setNull(colIndex, 93);
                        continue;
                    }
                    value = srcResultset.getObject(colIndex);
                    if (value != null) {
                        stmt.setObject(colIndex, value);
                        continue;
                    }
                    result.transferException = new RuntimeException("Unsupport null value insert on table[" + destTable.getName() + "] column[" + destCol.getName() + "] row[" + curRowIndex + "]!");
                    JDBCUtils.closeStatement(stmt);
                    JDBCUtils.closeStatement(stmt);
                    return;
                }
                if (!hasContainsLOB) ** GOTO lbl-1000
                try {
                    stmt.executeUpdate();
                    ++result.sucessRowCount;
                    ** GOTO lbl18
                }
                catch (SQLException sqle) {}
                if (!this.isPrimarykeyValidationException(sqle) || !ignorePrimaryKeyConfilc) break block35;
                ++result.failedRowCount;
                ** GOTO lbl18
            }
            ++result.failedRowCount;
            result.transferException = sqle;
            JDBCUtils.closeStatement(stmt);
            JDBCUtils.closeStatement(stmt);
            return;
        }
lbl-1000:
        // 1 sources

        {
            try {
                stmt.addBatch();
                if (++batchRowSize != 100) ** GOTO lbl18
                stmt.executeBatch();
                result.sucessRowCount += batchRowSize;
                batchRowSize = 0;
                ** GOTO lbl18
            }
            catch (SQLException sqle) {
                block36: {
                    if (!this.isPrimarykeyValidationException(sqle.getNextException()) || !ignorePrimaryKeyConfilc) break block36;
                    result.failedRowCount += batchRowSize;
                    ** GOTO lbl18
                }
                AbstractDB.logger.error((Object)sqle);
                result.failedRowCount += batchRowSize;
                sqlException = new SQLException("Exception while transfer row [" + (curRowIndex - batchRowSize) + "--" + curRowIndex + "]");
                sqlException.setNextException(sqle);
                result.transferException = sqlException;
                result.transferException = sqle;
                JDBCUtils.closeStatement(stmt);
                JDBCUtils.closeStatement(stmt);
                return;
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                if (batchRowSize > 0) {
                    stmt.executeBatch();
                    result.sucessRowCount += batchRowSize;
                    batchRowSize = 0;
                }
            }
            catch (SQLException sqle) {
                AbstractDB.logger.warn((Object)("Exception while do object insert! sqlcode[" + sqle.getErrorCode() + "] sqlstat[" + sqle.getSQLState() + "], sqlmessage[" + sqle.getMessage() + "]!"));
                if (this.isPrimarykeyValidationException(sqle.getNextException()) && ignorePrimaryKeyConfilc) {
                    result.failedRowCount += batchRowSize;
                }
                AbstractDB.logger.error((Object)sqle);
                result.failedRowCount += batchRowSize;
                sqlException = new SQLException("Exception while transfer row [" + (curRowIndex - batchRowSize) + "--" + curRowIndex + "]");
                sqlException.setNextException(sqle);
                result.transferException = sqlException;
                result.transferException = sqle;
                JDBCUtils.closeStatement(stmt);
                JDBCUtils.closeStatement(stmt);
                return;
            }
        }
        {
            JDBCUtils.closeStatement(stmt);
        }
        JDBCUtils.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doResultsetInsert(ResultSet srcResultset, SqlTable destTable, Connection destConnection, StringBuffer sql, boolean hasContainsLOB, boolean ignorePrimaryKeyConfilc, TableDataTransferResult result) {
        sql.insert(0, "SELECT ").append(" FROM ").append(destTable.getName());
        stmt = null;
        destResultset = null;
        destSQL = sql.toString();
        try {
            if (SqlServer.class.isInstance(this)) {
                stmt = destConnection.createStatement(1003, 1008);
            } else if (SyBase.class.isInstance(this)) {
                stmt = destConnection.createStatement(1004, 1008);
                destSQL = destSQL.toLowerCase();
            } else {
                stmt = destConnection.createStatement(1004, 1008);
            }
            AbstractDB.logger.debug((Object)("TransferData to destination use sql [" + destSQL + "] ..."));
            destResultset = stmt.executeQuery(destSQL);
            curRowIndex = 0;
lbl18:
            // 3 sources

            while (srcResultset.next()) {
                ++curRowIndex;
                destResultset.moveToInsertRow();
                destColIterator = destTable.columns.iterator();
                colIndex = 0;
                while (destColIterator.hasNext()) {
                    ++colIndex;
                    destCol = (SqlColumn)destColIterator.next();
                    if (destCol.dataType.equals("INT")) {
                        value = srcResultset.getObject(colIndex);
                        if (value != null) {
                            destResultset.updateObject(colIndex, value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.dataType.equals("DECIMAL")) {
                        value = srcResultset.getObject(colIndex);
                        if (value != null) {
                            destResultset.updateObject(colIndex, value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.dataType.indexOf("CHAR") >= 0) {
                        value = srcResultset.getString(colIndex);
                        if (value != null) {
                            destResultset.updateString(colIndex, (String)value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.dataType.indexOf("CLOB") >= 0) {
                        value = srcResultset.getString(colIndex);
                        if (value != null) {
                            destResultset.updateString(colIndex, (String)value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.dataType.indexOf("BLOB") >= 0) {
                        value = srcResultset.getBytes(colIndex);
                        if (value != null) {
                            destResultset.updateBytes(colIndex, (byte[])value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.dataType.indexOf("TIME") >= 0) {
                        value = srcResultset.getTimestamp(colIndex);
                        if (value != null) {
                            destResultset.updateTimestamp(colIndex, (Timestamp)value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    value = srcResultset.getObject(colIndex);
                    if (value != null) {
                        destResultset.updateObject(colIndex, value);
                        continue;
                    }
                    result.transferException = new RuntimeException("Unsupport null value insert on table[" + destTable.getName() + "] column[" + destCol.getName() + "] row[" + curRowIndex + "]!");
                    JDBCUtils.closeStatement(stmt);
                    if (null == destResultset) ** GOTO lbl99
                    ** GOTO lbl94
                }
                ** GOTO lbl-1000
            }
            ** GOTO lbl-1000
        }
        catch (Exception e) {
            block40: {
                block41: {
                    try {
                        result.transferException = e;
                        JDBCUtils.closeStatement(stmt);
                        if (null != destResultset) {
                        }
                        break block40;
                    }
                    catch (Throwable var17_22) {
                        if (null != destResultset) {
                            try {
                                destResultset.close();
                            }
                            catch (SQLException e) {
                                AbstractDB.logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        JDBCUtils.closeStatement(stmt);
                        throw var17_22;
                    }
lbl94:
                    // 1 sources

                    try {
                        destResultset.close();
                    }
                    catch (SQLException e) {
                        AbstractDB.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
lbl99:
                    // 3 sources

                    JDBCUtils.closeStatement(stmt);
                    return;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            destResultset.insertRow();
                            ++result.sucessRowCount;
                            ** GOTO lbl18
                        }
                        catch (SQLException sqle) {
                            block42: {
                                AbstractDB.logger.warn((Object)("Exception while do result insert! sqlcode[" + sqle.getErrorCode() + "] sqlstat[" + sqle.getSQLState() + "], sqlmessage[" + sqle.getMessage() + "]!"));
                                if (!this.isPrimarykeyValidationException(sqle) || !ignorePrimaryKeyConfilc) break block42;
                                ++result.failedRowCount;
                                ** GOTO lbl18
                            }
                            AbstractDB.logger.error((Object)sqle);
                            ++result.failedRowCount;
                            sqlException = new SQLException("Exception while transfer row [" + curRowIndex + "]");
                            sqlException.setNextException(sqle);
                            result.transferException = sqlException;
                            JDBCUtils.closeStatement(stmt);
                            if (null != destResultset) {
                                try {
                                    destResultset.close();
                                }
                                catch (SQLException e) {
                                    AbstractDB.logger.error((Object)e.getMessage(), (Throwable)e);
                                }
                            }
                            JDBCUtils.closeStatement(stmt);
                            return;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        JDBCUtils.closeStatement(stmt);
                        if (null == destResultset) break block41;
                    }
                    try {
                        destResultset.close();
                    }
                    catch (SQLException e) {
                        AbstractDB.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                JDBCUtils.closeStatement(stmt);
                return;
                try {
                    destResultset.close();
                }
                catch (SQLException e) {
                    AbstractDB.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            JDBCUtils.closeStatement(stmt);
            return;
        }
    }

    protected boolean isPrimarykeyValidationException(SQLException sqle) {
        for (SQLException ex = sqle; ex != null; ex = ex.getNextException()) {
            String state = ex.getSQLState();
            int code = ex.getErrorCode();
            logger.error((Object)(" SQLSTATE: " + ex.getSQLState() + " Error code: " + ex.getErrorCode()));
            if (!(SqlServer.class.isInstance(this) ? code != 2627 : (DB2UDB.class.isInstance(this) ? !"23505".equals(state) : Oracle.class.isInstance(this) && !"23000".equals(state)))) continue;
            return false;
        }
        return true;
    }

    class TT
    implements CompositeSqlProvider {
        ArrayList providerList;
        int index = 0;

        public TT(ArrayList list) {
            this.providerList = list;
        }

        @Override
        public SqlProvider getNextSqlProvider() {
            if (this.index < this.providerList.size()) {
                return (SqlProvider)this.providerList.get(this.index++);
            }
            return null;
        }

        @Override
        public boolean handleException(DBSQLException sqle) {
            return false;
        }
    }
}

