/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.AbstractDB;
import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.CreateDBInfo;
import com.kingdee.shr.dydeploy.web.executeSql.DB400VO;
import com.kingdee.shr.dydeploy.web.executeSql.DBException;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLQueryProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.IDB400;
import com.kingdee.shr.dydeploy.web.executeSql.IJTOpenDriver;
import com.kingdee.shr.dydeploy.web.executeSql.JDBCDriverFactory;
import com.kingdee.shr.dydeploy.web.executeSql.RowCallbackHandler;
import com.kingdee.shr.dydeploy.web.executeSql.SqlTable;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DB400
extends AbstractDB
implements IDB400 {
    private static final Logger logger = Logger.getLogger(DB400.class);
    private static final String SQL_RUN_STATISTICS = "CALL ADMIN_CMD(''RUNSTATS ON TABLE {0}.{1} AND INDEXES ALL'')";
    private static final String SQL_GET_TABLE_VIEW = "SELECT NAME FROM SYSTABLES WHERE TYPE ='V' OR TYPE ='T' AND TABLE_SCHEMA = ? ORDER BY NAME";
    private static final String SQL_GET_FK_LIST = "SELECT CONSTRAINT_NAME PK_NAME,TABLE_NAME TABLE_NAME FROM SYSCST WHERE CONSTRAINT_TYPE = 'PRIMARY KEY' AND CONSTRAINT_SCHEMA =?";
    private static final String SQL_GET_INVALID_VIEW_LIST = "SELECT * FROM SYSTABLES WHERE TYPE ='V' AND (VALID = 'N' OR VALID = 'X') AND TABLE_SCHEMA = ?";
    private IJTOpenDriver jtopenDriver = null;
    private DB400VO db400;

    public DB400(DB400VO dbvo) {
        this.db400 = dbvo;
        this.jtopenDriver = (IJTOpenDriver)JDBCDriverFactory.getDBDriver(dbvo);
    }

    @Override
    public String getJDBCDriverClassName() {
        return this.jtopenDriver.getDriverClassName();
    }

    @Override
    public String getJDBCUrl(DatabaseVO dbVO) {
        return this.jtopenDriver.getJDBCUrl(dbVO);
    }

    @Override
    protected Connection getPhysicalDBConnection() throws SQLException {
        this.testDBPort(this.db400);
        Properties props = new Properties();
        props.setProperty("user", this.db400.getDbUserName());
        props.setProperty("password", this.db400.getDbPassword());
        logger.info((Object)("Create physical db400 connection with user [" + props.getProperty("user") + "]"));
        return this.jtopenDriver.connect(this.getJDBCUrl(this.db400), props);
    }

    @Override
    public SqlTable[] getDBTableAndViews() {
        final ArrayList tablesList = new ArrayList();
        try {
            this.executeQueryWithSingleParam(SQL_GET_TABLE_VIEW, this.db400.getSchemaName(), new RowCallbackHandler(){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tbName = rs.getString(1);
                    String type = rs.getString(2);
                    SqlTable table = new SqlTable(tbName, "V".equalsIgnoreCase(type.trim()));
                    tablesList.add(table);
                }
            });
            return tablesList.toArray(new SqlTable[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get db/400 table and view failed!", e);
            throw new AdminException("Get db/400 table and view failed!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            DatabaseMetaData meta = conn.getMetaData();
            logger.info((Object)("DB2/400 ProductVersion: " + meta.getDatabaseProductVersion()));
            String string = meta.getDatabaseProductVersion().substring(3);
            return string;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    @Override
    public String[] getDatabaseUserList() {
        return null;
    }

    @Override
    public void createDatabase(DatabaseVO dbVO, CreateDBInfo info) throws SQLException {
    }

    @Override
    public HashMap getDBFKList(String dbSchema, String tableName) {
        final HashMap fkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT CONSTRAINT_NAME PK_NAME,TABLE_NAME TABLE_NAME FROM SYSCST WHERE CONSTRAINT_TYPE = 'PRIMARY KEY' AND CONSTRAINT_SCHEMA ='" + dbSchema.toUpperCase() + "' AND TABLE_NAME='" + tableName + "'" : "SELECT CONSTRAINT_NAME PK_NAME,TABLE_NAME TABLE_NAME FROM SYSCST WHERE CONSTRAINT_TYPE = 'PRIMARY KEY' AND CONSTRAINT_SCHEMA ='" + dbSchema.toUpperCase() + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    fkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get DB400 DB FK list failed!", e);
            throw new AdminException("Get DB400 DB FK list failed!", e);
        }
        return fkList;
    }

    @Override
    public void rebuildDisabledView() throws Exception {
    }

    private ArrayList processCreateViewsSQL(ArrayList viewList) {
        ArrayList<String> failedSQLList = new ArrayList<String>();
        for (int i = 0; i < viewList.size(); ++i) {
            String viewSQL = (String)viewList.get(i);
            try {
                logger.debug((Object)("Execute sql [" + viewSQL + "] on DB2/400 database!"));
                this.executeSql(viewSQL);
                continue;
            }
            catch (Exception ex) {
                failedSQLList.add(viewSQL);
                logger.warn((Object)("Execute sql [" + viewSQL + "] on DB2/400 database error !"));
            }
        }
        return failedSQLList;
    }

    @Override
    public void runStatics(Connection conn, String tableName) {
        String sql = MessageFormat.format(SQL_RUN_STATISTICS, this.db400.getDbUserName(), tableName);
        this.executeSqlProvider(conn, new DefaultSQLProviderExecutor(sql, false));
    }

    @Override
    public ArrayList getDBTableList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "SELECT NAME FROM SYSTABLES WHERE TYPE ='T' AND TABLE_SCHEMA = '" + dbSchema.toUpperCase() + "' ORDER BY NAME";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get table list failed!", e);
            throw new DBException("Get table list form db error", e);
        }
        return tableList;
    }

    @Override
    public ArrayList getDBViewList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "SELECT NAME FROM SYSTABLES WHERE TYPE ='V'   AND TABLE_SCHEMA = '" + dbSchema.toUpperCase() + "' ORDER BY NAME";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get view list failed!", e);
            throw new DBException("Get view list form db error", e);
        }
        return tableList;
    }

    @Override
    public HashMap getDBPKList(String dbSchema, String tableName) {
        final HashMap pkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT CONSTRAINT_NAME PK_NAME,TABLE_NAME TABLE_NAME FROM SYSCST WHERE CONSTRAINT_TYPE = 'PRIMARY KEY' AND CONSTRAINT_SCHEMA = '" + dbSchema.toUpperCase() + "' AND TABLE_NAME='" + tableName + "'" : "SELECT CONSTRAINT_NAME PK_NAME,TABLE_NAME TABLE_NAME FROM SYSCST WHERE CONSTRAINT_TYPE = 'PRIMARY KEY' AND CONSTRAINT_SCHEMA = '" + dbSchema.toUpperCase() + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    pkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get pk list failed!", e);
            throw new DBException("Get pk list form db error", e);
        }
        return pkList;
    }

    @Override
    public HashMap getDBIndexList(String dbSchema) {
        final HashMap indexList = new HashMap();
        try {
            String sql = "SELECT NAME,TBNAME FROM SYSINDEXES WHERE INDEX_SCHEMA = '" + dbSchema.toUpperCase() + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    indexList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get index list failed!", e);
            throw new DBException("Get index list form db error", e);
        }
        return indexList;
    }

    @Override
    public String getID() {
        return "db400" + this.db400.getID();
    }

    @Override
    public String getDetectSql() {
        return "SELECT 1 FROM SYSIBM.SYSDUMMY1";
    }
}

