/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.AbstractDB;
import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.CreateDBInfo;
import com.kingdee.shr.dydeploy.web.executeSql.DBException;
import com.kingdee.shr.dydeploy.web.executeSql.DBInstanceNotExistException;
import com.kingdee.shr.dydeploy.web.executeSql.DBLoginException;
import com.kingdee.shr.dydeploy.web.executeSql.DMVO;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLQueryProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.IDM;
import com.kingdee.shr.dydeploy.web.executeSql.IDmDriver;
import com.kingdee.shr.dydeploy.web.executeSql.QueryForObjectSQLProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.RowCallbackHandler;
import com.kingdee.shr.dydeploy.web.executeSql.SqlTable;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DM
extends AbstractDB
implements IDM {
    private static final Logger logger = Logger.getLogger(DM.class);
    private DMVO dm;
    private IDmDriver dmDriver = null;

    public DM(DMVO dbvo) {
        this.dm = dbvo;
        this.dmDriver = null;
    }

    @Override
    protected Connection getPhysicalDBConnection() throws SQLException {
        this.testDBPort(this.dm);
        Properties props = new Properties();
        props.setProperty("user", this.dm.getDbUserName());
        props.setProperty("password", this.dm.getDbPassword());
        if ("sys".equalsIgnoreCase(this.dm.getDbUserName())) {
            props.put("internal_logon", "sysdba");
            logger.info((Object)"Get Oracle connection with sysdba ......");
        }
        logger.info((Object)("Create physical dm connection with user [" + props.getProperty("user") + "]"));
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.getJDBCUrl(this.dm), this.dm.getDbUserName(), this.dm.getDbPassword());
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 1017 || ex.getErrorCode() == 17443) {
                logger.error((Object)("Create dm connection error,login failed," + ex));
                throw new DBLoginException("Create dm connection error,login failed," + ex.getMessage(), this.dm.getDBType(), this.dm.getDbUserName(), this.dm.getDisplayAddress(), this.dm.getDbPort());
            }
            if (ex.getErrorCode() == 0) {
                logger.error((Object)("Create dm connection error,get DBInstance failed," + ex));
                throw new DBInstanceNotExistException("Create dm connection error,get DBInstance failed,", this.dm.getDBType(), this.dm.getDisplayDBName(), this.dm.getDisplayAddress(), this.dm.getDbPort());
            }
            throw new DBLoginException("Create dm connection error,login failed," + ex.getMessage(), this.dm.getDBType(), this.dm.getDbUserName(), this.dm.getDisplayAddress(), this.dm.getDbPort());
        }
        return conn;
    }

    @Override
    public String getDetectSql() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public void createDatabase(DatabaseVO dbVO, CreateDBInfo info) throws SQLException {
    }

    @Override
    public HashMap getDBFKList(String dbSchema, String tableName) {
        final HashMap fkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT CONSTRAINT_NAME AS FK_NAME,TABLE_NAME  FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'R' AND TABLE_NAME='" + tableName + "'" : "SELECT CONSTRAINT_NAME AS FK_NAME,TABLE_NAME  FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'R' AND TABLE_NAME LIKE 'T_%'";
            this.executeQuery(sql, new RowCallbackHandler(){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    fkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get oracle DB FK list failed!", e);
            throw new AdminException("Get oracle DB FK list failed!", e);
        }
        return fkList;
    }

    @Override
    public HashMap getDBIndexList(String dbSchema) {
        final HashMap indexList = new HashMap();
        try {
            String sql = "SELECT INDEX_NAME AS NAME,TABLE_NAME AS TBName,INDEX_TYPE,TABLE_TYPE FROM USER_INDEXES";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    indexList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get index list failed!", e);
            throw new DBException("Get index list form db error", e);
        }
        return indexList;
    }

    @Override
    public HashMap getDBPKList(String dbSchema, String tableName) {
        final HashMap pkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT CONSTRAINT_NAME AS PK_NAME,TABLE_NAME  FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'P' AND TABLE_NAME='" + tableName.toUpperCase() + "'" : "SELECT CONSTRAINT_NAME AS PK_NAME,TABLE_NAME  FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'P'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    pkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get pk list failed!", e);
            throw new DBException("Get pk list form db error", e);
        }
        return pkList;
    }

    @Override
    public SqlTable[] getDBTableAndViews() {
        final ArrayList tablesList = new ArrayList();
        try {
            ArrayList<String> sqlList = new ArrayList<String>();
            sqlList.add("SELECT TABLE_NAME, 'T' FROM USER_TABLES  ORDER BY TABLE_NAME");
            sqlList.add("SELECT VIEW_NAME, 'V' FROM USER_VIEWS  ORDER BY VIEW_NAME");
            this.execute(new DefaultSQLQueryProviderExecutor(sqlList){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tbName = rs.getString(1);
                    String type = rs.getString(2);
                    SqlTable table = new SqlTable(tbName, "V".equalsIgnoreCase(type.trim()));
                    tablesList.add(table);
                }
            });
            return tablesList.toArray(new SqlTable[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get oracle table and view failed!", e);
            throw new AdminException("Get oracle table and view failed!", e);
        }
    }

    @Override
    public ArrayList getDBTableList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "SELECT TABLE_NAME FROM USER_TABLES  ORDER BY TABLE_NAME";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get table list failed!", e);
            throw new DBException("Get table list form db error", e);
        }
        return tableList;
    }

    @Override
    public ArrayList getDBViewList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "SELECT VIEW_NAME FROM USER_VIEWS  ORDER BY VIEW_NAME";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get view list failed!", e);
            throw new DBException("Get view list form db error", e);
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDatabaseUserList() {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        Statement statement = null;
        ResultSet set = null;
        try {
            Class.forName("dm.jdbc.driver.DmDriver");
            connection = this.getPhysicalDBConnection();
            statement = connection.createStatement();
            set = statement.executeQuery("select UserName from All_Users");
            while (set.next()) {
                list.add(set.getString(1));
            }
            String[] dbList = list.toArray(new String[list.size()]);
            String[] stringArray = dbList = StringUtils.sortStringArray(dbList);
            return stringArray;
        }
        catch (Exception ex) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (set != null) {
                try {
                    set.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getID() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            DatabaseMetaData meta = conn.getMetaData();
            logger.info((Object)("DM ProductVersion: " + meta.getDatabaseProductVersion()));
            String string = meta.getDatabaseMajorVersion() + "." + meta.getDatabaseMinorVersion();
            return string;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    @Override
    public String getJDBCDriverClassName() {
        return "dm.jdbc.driver.DmDriver";
    }

    @Override
    public String getJDBCUrl(DatabaseVO dbVO) {
        DMVO dmVO = (DMVO)dbVO;
        String jdbc_str = "jdbc:dm://" + dmVO.getDbAddress() + ":" + dmVO.getDbPort() + "?rewriteBatchedStatements=true&comOra=true";
        return jdbc_str;
    }

    @Override
    public void runStatics(Connection conn, String tableName) {
    }

    @Override
    public String[] getDatabaseList() {
        return null;
    }

    public static void main(String[] args) {
    }

    @Override
    public String getInstanceChartset() {
        QueryForObjectSQLProviderExecutor executor = new QueryForObjectSQLProviderExecutor("SELECT * FROM NLS_DATABASE_PARAMETERS WHERE PARAMETER='NLS_NCHAR_CHARACTERSET'", "VALUE");
        this.execute(executor);
        return (String)executor.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTablespaceExist(String spaceName) {
        ArrayList<String> sameNameSpaceList = new ArrayList<String>();
        String checkTableSpaceSql = "select * from DBA_TABLESPACES WHERE TABLESPACE_NAME = '" + spaceName + "'";
        Statement statement = null;
        ResultSet set = null;
        Connection connection = null;
        try {
            Class.forName("dm.jdbc.driver.DmDriver");
            connection = this.getPhysicalDBConnection();
            statement = connection.createStatement();
            set = statement.executeQuery(checkTableSpaceSql);
            if (set.next()) {
                sameNameSpaceList.add("sameName");
            }
            boolean bl = sameNameSpaceList.size() > 0;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (set != null) {
                try {
                    set.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

