/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.bos.db.ITempTableMonitorService;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.exception.DB2DropColumnException;
import com.kingdee.bos.sql.exception.DBNotSupportedException;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.shr.dydeploy.web.executeSql.DB2VO;
import com.kingdee.shr.dydeploy.web.executeSql.DB400VO;
import com.kingdee.shr.dydeploy.web.executeSql.DBException;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import org.apache.log4j.Logger;

public class KSQLProvider {
    private static final Logger logger = Logger.getLogger(KSQLProvider.class);
    private ITempTableMonitorService monitorService = null;
    private String sessionId;

    public static int getDBType(DatabaseVO dbvo) {
        int dbType;
        if ("Oracle".equals(dbvo.getDBType())) {
            dbType = 7;
        } else if ("MS SqlServer".equals(dbvo.getDBType())) {
            dbType = 3;
        } else if ("DB2".equals(dbvo.getDBType())) {
            dbType = 1;
        } else if ("Sybase".equals(dbvo.getDBType())) {
            dbType = 4;
        } else if ("DB2/400".equals(dbvo.getDBType())) {
            dbType = 9;
        } else if ("MySQL".equals(dbvo.getDBType())) {
            dbType = 6;
        } else if ("DM".equals(dbvo.getDBType())) {
            dbType = 11;
        } else if ("PostgreSql".equals(dbvo.getDBType())) {
            dbType = 5;
        } else {
            throw new DBException("Unsupported dbtype[" + dbvo.getDBType() + "]!", dbvo.getDBType());
        }
        return dbType;
    }

    public String translateSQL(String ksql, DatabaseVO dbvo, boolean isUseStoreProc) {
        int targetDBType = KSQLProvider.getDBType(dbvo);
        try {
            boolean throwError = "true".equalsIgnoreCase(System.getProperty("throwExWhenNameTooLong", "true"));
            logger.debug((Object)("throwExWhenNameTooLong=" + throwError));
            if (isUseStoreProc) {
                KSqlUtil.setAlterTableWithProcedureInDB2((boolean)true);
            } else {
                KSqlUtil.setAlterTableWithProcedureInDB2((boolean)false);
                KSqlUtil.setAutoReorgWhenAlterTableInDB2((boolean)true);
            }
            if (targetDBType == 9 || targetDBType == 1) {
                if (targetDBType == 9) {
                    FormatOptions fo = new FormatOptions();
                    fo.setDbSchema(((DB400VO)dbvo).getSchemaName());
                    ksql = TransUtil.translate((String)ksql, (int)9, (FormatOptions)fo, (boolean)throwError);
                } else {
                    FormatOptions fo = new FormatOptions();
                    fo.setDbSchema(((DB2VO)dbvo).getDbUserName());
                    ksql = TransUtil.translate((String)ksql, (int)1, (FormatOptions)fo, (boolean)throwError);
                }
            } else {
                ksql = TransUtil.Translate((String)ksql, (int)targetDBType, (boolean)throwError);
            }
        }
        catch (DB2DropColumnException e) {
            logger.warn((Object)("DB2 does not support 'DROP COLUNM' ,  sql {" + ksql + "} will not be executed!"), (Throwable)e);
        }
        catch (DBNotSupportedException ee) {
            logger.warn((Object)(ee.getMessage() + " ,  sql {" + ksql + "} will not be executed!"), (Throwable)ee);
        }
        catch (SqlTranslateException e) {
            logger.error((Object)("KSQL[" + ksql + "] Translate error[" + e.getMessage() + "]!"), (Throwable)e);
            System.out.println("KSQL[" + ksql + "] Translate error[" + e.getMessage() + "]!");
        }
        return ksql;
    }
}

