/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.AbstractDB;
import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.CreateDBInfo;
import com.kingdee.shr.dydeploy.web.executeSql.DBException;
import com.kingdee.shr.dydeploy.web.executeSql.DBInstanceNotExistException;
import com.kingdee.shr.dydeploy.web.executeSql.DBLoginException;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLQueryProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.IPostgreSQL;
import com.kingdee.shr.dydeploy.web.executeSql.IPostgresqlDriver;
import com.kingdee.shr.dydeploy.web.executeSql.PostgresqlVO;
import com.kingdee.shr.dydeploy.web.executeSql.RowCallbackHandler;
import com.kingdee.shr.dydeploy.web.executeSql.SqlTable;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import com.kingdee.shr.dydeploy.web.executeSql.TableSpaceInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Postgresql
extends AbstractDB
implements IPostgreSQL {
    private static final Logger logger = Logger.getLogger(Postgresql.class);
    private IPostgresqlDriver postgresqlDriver = null;
    private PostgresqlVO postgresqlVO;

    public Postgresql(PostgresqlVO dbvo) {
        this.postgresqlVO = dbvo;
    }

    @Override
    public void runStatics(Connection conn, String tableName) {
        String sql = "UPDATE STATISTICS " + tableName;
        this.executeSqlProvider(conn, new DefaultSQLProviderExecutor(sql, false));
    }

    @Override
    public String getJDBCDriverClassName() {
        return this.postgresqlDriver.getDriverClassName();
    }

    @Override
    public String getJDBCUrl(DatabaseVO dbVO) {
        return this.postgresqlDriver.getJDBCUrl(dbVO);
    }

    @Override
    protected Connection getPhysicalDBConnection() throws SQLException {
        this.testDBPort(this.postgresqlVO);
        Properties props = new Properties();
        props.setProperty("user", this.postgresqlVO.getDbUserName());
        props.setProperty("password", this.postgresqlVO.getDbPassword());
        logger.info((Object)("Create physical PostgreSQL connection with user [" + props.getProperty("user") + "]"));
        Connection conn = null;
        try {
            conn = this.postgresqlDriver.connect(this.getJDBCUrl(this.postgresqlVO), props);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 0) {
                logger.error((Object)("Create PostgreSQL connection error,login failed," + ex));
                throw new DBLoginException("Create PostgreSQL connection error,login failed," + ex.getMessage(), this.postgresqlVO.getDBType(), this.postgresqlVO.getDbUserName(), this.postgresqlVO.getDisplayAddress(), this.postgresqlVO.getDbPort());
            }
            if (ex.getErrorCode() == 2801) {
                logger.error((Object)("Create PostgreSQL connection error,get DBInstance failed," + ex));
                throw new DBInstanceNotExistException("Create PostgreSQL connection error,get DBInstance failed,", this.postgresqlVO.getDBType(), this.postgresqlVO.getDisplayDBName(), this.postgresqlVO.getDisplayAddress(), this.postgresqlVO.getDbPort());
            }
            throw ex;
        }
        return conn;
    }

    @Override
    public SqlTable[] getDBTableAndViews() {
        final ArrayList tablesList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor("select tablename from pg_tables where schemaname = 'public'"){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    SqlTable table = new SqlTable(rs.getString(1), false);
                    tablesList.add(table);
                }
            });
            this.execute(new DefaultSQLQueryProviderExecutor("select viewname from pg_views where schemaname='public'"){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    SqlTable view = new SqlTable(rs.getString(1), true);
                    tablesList.add(view);
                }
            });
            return tablesList.toArray(new SqlTable[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get PostgreSQL table and view failed!", e);
            throw new AdminException("Get PostgreSQL table and view failed!", e);
        }
    }

    @Override
    public String[] getDatabaseList() {
        final ArrayList dbList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor("SELECT datname FROM pg_database"){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    dbList.add(rs.getString(1));
                }
            });
            return dbList.toArray(new String[0]);
        }
        catch (Throwable e) {
            if (e instanceof AdminException) {
                throw (AdminException)e;
            }
            logger.error((Object)"Get PostgreSQL dblist failed!", e);
            throw new AdminException("Get PostgreSQL dblist failed!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            DatabaseMetaData meta = conn.getMetaData();
            logger.info((Object)("PostgreSQL ProductVersion: " + meta.getDatabaseProductVersion()));
            String string = meta.getDatabaseProductVersion();
            return string;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    @Override
    public String[] getDatabaseUserList() {
        final ArrayList userList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor("select usename from pg_user"){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    userList.add(rs.getString(1));
                }
            });
            return userList.toArray(new String[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get PostgreSQL userList failed!", e);
            throw new AdminException("Get PostgreSQL userList failed!", e);
        }
    }

    public void createDatabase(DatabaseVO dbVO, CreateDBInfo info, boolean isCreateUser) throws SQLException {
        ArrayList<String> sqlList = new ArrayList<String>();
        String createDB = "";
        if (isCreateUser) {
            String createUser = "CREATE USER " + info.getNewUserName() + " WITH PASSWORD '" + info.getNewUserPass() + "'";
            sqlList.add(createUser);
            createDB = "CREATE DATABASE " + info.getNewDBName() + " OWNER " + info.getNewUserName();
            sqlList.add(createDB);
            String privilSql = "GRANT ALL PRIVILEGES ON DATABASE " + info.getNewDBName() + " TO " + info.getNewUserName();
            sqlList.add(privilSql);
        } else {
            createDB = "CREATE DATABASE " + info.getNewDBName();
            sqlList.add(createDB);
        }
        this.executeMultiSql(sqlList);
    }

    @Override
    public void createDatabase(DatabaseVO dbVO, CreateDBInfo info) throws SQLException {
        String createDB = "CREATE DATABASE " + info.getNewDBName();
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(createDB);
        this.executeMultiSql(sqlList);
    }

    @Override
    public HashMap getDBFKList(String dbSchema, String tableName) {
        final HashMap fkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT co.conname,C.relname FROM pg_class C , pg_constraint co WHERE C.oid = co.conrelid AND co.contype = 'f' AND C.relname ='" + tableName.toLowerCase() + "'" : "SELECT co.conname,C.relname FROM pg_class C , pg_constraint co WHERE C.oid = co.conrelid AND co.contype = 'f'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    fkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get postgresql DB FK list failed!", e);
            throw new AdminException("Get postgresql DB FK list failed!", e);
        }
        return fkList;
    }

    public boolean isTablespaceExist(String spaceName) throws SQLException {
        final ArrayList list = new ArrayList();
        try {
            String sql = "select * from pg_tablespace WHERE spcname = '" + spaceName + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    list.add("success");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.size() > 0;
    }

    public void getTableSpaceActualSize(final TableSpaceInfo spaceInfo, String fileName) {
        try {
            String name = fileName + "_data";
            spaceInfo.cleareNormalSizes();
            String sql = "Exec sp_spaceused";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String strTotalSize = rs.getString("database_size");
                    String strFreeSize = rs.getString("unallocated space");
                    String percent = new DecimalFormat("0.00").format((Postgresql.this.dealSpaceSizeInfo(strTotalSize) - Postgresql.this.dealSpaceSizeInfo(strFreeSize)) / Postgresql.this.dealSpaceSizeInfo(strTotalSize) * 100.0);
                    spaceInfo.addNormalSize(Postgresql.this.dealSpaceSizeInfo(strTotalSize) + "(" + percent + "%)");
                }
            });
            name = fileName + "_log";
            sql = "DBCC SQLPERF(LOGSPACE)";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)"Get table space actual size error !", (Throwable)ex);
            AdminException e = new AdminException("Get tablespae actual size error", ex);
            throw e;
        }
    }

    private double dealSpaceSizeInfo(String strSize) {
        String sizeNumber = "";
        int index1 = (strSize = strSize.toLowerCase()).indexOf("m");
        if (index1 > 0) {
            sizeNumber = strSize.substring(0, index1);
        }
        return new Double(sizeNumber);
    }

    public TableSpaceInfo getOldVersionDCTableSpaceInfo() {
        final TableSpaceInfo spaceInfo = new TableSpaceInfo();
        try {
            String sql = "select * from sysfiles where groupid=1";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String path = rs.getString("filename");
                    String normalSize = String.valueOf(rs.getInt("size") * 8 / 1024);
                    String type = "standard";
                    spaceInfo.addNormalSize(normalSize);
                    spaceInfo.setSpaceType(type);
                    spaceInfo.setSpaceName(type);
                    spaceInfo.addSpacePath(path);
                }
            });
            sql = "select * from sysfiles where groupid=0";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tempSize = String.valueOf(rs.getInt("size") * 8 / 1024);
                    spaceInfo.addTempSize(tempSize);
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)"Get old version datacenter table space info error !", (Throwable)ex);
            AdminException e = new AdminException("Get old version datacenter table space information error", ex);
            throw e;
        }
        return spaceInfo;
    }

    @Override
    public ArrayList getDBTableList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "select tablename from pg_tables where schemaname = 'public'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get table list failed!", e);
            throw new DBException("Get table list form db error", e);
        }
        return tableList;
    }

    @Override
    public ArrayList getDBViewList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "select viewname from pg_views where schemaname='public'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get view list failed!", e);
            throw new DBException("Get view list form db error", e);
        }
        return tableList;
    }

    @Override
    public HashMap getDBPKList(String dbSchema, String tableName) {
        final HashMap pkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT co.conname,c.relname FROM pg_class C, pg_constraint co WHERE C .oid = co.conrelid AND co.contype = 'p' AND C.relname = '" + tableName + "'" : "SELECT co.conname,c.relname FROM pg_class C, pg_constraint co WHERE C .oid = co.conrelid AND co.contype = 'p'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    pkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get pk list failed!", e);
            throw new DBException("Get pk list form db error", e);
        }
        return pkList;
    }

    @Override
    public HashMap getDBIndexList(String dbuser) {
        final HashMap indexList = new HashMap();
        try {
            String sql = "select indexname,tablename from pg_indexes where SCHEMANAME = 'public'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    indexList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get postgresql index list failed!", e);
            throw new DBException("Get postgresql index list form db error", e);
        }
        return indexList;
    }

    @Override
    public String getID() {
        return "postgresql:" + this.postgresqlVO.getID();
    }

    @Override
    public String getDetectSql() {
        return "SELECT 1 FROM PG_DATABASE";
    }

    @Override
    public String getDBChartset() {
        String sql = "select datctype from pg_database where datname='" + this.postgresqlVO.getDbName() + "'";
        final ArrayList tableList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1));
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get DB Chartset failed!", e);
            throw new DBException("Get DB Chartset failed!", e);
        }
        return (String)tableList.get(0);
    }

    @Override
    public void rebuildDisabledView() throws Exception {
        final ArrayList viewNameList = new ArrayList();
        final ArrayList createViewSQLList = new ArrayList();
        this.executeQueryWithSingleParam("select viewname,definition from pg_views where schemaname = 'public' and viewowner = ?", this.postgresqlVO.getDbUserName().toLowerCase(), new RowCallbackHandler(){

            @Override
            public void processRow(ResultSet rs) throws SQLException {
                viewNameList.add(rs.getString(1));
                createViewSQLList.add(rs.getString(2));
            }
        });
        if (viewNameList.size() > 0) {
            logger.info((Object)("Invalid database view siz is " + viewNameList.size()));
            ArrayList<String> dropViewList = new ArrayList<String>();
            for (int i = 0; i < viewNameList.size(); ++i) {
                dropViewList.add("drop view " + (String)viewNameList.get(i));
            }
            this.executeMultiSql(dropViewList);
            ArrayList<String> validViewList = (ArrayList<String>)createViewSQLList.clone();
            validViewList = this.processCreateViewsSQL(validViewList);
            while (validViewList.size() > 0) {
                validViewList = this.processCreateViewsSQL(validViewList);
            }
        }
    }

    private ArrayList<String> processCreateViewsSQL(ArrayList<String> viewList) {
        ArrayList<String> failedSQLList = new ArrayList<String>();
        for (int i = 0; i < viewList.size(); ++i) {
            String viewSQL = viewList.get(i);
            try {
                logger.debug((Object)("Execute sql [" + viewSQL + "] on postgresql database!"));
                this.executeSql(viewSQL);
                continue;
            }
            catch (Exception ex) {
                failedSQLList.add(viewSQL);
                logger.warn((Object)("Execute sql [" + viewSQL + "] on postgresql database error !"));
            }
        }
        return failedSQLList;
    }
}

