/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.executeSql;

import com.kingdee.shr.dydeploy.web.executeSql.AbstractDB;
import com.kingdee.shr.dydeploy.web.executeSql.AdminException;
import com.kingdee.shr.dydeploy.web.executeSql.CreateDBInfo;
import com.kingdee.shr.dydeploy.web.executeSql.DBException;
import com.kingdee.shr.dydeploy.web.executeSql.DatabaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.DefaultSQLQueryProviderExecutor;
import com.kingdee.shr.dydeploy.web.executeSql.ISyBase;
import com.kingdee.shr.dydeploy.web.executeSql.ISybaseDriver;
import com.kingdee.shr.dydeploy.web.executeSql.JDBCDriverFactory;
import com.kingdee.shr.dydeploy.web.executeSql.SqlTable;
import com.kingdee.shr.dydeploy.web.executeSql.StringUtils;
import com.kingdee.shr.dydeploy.web.executeSql.SyBaseVO;
import com.kingdee.shr.dydeploy.web.executeSql.TableSpaceInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SyBase
extends AbstractDB
implements ISyBase {
    private static final Logger logger = Logger.getLogger(SyBase.class);
    private ISybaseDriver sybaseDriver = null;
    private SyBaseVO sybase;

    public SyBase(SyBaseVO dbvo) {
        this.sybase = dbvo;
        this.sybaseDriver = (ISybaseDriver)JDBCDriverFactory.getDBDriver(dbvo);
    }

    @Override
    public String getJDBCDriverClassName() {
        return this.sybaseDriver.getDriverClassName();
    }

    @Override
    public String getJDBCUrl(DatabaseVO dbVO) {
        return this.sybaseDriver.getJDBCUrl(dbVO);
    }

    @Override
    public String getJDBCReadOnlyUrl(DatabaseVO defaultDatabase) {
        return this.sybaseDriver.getJDBCReadOnlyUrl(defaultDatabase);
    }

    @Override
    protected Connection getPhysicalDBConnection() throws SQLException {
        this.testDBPort(this.sybase);
        Properties props = new Properties();
        props.setProperty("user", this.sybase.getDbUserName());
        props.setProperty("password", this.sybase.getDbPassword());
        logger.info((Object)("Create physical sybase connection with user [" + props.getProperty("user") + "]"));
        return this.sybaseDriver.connect(this.getJDBCUrl(this.sybase), props);
    }

    @Override
    public SqlTable[] getDBTableAndViews() {
        final ArrayList tablesList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor("SELECT name,type FROM sysobjects WHERE type='U' OR type='V' order by name"){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tbName = rs.getString(1);
                    String type = rs.getString(2);
                    SqlTable table = new SqlTable(tbName, "V".equals(type.trim()));
                    tablesList.add(table);
                }
            });
            return tablesList.toArray(new SqlTable[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get sybase table and view failed!", e);
            throw new AdminException("Get sybase table and view failed!", e);
        }
    }

    @Override
    public String[] getDatabaseList() {
        final ArrayList dbList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor("SELECT NAME FROM SYSDATABASES".toLowerCase()){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    dbList.add(rs.getString(1));
                }
            });
            return dbList.toArray(new String[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get sybase dblist failed!", e);
            throw new AdminException("Get sybase dblist failed!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            DatabaseMetaData meta = conn.getMetaData();
            logger.info((Object)("Sybase ProductVersion: " + meta.getDatabaseProductVersion()));
            String string = meta.getDatabaseProductVersion();
            return string;
        }
        finally {
            this.connectionHolder.release();
        }
    }

    @Override
    public String[] getDatabaseUserList() {
        final ArrayList userList = new ArrayList();
        try {
            this.execute(new DefaultSQLQueryProviderExecutor("SELECT NAME FROM SYSLOGINS".toLowerCase()){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    userList.add(rs.getString(1));
                }
            });
            return userList.toArray(new String[0]);
        }
        catch (Throwable e) {
            logger.error((Object)"Get sybase userList failed!", e);
            throw new AdminException("Get sybase userList failed!", e);
        }
    }

    @Override
    public void createDatabase(DatabaseVO dbVO, CreateDBInfo info) throws SQLException {
    }

    @Override
    public HashMap getDBFKList(String dbSchema, String tableName) {
        final HashMap fkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "SELECT object_name(C.constrid) FK_NAME,OBJECT_NAME(C.tableid) TABLE_NAME FROM sysconstraints C,sysobjects O WHERE C.constrid=O.id AND C.status=64 AND OBJECT_NAME(C.tableid)='" + tableName + "'" : "SELECT object_name(C.constrid) FK_NAME,OBJECT_NAME(C.tableid) TABLE_NAME FROM sysconstraints C,sysobjects O WHERE C.constrid=O.id AND C.status=64 AND object_name(C.tableid) like 'T_%'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    fkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get sybase DB FK list failed!", e);
            throw new AdminException("Get sybase DB FK list failed!", e);
        }
        return fkList;
    }

    @Override
    public void runStatics(Connection conn, String tableName) {
        String sql = "UPDATE STATISTICS " + tableName;
        this.executeSqlProvider(conn, new DefaultSQLProviderExecutor(sql, false));
    }

    @Override
    public boolean isTablespaceExist(String spaceName) throws SQLException {
        final ArrayList list = new ArrayList();
        try {
            String sql = "select * from sysfiles WHERE name = '" + spaceName + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    list.add("success");
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return list.size() > 0;
    }

    @Override
    public void getTableSpaceActualSize(final TableSpaceInfo spaceInfo, String fileName) {
        try {
            String name = fileName + "_data";
            String sql = "select size from sysfiles where name='" + name + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    int size = rs.getInt("size") * 8 / 1024;
                    spaceInfo.addNormalSize(String.valueOf(size));
                }
            });
            name = fileName + "_log";
            sql = "select size from sysfiles where name='" + name + "'";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    int size = rs.getInt("size") * 8 / 1024;
                    spaceInfo.addTempSize(String.valueOf(size));
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)"Get table space actual size error !", (Throwable)ex);
            AdminException e = new AdminException("Get tablespae actual size error", ex);
            throw e;
        }
    }

    @Override
    public TableSpaceInfo getOldVersionDCTableSpaceInfo() {
        final TableSpaceInfo spaceInfo = new TableSpaceInfo();
        try {
            String sql = "select * from sysfiles where groupid=1";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String path = rs.getString("filename");
                    int index = path.lastIndexOf(System.getProperty("file.separator"));
                    if (index == -1) {
                        index = path.lastIndexOf("/");
                    }
                    if (index == -1) {
                        index = path.lastIndexOf("\\");
                    }
                    if (index != -1) {
                        path = path.substring(0, index);
                    }
                    String normalSize = String.valueOf(rs.getInt("size") * 8 / 1024);
                    String type = "standard";
                    spaceInfo.addNormalSize(normalSize);
                    spaceInfo.setSpaceType(type);
                    spaceInfo.setSpaceName(type);
                    spaceInfo.addSpacePath(path);
                }
            });
            sql = "select * from sysfiles where groupid=0";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    String tempSize = String.valueOf(rs.getInt("size") * 8 / 1024);
                    spaceInfo.addTempSize(tempSize);
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)"Get old version datacenter table space info error !", (Throwable)ex);
            AdminException e = new AdminException("Get old version datacenter table space information error", ex);
            throw e;
        }
        return spaceInfo;
    }

    @Override
    public ArrayList getDBTableList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "select name from sysobjects where type = 'U' order by name";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get table list failed!", e);
            throw new DBException("Get table list form db error", e);
        }
        return tableList;
    }

    @Override
    public ArrayList getDBViewList(String dbSchema) {
        final ArrayList tableList = new ArrayList();
        try {
            String sql = "select name from sysobjects where type = 'V' order by name";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    tableList.add(rs.getString(1).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get view list failed!", e);
            throw new DBException("Get view list form db error", e);
        }
        return tableList;
    }

    @Override
    public HashMap getDBPKList(String dbSchema, String tableName) {
        final HashMap pkList = new HashMap();
        try {
            String sql = null;
            sql = StringUtils.hasText(tableName) ? "select I.name PK_NAME, object_name(I.id) TABLE_NAME from sysindexes I, sysobjects O where I.id=O.id and I.status2&2=2 and I.status&2048=2048 and I.indid>0 and object_name(I.id)='" + tableName + "'" : "select I.name PK_NAME, object_name(I.id) TABLE_NAME from sysindexes I, sysobjects O where I.id=O.id and I.status2&2=2 and I.status&2048=2048 and I.indid>0";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    pkList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get pk list failed!", e);
            throw new DBException("Get pk list form db error", e);
        }
        return pkList;
    }

    @Override
    public HashMap getDBIndexList(String dbSchema) {
        final HashMap indexList = new HashMap();
        try {
            String sql = "SELECT I.name,O.name FROM sysindexes I,sysobjects O WHERE I.indid>0 AND I.indid<255 AND (I.status2&2!=2 OR (I.status2&2=2 AND status=2) OR (I.status2&2=2 AND status=130)) AND O.id=I.id AND O.type='U' AND O.type!='S' ORDER BY 1,2";
            this.execute(new DefaultSQLQueryProviderExecutor(sql){

                @Override
                public void processRow(ResultSet rs) throws SQLException {
                    indexList.put(rs.getString(1).toLowerCase(), rs.getString(2).toLowerCase());
                }
            });
        }
        catch (Throwable e) {
            logger.error((Object)"Get index list failed!", e);
            throw new DBException("Get index list form db error", e);
        }
        return indexList;
    }

    @Override
    public String getID() {
        return "sybase:" + this.sybase.getID();
    }

    @Override
    public String getDetectSql() {
        return "select 1";
    }
}

