/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dydeploy.web.util;

import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.dydeploy.web.util.AppXmlUtil;
import com.kingdee.shr.dydeploy.web.util.Constants;
import com.kingdee.shr.dydeploy.web.util.FileCheckUtil;
import com.kingdee.shr.dydeploy.web.util.LoggerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZIPUtil {
    public static final int BUFFER_SIZE = 8192;

    public static void doZip(String dirPath, String toZipPath) {
        File dir = null;
        ZipOutputStream zipOut = null;
        String zipDirName = "";
        String parentPath = null;
        try {
            dir = new File(dirPath);
            zipDirName = ZIPUtil.getZipPath(dir.getName(), toZipPath);
            parentPath = dir.getParent();
            zipOut = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(zipDirName)));
            ZIPUtil.doZipHandlerDir(dir, zipOut, parentPath);
            zipOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getZipPath(String dirName, String toZipPath) {
        File newDir;
        String zipDirName = "";
        if (toZipPath != null && !"".equals(toZipPath.trim()) && !(newDir = new File(zipDirName = toZipPath + File.separator)).exists()) {
            newDir.mkdirs();
        }
        zipDirName = zipDirName + dirName + ".zip";
        return zipDirName;
    }

    private static void doZipHandlerDir(File dir, ZipOutputStream zipOut, String parentPath) throws Exception {
        File[] files = dir.listFiles();
        byte[] buffer = new byte[8192];
        if (files.length == 0) {
            zipOut.putNextEntry(new ZipEntry(ZIPUtil.handlerFilePath(dir.toString(), parentPath) + File.separator));
            zipOut.closeEntry();
        } else {
            for (File file : files) {
                if (file.isDirectory()) {
                    ZIPUtil.doZipHandlerDir(file, zipOut, parentPath);
                    continue;
                }
                ZIPUtil.doZipWriteFile(file, zipOut, parentPath, buffer);
            }
        }
    }

    private static void doZipWriteFile(File file, ZipOutputStream zipOut, String parentPath, byte[] buffer) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        zipOut.putNextEntry(new ZipEntry(ZIPUtil.handlerFilePath(file.toString(), parentPath)));
        int length = 0;
        while ((length = fis.read(buffer)) > 0) {
            zipOut.write(buffer, 0, length);
        }
        zipOut.closeEntry();
        fis.close();
    }

    private static String handlerFilePath(String realPath, String parentPath) throws Exception {
        int index = -1;
        index = realPath.indexOf(parentPath);
        if (index == -1) {
            throw new Exception(SHRWebResource.getString((String)"com.kingdee.shr.dydeploy.DydeployResourse", (String)"path_error"));
        }
        return realPath.substring(index + parentPath.length());
    }

    public static void unZip(String appId, String unZipPath, String toUnZipPath) throws Exception {
        ZipFile zipFile = null;
        FileOutputStream outStream = null;
        InputStream inputStream = null;
        File file = null;
        ZipEntry zipEntry = null;
        Logger logger = LoggerUtil.getLoggerByAppId(appId);
        try {
            zipFile = new ZipFile(unZipPath, "UTF-8");
            Enumeration entities = zipFile.getEntries();
            while (entities.hasMoreElements()) {
                zipEntry = (ZipEntry)entities.nextElement();
                file = new File(SHRCheck.checkFilePath((String)ZIPUtil.getUnZipPath(zipEntry.getName(), toUnZipPath)));
                ZIPUtil.mkdirs(zipEntry, file);
                inputStream = zipFile.getInputStream(zipEntry);
                if (zipEntry.isDirectory()) continue;
                logger.info((Object)("copy component file : " + file.getAbsolutePath()));
                outStream = new FileOutputStream(file);
                ZIPUtil.write2Disk(outStream, inputStream);
            }
            zipFile.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    public static String readeZipFile(File file) throws Exception {
        String appId = null;
        String filePath = file.getName();
        StringBuilder sb = new StringBuilder();
        ZipFile zipFile = null;
        ZipEntry zipEntry = null;
        InputStream inputStream = null;
        try {
            zipFile = new ZipFile(file, "UTF-8");
            zipEntry = zipFile.getEntry("app.xml");
            if (zipFile.getEntry("components.xml") == null) {
                String string = sb.toString();
                return string;
            }
            if (zipEntry != null) {
                sb.append("{");
                int lastIndex = filePath.lastIndexOf(".zip");
                appId = filePath.substring(0, lastIndex);
                sb.append("\"appId\":\"" + appId + "\",");
                inputStream = zipFile.getInputStream(zipEntry);
                try {
                    AppXmlUtil.parserXml(inputStream, sb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String string = "";
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    return string;
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("},");
            }
            zipFile.close();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return sb.toString();
    }

    public static String readerFile(String filePath) throws Exception {
        String appId = null;
        StringBuilder sb = new StringBuilder();
        File file = new File(SHRCheck.checkFilePath((String)filePath));
        File[] files = file.listFiles();
        if (files == null) {
            return "";
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().equals("app.xml")) continue;
            sb.append("{");
            int lastIndex = file.getName().lastIndexOf(".zip");
            appId = file.getName().substring(0, lastIndex);
            sb.append("\"appId\":\"" + appId + "\",");
            try {
                AppXmlUtil.parserXml(files[i].getAbsolutePath(), sb);
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("},");
        }
        return sb.toString();
    }

    private static void mkdirs(ZipEntry zipEntry, File file) {
        if (zipEntry.isDirectory()) {
            file.mkdirs();
        } else {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
    }

    private static void write2Disk(FileOutputStream outStream, InputStream inputStream) throws IOException {
        int length = 0;
        byte[] buffer = new byte[8192];
        while ((length = inputStream.read(buffer)) > 0) {
            outStream.write(buffer, 0, length);
        }
        outStream.flush();
        outStream.close();
        inputStream.close();
    }

    private static String getUnZipPath(String zipName, String toUnZipPath) {
        String unZipPath = "";
        if (toUnZipPath != null && !"".equals(toUnZipPath)) {
            unZipPath = toUnZipPath + File.separator;
        }
        unZipPath = unZipPath + zipName;
        return unZipPath;
    }

    private static String getZipListJson(String path) throws Exception {
        StringBuilder sb = new StringBuilder();
        File f = new File(SHRCheck.checkFilePath((String)path));
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!FileCheckUtil.isFileType(files[i], "zip")) continue;
                sb.append(ZIPUtil.readeZipFile(files[i]));
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static String getListJson(String path) throws Exception {
        StringBuilder sb = new StringBuilder();
        File f = new File(SHRCheck.checkFilePath((String)path));
        File[] files = f.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                sb.append(ZIPUtil.readerFile(path + files[i].getName()));
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static StringBuilder readZipFiles(String basePath) throws Exception {
        File file = new File(SHRCheck.checkFilePath((String)Constants.getAppsPath(basePath)));
        File[] files = file.listFiles();
        File file1 = new File(SHRCheck.checkFilePath((String)Constants.getAppsPath(basePath)));
        HashSet<String> set = new HashSet<String>();
        if (file1.exists()) {
            File[] files1 = file1.listFiles();
            for (int i = 0; i < files1.length; ++i) {
                set.add(files1[i].getName());
            }
        }
        StringBuilder sb = new StringBuilder();
        if (files == null) {
            return sb;
        }
        sb.append("{");
        sb.append("\"count\":" + (files.length - (files.length == 0 ? 0 : 1)) + ",");
        sb.append("\"listLocal\":[" + ZIPUtil.getZipListJson(Constants.getAppsPath(basePath)) + "],");
        String path = Constants.getAppsPath(basePath) + "/bak/";
        sb.append("\"listDeploy\":[" + ZIPUtil.getListJson(Constants.getAppsPath(basePath) + "/bak/") + "]");
        sb.append("}");
        return sb;
    }
}

