/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.complexquery;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.md5;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.RowSetSizeParamConfig;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import com.kingdee.shr.base.syssetting.web.util.UuidGenerator;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpQueryImpl {
    private static final String QUERY_STORE_DATA = "query_store_data";
    private static final String TEMP_TABLE_NAME = "temp_table_name";
    private static final String QUERY_SQL = "query_sql";
    private static final String TEMP_TABLE_COUNT = "query_store_count";
    private static final String QUERY_STORE_KEY = "query_store_key";
    private static Logger logger = Logger.getLogger(EmpQueryImpl.class);

    public static GridDataEntity execQuery(Context ctx, String function, SqlParam param) throws Exception {
        GridDataEntity gridData = null;
        gridData = param.isNeedDistinct() ? EmpQueryImpl.empQuery(ctx, function, param) : EmpQueryImpl.execQueryReal(ctx, function, param);
        return gridData;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GridDataEntity execQuery0(Context ctx, String function, SqlParam param, Map<String, Object> otherParams) throws Exception {
        if (StringUtils.isEmpty((String)function)) {
            function = "EmpQuery";
        }
        long totalCount = 0L;
        int rows = (Integer)otherParams.get("rows");
        int page = (Integer)otherParams.get("page");
        boolean isExportAllToExcelCount = (Boolean)otherParams.get("isExportAllToExcelCount");
        boolean isOrderForExportAll = false;
        String exportCustomSql = null;
        if (null != otherParams.get("sHRSupportExportOrder")) {
            isOrderForExportAll = (Boolean)otherParams.get("sHRSupportExportOrder");
        }
        if (null != otherParams.get("exportCustomSql")) {
            exportCustomSql = (String)otherParams.get("exportCustomSql");
        }
        if (StringUtils.isEmpty(exportCustomSql) && param.isNeedDistinct()) {
            isOrderForExportAll = false;
        }
        String queryUuid = null;
        String tempTableName = null;
        long begin = 0L;
        long end = 0L;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String orderBySql = null;
        int dbType = -1;
        String excuteSql = null;
        if (isExportAllToExcelCount) {
            GridDataEntity gridDataEntity;
            try {
                begin = System.currentTimeMillis();
                String querySql = null;
                if (StringUtils.isEmpty((String)exportCustomSql)) {
                    if (isOrderForExportAll) {
                        EmpQueryImpl.addSorterItemToSelector(param);
                    }
                    querySql = FilterUtil.getSql((Context)ctx, (SqlParam)param);
                    if (isOrderForExportAll && param.getSorter() != null) {
                        SorterItemInfo info = null;
                        StringBuffer orderby = new StringBuffer().append(" order by ");
                        for (int i = 0; i < param.getSorter().size(); ++i) {
                            if (i > 0) {
                                orderby.append(",");
                            }
                            info = param.getSorter().get(i);
                            orderby.append(" \"").append(info.getPropertyName()).append("\" ").append(info.getSortType());
                        }
                        orderBySql = orderby.toString();
                    }
                } else {
                    querySql = exportCustomSql;
                }
                tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
                conn = EJBFactory.getConnection((Context)ctx);
                excuteSql = MessageFormat.format("select * into {0} from ( {1} ) TTT ", tempTableName, querySql);
                statement = conn.prepareStatement(excuteSql);
                dbType = KSqlUtil.getDbType((Connection)conn);
                long t0 = System.currentTimeMillis();
                statement.execute();
                long t1 = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("{0} tempTableName create cost:{1} ms, {2} s, querySql:{3}", EmpQueryImpl.class.toString(), t1 - t0, Float.valueOf((float)(t1 - t0) / 1000.0f), excuteSql));
                }
                excuteSql = MessageFormat.format("select count(*) cc from {0} ", tempTableName);
                rs = statement.executeQuery(excuteSql);
                JdbcRowSet rs0 = new JdbcRowSet();
                rs0.populate(rs);
                while (rs0.next()) {
                    totalCount = rs0.getLong("cc");
                }
                HashMap<String, Object> userdata = new HashMap<String, Object>();
                userdata.put("querySql", querySql);
                userdata.put("tempTableName", tempTableName);
                userdata.put("dbType", dbType);
                userdata.put("conn", conn);
                userdata.put("statement", statement);
                userdata.put("empQueryImplOrderBySql", orderBySql);
                GridDataEntity gridData = new GridDataEntity();
                gridData.setRecords(totalCount);
                gridData.setUserdata(userdata);
                end = System.currentTimeMillis();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("{0} execQuery0 tempTable and count cost:{1} ms, {2} s", EmpQueryImpl.class.toString(), end - begin, Float.valueOf((float)(end - begin) / 1000.0f)));
                }
                gridDataEntity = gridData;
            }
            catch (SQLException e) {
                try {
                    EmpQueryImpl.releaseResource(ctx, tempTableName, conn, statement, rs);
                    throw new SHRWebException("Sql3 execute exception : " + excuteSql, e);
                    catch (Exception e2) {
                        EmpQueryImpl.releaseResource(ctx, tempTableName, conn, statement, rs);
                        throw new SHRWebException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, statement, null);
                    if (totalCount <= 0L) {
                        EmpQueryImpl.releaseResource(ctx, tempTableName, conn, statement, rs);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, null);
            if (totalCount <= 0L) {
                EmpQueryImpl.releaseResource(ctx, tempTableName, conn, statement, rs);
            }
            return gridDataEntity;
        }
        GridDataEntity gridData = new GridDataEntity();
        begin = System.currentTimeMillis();
        ArrayList rowList = null;
        tempTableName = (String)otherParams.get("tempTableName");
        boolean isLastTime = (Boolean)otherParams.get("isLastTime");
        dbType = (Integer)otherParams.get("dbType");
        conn = (Connection)otherParams.get("conn");
        statement = (PreparedStatement)otherParams.get("statement");
        orderBySql = (String)otherParams.get("empQueryImplOrderBySql");
        excuteSql = StringUtils.isEmpty((String)exportCustomSql) && isOrderForExportAll ? MessageFormat.format("SELECT * from {0} {1}", tempTableName, orderBySql) : MessageFormat.format("SELECT * from {0}", tempTableName);
        PagingHelper pageHelper = new PagingHelper();
        try {
            excuteSql = pageHelper.getPagingSqlNoOptmize(dbType, excuteSql, (page - 1) * rows, rows);
            long t0 = System.currentTimeMillis();
            rs = statement.executeQuery(excuteSql);
            JdbcRowSet rs0 = new JdbcRowSet();
            rs0.populate(rs);
            long t1 = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("{0} getGridDataEntity0 executeQuery cost:{1} ms, {2} s", EmpQueryImpl.class.toString(), t1 - t0, Float.valueOf((float)(t1 - t0) / 1000.0f)));
            }
            rowList = FilterUtil.pupolate((Context)ctx, (SqlParam)param, (IRowSet)rs0);
        }
        catch (SQLException e) {
            EmpQueryImpl.releaseResource(ctx, tempTableName, conn, statement, rs);
            throw new SHRWebException("Sql3 execute exception : " + excuteSql, e);
        }
        catch (Exception e) {
            EmpQueryImpl.releaseResource(ctx, tempTableName, conn, statement, rs);
            throw new SHRWebException(e.getMessage(), e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, null, null);
            if (isLastTime) {
                EmpQueryImpl.releaseResource(ctx, tempTableName, conn, statement, rs);
            }
        }
        if (null == rowList) {
            rowList = new ArrayList();
        }
        gridData.setRows(rowList);
        gridData.setQueryUuid(queryUuid);
        gridData.setRecords(gridData.getRows().size());
        gridData.setPage(page);
        end = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("{0} execQuery0 getData cost:{1} ms, {2} s", EmpQueryImpl.class.toString(), end - begin, Float.valueOf((float)(end - begin) / 1000.0f)));
        }
        return gridData;
    }

    private static void releaseResource(Context ctx, String tempTableName, Connection conn, PreparedStatement statement, ResultSet rs) {
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        if (!StringUtils.isEmpty((String)tempTableName)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
    }

    public static GridDataEntity empQuery(Context ctx, String function, SqlParam param) throws Exception {
        if (StringUtils.isEmpty((String)function)) {
            function = "EmpQuery";
        }
        String tempTableName = null;
        int totalCount = 0;
        int rows = param.getRows();
        int page = param.getPage();
        String queryUuid = null;
        String queryKeyOld = null;
        String queryKeyNow = EmpQueryImpl.md5HashCode(param);
        Map<String, Map<String, Object>> storeDatas = null;
        Map<String, Object> storeData = null;
        if (param.isSupportQueryUuid()) {
            queryUuid = param.getQueryUuid();
            storeDatas = EmpQueryImpl.getStoreDatas(ctx);
            storeData = storeDatas.get(queryUuid);
            if (storeData != null) {
                tempTableName = (String)storeData.get(TEMP_TABLE_NAME);
                queryKeyOld = (String)storeData.get(QUERY_STORE_KEY);
                if (!param.isSynchTotal()) {
                    totalCount = (Integer)storeData.get(TEMP_TABLE_COUNT);
                }
                if (!queryKeyOld.equals(queryKeyNow)) {
                    storeDatas.remove(queryUuid);
                    if (tempTableName != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
                    }
                    storeData = null;
                    tempTableName = null;
                    totalCount = 0;
                }
            }
        }
        String querySql = "";
        if (tempTableName == null) {
            EmpQueryImpl.addSorterItemToSelector(param);
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTableName();
            querySql = FilterUtil.getSql((Context)ctx, (SqlParam)param);
            String tempSql = "select * into " + tempTableName + " from (" + querySql + ") T ";
            DbUtil.execute((Context)ctx, (String)tempSql.toString());
            if (param.isSupportQueryUuid() && null != storeDatas) {
                queryUuid = UuidGenerator.generate();
                storeData = new HashMap<String, Object>();
                storeData.put(TEMP_TABLE_NAME, tempTableName);
                storeData.put(QUERY_STORE_KEY, queryKeyNow);
                if (!param.isSynchTotal()) {
                    storeData.put(TEMP_TABLE_COUNT, totalCount);
                }
                storeDatas.put(queryUuid, storeData);
            }
        }
        if (param.isReqTotalCount() || !param.isSynchTotal()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from " + tempTableName));
            while (rs.next()) {
                totalCount = rs.getInt(1);
            }
            if (null != storeData) {
                storeData.put(TEMP_TABLE_COUNT, totalCount);
            }
        } else {
            totalCount = rows * page;
        }
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        int start = (page - 1) * rows;
        List rowList = null;
        int top = start + length;
        if (!param.isReqTotalCount() || !param.isSynchTotal()) {
            String sql = "SELECT TOP " + top + " * from " + tempTableName;
            if (param.getSorter() != null) {
                SorterItemInfo info = null;
                String orderby = " order by ";
                for (int i = 0; i < param.getSorter().size(); ++i) {
                    if (i > 0) {
                        orderby = orderby + ",";
                    }
                    info = param.getSorter().get(i);
                    orderby = orderby + " \"" + info.getPropertyName() + "\" " + info.getSortType();
                }
                sql = sql + orderby;
            }
            PagingHelper pageHelper = new PagingHelper();
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                sql = pageHelper.getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), sql, start, length);
                IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
                rowList = FilterUtil.pupolate((Context)ctx, (SqlParam)param, (IRowSet)rowset);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        } else {
            rowList = new ArrayList();
        }
        GridDataEntity gridData = new GridDataEntity();
        gridData.setRows(rowList);
        gridData.setQueryUuid(queryUuid);
        if (totalCount % rows == 0) {
            gridData.setTotal(totalCount / rows);
        } else {
            gridData.setTotal(totalCount / rows + 1);
        }
        if (param.isReqTotalCount() || !param.isSynchTotal()) {
            gridData.setRecords(totalCount);
        } else {
            gridData.setRecords(gridData.getRows() == null ? 0L : (long)gridData.getRows().size());
        }
        gridData.setPage(page);
        return gridData;
    }

    private static String md5HashCode(SqlParam param) {
        StringBuffer sb = new StringBuffer();
        sb.append(param.getSelectMapping().toString());
        if (StringUtils.isEmpty((String)param.getFilterInfo().getMaskString())) {
            sb.append(param.getFilterInfo().toString());
        } else {
            sb.append(param.getFilterInfo().getFilterItems().toString());
        }
        if (null != param.getDynExtendSQLJoinConditionPostFragment()) {
            sb.append(param.getDynExtendSQLJoinConditionPostFragment().toString());
        }
        sb.append(param.getFilterDate().toString());
        sb.append(param.getInfoCtr().toString());
        if (null != param.getSorter()) {
            sb.append(param.getSorter().toString());
        }
        md5 md = new md5(sb.toString());
        md.processString();
        return md.getStringDigest();
    }

    public static GridDataEntity execQueryReal(Context ctx, String function, SqlParam param) throws Exception {
        if (StringUtils.isEmpty((String)function)) {
            function = "EmpQuery";
        }
        int rows = param.getRows();
        int page = param.getPage();
        EmpQueryImpl.addSorterItemToSelector(param);
        String querySql = null;
        int totalCount = 0;
        String queryUuid = null;
        String queryKeyOld = null;
        String queryKeyNow = EmpQueryImpl.md5HashCode(param);
        Map<String, Map<String, Object>> storeDatas = null;
        Map<String, Object> storeData = null;
        if (param.isSupportQueryUuid()) {
            queryUuid = param.getQueryUuid();
            storeDatas = EmpQueryImpl.getStoreDatas(ctx);
            storeData = storeDatas.get(queryUuid);
            if (storeData != null) {
                querySql = (String)storeData.get(QUERY_SQL);
                queryKeyOld = (String)storeData.get(QUERY_STORE_KEY);
                if (!param.isSynchTotal()) {
                    totalCount = (Integer)storeData.get(TEMP_TABLE_COUNT);
                }
                if (!queryKeyOld.equals(queryKeyNow)) {
                    storeDatas.remove(queryUuid);
                    storeData = null;
                    querySql = null;
                    totalCount = 0;
                }
            }
        }
        if (querySql == null) {
            querySql = FilterUtil.getSql((Context)ctx, (SqlParam)param);
            if (param.isSupportQueryUuid() && null != storeDatas) {
                queryUuid = UuidGenerator.generate();
                storeData = new HashMap<String, Object>();
                storeData.put(QUERY_SQL, querySql);
                storeData.put(QUERY_STORE_KEY, queryKeyNow);
                if (!param.isSynchTotal()) {
                    storeData.put(TEMP_TABLE_COUNT, totalCount);
                }
                storeDatas.put(queryUuid, storeData);
            }
        }
        String subSql = querySql.substring(querySql.indexOf("FROM"));
        if (param.isReqTotalCount() || param.isAll() || !param.isSynchTotal()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) " + subSql));
            if (rs.next()) {
                totalCount = rs.getInt(1);
            }
            if (null != storeData) {
                storeData.put(TEMP_TABLE_COUNT, totalCount);
            }
        } else {
            totalCount = rows * page;
        }
        if (param.getSorter() != null) {
            SorterItemInfo info = null;
            String orderby = " order by ";
            for (int i = 0; i < param.getSorter().size(); ++i) {
                if (i > 0) {
                    orderby = orderby + ",";
                }
                info = param.getSorter().get(i);
                orderby = orderby + " \"" + info.getPropertyName() + "\" " + info.getSortType();
            }
            querySql = querySql + orderby;
        }
        if (param.isAll()) {
            rows = totalCount;
            page = 1;
        }
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        int start = (page - 1) * rows;
        List rowList = EmpQueryImpl.doPagingQuery(ctx, param, querySql, start, length);
        GridDataEntity gridData = new GridDataEntity();
        gridData.setRows(rowList);
        gridData.setQueryUuid(queryUuid);
        int n = rows = 0 == rows ? 1 : rows;
        if (totalCount % rows == 0) {
            gridData.setTotal(totalCount / rows);
        } else {
            gridData.setTotal(totalCount / rows + 1);
        }
        if (param.isReqTotalCount() || !param.isSynchTotal()) {
            gridData.setRecords(totalCount);
        } else {
            gridData.setRecords(gridData.getRows() == null ? 0L : (long)gridData.getRows().size());
        }
        gridData.setPage(page);
        return gridData;
    }

    private static List doPagingQuery(Context ctx, SqlParam param, String querySql, int start, int length) throws Exception {
        int maxPagingRowSize = EmpQueryImpl.getMaxPagingRowSize(param);
        int pagingRowSize = Math.min(length, maxPagingRowSize);
        int currentIndex = start;
        Connection conn = null;
        ArrayList rowList = new ArrayList();
        List rows = null;
        if (!param.isReqTotalCount()) {
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                PagingHelper pageHelper = new PagingHelper();
                boolean isSQLServerDB = SystemContextUtil.isSQLServerDB((Context)ctx);
                for (int fetchRowSize = 0; fetchRowSize < length; fetchRowSize += pagingRowSize) {
                    int top = currentIndex + pagingRowSize;
                    if (top > start + length) {
                        top = start + length;
                        pagingRowSize = top - currentIndex;
                    }
                    String sql = querySql.trim().replaceFirst("SELECT", "SELECT TOP " + top);
                    sql = pageHelper.getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), sql, currentIndex, pagingRowSize);
                    if (!isSQLServerDB && "SCHINESE_PINYIN".equals(param.getSorterMethod()) && sql.indexOf("ORDER BY") > -1) {
                        StringBuffer order0 = new StringBuffer();
                        String orderByEnd = sql.substring(sql.indexOf("ORDER BY"), sql.length());
                        String orderBy = orderByEnd.substring(0, orderByEnd.indexOf(")"));
                        String[] orders = orderBy.replace("ORDER BY ", "").split(",");
                        order0.append("ORDER BY ");
                        int i = 0;
                        for (String s : orders) {
                            String[] fields = s.trim().split("\\s+");
                            if (i > 0) {
                                order0.append(",");
                            }
                            order0.append(" NLSSORT(").append(fields[0].trim()).append(", 'NLS_SORT=SCHINESE_PINYIN_M') ").append(fields[1].trim());
                            ++i;
                        }
                        sql = sql.replace(orderBy, order0.toString());
                    }
                    long begin = System.currentTimeMillis();
                    IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
                    long end = System.currentTimeMillis();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("dynamicQuery cost :" + (end - begin) + " ms"));
                    }
                    rows = FilterUtil.pupolate((Context)ctx, (SqlParam)param, (IRowSet)rowset);
                    rowList.addAll(rows);
                    currentIndex = top;
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return rowList;
    }

    private static int getMaxPagingRowSize(SqlParam param) {
        return new RowSetSizeParamConfig().getCollectionExceptionSize() / param.getSelectMapping().size();
    }

    private static void addSorterItemToSelector(SqlParam param) {
        int i;
        SorterItemCollection sorter = param.getSorter();
        if (sorter == null) {
            return;
        }
        String fieldName = null;
        Map selector = param.getSelectMapping();
        String selectFieldName = null;
        boolean isExist = false;
        int size = sorter.size();
        for (int i2 = 0; i2 < size; ++i2) {
            fieldName = sorter.get(i2).getPropertyName();
            for (Map.Entry e : selector.entrySet()) {
                selectFieldName = (String)e.getKey();
                if (!selectFieldName.equalsIgnoreCase(fieldName)) continue;
                isExist = true;
                break;
            }
            if (isExist) {
                sorter.get(i2).setPropertyName(selectFieldName);
                continue;
            }
            selector.put(fieldName, fieldName);
        }
        HashSet<String> dump = new HashSet<String>();
        SorterItemCollection removeSorters = new SorterItemCollection();
        int size2 = sorter.size();
        for (i = 0; i < size2; ++i) {
            if (dump.contains(sorter.get(i).getPropertyName())) {
                removeSorters.add(sorter.get(i));
                continue;
            }
            dump.add(sorter.get(i).getPropertyName());
        }
        if (removeSorters.size() > 0) {
            size2 = removeSorters.size();
            for (i = 0; i < size2; ++i) {
                sorter.remove(removeSorters.get(i));
            }
        }
    }

    private static Map<String, Map<String, Object>> getStoreDatas(Context ctx) {
        HashMap storeDatas = (HashMap)ctx.get((Object)QUERY_STORE_DATA);
        if (storeDatas == null) {
            storeDatas = new HashMap();
            ctx.put((Object)QUERY_STORE_DATA, storeDatas);
        }
        return storeDatas;
    }

    public static void removeStoreData(Context ctx, String key) {
        Map<String, Map<String, Object>> storeDatas = EmpQueryImpl.getStoreDatas(ctx);
        storeDatas.remove(key);
    }
}

