/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.MethodInfo;
import com.kingdee.bos.bsf.service.ServiceInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.app.util.MsfServiceUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.msf.web.util.MsfWebUtils;
import com.kingdee.shr.osf.OSFCacheHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OSFWebUtil {
    public static Object callServiceHasPermission(HttpServletRequest request, HttpServletResponse response, String serviceName, HashMap param) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        try {
            IMSFServiceFacade iMSFServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
            boolean isOuterCall = MsfWebUtils.isOuterCallOsf(ctx, request);
            ServiceInfo serviceInfo = OSFCacheHelper.getServiceInfo((Context)ctx, (String)serviceName);
            MethodInfo m = MsfServiceUtil.getMethodInfo((String)"process", (ServiceInfo)serviceInfo);
            MsfServiceUtil.checkOuterAndInnerOsfPermission((Context)ctx, (String)serviceName, (ServiceInfo)serviceInfo, (boolean)isOuterCall);
            if (serviceInfo.getServiceType() == 10) {
                param.put("HttpServletRequest", request);
                param.put("HttpServletResponse", response);
                return MsfServiceUtil.processService((Context)ctx, (ServiceInfo)serviceInfo, (Map)param);
            }
            return iMSFServiceFacade.processService(serviceName, (Map)param);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (EASBizException e) {
            throw new SHRWebException(e);
        }
    }

    public static String callOSFService(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        PrintWriter pw;
        Map param = request.getParameterMap();
        String serviceName = request.getParameter("serviceName");
        HashMap cleanMap = new HashMap();
        for (Map.Entry entry : param.entrySet()) {
            cleanMap.put(entry.getKey(), request.getParameter((String)entry.getKey()));
        }
        Context ctx = SHRContext.getInstance().getContext();
        HashMap<String, String> value = null;
        try {
            value = OSFWebUtil.callServiceHasPermission(request, response, serviceName, cleanMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            value = new HashMap<String, String>();
            value.put("error:", e.getMessage());
        }
        response.setContentType("text/html;charset=UTF-8");
        try {
            pw = response.getWriter();
        }
        catch (IOException e) {
            throw new SHRWebException("can't open the output stream!");
        }
        pw.flush();
        pw.write(JSONUtils.convertObjectToJson(ctx, value));
        pw.flush();
        return JSONUtils.convertObjectToJson(ctx, value);
    }

    public static HttpServletRequest getRequest(Map param) {
        HttpServletRequest request = (HttpServletRequest)param.get("HttpServletRequest");
        return request;
    }

    public static Context getContext(Map param) {
        HttpServletRequest request = (HttpServletRequest)param.get("HttpServletRequest");
        return (Context)request.getSession().getAttribute("UserContext");
    }
}

