/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.component.botp;

import com.kingdee.bos.Context;
import com.kingdee.bos.meta.ui.MetaComponent;
import com.kingdee.bos.meta.ui.MetaComponentProperty;
import com.kingdee.bos.meta.ui.MetaEventBinding;
import com.kingdee.bos.meta.ui.MetaPropertyBinding;
import com.kingdee.bos.meta.ui.MetaWebEditPage;
import com.kingdee.shr.base.syssetting.context.SHRContext;

public class DynamicUtils {
    public static String convertMetaUIToJson(MetaWebEditPage webEditPage) {
        MetaComponent rootComponent = webEditPage.getRootMetaComponent();
        if (rootComponent == null) {
            return null;
        }
        String pageMetadata = DynamicUtils.convertMetaComponentToJson(rootComponent);
        System.out.println("pageMetadata:" + pageMetadata);
        return pageMetadata;
    }

    public static String getDynamicListUrl(String uipk) {
        return "/dynamicList.do?event=initialize&method=initalize&uipk=" + uipk;
    }

    public static String getDynamicEditUrl(String uipk) {
        return "/dynamicForm.do?event=initialize&method=initalize&uipk=" + uipk;
    }

    public static String convertMetaComponentToJson(MetaComponent component) {
        int nIndex;
        String field;
        String componentID = component.getName();
        StringBuffer jsonBuffer = new StringBuffer();
        jsonBuffer.append("{");
        jsonBuffer.append("\"id\":\"" + componentID + "\"");
        jsonBuffer.append(",");
        jsonBuffer.append("\"componentType\":\"" + component.getClassType() + "\"");
        jsonBuffer.append(",");
        if (component.getPropertyBindings().size() > 0 && (field = ((MetaPropertyBinding)component.getPropertyBindings().get(0)).getBindingField()) != null) {
            field = field.substring(0, 1).toLowerCase() + field.substring(1);
            jsonBuffer.append("\"field\":\"" + field + "\"");
            jsonBuffer.append(",");
        }
        if (component.getParent() != null && component.getParent().getParent() != null) {
            jsonBuffer.append("\"parent\":\"" + component.getParent().getName() + "\"");
        } else {
            jsonBuffer.append("\"parent\":\"mainContent\"");
        }
        jsonBuffer.append(",");
        if (component.getParent() != null && component.getParent().getParent() != null) {
            String parentComponentID = component.getParent().getName();
            if (component.getParent().getClassType() == "com.kingdee.bos.ctrl.web.Section") {
                jsonBuffer.append("\"parentEl\":\"" + parentComponentID + "_content\"");
            } else {
                jsonBuffer.append("\"parentEl\":\"" + parentComponentID + "\"");
            }
        } else {
            jsonBuffer.append("\"parentEl\":\"mainContent\"");
        }
        jsonBuffer.append(",");
        jsonBuffer.append("\"properties\":{");
        for (nIndex = 0; nIndex < component.getProperties().size(); ++nIndex) {
            MetaComponentProperty property = (MetaComponentProperty)component.getProperties().get(nIndex);
            if (property.getName().equals("value")) {
                // empty if block
            }
            if (property.getName().equals("enumSource")) {
                Context ctx = SHRContext.getInstance().getContext();
                jsonBuffer.append("\"enumSource\":" + property.getValue());
                if (nIndex >= component.getProperties().size() - 1) continue;
                jsonBuffer.append(",");
                continue;
            }
            String propertyType = property.getType();
            if ((component.getClassType() == "com.kingdee.bos.ctrl.web.GridLayoutPanel" || component.getClassType() == "com.kingdee.bos.ctrl.web.GridLayoutCell") && (property.getName().equals("rows") || property.getName().equals("cols") || property.getName().equals("startRow") || property.getName().equals("endRow") || property.getName().equals("startCol") || property.getName().equals("endCol"))) {
                propertyType = "int";
            }
            if ("boolean".equals(propertyType)) {
                jsonBuffer.append("\"" + property.getName().replace(".", "_") + "\":" + Boolean.parseBoolean(property.getValue()));
                if (nIndex >= component.getProperties().size() - 1) continue;
                jsonBuffer.append(",");
                continue;
            }
            if ("int".equals(propertyType)) {
                jsonBuffer.append("\"" + property.getName().replace(".", "_") + "\":" + Integer.parseInt(property.getValue()));
                if (nIndex >= component.getProperties().size() - 1) continue;
                jsonBuffer.append(",");
                continue;
            }
            if ("Object".equals(propertyType)) {
                jsonBuffer.append("\"" + property.getName().replace(".", "_") + "\":" + property.getValue() + "");
                if (nIndex >= component.getProperties().size() - 1) continue;
                jsonBuffer.append(",");
                continue;
            }
            jsonBuffer.append("\"" + property.getName().replace(".", "_") + "\":\"" + property.getValue() + "\"");
            if (nIndex >= component.getProperties().size() - 1) continue;
            jsonBuffer.append(",");
        }
        if (component.getEventBindings().size() > 0 && !jsonBuffer.toString().endsWith(",")) {
            jsonBuffer.append(",");
        }
        for (nIndex = 0; nIndex < component.getEventBindings().size(); ++nIndex) {
            MetaEventBinding event = (MetaEventBinding)component.getEventBindings().get(nIndex);
            jsonBuffer.append("\"" + event.getEventName() + "\":\"_self." + event.getMethodName() + "\"");
            if (nIndex >= component.getEventBindings().size() - 1) continue;
            jsonBuffer.append(",");
        }
        jsonBuffer.append("},");
        jsonBuffer.append("\"childrens\":[");
        for (nIndex = 0; nIndex < component.getComponents().size(); ++nIndex) {
            MetaComponent childElement = (MetaComponent)component.getComponents().get(nIndex);
            jsonBuffer.append(DynamicUtils.convertMetaComponentToJson(childElement));
            if (nIndex >= component.getComponents().size() - 1) continue;
            jsonBuffer.append(",");
        }
        jsonBuffer.append("]");
        jsonBuffer.append("}");
        System.out.println("page metadata:" + jsonBuffer.toString());
        return jsonBuffer.toString();
    }
}

