/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.component.botp.web;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.UIViewCollection;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/botp"})
public class BOTPController
extends WebComponentController {
    @RequestMapping(value={"/transform"})
    public String transformAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String targetInfo = request.getParameter("targetInfo");
        String direction = request.getParameter("direction");
        String targetBosType = request.getParameter("destType");
        String srcBillIds = request.getParameter("billIDs");
        String strBotpRule = request.getParameter("transformRule");
        if (StringUtils.isEmpty((String)srcBillIds)) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "select_source_bill"));
        }
        if (srcBillIds.endsWith(",")) {
            srcBillIds = srcBillIds.substring(0, srcBillIds.length() - 1);
        }
        this.checkReBuildControl(strBotpRule, targetBosType, srcBillIds);
        String[] idList = srcBillIds.split(",");
        ArrayList entryids = new ArrayList();
        ObjectUuidPK botMappingId = new ObjectUuidPK(strBotpRule);
        try {
            IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
            BOTMappingInfo mappingInfo = iBOTMapping.getMappingInfoByPK((IObjectPK)botMappingId);
            IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
            BTPTransformResult btpResult = iBTPManager.transformForBotp(idList, null, entryids, null, mappingInfo.getDestEntityName(), (IObjectPK)botMappingId, mappingInfo.getSrcEntityName());
            if (btpResult == null) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bill_transfer_fail"));
            }
            IObjectCollection destBillCols = btpResult.getBills();
            if (destBillCols == null) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "bill_transfer_fail"));
            }
            String destBillIDs = "";
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                destBillIDs = i == count - 1 ? destBillIDs + destBillInfo.getId() : destBillIDs + destBillInfo.getId() + ",";
            }
            String targetUipk = "";
            if (direction.equals("push")) {
                String uiViewType = "form";
                if (mappingInfo.getIsShowEditUI() == 2) {
                    uiViewType = "list";
                }
                List targetList = new ArrayList();
                targetList = (List)this.jsonToObject(targetInfo);
                EntityObjectInfo entity = MetaDataUtil.getEntityObjectByBosType(BOSObjectType.create((String)targetBosType));
                String fullName = entity.getFullName();
                String oql = "select * where model = '" + fullName + "' and type = '" + uiViewType + "'";
                UIViewCollection uiViewCollection = UIViewFactory.getRemoteInstance().getUIViewCollection(oql);
                boolean isBreak = false;
                for (int i = 0; i < uiViewCollection.size(); ++i) {
                    String uiPK = uiViewCollection.get(i).getUipk();
                    for (int j = 0; j < targetList.size(); ++j) {
                        String uipk = (String)((HashMap)targetList.get(j)).get("uipk");
                        if (!uiPK.equals(uipk)) continue;
                        targetUipk = uipk;
                        isBreak = true;
                        break;
                    }
                    if (isBreak) break;
                }
                if (StringUtils.isEmpty((String)targetUipk)) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "botp_uipk_error"));
                }
            }
            HashMap<String, String> transformResult = new HashMap<String, String>();
            transformResult.put("destBillIDs", destBillIDs);
            transformResult.put("title", mappingInfo.getDestEntityAlias());
            transformResult.put("targetUipk", targetUipk);
            JSONUtils.writeJson(response, transformResult);
            return null;
        }
        catch (Exception e) {
            String message = this.processException(e);
            throw new ShrWebBizException(message, e);
        }
    }

    @RequestMapping(value={"/getDestType"})
    public String getDestTypeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        this.getTargetBotpType(request, response, true);
        return null;
    }

    @RequestMapping(value={"/getSrcType"})
    public String getSrcTypeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.getTargetBotpType(request, response, false);
        return null;
    }

    private void getTargetBotpType(HttpServletRequest request, HttpServletResponse response, boolean isPush) throws SHRWebException {
        Map<String, Object> targetBotp;
        ArrayList<HashMap<String, String>> resultList = new ArrayList<HashMap<String, String>>();
        String uipk = request.getParameter("uipk");
        String bosType = this.getBosTypeByUipk(uipk, request);
        try {
            targetBotp = this.getTargetBotp(bosType, isPush);
        }
        catch (BOSException e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "transfer_rule_not_found"));
        }
        this.assembleResultData(resultList, targetBotp);
        JSONUtils.writeJson(response, resultList);
    }

    private void assembleResultData(List<HashMap<String, String>> resultList, Map<String, Object> botpInfo) {
        String[] bosTypeArr = (String[])botpInfo.get("bosTypeArr");
        String[] aliasArr = (String[])botpInfo.get("aliasArr");
        ArrayList<String> bosTypeList = new ArrayList<String>();
        for (int i = 0; i < bosTypeArr.length; ++i) {
            if (bosTypeList.size() > 0 && bosTypeList.contains(bosTypeArr[i])) continue;
            bosTypeList.add(bosTypeArr[i]);
            String targetBillDisplayName = aliasArr[i];
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("alias", targetBillDisplayName);
            hashMap.put("title", targetBillDisplayName);
            hashMap.put("value", bosTypeArr[i]);
            resultList.add(hashMap);
        }
    }

    private Map<String, Object> getTargetBotp(String bosType, boolean isPush) throws BOSException, SHRWebException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String targetTypeAndAliasString = "";
        IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
        try {
            targetTypeAndAliasString = isPush ? iBOTMapping.getTargetBillTypeList(bosType.toString()) : iBOTMapping.getSourceBillTypeListAndAlias(bosType.toString());
        }
        catch (BOTPException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        String[] targetTypeAndAlias = StringUtil.split((String)targetTypeAndAliasString, (String)"|");
        if (targetTypeAndAlias.length != 2) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "transfer_rule_not_found"));
        }
        String srcBillTypeString = targetTypeAndAlias[0];
        String srcAliasString = targetTypeAndAlias[1];
        String[] srcAlias = StringUtil.split((String)srcAliasString, (String)",");
        String[] srcBillType = StringUtil.split((String)srcBillTypeString, (String)",");
        if (srcBillType == null || srcBillType.length < 1) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "transfer_rule_not_found"));
        }
        result.put("bosTypeArr", srcBillType);
        result.put("aliasArr", srcAlias);
        return result;
    }

    private String getBosTypeByUipk(String uipk, HttpServletRequest request) throws SHRWebException {
        UIViewInfo uiView = UIViewUtil.getUIViewInfoByUIPK(SHRContext.getInstance().getContext(), uipk);
        String model = uiView.getModel();
        if (uiView.getType().equals("dynamicList")) {
            model = request.getParameter("metaDataPath");
        }
        if (StringUtils.isEmpty((String)model)) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "unable_get)bill_model"));
        }
        EntityObjectInfo entity = MetaDataUtil.getEntityObjectByEntityName(model);
        BOSObjectType bosType = entity.getType();
        return bosType.toString();
    }

    @RequestMapping(value={"/getMappingRule"})
    public String getMappingRuleAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException {
        BOTMappingCollection botMappingCollection;
        ArrayList resultList = new ArrayList();
        String uipk = request.getParameter("uipk");
        String sourceBillType = this.getBosTypeByUipk(uipk, request);
        String targetBillType = request.getParameter("destType");
        IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
        try {
            botMappingCollection = iBOTMapping.getMappingCollectionForSelect(sourceBillType, targetBillType, DefineSysEnum.BTP);
        }
        catch (BOTPException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        for (int i = 0; i < botMappingCollection.size(); ++i) {
            String ruleName = botMappingCollection.get(i).getAlias();
            String ruleID = botMappingCollection.get(i).getId().toString();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("alias", ruleName);
            hashMap.put("title", ruleName);
            hashMap.put("value", ruleID);
            resultList.add(hashMap);
        }
        JSONUtils.writeJson(response, resultList);
        return null;
    }

    @RequestMapping(value={"/getMappingRuleForPull"})
    public String getMappingRuleForPullAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        ArrayList resultList = new ArrayList();
        String uipk = request.getParameter("uipk");
        String sourceBillType = request.getParameter("destType");
        String targetBillType = this.getBosTypeByUipk(uipk, request);
        BOTMappingCollection botMappingCollection = null;
        try {
            IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
            botMappingCollection = iBOTMapping.getMappingCollectionForSelect(sourceBillType, targetBillType, DefineSysEnum.BTP);
        }
        catch (BOTPException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (BOSException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        if (botMappingCollection == null) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "transfer_rule_not_found"));
        }
        for (int i = 0; i < botMappingCollection.size(); ++i) {
            String ruleName = botMappingCollection.get(i).getAlias();
            String ruleID = botMappingCollection.get(i).getId().toString();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("alias", ruleName);
            hashMap.put("title", ruleName);
            hashMap.put("value", ruleID);
            resultList.add(hashMap);
        }
        JSONUtils.writeJson(response, resultList);
        return null;
    }

    @RequestMapping(value={"/getTargetPageInfo"})
    public String getPullTargetListAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        HashMap targetPageInfo = new HashMap();
        String targetBosType = request.getParameter("destType");
        String targetInfo = request.getParameter("targetInfo");
        EntityObjectInfo tarEntity = MetaDataUtil.getEntityObjectByBosType(BOSObjectType.create((String)targetBosType));
        String model = tarEntity.getFullName();
        String oql = "select * where model = '" + model + "' and type ='" + "list" + "'";
        UIViewCollection uiViewCollection = new UIViewCollection();
        try {
            uiViewCollection = UIViewFactory.getRemoteInstance().getUIViewCollection(oql);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        List targetList = new ArrayList();
        targetList = (List)this.jsonToObject(targetInfo);
        block2: for (int i = 0; i < uiViewCollection.size(); ++i) {
            String uiPK = uiViewCollection.get(i).getUipk();
            for (int j = 0; j < targetList.size(); ++j) {
                String uipk = (String)((HashMap)targetList.get(j)).get("uipk");
                if (!uiPK.equals(uipk)) continue;
                targetPageInfo = (HashMap)targetList.get(i);
                continue block2;
            }
        }
        if (targetPageInfo.isEmpty()) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "no_bill_found"));
        }
        JSONUtils.writeJson(response, targetPageInfo);
        return null;
    }

    @RequestMapping(value={"/track"})
    public String getRelativeBill(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String targetIds;
        HashMap<String, String> data;
        String targetUipk;
        block10: {
            String billID = request.getParameter("billId");
            String direction = request.getParameter("direction");
            targetUipk = request.getParameter("uipk");
            if (StringUtils.isEmpty((String)billID) || StringUtils.isEmpty((String)direction) || StringUtils.isEmpty((String)targetUipk)) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "parameter_error"));
            }
            if (billID.contains(",")) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "select_one"));
            }
            String targetBillType = this.getBosTypeByUipk(targetUipk, request);
            data = new HashMap<String, String>();
            targetIds = "";
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (direction.equals("trackup")) {
                filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)billID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)targetBillType, CompareType.EQUALS));
                filter.setMaskString("#0 and #1");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)targetBillType, CompareType.EQUALS));
                filter.setMaskString("#0 and #1");
            }
            viewInfo.setFilter(filter);
            IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
            exec.setObjectView(viewInfo);
            try {
                IRowSet rs = exec.executeQuery();
                if (rs != null && rs.size() > 0) {
                    while (rs.next()) {
                        String destid = rs.getString("destObjectID");
                        if (direction.equals("trackup")) {
                            destid = rs.getString("srcObjectID");
                        }
                        targetIds = targetIds + destid + ",";
                    }
                    break block10;
                }
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "source_bill_not_match"));
            }
            catch (BOSException e) {
                throw new SHRWebException(e);
            }
            catch (SQLException e) {
                throw new SHRWebException(e);
            }
        }
        data.put("targetIds", targetIds.substring(0, targetIds.length() - 1));
        data.put("targetUipk", targetUipk);
        JSONUtils.writeJson(response, data);
        return null;
    }

    private Boolean checkReBuildControl(String botpRule, String destType, String srcBillIds) throws ShrWebBizException {
        if (srcBillIds == null) {
            return false;
        }
        String[] idList = srcBillIds.split(",");
        try {
            ObjectStringPK botMappingId = new ObjectStringPK(botpRule);
            IBOTMapping iBOTMapping = BOTMappingFactory.getRemoteInstance();
            BOTMappingInfo botMappingInfo = iBOTMapping.getMappingInfoByPK((IObjectPK)botMappingId);
            String reBuildControl = "";
            String extconfig = botMappingInfo.getExtConfig();
            BotpExtConfigHelper.ExtConfigInfo info = null;
            BotpExtConfigHelper.XMLProcessor processor = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper());
            if (!StringUtils.isEmpty((String)extconfig)) {
                info = processor.marshallingExtConfig(extconfig);
                reBuildControl = info.getReBuildControl();
                if (reBuildControl == null || reBuildControl.equals("")) {
                    reBuildControl = "1";
                }
            } else {
                reBuildControl = "1";
            }
            if (reBuildControl.equals("1")) {
                return true;
            }
            if (reBuildControl.equals("2") ? this.hasReBuild(idList, destType) : this.hasReBuild(idList, destType)) {
                throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "generate_bill_fail"));
            }
            return true;
        }
        catch (Exception exception) {
            throw new ShrWebBizException(exception);
        }
    }

    private boolean hasReBuild(String[] idList, String destBillTypeBOSType) throws BOSException {
        String billIds = StringUtils.arrayToString((Object[])idList, (String)",");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterBill = new FilterInfo();
        FilterInfo filterMapping = new FilterInfo();
        filterBill.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIds, CompareType.INCLUDE));
        filterMapping.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destBillTypeBOSType, CompareType.EQUALS));
        filterBill.mergeFilter(filterMapping, "And");
        viewInfo.setFilter(filterBill);
        IBOTRelation iBOTRelation = BOTRelationFactory.getRemoteInstance();
        BOTRelationCollection relations = iBOTRelation.getCollection(viewInfo);
        return relations != null && relations.size() != 0;
    }

    private Object jsonToObject(String jsonStr) {
        Gson gson = new Gson();
        return gson.fromJson(jsonStr, new TypeToken<List<HashMap<String, String>>>(){}.getType());
    }

    private String processException(Exception e) {
        String message = e.getMessage();
        if (message.startsWith(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "call_busines_method_error"))) {
            message = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "generate_bill_fail");
        }
        return message;
    }
}

