/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.core.view;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.annotation.Action;
import com.kingdee.shr.base.syssetting.component.commonquery.CommonQueryHelper;
import com.kingdee.shr.base.syssetting.component.commonquery.CommonQueryUtils;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.IMetadataSupport;
import com.kingdee.shr.base.syssetting.core.WebPageController;
import com.kingdee.shr.base.syssetting.core.view.IListController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.FieldPermissionHelper;
import com.kingdee.shr.base.syssetting.util.NetCtrlHelper;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

public abstract class ListController
extends WebPageController
implements IListController,
IMetadataSupport {
    public static final String FIELD_PERMISSION_SCRIPT = "fieldPermissionProcessScript";
    public static final String DEFFILTER = "defFilter";
    public static final int DEFCOMP_NO = 0;
    public static final int DEFCOMP_SIMPLEQUERY = 1;
    public static final int DEFCOMP_COMMONQUERY = 2;

    @Override
    @Autowired
    protected void initalizeCompnentActionBind() throws SHRWebException {
        this.getActionManager().registerComponentActionBind("grid.initalize", "initalize");
    }

    @Override
    public String initalizeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return super.initalizeAction(request, response, modelMap);
    }

    @Override
    public String loadAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.getSession().put("stateless_entityViewInfo", this.getDefaultEntityViewInfo(request, response, modelMap));
        this.doFieldPermission(request);
        String defFilter = this.getDefaultSoluFilter(request, response, modelMap);
        request.setAttribute(DEFFILTER, (Object)defFilter);
        return super.loadAction(request, response, modelMap);
    }

    @Override
    public String closeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        return super.closeAction(request, response, modelMap);
    }

    @Override
    public String getListData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        modelMap.put((Object)"DataGridEntityView", (Object)this.getDefaultEntityViewInfo(request, response, modelMap));
        return null;
    }

    protected void fillGridData(GridDataEntity gridDataEntity, List listModel) throws SHRWebException, ShrWebBizException {
        ArrayList<Map> records = new ArrayList<Map>();
        for (int nIndex = 0; nIndex < listModel.size(); ++nIndex) {
            Map info = (Map)listModel.get(nIndex);
            HashMap row = new HashMap();
            records.add(info);
        }
        gridDataEntity.setRows(records);
    }

    protected IQueryExecutor getQueryExecutor(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws ShrWebBizException, SHRWebException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.getQueryPK());
        exec.setObjectView(this.getStatelessEntityViewInfo(request, response, modelMap));
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        return exec;
    }

    @Override
    public EntityViewInfo getDefaultEntityViewInfo(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws ShrWebBizException, SHRWebException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        return entityViewInfo;
    }

    @Override
    public EntityViewInfo getStatelessEntityViewInfo(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws ShrWebBizException, SHRWebException {
        EntityViewInfo entityViewInfo = (EntityViewInfo)this.getSession().get("stateless_entityViewInfo");
        if (entityViewInfo == null) {
            entityViewInfo = this.getDefaultEntityViewInfo(request, response, modelMap);
            this.getSession().put("stateless_entityViewInfo", entityViewInfo);
        }
        return entityViewInfo;
    }

    private EntityViewInfo mergeEntityViews(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, EntityViewInfo baseEntityViewInfo, EntityViewInfo entityViewInfo) throws SHRWebException, ShrWebBizException {
        if (baseEntityViewInfo == null) {
            baseEntityViewInfo = this.getDefaultEntityViewInfo(request, response, modelMap);
        }
        try {
            if (FilterUtility.hasFilterItem((FilterInfo)baseEntityViewInfo.getFilter())) {
                baseEntityViewInfo.getFilter().mergeFilter(entityViewInfo.getFilter(), "AND");
            } else {
                FilterInfo filterInfo = entityViewInfo.getFilter();
                if (filterInfo != null && filterInfo.getFilterItems().size() > 0) {
                    baseEntityViewInfo.setFilter((FilterInfo)filterInfo.clone());
                }
            }
            if (entityViewInfo.getSorter().size() > 0) {
                baseEntityViewInfo.getSorter().clear();
                for (int i = 0; i < entityViewInfo.getSorter().size(); ++i) {
                    entityViewInfo.getSorter().add(entityViewInfo.getSorter().get(i));
                }
            }
        }
        catch (BOSException exception) {
            throw new SHRWebException(exception);
        }
        return baseEntityViewInfo;
    }

    @Override
    public EntityViewInfo mergeDefaultEntityViewInfo(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, EntityViewInfo entityViewInfo) throws ShrWebBizException, SHRWebException {
        return this.mergeEntityViews(request, response, modelMap, this.getDefaultEntityViewInfo(request, response, modelMap), entityViewInfo);
    }

    @Override
    public EntityViewInfo mergeStatelessEntityViewInfo(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, EntityViewInfo entityViewInfo) throws ShrWebBizException, SHRWebException {
        return this.mergeEntityViews(request, response, modelMap, this.getStatelessEntityViewInfo(request, response, modelMap), entityViewInfo);
    }

    private long calcTotalCount(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) {
        long totalCount = 0L;
        try {
            totalCount = this.getQueryExecutor(request, response, modelMap).getRowCount();
        }
        catch (Throwable e) {
            this.logger.error((Object)"get total record count error!", e);
            totalCount = 0L;
        }
        return totalCount;
    }

    @Override
    @RequestMapping(params={"method=firstPage"})
    @Action
    public String firstPageAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    @RequestMapping(params={"method=previewPage"})
    @Action
    public String previewPageAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    @RequestMapping(params={"method=nextPage"})
    @Action
    public String nextPageAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    public String lastPageAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    public String advanceSearchAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        return "";
    }

    @Override
    public String addNewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String editUrl = this.getEditUrl(request, response, modelMap);
        editUrl = editUrl + "?" + "method" + "=" + "initalize" + "&operateState=addNew";
        editUrl = this.appendConversationToUrl(request, editUrl);
        return "redirect:" + editUrl;
    }

    private void setCurrentPage(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String pageParam = request.getParameter("page");
        int currentPage = Integer.parseInt(pageParam);
        this.getSession().put("currentPage", currentPage);
    }

    @Override
    public String editAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String modelID = request.getParameter("modelID");
        if (modelID == null || modelID.length() <= 0) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "record_not_found"));
        }
        String editUrl = this.getEditUrl(request, response, modelMap);
        editUrl = editUrl + "?" + "method" + "=" + "initalize" + "&operateState=edit";
        editUrl = editUrl + "&modelID=" + URLEncoder.encode(modelID);
        editUrl = this.appendConversationToUrl(request, editUrl);
        return "redirect:" + editUrl;
    }

    @Override
    public String viewAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String modelID = request.getParameter("modelID");
        if (modelID == null || modelID.length() <= 0) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "record_not_found"));
        }
        String viewUrl = this.getViewUrl(request, response, modelMap);
        viewUrl = viewUrl + "?" + "method" + "=" + "initalize" + "&operateState=view";
        viewUrl = viewUrl + "&modelID=" + URLEncoder.encode(modelID);
        viewUrl = this.appendConversationToUrl(request, viewUrl);
        return "redirect:" + viewUrl;
    }

    @Override
    public String deleteAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        String modelID = request.getParameter("modelID");
        if (modelID == null || modelID.length() <= 0) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "no_selected_record"));
        }
        Object[] ids = null;
        try {
            ids = modelID.split(",");
            ObjectUuidPK[] objects = new ObjectUuidPK[ids.length];
            for (int nIndex = 0; nIndex < ids.length; ++nIndex) {
                objects[nIndex] = new ObjectUuidPK(((String)ids[nIndex]).toString());
            }
            this.getBizInterface().delete((IObjectPK[])objects);
            JSONUtils.SUCCESS(null);
        }
        catch (Exception exception) {
            throw new ShrWebBizException(exception.getMessage());
        }
        finally {
            try {
                NetCtrlHelper.batchReleaseObjIDForUpdate(Arrays.asList((Object[])ids));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String refreshAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        return null;
    }

    @Override
    public String printAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, ShrWebBizException {
        return null;
    }

    private void doFieldPermission(HttpServletRequest request) throws ShrWebBizException, SHRWebException {
        IObjectPK userPK = SHRContext.getInstance().getContext().getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(this.getMainOrgInfo().getId());
        StringBuffer fieldPermissionScript = FieldPermissionHelper.doQueryFieldPermission(this.getQueryPK(), userPK, (IObjectPK)orgPK);
        request.setAttribute(FIELD_PERMISSION_SCRIPT, (Object)fieldPermissionScript.toString());
    }

    protected String appendConversationToUrl(HttpServletRequest request, String url) throws SHRWebException {
        if (url == null) {
            return url;
        }
        if (url.indexOf("conversationid") >= 0) {
            return url;
        }
        if (url.indexOf("?") < 0) {
            url = url + "?";
            url = url + "conversationid" + "=" + this.getConversationID();
        } else {
            url = url + "&";
            url = url + "conversationid" + "=" + this.getConversationID();
        }
        return url;
    }

    private String getDefaultSoluFilter(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        int defQueryComp = this.getDefQueryComp();
        String parentPageName = "";
        if (defQueryComp == 0) {
            return null;
        }
        if (defQueryComp == 1) {
            parentPageName = "com.kingdee.bos.webframework.component.simplequery.SimpleQueryController";
        } else if (defQueryComp == 2) {
            parentPageName = "commonquery.CommonQueryDialog";
        }
        String filter = "";
        Context ctx = SHRContext.getInstance().getContext();
        String queryPK = this.getQueryPK().getFullName();
        BOSUuid orgID = this.getMainOrgInfo().getId();
        BOSUuid userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        try {
            IQuerySolution iSolution = QuerySolutionFactory.getRemoteInstance();
            StringBuffer oql = new StringBuffer("where isuserdefaultsolu = 1");
            oql.append(" and queryobjectname = '" + queryPK + "'").append(" and parentuiname = '" + parentPageName + "'").append(" and orgid = '" + orgID + "'").append(" and owner = '" + userID + "'");
            QuerySolutionInfo defsolution = iSolution.getQuerySolutionInfo(oql.toString());
            if (defsolution != null) {
                filter = defsolution.getQueryPanelInfo().get(0).getFilterInfo();
                filter = this.dealFilter(filter, queryPK);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filter;
    }

    private String dealFilter(String filter, String queryPK) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        MetaDataPK queryObjectPK = new MetaDataPK(queryPK);
        QueryInfo queryInfo = CommonQueryHelper.getQueryInfo(ctx, (IMetaDataPK)queryObjectPK);
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(filter);
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                for (int i = 0; i < filterItemCol.size(); ++i) {
                    String filterValue;
                    FilterItemInfo filterItemInfo = filterItemCol.get(i);
                    String filterField = filterItemInfo.getPropertyName();
                    String compareOp = filterItemInfo.getCompareType().toString();
                    String string = filterValue = filterItemInfo.getCompareValue() == null ? null : filterItemInfo.getCompareValue().toString();
                    if (this.isUsingF7(filterField, queryInfo)) {
                        if (filter.indexOf(".name ") > 0) {
                            filterItemInfo.setPropertyName(filterField.replaceAll(".name ", ".id "));
                        }
                        if (filter.indexOf(".number ") > 0) {
                            filterItemInfo.setPropertyName(filterField.replaceAll(".number ", ".id "));
                        }
                    }
                    if ((CompareType.LIKE.toString().equals(compareOp) || CompareType.NOTLIKE.toString().equals(compareOp)) && filterValue != null && filterValue.indexOf("$macro") < 0) {
                        filterItemInfo.setPropertyName(filterField.replaceAll(filterField, "lower(" + filterField + ")"));
                        filterItemInfo.setCompareValue((Object)filterValue.replaceAll(filterValue, filterValue.toLowerCase()));
                    }
                    if (filterValue == null) continue;
                    SimpleDateFormat sp = new SimpleDateFormat("yyyy-MM-dd");
                    if (filterValue.equals("today")) {
                        Date today = new Date(System.currentTimeMillis());
                        String strToday = sp.format(today);
                        filterItemInfo.setCompareValue((Object)filterValue.replaceAll(filterValue, strToday));
                        continue;
                    }
                    if (filterValue.equals("yesterday")) {
                        Date yesterday = new Date(System.currentTimeMillis() - 86400000L);
                        String strYesterday = sp.format(yesterday);
                        filterItemInfo.setCompareValue((Object)filterValue.replaceAll(filterValue, strYesterday));
                        continue;
                    }
                    if (!filterValue.equals("tomorrow")) continue;
                    Date tomorrow = new Date(System.currentTimeMillis() + 86400000L);
                    String strTomorrow = sp.format(tomorrow);
                    filterItemInfo.setCompareValue((Object)filterValue.replaceAll(filterValue, strTomorrow));
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo.toString();
    }

    private boolean isUsingF7(String queryFieldName, QueryInfo queryInfo) {
        String type;
        DataObject dataObject = QueryUtils.getRefMetaData(null, (QueryInfo)queryInfo, (String)queryFieldName);
        return dataObject != null && CommonQueryUtils.isF7Type(type = dataObject.getName());
    }

    protected int getDefQueryComp() {
        return 0;
    }

    protected abstract String getEditUrl(HttpServletRequest var1, HttpServletResponse var2, ModelMap var3);

    protected abstract String getViewUrl(HttpServletRequest var1, HttpServletResponse var2, ModelMap var3);

    protected abstract ICoreBase getBizInterface() throws SHRWebException, ShrWebBizException;

    protected abstract IMetaDataPK getQueryPK() throws SHRWebException, ShrWebBizException;
}

