/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.log;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.LogServerUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.permission.helper.SHRMenuServiceHelper;
import com.kingdee.shr.base.syssetting.ServiceInfo;
import com.kingdee.shr.base.syssetting.action.DataPlatformAction;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.log.IOperateLogService;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ButtonInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.card.model.CardParams;
import com.kingdee.shr.common.model.RemoteCallMessage;
import com.kingdee.shr.log.LogLevel;
import com.kingdee.shr.log.cache.LogConfigBean;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class AbstractOperateLogService
implements IOperateLogService {
    private static Logger logger = Logger.getLogger(AbstractOperateLogService.class);
    protected Context ctx;
    protected LogConfigBean logConfig;
    protected String buttonCaptionAlias;
    protected String buttonName;
    protected String method;
    protected String uipk;
    protected Object[] logKeys;
    protected Map<String, String> logPkMappingBizPk = new HashMap<String, String>();

    protected void initProperties(HttpServletRequest request) {
        String alias;
        this.uipk = DynamicUtil.getUIPK(request);
        this.method = request.getParameter("method");
        if (StringUtils.isEmpty((String)this.uipk)) {
            this.uipk = request.getParameter("pUipk");
        }
        if (StringUtils.isEmpty((String)this.method)) {
            this.method = "initalize";
        }
        this.buttonName = !StringUtils.isEmpty((String)this.logConfig.getButtonName()) ? this.logConfig.getButtonName() : this.method;
        if (null != this.logConfig.getCaption() && !this.logConfig.getCaption().isEmpty() && !StringUtils.isEmpty((String)(alias = (String)this.logConfig.getCaption().get(com.kingdee.util.LocaleUtils.getShortCode((Locale)this.ctx.getLocale()))))) {
            this.buttonCaptionAlias = alias;
        }
    }

    @Override
    public void preLogHandle(HttpServletRequest request) throws SHRWebException {
        this.initProperties(request);
        List<HashMap<String, Object>> logDatas = this.getLogDatas(request);
        this.doWriteLog(logDatas);
    }

    private void doWriteLog(List<HashMap<String, Object>> logDatas) throws SHRWebException {
        try {
            if (null == logDatas || logDatas.isEmpty()) {
                return;
            }
            Object[] keys = this.writeLog(logDatas);
            this.logKeys = keys;
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    protected final boolean writeLogByLogConfigParam(HttpServletRequest request) throws SHRWebException {
        if (!(null == this.logConfig || null == this.logConfig.getParams() && StringUtils.isEmpty((String)this.logConfig.getButtonName()))) {
            List<HashMap<String, Object>> logDatas = this.getCommonLogDatas(request, UIViewUtil.getUIViewInfoByUIPK(this.ctx, this.uipk));
            this.doWriteLog(logDatas);
            return true;
        }
        return false;
    }

    protected void writeSaveLog(HttpServletRequest request) throws SHRWebException {
        if (this.writeLogByLogConfigParam(request)) {
            this.updateLog(request);
            return;
        }
        UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(this.ctx, this.uipk);
        Object obj = request.getAttribute("dynamic_model");
        if (null == obj) {
            try {
                this.logKeys = this.writeLog(this.getCommonLogDatas(request, uiViewInfo));
                this.updateLog(request);
            }
            catch (BOSException e) {
                throw new SHRWebException(e);
            }
            return;
        }
        if (obj instanceof CoreBaseInfo) {
            CoreBaseInfo model = (CoreBaseInfo)request.getAttribute("dynamic_model");
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(1);
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("isSuccessed", "0");
            this.assembleLogData(request, uiViewInfo, map);
            String numberLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"number", (Context)this.ctx);
            String nameLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"name", (Context)this.ctx);
            this.assembleOperateObjForCoreBaseInfo(model, map, numberLabel, nameLabel);
            list.add(this.assembleLogData(this.ctx, map));
            try {
                if (LogLevel.SIMPLE_LEVEL.equals((Object)this.logConfig.getLevel())) {
                    this.logKeys = this.writeLog(list);
                    this.updateLog(request);
                    return;
                }
                Map lps = MetaDataUtil.getCompositionLinkProperties((Context)this.ctx, (BOSObjectType)model.getBOSType());
                IObjectCollection eColl = null;
                IObjectValue ov = null;
                if (null == lps || lps.isEmpty()) {
                    this.logKeys = this.writeLog(list);
                    this.updateLog(request);
                    return;
                }
                for (Map.Entry lp : lps.entrySet()) {
                    if (model.get((String)lp.getKey()) instanceof IObjectValue) {
                        ov = (IObjectValue)model.get((String)lp.getKey());
                        list.add(this.assembleLogData(this.ctx, this.assembleEntriseData(ov, map, (String)lp.getKey())));
                        continue;
                    }
                    eColl = (IObjectCollection)model.get((String)lp.getKey());
                    if (null == eColl || eColl.isEmpty()) continue;
                    int total = eColl.size();
                    for (int i = 0; i < total; ++i) {
                        ov = eColl.getObject(i);
                        list.add(this.assembleLogData(this.ctx, this.assembleEntriseData(ov, map, (String)lp.getKey())));
                    }
                }
                this.logKeys = this.writeLog(list);
                this.updateLog(request);
            }
            catch (BOSException e) {
                throw new SHRWebException(e);
            }
        }
    }

    private Map<String, String> assembleEntriseData(IObjectValue ov, Map<String, String> map, String propertyName) {
        HashMap<String, String> mapEntry = new HashMap<String, String>(4);
        mapEntry.putAll(map);
        StringBuffer s = new StringBuffer(map.get("operateObj"));
        s.append(",");
        s.append(propertyName).append(".id:").append(ov.get("id"));
        mapEntry.put("operateObj", s.toString());
        return mapEntry;
    }

    protected abstract Object[] writeLog(List<HashMap<String, Object>> var1) throws BOSException;

    protected final Object[] writeLogToAppLog(List<HashMap<String, Object>> logDatas) throws BOSException {
        if (null == logDatas || logDatas.isEmpty()) {
            return null;
        }
        IAppLog iAppLog = AppLogFactory.getLocalInstance((Context)this.ctx);
        Object[] result = new Object[logDatas.size()];
        int total = logDatas.size();
        for (int i = 0; i < total; ++i) {
            HashMap<String, Object> each = logDatas.get(i);
            iAppLog.writeLog(each);
            String logPk = each.get("FID").toString();
            String bizPk = (String)each.get("shr_biz_id");
            result[i] = new ObjectUuidPK(BOSUuid.read((String)logPk));
            if (StringUtils.isEmpty((String)bizPk)) continue;
            this.logPkMappingBizPk.put(logPk, bizPk);
        }
        return result;
    }

    private List<HashMap<String, Object>> getLogDatas(HttpServletRequest request) throws SHRWebException {
        if (!StringUtils.isEmpty((String)this.uipk)) {
            UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(this.ctx, this.uipk);
            if (null == uiViewInfo) {
                return null;
            }
            return this.getLogDatas(request, uiViewInfo);
        }
        return null;
    }

    private List<HashMap<String, Object>> getLogDatas(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        ButtonInfo buttonInfo = this.getButtonInfo(uiViewInfo);
        if (null != buttonInfo && StringUtils.isEmpty((String)this.buttonCaptionAlias) && !StringUtils.isEmpty((String)buttonInfo.getCaption())) {
            this.buttonCaptionAlias = buttonInfo.getCaption();
        }
        if (null == buttonInfo || buttonInfo.isVisible() && buttonInfo.isLogenable()) {
            if ("save".equals(this.method)) {
                return this.saveButtonLogData(request, uiViewInfo);
            }
            if ("submit".equals(this.method)) {
                return this.submitButtonLogData(request, uiViewInfo);
            }
            if ("disable".equals(this.method) || "enable".equals(this.method) || "batchEnable".equals(this.method) || "batchDisable".equals(this.method)) {
                if (StringUtils.isEmpty((String)this.buttonCaptionAlias)) {
                    if ("batchEnable".equals(this.method)) {
                        this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"batchEnable", (Context)this.ctx);
                    } else if ("batchDisable".equals(this.method)) {
                        this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"batchDisable", (Context)this.ctx);
                    }
                }
                return this.enableOrDisableButtonLogData(request, uiViewInfo);
            }
            if ("delete".equals(this.method) || "batchDelete".equals(this.method)) {
                if (StringUtils.isEmpty((String)this.buttonCaptionAlias) && "batchDelete".equals(this.method)) {
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"batchDelete", (Context)this.ctx);
                }
                return this.deleteButtonLogData(request, uiViewInfo);
            }
            if ("print".equals(this.method) || "report".equals(this.method)) {
                if (StringUtils.isEmpty((String)this.buttonCaptionAlias)) {
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"print", (Context)this.ctx);
                }
                return this.reportButtonLogData(request, uiViewInfo);
            }
            if ("edit".equals(this.method)) {
                return null;
            }
            if ("exportToExcel".equals(this.method) || "exportCurrent".equals(this.method) || "exportCurrentAsyn".equals(this.method) || "exportToExcelAsyn".equals(this.method)) {
                if (null != buttonInfo) {
                    this.buttonCaptionAlias = buttonInfo.getCaption();
                }
                return this.exportToExcelButton(request, uiViewInfo);
            }
            if ("setComUse".equals(this.method) || "cancelComUse".equals(this.method)) {
                if ("cancelComUse".equals(this.method)) {
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"baseitem_cancelComUse", (Context)this.ctx);
                }
                return this.comUseOrUnComUserButton(request, uiViewInfo);
            }
            if ("setIndexs".equals(this.method)) {
                this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"baseitem_setIndexs", (Context)this.ctx);
                return this.setIndexsButton(request, uiViewInfo);
            }
            if ("unDistribute".equals(this.method)) {
                this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"baseitem_unDistribute", (Context)this.ctx);
                return this.unDistributeButton(request, uiViewInfo);
            }
            if ("updateImportTemplateDisplay".equals(this.method)) {
                String type = request.getParameter("type");
                if ("1".equals(type)) {
                    buttonInfo = this.getButtonInfo(uiViewInfo, "displayName");
                    if (null != buttonInfo) {
                        this.buttonCaptionAlias = buttonInfo.getCaption();
                    }
                } else if ("2".equals(type) && null != (buttonInfo = this.getButtonInfo(uiViewInfo, "displayNameAndNumber"))) {
                    this.buttonCaptionAlias = buttonInfo.getCaption();
                }
            } else {
                if ("hrOrgUnitTrans".equals(this.method)) {
                    return this.hrOrgUnitTransButton(request, uiViewInfo);
                }
                if ("dataplatformService".equals(this.method)) {
                    return this.dataplatformService(request, uiViewInfo);
                }
                if ("resetOTPKey".equals(this.method) || "getOTPKey".equals(this.method)) {
                    return null;
                }
            }
            if (this.writeLogByLogConfigParam(request)) {
                return null;
            }
            if (null != buttonInfo) {
                return this.getCommonLogDatas(request, uiViewInfo);
            }
        }
        return null;
    }

    private List<HashMap<String, Object>> exportToExcelButton(HttpServletRequest request, UIViewInfo uiViewInfo) {
        ArrayList<HashMap<String, Object>> list0 = new ArrayList<HashMap<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("isSuccessed", "0");
        this.assembleLogData(request, uiViewInfo, map);
        map.put("operateObj", "");
        list0.add(this.assembleLogData(this.ctx, map));
        return list0;
    }

    protected List<HashMap<String, Object>> reportButtonLogData(HttpServletRequest request, UIViewInfo uiViewInfo) {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("isSuccessed", "0");
        this.assembleLogData(request, uiViewInfo, map);
        String billId = this.getBillId(request);
        this.generateMultiBillLog(billId, map, list);
        return list;
    }

    protected final ButtonInfo getButtonInfo(UIViewInfo uiViewInfo) {
        return this.getButtonInfo(uiViewInfo, this.buttonName);
    }

    protected final ButtonInfo getButtonInfo(UIViewInfo uiViewInfo, String tmpButtonName) {
        Map<String, ButtonInfo> map = uiViewInfo.getButtons();
        if (null == map || map.isEmpty()) {
            return null;
        }
        ButtonInfo bi = map.get(tmpButtonName);
        if (null != bi && bi.isVisible() && bi.isLogenable()) {
            return bi;
        }
        return null;
    }

    protected List<HashMap<String, Object>> saveButtonLogData(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        Object obj = request.getAttribute("dynamic_model");
        if (obj instanceof CoreBaseInfo) {
            CoreBaseInfo model = (CoreBaseInfo)request.getAttribute("dynamic_model");
            if (StringUtils.isEmpty((String)this.buttonCaptionAlias)) {
                this.buttonCaptionAlias = null == model.getId() ? SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "addnew") : SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "edit");
            }
        }
        return null;
    }

    protected List<HashMap<String, Object>> submitButtonLogData(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        if (this.writeLogByLogConfigParam(request)) {
            return null;
        }
        CoreBaseInfo model = (CoreBaseInfo)request.getAttribute("dynamic_model");
        if (null == model) {
            return this.getCommonLogDatas(request, uiViewInfo);
        }
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(1);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("isSuccessed", "0");
        this.assembleLogData(request, uiViewInfo, map);
        String numberLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"number", (Context)this.ctx);
        String nameLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"name", (Context)this.ctx);
        this.assembleOperateObjForCoreBaseInfo(model, map, numberLabel, nameLabel);
        list.add(this.assembleLogData(this.ctx, map));
        return list;
    }

    protected final EntityViewInfo getEntityViewInfo(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        String billId = this.getBillId(request);
        Set<String> ids = this.getIDSet(billId);
        FilterInfo filter = new FilterInfo();
        if (ids.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"-99999"));
        } else if (ids.size() == 1) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(AbstractOperateLogService.getSelectors(uiViewInfo));
        view.setFilter(filter);
        return view;
    }

    protected final Set<String> getIDSet(String billId) {
        if (StringUtils.isEmpty((String)billId)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> set = new HashSet<String>();
        if (billId.indexOf(",") == -1) {
            set.add(billId);
        } else {
            String[] ids;
            for (String id : ids = billId.split(",")) {
                set.add(id);
            }
        }
        return set;
    }

    protected final CoreBaseCollection getCoreBaseCollection(HttpServletRequest request, UIViewInfo uiViewInfo) throws BOSException, SHRWebException {
        String billId = this.getBillId(request);
        if (StringUtils.isEmpty((String)billId)) {
            return null;
        }
        String[] bids = billId.split(",");
        if (StringUtils.isEmpty((String)bids[0])) {
            return null;
        }
        return MetaDataUtil.getBizInterface((Context)this.ctx, (BOSObjectType)MetaDataUtil.getBOSObjectTypeById(bids[0])).getCollection(this.getEntityViewInfo(request, uiViewInfo));
    }

    protected List<HashMap<String, Object>> enableOrDisableButtonLogData(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        if (this.writeLogByLogConfigParam(request)) {
            return null;
        }
        return this.assembleButtonLogDataByBillId(request, uiViewInfo);
    }

    protected final List<HashMap<String, Object>> assembleButtonLogDataByBillId(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        String billId = this.getBillId(request);
        if (StringUtils.isEmpty((String)billId)) {
            return null;
        }
        try {
            CoreBaseCollection coll = this.getCoreBaseCollection(request, uiViewInfo);
            if (null == coll || coll.isEmpty()) {
                return null;
            }
            ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("isSuccessed", "0");
            this.assembleLogData(request, uiViewInfo, map);
            String numberLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"number", (Context)this.ctx);
            String nameLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"name", (Context)this.ctx);
            HashMap<String, String> map0 = null;
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                CoreBaseInfo model = coll.get(i);
                map0 = new HashMap<String, String>(4);
                map0.putAll(map);
                this.assembleOperateObjForCoreBaseInfo(model, map0, numberLabel, nameLabel);
                this.assembleBizId(map0, list, model.getId().toString());
            }
            return list;
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    private void assembleBizId(Map<String, String> map, List<HashMap<String, Object>> list, String bizId) {
        HashMap<String, Object> logData = this.assembleLogData(this.ctx, map);
        logData.put("shr_biz_id", bizId);
        list.add(logData);
    }

    protected final void assembleOperateObjForCoreBaseInfo(CoreBaseInfo model, Map<String, String> map0, String numberLabel, String nameLabel) {
        map0.put("operateObj", this.getOperateObjByCoreBaseInfo(model, numberLabel, nameLabel));
    }

    protected final String getOperateObjByCoreBaseInfo(CoreBaseInfo model, String numberLabel, String nameLabel) {
        if (null != model && !StringUtils.isEmpty((String)((String)model.get("number")))) {
            return MessageFormat.format("{0}:{1}", numberLabel, (String)model.get("number"));
        }
        if (null != model && !StringUtils.isEmpty((String)((String)model.get("name")))) {
            String nameValue = (String)model.get("name");
            if (!StringUtils.isEmpty((String)nameValue) && nameValue.startsWith("{") && nameValue.endsWith("}")) {
                try {
                    HashMap nameValueMap = JSONUtils.convertJsonToObject(this.ctx, nameValue);
                    return MessageFormat.format("{0}:{1}", nameLabel, nameValueMap.get(com.kingdee.util.LocaleUtils.getShortCode((Locale)this.ctx.getLocale())));
                }
                catch (SHRWebException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    return MessageFormat.format("{0}:{1}", nameLabel, nameValue);
                }
            }
            return MessageFormat.format("{0}:{1}", nameLabel, nameValue);
        }
        if (null != model && null != model.getId()) {
            return MessageFormat.format("{0}:{1}", "ID", model.getId().toString());
        }
        return this.buttonCaptionAlias;
    }

    protected String getBillId(HttpServletRequest request) {
        String billId = request.getParameter("billID");
        if (StringUtils.isEmpty((String)billId)) {
            billId = request.getParameter("billId");
        }
        if (StringUtils.isEmpty((String)billId)) {
            billId = (String)request.getAttribute("billId");
        }
        return billId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<HashMap<String, Object>> dataplatformService(HttpServletRequest request, UIViewInfo uiViewInfo) throws ShrWebBizException {
        try {
            RemoteCallMessage rcm = DataPlatformAction.initMessage(this.ctx, request);
            ArrayList<HashMap<String, Object>> list0 = new ArrayList<HashMap<String, Object>>();
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("isSuccessed", "0");
            this.assembleLogData(request, uiViewInfo, map);
            map.put("operateObj", "");
            if ("/dataplateform/dataSet.do".equals(rcm.getServiceType())) {
                if ("preview".equals(rcm.getParams().get("method"))) {
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"preview_data", (Context)this.ctx);
                    map.put("operateObj", MessageFormat.format("dataSetId:{0}", rcm.getParams().get("dataSetId")));
                    map.put("operate", MessageFormat.format("{0}-{1}", map.get("functionName"), this.buttonCaptionAlias));
                } else if ("getCustomSQLData".equals(rcm.getParams().get("method"))) {
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"run_sql", (Context)this.ctx);
                    map.put("operate", MessageFormat.format("{0}-{1}", map.get("functionName"), this.buttonCaptionAlias));
                } else {
                    if (!"deleteCustomSQL".equals(rcm.getParams().get("method"))) return null;
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"delete_custom_sql", (Context)this.ctx);
                    map.put("operateObj", MessageFormat.format("customSQLID:{0}", rcm.getParams().get("customSQLID")));
                    map.put("operate", MessageFormat.format("{0}-{1}", map.get("functionName"), this.buttonCaptionAlias));
                }
            } else if ("/dataplateform/page.do".equals(rcm.getServiceType())) {
                if ("doSave".equals(rcm.getParams().get("method"))) {
                    Map obj = null;
                    if (rcm.getParams().get("page") instanceof Map) {
                        obj = (Map)rcm.getParams().get("page");
                    }
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"save_page", (Context)this.ctx);
                    map.put("operateObj", MessageFormat.format("pageId: {0}", null != obj ? obj.get("pageId") : ""));
                    map.put("operate", MessageFormat.format("{0}-{1}", map.get("functionName"), this.buttonCaptionAlias));
                } else {
                    if (!"resetConfig".equals(rcm.getParams().get("method"))) return null;
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"reset_page", (Context)this.ctx);
                    map.put("operateObj", MessageFormat.format("pageId: {0}", rcm.getParams().get("pageId")));
                    map.put("operate", MessageFormat.format("{0}-{1}", map.get("functionName"), this.buttonCaptionAlias));
                }
            } else if ("/dataplateform/card.do".equals(rcm.getServiceType())) {
                if (!"execute".equals(rcm.getParams().get("method"))) return null;
                String cardParamsJson = JSONUtils.convertObjectToJson(this.ctx, rcm.getParams().get("cardParams"));
                CardParams cardParams = (CardParams)JSONUtils.convertJsonToObject(this.ctx, cardParamsJson, CardParams.class);
                this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"run_card", (Context)this.ctx);
                map.put("operateObj", MessageFormat.format("cardId:{0}", cardParams.getCardNodeId()));
                map.put("operate", MessageFormat.format("{0}-{1}", map.get("functionName"), this.buttonCaptionAlias));
            } else {
                if (!"/dataplateform/solution.do".equals(rcm.getServiceType())) return null;
                if ("doSave".equals(rcm.getParams().get("method"))) {
                    Map obj = null;
                    if (rcm.getParams().get("solution") instanceof Map) {
                        obj = (Map)rcm.getParams().get("solution");
                    }
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"save_solution", (Context)this.ctx);
                    map.put("operateObj", MessageFormat.format("solutionId:{0}", null != obj ? obj.get("solutionId") : ""));
                    map.put("operate", MessageFormat.format("{0}-{1}", map.get("functionName"), this.buttonCaptionAlias));
                } else if ("deleteSolutionById".equals(rcm.getParams().get("method"))) {
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"delete_solution", (Context)this.ctx);
                    map.put("operateObj", MessageFormat.format("solutionId:{0}", rcm.getParams().get("solutionId")));
                    map.put("operate", MessageFormat.format("{0}-{1}", map.get("functionName"), this.buttonCaptionAlias));
                } else {
                    if (!"setIsDefault".equals(rcm.getParams().get("method"))) return null;
                    this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.dataplatform.DataplatformResource", (String)"setdefault_solution", (Context)this.ctx);
                    map.put("operateObj", MessageFormat.format("solutionId:{0}", rcm.getParams().get("solutionId")));
                    map.put("operate", MessageFormat.format("{0}-{1}", map.get("functionName"), this.buttonCaptionAlias));
                }
            }
            list0.add(this.assembleLogData(this.ctx, map));
            return list0;
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    protected List<HashMap<String, Object>> deleteButtonLogData(HttpServletRequest request, UIViewInfo uiViewInfo) throws SHRWebException {
        if (StringUtils.isEmpty((String)this.buttonCaptionAlias)) {
            this.buttonCaptionAlias = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"delete", (Context)this.ctx);
        }
        if (this.writeLogByLogConfigParam(request)) {
            return null;
        }
        String logModelStr = request.getParameter("logModel");
        if (!StringUtils.isEmpty((String)logModelStr)) {
            List list = (List)JSONUtils.convertJsonToObject(this.ctx, logModelStr, List.class);
            if (null == list || list.isEmpty()) {
                return null;
            }
            ArrayList<HashMap<String, Object>> list0 = new ArrayList<HashMap<String, Object>>();
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("isSuccessed", "0");
            this.assembleLogData(request, uiViewInfo, map);
            String numberLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"number", (Context)this.ctx);
            String nameLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"name", (Context)this.ctx);
            HashMap<String, String> map0 = null;
            for (int i = 0; i < list.size(); ++i) {
                LinkedTreeMap object = (LinkedTreeMap)list.get(i);
                map0 = new HashMap<String, String>(4);
                map0.putAll(map);
                if (!StringUtils.isEmpty((String)((String)object.get((Object)"number")))) {
                    map0.put("operateObj", MessageFormat.format("{0}:{1}", numberLabel, object.get((Object)"number")));
                } else if (!StringUtils.isEmpty((String)((String)object.get((Object)"name")))) {
                    map0.put("operateObj", MessageFormat.format("{0}:{1}", nameLabel, object.get((Object)"name")));
                } else {
                    if (StringUtils.isEmpty((String)((String)object.get((Object)"id")))) continue;
                    map0.put("operateObj", MessageFormat.format("ID:{0}", object.get((Object)"id")));
                }
                list0.add(this.assembleLogData(this.ctx, map0));
            }
            return list0;
        }
        return this.assembleButtonLogDataByBillId(request, uiViewInfo);
    }

    private List<HashMap<String, Object>> getCommonLogDatas(HttpServletRequest request, UIViewInfo uiViewInfo) {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("isSuccessed", "0");
        this.assembleLogData(request, uiViewInfo, map);
        this.assembleLogOperateObj(request, uiViewInfo, map, list);
        return list;
    }

    protected final void assembleLogData(HttpServletRequest request, UIViewInfo uiViewInfo, Map<String, String> map) {
        ServiceInfo serviceInfo;
        String serviceId = request.getParameter("serviceId");
        if (null != this.logConfig.getParams()) {
            this.calButtonCaptionAliasByParams(request, uiViewInfo);
        }
        if (null == (serviceInfo = SHRMenuServiceHelper.getServiceInfo((Context)this.ctx, (String)serviceId)) || StringUtils.isEmpty((String)serviceInfo.getAlias())) {
            map.put("functionName", uiViewInfo.getName());
            map.put("operate", MessageFormat.format("{0} {1}", uiViewInfo.getName(), this.buttonCaptionAlias));
        } else {
            map.put("functionName", serviceInfo.getAlias());
            map.put("operate", MessageFormat.format("{0}-{1} {2}", serviceInfo.getAlias(), uiViewInfo.getName(), this.buttonCaptionAlias));
        }
    }

    protected final void calButtonCaptionAliasByParams(HttpServletRequest request, UIViewInfo uiViewInfo) {
        Map p;
        if (this.logConfig.getParams() instanceof Map && (p = (Map)this.logConfig.getParams()).containsKey("i18nMethod")) {
            Map i18nMethod = (Map)p.get("i18nMethod");
            String pkg = (String)i18nMethod.get("package");
            String file = (String)i18nMethod.get("file");
            String key = (String)i18nMethod.get("key");
            if (!(StringUtils.isEmpty((String)pkg) || StringUtils.isEmpty((String)file) || StringUtils.isEmpty((String)key))) {
                try {
                    Map result = null;
                    result = com.kingdee.util.LocaleUtils.locale_zh_CN.toString().equals(LocaleUtils.getLocal((Context)this.ctx)) ? SHRWebResource.getSHRFileResource(this.ctx, pkg, file) : SHRWebResource.getFileResource((Context)this.ctx, (String)pkg, (String)file);
                    this.buttonCaptionAlias = (String)result.get(key);
                }
                catch (EASBizException eASBizException) {
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
            }
            if (StringUtils.isEmpty((String)this.buttonCaptionAlias)) {
                this.buttonCaptionAlias = this.method;
            }
        }
    }

    protected void assembleLogOperateObj(HttpServletRequest request, UIViewInfo uiViewInfo, Map<String, String> map, List<HashMap<String, Object>> list) {
        String numberLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"number", (Context)this.ctx);
        String nameLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"name", (Context)this.ctx);
        if (null != this.logConfig.getParams()) {
            this.generateOperateObjByLogParam(request, uiViewInfo, map, list);
            return;
        }
        String id = request.getParameter("id");
        String name = request.getParameter("name");
        String number = request.getParameter("number");
        String billId = this.getBillId(request);
        String selectIds = request.getParameter("selectIds");
        String billIds = request.getParameter("billIds");
        if (!StringUtils.isEmpty((String)number)) {
            map.put("operateObj", numberLabel + ":" + number);
        } else if (!StringUtils.isEmpty((String)name)) {
            map.put("operateObj", nameLabel + ":" + name);
        } else if (!StringUtils.isEmpty((String)id)) {
            map.put("operateObj", "ID:" + id);
        } else {
            if (!StringUtils.isEmpty((String)billId)) {
                this.generateMultiBillLog(billId, map, list);
                return;
            }
            if (!StringUtils.isEmpty((String)selectIds)) {
                this.generateMultiBillLog(selectIds, map, list);
                return;
            }
            if (!StringUtils.isEmpty((String)billIds)) {
                this.generateMultiBillLog(billIds, map, list);
                return;
            }
            map.put("operateObj", this.buttonCaptionAlias);
        }
        list.add(this.assembleLogData(this.ctx, map));
    }

    protected void generateMultiBillLog(String billId, Map<String, String> map, List<HashMap<String, Object>> list) {
        String[] billIds = billId.split(",");
        HashMap<String, String> map0 = null;
        for (String bi : billIds) {
            map0 = new HashMap<String, String>();
            map0.putAll(map);
            map0.put("operateObj", "billId:" + bi);
            this.assembleBizId(map0, list, bi);
        }
    }

    private void generateListBillLog(List listData, Map<String, String> map, List<HashMap<String, Object>> list) {
        HashMap<String, String> map0 = null;
        int total = listData.size();
        for (int i = 0; i < total; ++i) {
            Map each = (Map)listData.get(i);
            map0 = new HashMap<String, String>();
            map0.putAll(map);
            map0.put("operateObj", "billId:" + (String)each.get("id"));
            this.assembleBizId(map0, list, (String)each.get("id"));
        }
    }

    protected List<HashMap<String, Object>> comUseOrUnComUserButton(HttpServletRequest request, UIViewInfo uiViewInfo) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("isSuccessed", "0");
        if (StringUtils.isEmpty((String)this.buttonCaptionAlias)) {
            this.buttonCaptionAlias = this.method;
        }
        this.assembleLogData(request, uiViewInfo, map);
        map.put("operateObj", this.buttonCaptionAlias);
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        String data = request.getParameter("data");
        boolean isRecord = true;
        if (StringUtils.isEmpty((String)data) || !data.startsWith("{") || !data.endsWith("}")) {
            isRecord = false;
        }
        String billId = null;
        try {
            HashMap dataValue = JSONUtils.convertJsonToObject(this.ctx, data);
            billId = (String)dataValue.get("billIds");
        }
        catch (Exception e) {
            isRecord = false;
        }
        if (StringUtils.isEmpty(billId)) {
            isRecord = false;
        }
        if (isRecord) {
            this.generateMultiBillLog(billId, map, list);
        } else {
            list.add(this.assembleLogData(this.ctx, map));
        }
        return list;
    }

    protected List<HashMap<String, Object>> setIndexsButton(HttpServletRequest request, UIViewInfo uiViewInfo) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("isSuccessed", "0");
        if (StringUtils.isEmpty((String)this.buttonCaptionAlias)) {
            this.buttonCaptionAlias = this.method;
        }
        this.assembleLogData(request, uiViewInfo, map);
        map.put("operateObj", this.buttonCaptionAlias);
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        String data = request.getParameter("data");
        boolean isRecord = true;
        if (StringUtils.isEmpty((String)data) || !data.startsWith("[") || !data.endsWith("]")) {
            isRecord = false;
        }
        List dataValue = null;
        try {
            dataValue = (List)JSONUtils.convertJsonToObject(this.ctx, data, List.class);
        }
        catch (Exception e) {
            isRecord = false;
        }
        if (null == dataValue || dataValue.isEmpty()) {
            isRecord = false;
        }
        if (isRecord) {
            this.generateListBillLog(dataValue, map, list);
        } else {
            list.add(this.assembleLogData(this.ctx, map));
        }
        return list;
    }

    protected List<HashMap<String, Object>> unDistributeButton(HttpServletRequest request, UIViewInfo uiViewInfo) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("isSuccessed", "0");
        if (StringUtils.isEmpty((String)this.buttonCaptionAlias)) {
            this.buttonCaptionAlias = this.method;
        }
        this.assembleLogData(request, uiViewInfo, map);
        map.put("operateObj", this.buttonCaptionAlias);
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        String billId = request.getParameter("billIds");
        if (StringUtils.isEmpty((String)billId)) {
            list.add(this.assembleLogData(this.ctx, map));
        } else {
            this.generateMultiBillLog(billId, map, list);
        }
        return list;
    }

    protected List<HashMap<String, Object>> hrOrgUnitTransButton(HttpServletRequest request, UIViewInfo uiViewInfo) {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("isSuccessed", "0");
        this.assembleLogData(request, uiViewInfo, map);
        String billIds = request.getParameter("basicItemIds");
        String sourceHrOrgNameLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"sourceHrOrgName", (Context)this.ctx);
        String targetHrOrgNameLabel = SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"targetHrOrgName", (Context)this.ctx);
        String sourceHrOrgName = request.getParameter("sourceHrOrgName");
        String targetHrOrgName = request.getParameter("targetHrOrgName");
        String operateObj = "";
        if (!StringUtils.isEmpty((String)billIds)) {
            operateObj = operateObj + "billIds:" + billIds + ";";
        }
        operateObj = operateObj + sourceHrOrgNameLabel + ":" + sourceHrOrgName + "," + targetHrOrgNameLabel + ":" + targetHrOrgName;
        map.put("operateObj", operateObj);
        list.add(this.assembleLogData(this.ctx, map));
        return list;
    }

    protected final void generateOperateObjByLogParam(HttpServletRequest request, UIViewInfo uiViewInfo, Map<String, String> map, List<HashMap<String, Object>> list) {
        if (this.logConfig.getParams() instanceof Map) {
            this.generateOperateObjByLogParamMap(request, uiViewInfo, map, list);
        } else if (this.logConfig.getParams() instanceof List) {
            this.generateOperateObjByLogParamList(request, uiViewInfo, map, list);
        } else {
            list.add(this.assembleLogData(this.ctx, map));
        }
    }

    protected final void generateOperateObjByLogParamMap(HttpServletRequest request, UIViewInfo uiViewInfo, Map<String, String> map, List<HashMap<String, Object>> list) {
        Map config = (Map)this.logConfig.getParams();
        Object params = config.get("params");
        if (params instanceof List) {
            this.generateOperateObjByLogParamList(request, uiViewInfo, map, list, (List)params);
            return;
        }
        String dataName = (String)config.get("dataName");
        Object recordInfo = config.get("recordInfo");
        if (StringUtils.isEmpty((String)dataName) || null == recordInfo || !(recordInfo instanceof List)) {
            list.add(this.assembleLogData(this.ctx, map));
            return;
        }
        String dataValue = request.getParameter(dataName);
        List recordInfoList = (List)recordInfo;
        try {
            if (dataValue.startsWith("{") && dataValue.endsWith("}")) {
                HashMap dataValueMap = JSONUtils.convertJsonToObject(this.ctx, dataValue);
                this.generateMapDataForOperateObj(recordInfoList, dataValueMap, map);
                list.add(this.assembleLogData(this.ctx, map));
            } else if (dataValue.startsWith("[") && dataValue.endsWith("]")) {
                List dataValueList = (List)JSONUtils.convertJsonToObject(this.ctx, dataValue, List.class);
                if (null == dataValueList || dataValueList.isEmpty()) {
                    list.add(this.assembleLogData(this.ctx, map));
                    return;
                }
                HashMap<String, String> map0 = null;
                int total = dataValueList.size();
                for (int i = 0; i < total; ++i) {
                    Map dataValueMap = (Map)dataValueList.get(i);
                    map0 = new HashMap<String, String>();
                    map0.putAll(map);
                    this.generateMapDataForOperateObj(recordInfoList, dataValueMap, map0);
                    list.add(this.assembleLogData(this.ctx, map0));
                }
            } else {
                list.add(this.assembleLogData(this.ctx, map));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            list.add(this.assembleLogData(this.ctx, map));
        }
    }

    protected final void generateMapDataForOperateObj(List recordInfoList, Map dataValueMap, Map<String, String> map) {
        if (null == dataValueMap || dataValueMap.isEmpty() || null == recordInfoList || recordInfoList.isEmpty()) {
            return;
        }
        StringBuffer s = new StringBuffer();
        int total = recordInfoList.size();
        for (int i = 0; i < total; ++i) {
            Map each = (Map)recordInfoList.get(i);
            if (i > 0) {
                s.append(",");
            }
            s.append((String)each.get("alais_" + com.kingdee.util.LocaleUtils.getShortCode((Locale)this.ctx.getLocale()))).append(":").append(dataValueMap.get(each.get("logParam")));
        }
        map.put("operateObj", s.toString());
    }

    protected final void generateOperateObjByLogParamList(HttpServletRequest request, UIViewInfo uiViewInfo, Map<String, String> map, List<HashMap<String, Object>> list) {
        List paramList = (List)this.logConfig.getParams();
        this.generateOperateObjByLogParamList(request, uiViewInfo, map, list, paramList);
    }

    protected final void generateOperateObjByLogParamList(HttpServletRequest request, UIViewInfo uiViewInfo, Map<String, String> map, List<HashMap<String, Object>> list, List paramList) {
        StringBuffer s = new StringBuffer();
        int total = paramList.size();
        for (int i = 0; i < total; ++i) {
            String paramValue;
            Map each = (Map)paramList.get(i);
            String realValue = paramValue = request.getParameter((String)each.get("logParam"));
            if (!StringUtils.isEmpty((String)paramValue) && paramValue.startsWith("{") && paramValue.endsWith("}")) {
                try {
                    HashMap paramValueMap = JSONUtils.convertJsonToObject(this.ctx, paramValue);
                    realValue = (String)paramValueMap.get(com.kingdee.util.LocaleUtils.getShortCode((Locale)this.ctx.getLocale()));
                }
                catch (Exception paramValueMap) {
                    // empty catch block
                }
            }
            String paramLabel = (String)each.get("alais_" + com.kingdee.util.LocaleUtils.getShortCode((Locale)this.ctx.getLocale()));
            if (i > 0) {
                s.append(",");
            }
            s.append(paramLabel).append(":").append(realValue);
        }
        map.put("operateObj", s.toString());
        list.add(this.assembleLogData(this.ctx, map));
    }

    @Override
    public void postLogHandle(HttpServletRequest request) throws SHRWebException {
        if (null != this.logKeys) {
            this.updateLog(request);
        } else if ("save".equals(this.buttonName)) {
            this.writeSaveLog(request);
        }
    }

    protected abstract void updateLog(HttpServletRequest var1);

    protected final void updateLogToAppLog(HttpServletRequest request) {
        if (null == this.logKeys || this.logKeys.length <= 0) {
            return;
        }
        for (Object obj : this.logKeys) {
            if (!this.isUpdateResult(request, obj)) continue;
            LogUtil.afterLog((Context)this.ctx, (IObjectPK)((IObjectPK)obj));
        }
    }

    protected final boolean isUpdateResult(HttpServletRequest request, Object pk) {
        if (null == pk) {
            return false;
        }
        Object objRes = request.getAttribute("res_method_data");
        BatchMessageTipsHeader bmth = null;
        if (objRes instanceof BatchMessageTipsHeader) {
            bmth = (BatchMessageTipsHeader)objRes;
        }
        if (null == bmth || null == bmth.getResult() || bmth.getResult().isEmpty()) {
            return true;
        }
        if (null == this.logPkMappingBizPk || this.logPkMappingBizPk.isEmpty()) {
            return true;
        }
        String bizId = this.logPkMappingBizPk.get(pk.toString());
        if (StringUtils.isEmpty((String)bizId)) {
            return true;
        }
        List bodyList = bmth.getResult();
        for (BatchMessageTipsBody body : bodyList) {
            if (!bizId.equals(body.getId())) continue;
            return body.isMuitTipsState();
        }
        return true;
    }

    protected static SelectorItemCollection getSelectors(UIViewInfo uiViewInfo) throws SHRWebException {
        SelectorItemCollection sic = null;
        if (uiViewInfo != null && (sic = uiViewInfo.getSelectors()) == null) {
            sic = UIViewUtil.assembleSelector(uiViewInfo);
            uiViewInfo.setSelectors(sic);
        }
        return sic;
    }

    @Override
    public Set<String> customLogItemSet(HttpServletRequest request) throws SHRWebException {
        return Collections.emptySet();
    }

    protected final HashMap<String, Object> assembleLogData(Context ctx, Map<String, String> map) {
        if (null == ctx || null == map || map.isEmpty()) {
            return null;
        }
        HashMap<String, Object> logData = new HashMap<String, Object>();
        String fMethodDescriptionL2 = "";
        if (!StringUtils.isEmpty((String)map.get("operate"))) {
            fMethodDescriptionL2 = map.get("operate").length() > 255 ? map.get("operate").substring(0, 255) : map.get("operate");
        }
        LogServerUtil.setLogInfo(null, (Context)ctx, logData);
        logData.put("FIsSuccessed", map.get("isSuccessed"));
        logData.put("FItemName", "manual_default_logitem");
        logData.put("FMethodDescription_L1", fMethodDescriptionL2);
        logData.put("FMethodDescription_L2", fMethodDescriptionL2);
        logData.put("FMethodDescription_L3", fMethodDescriptionL2);
        logData.put("FEntityAlias_L1", map.get("functionName"));
        logData.put("FEntityAlias_L2", map.get("functionName"));
        logData.put("FEntityAlias_L3", map.get("functionName"));
        logData.put("FInstanceNo", map.get("operateObj"));
        logData.put("LOG_HIDDEN_WRITE_MODE", "LOG_HIDDEN_WRITE_MODE");
        return logData;
    }

    @Override
    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setLogConfigBean(LogConfigBean logConfig) {
        this.logConfig = logConfig;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)logConfig.toString());
        }
    }
}

