/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.model.RealDataFetcher;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataFetcherHelper {
    public static List<Map<String, Object>> getByQueryAllDataFetcher(Context ctx, IQueryExecutor queryExecutor, int start, int length) throws BOSException {
        List listModel = null;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        RealDataFetcher vdf = RealDataFetcher.createInstance(queryExecutor, start, length);
        listModel = vdf.getData();
        SelectorItemCollection columnModel = queryExecutor.getObjectView().getSelector();
        if (null != listModel && listModel.size() > 0) {
            for (int nIndex = 0; nIndex < listModel.size(); ++nIndex) {
                Map info = (Map)listModel.get(nIndex);
                HashMap<String, String> row = new HashMap<String, String>();
                for (int columnIndex = 0; columnIndex < columnModel.size(); ++columnIndex) {
                    String column = columnModel.get(columnIndex).getPropertyName();
                    String value = null;
                    if (info.get(column) != null) {
                        value = (String)info.get(column);
                    }
                    if (value == null) {
                        value = info.get(column.toUpperCase());
                    }
                    if (value == null) {
                        value = "";
                    }
                    row.put(column, value);
                }
                result.add(row);
            }
        }
        return result;
    }

    public static List<Map<String, Object>> getByEntityAllDataFetcher(Context ctx, EntityViewInfo entityViewInfo, String entityFullName, int start, int length) throws BOSException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ICoreBase bizInterface = MetaDataUtil.getBizInterface((Context)ctx, (String)entityFullName);
        List list = bizInterface.getPagingList(entityViewInfo, start, length);
        if (list != null && !list.isEmpty()) {
            CoreBaseInfo info = null;
            SelectorItemCollection sic = entityViewInfo.getSelector();
            Map<String, PropertyInfo> properyMap = DataFetcherHelper.getPropertyMap(ctx, entityFullName, sic);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                info = (CoreBaseInfo)list.get(i);
                result.add(MetaDataUtil.convertObjectInfoToMap(ctx, info, sic, properyMap));
            }
        }
        return result;
    }

    private static Map<String, PropertyInfo> getPropertyMap(Context ctx, String entity, SelectorItemCollection sic) {
        Map properyMap = MetaDataUtil.getProperties((Context)ctx, (String)entity);
        String propertyName = null;
        PropertyInfo propertyInfo = null;
        int size = sic.size();
        for (int i = 0; i < size; ++i) {
            propertyName = sic.get(i).getPropertyName();
            if (properyMap.containsKey(propertyName) || !propertyName.contains(".")) continue;
            propertyInfo = MetaDataUtil.getPropertyInfo((Context)ctx, (String)entity, (String[])propertyName.split("\\."));
            properyMap.put(propertyName, propertyInfo);
        }
        return properyMap;
    }
}

