/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.URLInfo;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.base.permission.util.SHRPermissionParamUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.permission.data.ShrCheckDataPermissionUtil;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.gzh.AESUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CheckFunctionPermissionUtil {
    private static Logger logger = Logger.getLogger(CheckFunctionPermissionUtil.class);
    private static final Set<String> UIPK_WHITE_LIST = new HashSet<String>();
    private static final Set<String> PERM_ITEM_URL_WHITE_LIST = new HashSet<String>();

    public static Set<String> getUipkWhiteList() {
        return UIPK_WHITE_LIST;
    }

    public static boolean isNeedCheckFunctionPermission(String uipk, String url) {
        if (!StringUtils.isEmpty((String)(uipk = SHRPermissionWebUtils.getRealUipk(uipk)))) {
            for (String uipk0 : UIPK_WHITE_LIST) {
                if (!uipk0.contains(uipk)) continue;
                return false;
            }
        }
        if (StringUtils.isEmpty((String)url)) {
            return false;
        }
        for (String url0 : PERM_ITEM_URL_WHITE_LIST) {
            if (!url.contains(url0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNeedCheckFunctionPermission(HttpServletRequest request) {
        String uipk = request.getParameter("uipk");
        uipk = SHRPermissionWebUtils.getRealUipk(uipk);
        String url = SHRPermissionWebUtils.assemblePermissionURL(request);
        return CheckFunctionPermissionUtil.isNeedCheckFunctionPermission(uipk, url);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkFunctionPermission(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        boolean isF7;
        String url;
        String uipk = request.getParameter("uipk");
        if (!CheckFunctionPermissionUtil.isNeedCheckFunctionPermission(uipk = SHRPermissionWebUtils.getRealUipk(uipk), url = SHRPermissionWebUtils.assemblePermissionURL(request))) {
            return;
        }
        Context ctx = SHRContext.getInstance().getContext();
        PermItemInfo permItemInfo = SHRPermissionWebUtils.getCurrentPagePermItemByRequest(ctx, request, url, isF7 = CheckFunctionPermissionUtil.isF7Request(request, ctx, uipk));
        if (permItemInfo != null && !StringUtils.isEmpty((String)permItemInfo.getName())) {
            request.setAttribute("permItemId", (Object)permItemInfo.getId().toString());
            request.setAttribute("current_req_permItem", (Object)permItemInfo);
            if (isF7) {
                return;
            }
            HashMap<String, Set<String>> shrWfInProcess = (HashMap<String, Set<String>>)request.getSession().getAttribute("SHR_WF_IN_PROCESS");
            HashMap<String, Set<String>> shrWfFinished = (HashMap<String, Set<String>>)request.getSession().getAttribute("SHR_WF_FINISHED");
            HashMap<String, Set<String>> shrWfCirculation = (HashMap<String, Set<String>>)request.getSession().getAttribute("SHR_WF_CIRCULATION");
            HashMap<String, Set<String>> myShrWfInOrFinished = (HashMap<String, Set<String>>)request.getSession().getAttribute("MY_SHR_WF_INORFINISHED");
            if (null == shrWfInProcess) {
                shrWfInProcess = new HashMap<String, Set<String>>();
                request.getSession().setAttribute("SHR_WF_IN_PROCESS", shrWfInProcess);
            }
            if (null == shrWfFinished) {
                shrWfFinished = new HashMap<String, Set<String>>();
                request.getSession().setAttribute("SHR_WF_FINISHED", shrWfFinished);
            }
            if (null == shrWfCirculation) {
                shrWfCirculation = new HashMap<String, Set<String>>();
                request.getSession().setAttribute("SHR_WF_CIRCULATION", shrWfCirculation);
            }
            if (null == myShrWfInOrFinished) {
                myShrWfInOrFinished = new HashMap<String, Set<String>>();
                request.getSession().setAttribute("MY_SHR_WF_INORFINISHED", myShrWfInOrFinished);
            }
            String billId = ShrCheckDataPermissionUtil.getBillId(request);
            String msgId = request.getParameter("msgId");
            try {
                UserInfo u;
                if (null != ContextUtil.getCurrentUserInfo((Context)ctx) && UserType.SYSTEM.equals((Object)(u = ContextUtil.getCurrentUserInfo((Context)ctx)).getType()) && PermItemType.BIZ_FUNCTION.equals((Object)permItemInfo.getType())) {
                    logger.error((Object)"checkFuncPermissionByURL admin user can't operate biz function.");
                    throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
                }
                if ((shrWfInProcess.containsKey(uipk) || shrWfFinished.containsKey(uipk) || shrWfCirculation.containsKey(uipk) || myShrWfInOrFinished.containsKey(uipk)) && "POST".equals(request.getMethod())) {
                    if (!logger.isDebugEnabled()) return;
                    logger.debug((Object)"checkFuncPermissionByURL getMethod is POST ");
                    return;
                }
                if (CheckFunctionPermissionUtil.checkWFBillInProcessSecurity(request)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("checkFuncPermissionByURL checkWFBillInProcessSecurity is in process,uipk={0}, billId={1}", uipk, billId));
                    }
                    ShrCheckDataPermissionUtil.sessionDataAddHandler(shrWfInProcess, uipk, billId);
                    return;
                }
                if (CheckFunctionPermissionUtil.checkWFBillFinishedSecurity(request)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("checkFuncPermissionByURL checkWFBillFinishedSecurity is finished,uipk={0}, billId={1}", uipk, billId));
                    }
                    ShrCheckDataPermissionUtil.sessionDataAddHandler(shrWfFinished, uipk, billId);
                    return;
                }
                if (CheckFunctionPermissionUtil.checkWFBillCirculationSecurity(request)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("checkFuncPermissionByURL checkWFBillFinishedSecurity is finished,uipk={0}, msgId={1}", uipk, msgId));
                    }
                    ShrCheckDataPermissionUtil.sessionDataAddHandler(shrWfCirculation, uipk, msgId);
                    return;
                }
                if (CheckFunctionPermissionUtil.checkMyWFBillInOrFinished(request)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)MessageFormat.format("checkFuncPermissionByURL checkMyWFBillInOrFinished is in process,uipk={0}, billId={1}", uipk, billId));
                    }
                    ShrCheckDataPermissionUtil.sessionDataAddHandler(myShrWfInOrFinished, uipk, billId);
                    return;
                }
                ShrCheckDataPermissionUtil.sessionDataDeleteHandler(shrWfInProcess, uipk, billId);
                ShrCheckDataPermissionUtil.sessionDataDeleteHandler(shrWfFinished, uipk, billId);
                ShrCheckDataPermissionUtil.sessionDataDeleteHandler(shrWfCirculation, uipk, msgId);
                ShrCheckDataPermissionUtil.sessionDataDeleteHandler(myShrWfInOrFinished, uipk, billId);
                SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)permItemInfo);
                return;
            }
            catch (EASBizException e) {
                logger.error((Object)MessageFormat.format("checkFuncPermissionByURL no permission,uipk={0}, billId={1}, Current Request permItemId={2}", uipk, billId, permItemInfo.getId().toString()));
                throw new ShrWebBizException(e);
            }
            catch (BOSException e) {
                logger.error((Object)MessageFormat.format("checkFuncPermissionByURL no permission,uipk={0}, billId={1}, Current Request permItemId={2}", uipk, billId, permItemInfo.getId().toString()));
                throw new SHRWebException(e);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("checkFuncPermissionByURL url={0}", url));
            }
            if (isF7) {
                return;
            }
            CheckFunctionPermissionUtil.whiteListPermissionCheck(request, ctx, uipk, permItemInfo);
        }
    }

    private static boolean isF7Request(HttpServletRequest request, Context ctx, String uipk) throws SHRWebException {
        String shrEncryptF7Client = request.getHeader("x-shr-encrypt-F7");
        if (StringUtils.isEmpty((String)shrEncryptF7Client)) {
            return false;
        }
        String formatServer = "{0}_{1}_{2}";
        String shrEncryptF7Server = MessageFormat.format(formatServer, AESUtil.encrypt(ctx.getAIS(), ctx.getContextID()), AESUtil.encrypt(HRFilterUtils.getCurrentUserId((Context)ctx), ctx.getContextID()), AESUtil.encrypt(ctx.getContextID(), ctx.getContextID()));
        if (shrEncryptF7Client.equals(shrEncryptF7Server)) {
            return true;
        }
        UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        return "F7".equals(uiViewInfo.getType());
    }

    private static boolean checkWFBillInProcessSecurity(HttpServletRequest request) throws SHRWebException {
        String sql = "SELECT count(*) cc FROM t_wfr_assign where FBIZOBJID = ? and FPERSONUSERID = ?  and FASSIGNID= ?";
        return CheckFunctionPermissionUtil.isWfPermission(request, sql);
    }

    private static boolean checkWFBillFinishedSecurity(HttpServletRequest request) throws SHRWebException {
        String sql = "SELECT count(*) cc FROM t_wfr_assigndetail where FBIZOBJID = ? and FPERSONUSERID = ? and FASSIGNID= ?";
        return CheckFunctionPermissionUtil.isWfPermission(request, sql);
    }

    private static boolean isWfPermission(HttpServletRequest request, String sql) throws SHRWebException {
        String billId;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"isWfPermission begin");
        }
        if (StringUtils.isEmpty((String)(billId = ShrCheckDataPermissionUtil.getBillId(request)))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"isWfPermission billId is null");
            }
            return false;
        }
        String uipk = request.getParameter("uipk");
        uipk = SHRPermissionWebUtils.getRealUipk(uipk);
        String assigmentId = ShrCheckDataPermissionUtil.getAssigmentId(request);
        if (StringUtils.isEmpty((String)uipk) || StringUtils.isEmpty((String)assigmentId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"isWfPermission uipk is null or assigmentId is null");
            }
            return false;
        }
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo u = ContextUtil.getCurrentUserInfo((Context)ctx);
        try {
            URLInfo url = ProcessCenterUtil.getEditUrlInfoByAssign((String)assigmentId, (Context)ctx);
            String realCompareUipk = CheckFunctionPermissionUtil.getRealCompareUipk(request, uipk);
            String uipkInWf = "";
            if (null != url && !StringUtils.isEmpty((String)url.getURL())) {
                uipkInWf = SHRPermissionWebUtils.getUipkByUrl(url.getURL());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("isWfPermission uipk = {0},uipkInWf={1}, realCompareUipk={2},billId={3},assigmentId={4},url={5}", uipk, uipkInWf, realCompareUipk, billId, assigmentId, url.getURL()));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("isWfPermission uipk = {0},uipkInWf={1}, realCompareUipk={2},billId={3},assigmentId={4}, url is null", uipk, uipkInWf, realCompareUipk, billId, assigmentId));
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId, u.getId().toString(), assigmentId});
            while (rs.next()) {
                int cc = rs.getInt("cc");
                if (cc <= 0 || StringUtils.isEmpty((String)realCompareUipk) || !realCompareUipk.equals(uipkInWf)) continue;
                return true;
            }
            return false;
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (SQLException e) {
            throw new SHRWebException(e);
        }
    }

    private static String getRealCompareUipk(HttpServletRequest request, String uipk) {
        String realCompareUipk = null;
        String forwardMark = (String)request.getAttribute("SHR_BILL_FORWARD_MARK");
        if (!StringUtils.isEmpty((String)forwardMark)) {
            realCompareUipk = forwardMark.split("=")[0];
        }
        if (StringUtils.isEmpty(realCompareUipk)) {
            realCompareUipk = uipk;
        }
        return realCompareUipk;
    }

    private static boolean checkWFBillCirculationSecurity(HttpServletRequest request) throws SHRWebException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"checkWFBillCirculationSecurity begin");
        }
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo u = ContextUtil.getCurrentUserInfo((Context)ctx);
        String msgId = request.getParameter("msgId");
        if (StringUtils.isEmpty((String)msgId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"checkWFBillCirculationSecurity msgId is null");
            }
            return false;
        }
        try {
            String sql = "SELECT count(*) cc FROM T_BAS_Message where fid = ? and (FRECEIVER = ? or FSENDERID = ? ) ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{msgId, u.getId().toString(), u.getId().toString()});
            int cc = 0;
            while (null != rs && rs.next()) {
                cc = rs.getInt("cc");
                if (cc < 1) continue;
                return true;
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (SQLException e) {
            throw new SHRWebException(e);
        }
        return false;
    }

    private static boolean checkMyWFBillInOrFinished(HttpServletRequest request) throws SHRWebException {
        String billId;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"checkMyWFBillInOrFinished begin");
        }
        if (StringUtils.isEmpty((String)(billId = ShrCheckDataPermissionUtil.getBillId(request)))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"checkMyWFBillInOrFinished billId is null");
            }
            return false;
        }
        String uipk = request.getParameter("uipk");
        uipk = SHRPermissionWebUtils.getRealUipk(uipk);
        String procInstId = ShrCheckDataPermissionUtil.getProcInstId(request);
        if (StringUtils.isEmpty((String)uipk) || StringUtils.isEmpty((String)procInstId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"checkMyWFBillInOrFinished uipk is null or procInstId is null");
            }
            return false;
        }
        Context ctx = SHRContext.getInstance().getContext();
        UserInfo u = ContextUtil.getCurrentUserInfo((Context)ctx);
        String sql = "SELECT count(*) cc FROM t_wfr_procinst t0 left join t_wfr_procinstref t1 on t0.FPROCINSTID = t1.FPROCINSTID where t0.FINITIATORID = ? and t0.FPROCINSTID=? and t1.FREFID = ? ";
        URLInfo url = ProcessCenterUtil.getBillViewUrlByProcInstId((String)procInstId, (Context)ctx, null);
        String realCompareUipk = CheckFunctionPermissionUtil.getRealCompareUipk(request, uipk);
        String uipkInWf = "";
        if (null != url && !StringUtils.isEmpty((String)url.getURL())) {
            uipkInWf = SHRPermissionWebUtils.getUipkByUrl(url.getURL());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("checkMyWFBillInOrFinished uipk ={0}, uipkInWf= {1}, billId={2},procInstId={3}, url={4}, ", uipk, uipkInWf, billId, procInstId, url.getURL()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("checkMyWFBillInOrFinished uipk ={0}, uipkInWf= {1}, billId={2},procInstId={3}, url is null, ", uipk, uipkInWf, billId, procInstId));
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{u.getId().toString(), procInstId, billId});
            int cc = 0;
            while (null != rs && rs.next()) {
                cc = rs.getInt("cc");
                if (cc < 1 || StringUtils.isEmpty((String)realCompareUipk) || !realCompareUipk.equals(uipkInWf)) continue;
                return true;
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
        catch (SQLException e) {
            throw new SHRWebException(e);
        }
        return false;
    }

    private static void whiteListPermissionCheck(HttpServletRequest request, Context ctx, String uipk, PermItemInfo permItemInfo) throws SHRWebException {
        try {
            if (SHRPermissionParamUtil.isSHRPermissionVerificationWithWhiteList((Context)ctx)) {
                throw new ShrPermissionException(ShrPermissionException.NO_FUNCTION_PERMISSION);
            }
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    static {
        UIPK_WHITE_LIST.add("com.kingdee.shr.shrimport.app.ImportTask.userList");
        UIPK_WHITE_LIST.add("shr.workflow.notice.viewbill");
        UIPK_WHITE_LIST.add("shr.workflow.view");
        UIPK_WHITE_LIST.add("shr.perself.homepage");
        UIPK_WHITE_LIST.add("shr.service.desktop.new");
        UIPK_WHITE_LIST.add("com.kingdee.shr.base.syssetting.app.theme.form");
        UIPK_WHITE_LIST.add("hr.homepage.help");
        UIPK_WHITE_LIST.add("hr.homepage.about");
        UIPK_WHITE_LIST.add("com.kingdee.shr.io.app.ImportInfo");
        UIPK_WHITE_LIST.add("com.kingdee.eas.base.param.app.PersonalNantionalPlanView");
        UIPK_WHITE_LIST.add("shr.perself.notExistPerson");
        UIPK_WHITE_LIST.add("com.kingdee.shr.base.syssetting.app.BaseItemRevise.list");
        UIPK_WHITE_LIST.add("com.kingdee.shr.base.syssetting.app.BaseItemRevise.form");
        UIPK_WHITE_LIST.add("agreement.info");
        UIPK_WHITE_LIST.add("com.kingdee.eas.basedata.assistant.app.TimeZone.F7");
        UIPK_WHITE_LIST.add("commonPageForOperateGuide");
        UIPK_WHITE_LIST.add("com.kingdee.shr.recuritment.baseCommon");
        UIPK_WHITE_LIST.add("com.kingdee.shr.recuritment.ueditor");
        UIPK_WHITE_LIST.add("com.kingdee.shr.compensation.app.SHRWordTemplate.list");
        UIPK_WHITE_LIST.add("com.kingdee.shr.compensation.app.SHRWordTemplate.form");
        UIPK_WHITE_LIST.add("com.kingdee.shr.compensation.app.preview.CmpPreTemplate.list");
        UIPK_WHITE_LIST.add("com.kingdee.shr.compensation.app.preview.CmpPreTemplate.form");
        PERM_ITEM_URL_WHITE_LIST.add("/dynamic.do?method=getUIViewInfo#uri=com.kingdee.shr.base.syssetting.app.UIView.list");
        PERM_ITEM_URL_WHITE_LIST.add("/dynamic.do?method=addHandlerWhiteList#uri=com.kingdee.shr.base.syssetting.app.UIView.list");
    }
}

