/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission.data.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.permission.data.AbstractShrCheckDataPermissionService;
import com.kingdee.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AdminAndHrOrHrAndOuterOrgRangCheckerService
extends AbstractShrCheckDataPermissionService {
    @Override
    public void checkDataPermission(HttpServletRequest request, Context ctx, Map<String, Object> fieldConfig, Map<String, Object> ruleConfig, Object model) throws SHRWebException {
        if (null == model) {
            return;
        }
        try {
            String ou = (String)fieldConfig.get("ou");
            String bu = (String)fieldConfig.get("bu");
            String isInnerPerson = (String)fieldConfig.get("isInnerPerson");
            if (StringUtils.isEmpty((String)ou) || StringUtils.isEmpty((String)bu) || StringUtils.isEmpty((String)isInnerPerson) || model == null) {
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION);
            }
            String adminId = this.getAdminOrgUnitId(model, ou);
            String hrOrgUnitId = this.getHROrgUnitId(model, bu);
            boolean isInner = this.getIsInnerPerson(model, isInnerPerson);
            this.checkOUAndBUOrBuAndEntrust(ctx, this.getPermItemId(request), adminId, hrOrgUnitId, isInner);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
    }

    @Override
    public FilterInfo getListPermissionFilterInfo(HttpServletRequest request, Context ctx, Map<String, Object> fieldConfig, Map<String, Object> ruleConfig) throws SHRWebException {
        String ou = (String)fieldConfig.get("ou");
        String bu = (String)fieldConfig.get("bu");
        String isInnerPerson = (String)fieldConfig.get("isInnerPerson");
        if (StringUtils.isEmpty((String)ou) || StringUtils.isEmpty((String)bu) || StringUtils.isEmpty((String)isInnerPerson)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        String permItemId = this.getPermItemId(request);
        this.addAdminOrgRange(ctx, permItemId, filter, ou);
        this.addHROrgRange(ctx, permItemId, filter, bu);
        filter.getFilterItems().add(new FilterItemInfo(isInnerPerson, (Object)false, CompareType.EQUALS));
        filter.setMaskString("(#0 and #1) or (#1 and #2)");
        return filter;
    }
}

