/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.permission.data.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.ShrPermissionException;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.permission.data.AbstractShrCheckDataPermissionService;
import com.kingdee.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MySelfFunctionCheckerService
extends AbstractShrCheckDataPermissionService {
    @Override
    public void checkDataPermission(HttpServletRequest request, Context ctx, Map<String, Object> fieldConfig, Map<String, Object> ruleConfig, Object model) throws SHRWebException {
        if (null == model) {
            return;
        }
        try {
            String selfField = (String)fieldConfig.get("selfField");
            if (StringUtils.isEmpty((String)selfField) || model == null) {
                throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION_SEE_OTHER);
            }
            String personId = this.getPersonId(model, selfField);
            String myPersonId = this.getPersonId(ctx);
            if (!StringUtils.isEmpty((String)personId) && !StringUtils.isEmpty((String)myPersonId) && personId.equals(myPersonId)) {
                return;
            }
            throw new ShrPermissionException(ShrPermissionException.NO_DATA_PERMISSION_SEE_OTHER);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
    }

    @Override
    public FilterInfo getListPermissionFilterInfo(HttpServletRequest request, Context ctx, Map<String, Object> fieldConfig, Map<String, Object> ruleConfig) throws SHRWebException {
        String selfField = (String)fieldConfig.get("selfField");
        if (StringUtils.isEmpty((String)selfField)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(selfField, (Object)this.getPersonId(ctx), CompareType.EQUALS));
        return filter;
    }
}

