/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.service;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.shr.base.syssetting.annotation.BOSObjectInfo;
import com.kingdee.shr.base.syssetting.annotation.IBOSBizCtrl;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.IWebController;
import com.kingdee.shr.base.syssetting.service.BOSService;
import com.kingdee.shr.base.syssetting.util.BeanUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class BOSServiceAssistant {
    private static Logger logger = Logger.getLogger(BOSServiceAssistant.class.getName());

    private BOSServiceAssistant() {
    }

    public static void handleAnnotation(Object bean) {
        if (bean == null) {
            return;
        }
        BOSServiceAssistant.InjectBOSService(bean, null);
    }

    private static void InjectBOSService(Object bean, Class<?> objClass) {
        Class<?> beanClass;
        if (bean == null) {
            return;
        }
        Class<?> clazz = beanClass = objClass == null ? bean.getClass() : objClass;
        if (beanClass.getSuperclass() != null) {
            BOSServiceAssistant.InjectBOSService(bean, beanClass.getSuperclass());
        }
        Field[] fields = beanClass.getDeclaredFields();
        HashSet<Field> set = new HashSet<Field>();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].isAnnotationPresent(BOSObjectInfo.class)) {
                set.add(fields[i]);
                continue;
            }
            if (fields[i].isAnnotationPresent(IBOSBizCtrl.class)) {
                set.add(fields[i]);
                continue;
            }
            if (!fields[i].isAnnotationPresent(Autowired.class)) continue;
            fields[i].setAccessible(true);
            Class<?> componentBeanClass = fields[i].getType();
            try {
                Object componentBean = BeanUtils.getBean(componentBeanClass);
                if (!(componentBean instanceof IWebController)) continue;
                BOSServiceAssistant.InjectBOSService(componentBean, componentBean.getClass());
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (set.size() == 0) {
            return;
        }
        for (Field m : set) {
            try {
                if (m.getAnnotation(BOSObjectInfo.class) != null) {
                    BOSServiceAssistant.setBOSObjectInfoValue(bean, m);
                    continue;
                }
                if (m.getAnnotation(IBOSBizCtrl.class) == null) continue;
                BOSServiceAssistant.setIBOSBizCtrlValue(bean, m);
            }
            catch (BOSException e) {
                logger.warning("Inject BOSObjectInfo/IBOSBizCtrl error!");
                e.printStackTrace();
            }
        }
    }

    public static void setIBOSBizCtrlValue(Object bean, Field m) throws BOSException {
        IBOSBizCtrl IBOSBizCtrl2 = m.getAnnotation(IBOSBizCtrl.class);
        try {
            String[] names = m.getType().getName().split("\\.");
            String className = "";
            String classNameSub = "";
            if (names.length > 0) {
                classNameSub = names[names.length - 1].substring(1);
            }
            className = m.getType().getName().substring(0, m.getType().getName().lastIndexOf(".") + 1) + classNameSub;
            Class<?> model = Class.forName(className + "Factory");
            Context ctx = SHRContext.getInstance().getContext();
            Method method = model.getMethod("getRemoteInstance", new Class[0]);
            Object value = method.invoke(null, new Object[0]);
            boolean accessible = m.isAccessible();
            m.setAccessible(true);
            if (value != null && (value instanceof IBizCtrl || value instanceof IBOSObject)) {
                m.set(bean, value);
            }
            m.setAccessible(accessible);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void setBOSObjectInfoValue(Object bean, Field m) throws BOSException {
        BOSObjectInfo bosObjectInfo = m.getAnnotation(BOSObjectInfo.class);
        try {
            Object value = m.getType().newInstance();
            boolean accessible = m.isAccessible();
            m.setAccessible(true);
            if (StringUtils.isEmpty((String)bosObjectInfo.id()) || !(value instanceof AbstractBOSObject)) {
                m.set(bean, value);
            } else {
                m.set(bean, BOSService.createBOSObject(m.getType()));
            }
            m.setAccessible(accessible);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

