/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.utils.SecurityValidator;
import com.kingdee.eas.util.app.ContextUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SHRUserCheckUtils {
    private static Logger logger = Logger.getLogger(SHRUserCheckUtils.class);

    public static boolean checkPasswordPolicy(Context ctx, HttpServletRequest request) {
        boolean expire = false;
        boolean isChgPass = false;
        if (ctx != null) {
            expire = SHRUserCheckUtils.passWillBeExpired(ctx);
            String expireTip = SHRUserCheckUtils.getExpireWarnMsg(ctx);
            isChgPass = SHRUserCheckUtils.isRequireChangePassword(ctx);
            request.setAttribute("expire", (Object)expire);
            request.setAttribute("expireTip", (Object)expireTip);
            request.setAttribute("isChgPass", (Object)isChgPass);
        }
        return expire || isChgPass;
    }

    private static boolean passWillBeExpired(Context ctx) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        return PermissionCommonUtil.isPassExpired((UserInfo)user);
    }

    private static String getExpireWarnMsg(Context ctx) {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        return PermissionCommonUtil.getExpireWarnMsg((UserInfo)user);
    }

    private static boolean isRequireChangePassword(Context ctx) {
        boolean isChgPass = false;
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String encryptPassword = (String)ctx.get((Object)"encryptPassword");
        if (encryptPassword != null) {
            UserInfo userInfoCopy = (UserInfo)user.clone();
            String plainPassword = null;
            try {
                plainPassword = CryptoTean.decrypt((String)user.getNumber(), (String)encryptPassword);
            }
            catch (CryptException e) {
                logger.error((Object)"password decrypt error:", (Throwable)e);
            }
            userInfoCopy.setPassword(plainPassword);
            isChgPass = SecurityValidator.isRequireChangePassword((UserInfo)userInfoCopy);
        }
        return isChgPass;
    }
}

